/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public final class TcpMultiplexer {
    private static final String CLASS_NAME = TcpMultiplexer.class.getName();
    private static volatile boolean isStarted = false;
    private final Selector selector;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger pendingTaskCount = new AtomicInteger(0);
    private final Thread pollingThread;

    private static TcpMultiplexer soleInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void registerForReadEvent(SocketChannel channel, Consumer<Throwable> onReady) throws IOException {
        TcpMultiplexer.soleInstance().register(channel, 1, onReady);
    }

    public static void registerForWriteEvent(SocketChannel channel, Consumer<Throwable> onReady) throws IOException {
        TcpMultiplexer.soleInstance().register(channel, 4, onReady);
    }

    public static void registerForConnectEvent(SocketChannel channel, Consumer<Throwable> onReady) throws IOException {
        TcpMultiplexer.soleInstance().register(channel, 8, onReady);
    }

    public static void forceCallback(SocketChannel channel, Throwable error) {
        if (!isStarted) {
            return;
        }
        SelectionKey key = TcpMultiplexer.soleInstance().getKeyForChannel(channel);
        if (key == null) {
            return;
        }
        TcpMultiplexer.soleInstance().enqueueTask(() -> TcpMultiplexer.onReady(key, error));
    }

    static void restoreBlockingMode(SocketChannel socketChannel) throws IOException {
        SelectionKey selectionKey = TcpMultiplexer.getRegisteredKey(socketChannel);
        if (selectionKey == null) {
            return;
        }
        selectionKey.cancel();
        socketChannel.configureBlocking(true);
        Registration registration = (Registration)selectionKey.attachment();
        if (registration == null) {
            return;
        }
        Throwable pendingError = registration.pendingError;
        if (pendingError == null) {
            return;
        }
        if (pendingError instanceof IOException) {
            throw (IOException)pendingError;
        }
        throw new IOException(pendingError);
    }

    static boolean isRegistered(SocketChannel socketChannel) {
        return TcpMultiplexer.getRegisteredKey(socketChannel) != null;
    }

    private static SelectionKey getRegisteredKey(SocketChannel socketChannel) {
        if (!isStarted) {
            return null;
        }
        TcpMultiplexer tcpMultiplexer = TcpMultiplexer.soleInstance();
        SelectionKey selectionKey = tcpMultiplexer.getKeyForChannel(socketChannel);
        if (selectionKey != null && selectionKey.isValid()) {
            return selectionKey;
        }
        return null;
    }

    public static void stop() {
        if (!isStarted) {
            return;
        }
        isStarted = false;
        TcpMultiplexer.soleInstance().pollingThread.interrupt();
    }

    private TcpMultiplexer(Selector selector) {
        this.selector = selector;
        this.pollingThread = new Thread(this::poll, this.getClass().getName());
        this.pollingThread.setDaemon(true);
        this.pollingThread.start();
        isStarted = true;
    }

    private void register(SocketChannel channel, int interest, Consumer<Throwable> onReady) throws IOException {
        this.enqueueTask(() -> {
            try {
                Registration registration;
                SelectionKey existingKey = channel.keyFor(this.selector);
                if (existingKey != null) {
                    registration = (Registration)existingKey.attachment();
                    if (!existingKey.isValid()) {
                        this.selector.selectNow();
                    }
                } else {
                    registration = new Registration();
                }
                registration.updateInterest(interest, onReady);
                channel.configureBlocking(false);
                channel.register(this.selector, registration.interest, registration);
            }
            catch (Throwable throwable) {
                onReady.accept(throwable);
            }
        });
    }

    private void enqueueTask(Runnable task) {
        this.taskQueue.add(task);
        if (this.pendingTaskCount.getAndIncrement() == 0) {
            this.selector.wakeup();
        }
    }

    private SelectionKey getKeyForChannel(SocketChannel channel) {
        return channel.keyFor(this.selector);
    }

    private void poll() {
        try {
            while (true) {
                int taskCount;
                int selected = this.selector.select();
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedIOException(Thread.currentThread().getName() + " received a thread interrupt");
                }
                while (selected != 0) {
                    for (SelectionKey key2 : this.selector.selectedKeys()) {
                        TcpMultiplexer.onReady(key2);
                    }
                    this.selector.selectedKeys().clear();
                    selected = this.selector.selectNow();
                }
                do {
                    taskCount = 0;
                    Runnable task = this.taskQueue.poll();
                    while (task != null) {
                        ++taskCount;
                        task.run();
                        task = this.taskQueue.poll();
                    }
                } while (this.pendingTaskCount.addAndGet(-taskCount) > 0);
            }
        }
        catch (Throwable selectFailure) {
            Registration[] callbacks = (Registration[])this.selector.keys().stream().map(key -> (Registration)key.attachment()).toArray(Registration[]::new);
            try {
                this.selector.close();
            }
            catch (IOException closeFailure) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.INTERNAL, CLASS_NAME, "poll", closeFailure.getMessage(), "", closeFailure);
            }
            for (Registration callback : callbacks) {
                callback.onError(selectFailure);
            }
            return;
        }
    }

    private static void onReady(SelectionKey key) {
        TcpMultiplexer.onReady(key, null);
    }

    private static void onReady(SelectionKey key, Throwable error) {
        try {
            Registration registration = (Registration)key.attachment();
            if (error == null) {
                registration.onReady(key.readyOps());
            } else {
                registration.onError(error);
            }
            key.interestOps(registration.interest);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    private static final class LazyHolder {
        private static final TcpMultiplexer INSTANCE;

        private LazyHolder() {
        }

        static {
            Selector selector;
            try {
                selector = Selector.open();
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
            INSTANCE = new TcpMultiplexer(selector);
        }
    }

    private static final class Registration {
        private int interest;
        private Throwable pendingError = null;
        private Consumer<Throwable> connectCallback;
        private Consumer<Throwable> writeCallback;
        private Consumer<Throwable> readCallback;

        private Registration() {
        }

        private void updateInterest(int interest, Consumer<Throwable> callback) {
            if (this.pendingError != null) {
                Throwable error = this.pendingError;
                this.pendingError = null;
                callback.accept(error);
                return;
            }
            this.interest |= interest;
            if ((interest & 8) != 0) {
                this.connectCallback = callback;
            }
            if ((interest & 4) != 0) {
                this.writeCallback = callback;
            }
            if ((interest & 1) != 0) {
                this.readCallback = callback;
            }
        }

        private void onReady(int readyOps) {
            this.interest &= ~readyOps;
            try {
                if ((readyOps & 8) != 0) {
                    this.executeConnect(null);
                }
                if ((readyOps & 4) != 0) {
                    this.executeWrite(null);
                }
                if ((readyOps & 1) != 0) {
                    this.executeRead(null);
                }
            }
            catch (Throwable throwable) {
                this.handleCallbackError(throwable);
            }
        }

        private void onError(Throwable error) {
            this.interest = 0;
            try {
                boolean isErrorReceived = false;
                isErrorReceived |= this.executeConnect(error);
                isErrorReceived |= this.executeWrite(error);
                if (!(isErrorReceived |= this.executeRead(error))) {
                    this.pendingError = error;
                }
            }
            catch (Throwable throwable) {
                this.handleCallbackError(throwable);
            }
        }

        private boolean executeConnect(Throwable error) {
            Consumer<Throwable> connectCallback = this.connectCallback;
            this.connectCallback = null;
            if (connectCallback == null) {
                return false;
            }
            connectCallback.accept(error);
            return true;
        }

        private boolean executeWrite(Throwable error) {
            Consumer<Throwable> writeCallback = this.writeCallback;
            this.writeCallback = null;
            if (writeCallback == null) {
                return false;
            }
            writeCallback.accept(error);
            return true;
        }

        private boolean executeRead(Throwable error) {
            Consumer<Throwable> readCallback = this.readCallback;
            this.readCallback = null;
            if (readCallback == null) {
                return false;
            }
            readCallback.accept(error);
            return true;
        }

        private void handleCallbackError(Throwable throwable) {
            CommonDiagnosable.getInstance().debug(Level.SEVERE, SecurityLabel.INTERNAL, null, null, null, "I/O Readiness callback threw an exception", throwable);
        }
    }
}

