/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIosessrls
extends T4CTTIfun {
    String sessrlstag;
    long sessrlsmode;
    static final int SESSRLS_DROPSESS = 1;
    static final int SESSRLS_DEAUTHENTICATE = 2;
    static final int SESSRLS_RETAG = 4;
    static final int SESSRLS_MULTIPROPERTY_TAG = 8;

    T4CTTIosessrls(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)26);
        this.setFunCode((short)163);
    }

    @Override
    void marshal() throws IOException {
        try {
            byte[] byArray = null;
            this.sessrlsmode = 0L;
            if (this.connection.drcpTagName != null) {
                byArray = this.meg.conv.StringToCharBytes(this.connection.drcpTagName);
                this.meg.marshalPTR();
                this.meg.marshalSWORD(byArray.length);
                this.sessrlsmode |= 4L;
                if (this.connection.getTTCVersion() >= 8 && this.connection.useDRCPMultipletag) {
                    this.sessrlsmode |= 8L;
                }
            } else {
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
            }
            this.meg.marshalUB4(this.sessrlsmode);
            if (byArray != null) {
                this.meg.marshalCHR(byArray);
            }
        }
        catch (SQLException sQLException) {
        }
    }

    void receive() throws SQLException, IOException {
        int n2 = this.meg.unmarshalSWORD();
        if (n2 > 0) {
            byte[] byArray = this.meg.unmarshalCHR(n2);
            this.sessrlstag = new String(byArray);
        }
        this.sessrlsmode = this.meg.unmarshalUB4();
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

