/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.jdbc.XAConnectionConnectionPool;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleXAConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.other.OtherConnectionProxyFactory;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class PoolXADataSourceImpl
extends PoolDataSourceImpl
implements PoolXADataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    private static final long serialVersionUID = 4343640747511L;
    private XADataSource m_xaDataSource = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public PoolXADataSourceImpl() {
    }

    PoolXADataSourceImpl(String poolName, String dsName, Map<String, Object> config) throws UniversalConnectionPoolException, Exception {
        super(poolName, dsName, config);
    }

    @Override
    protected void createPoolWithDefaultProperties() throws SQLException {
        String className = this.getClass().getName();
        int errCode = 27;
        try {
            this.m_xaDataSource = (XADataSource)this.connectionFactory;
            this.ilogFinest(null, null, null, null, "XADataSource is set");
            errCode = 1;
            if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.startsWith("oracle.jdbc")) {
                OracleXADataSourceConnectionFactoryAdapter ocfa = new OracleXADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.connectionPool = new OracleXAConnectionConnectionPool(ocfa);
                ocfa.setUniversalConnectionPool(this.connectionPool);
                this.connectionPool.setOraclePool(true);
            } else {
                XADataSourceConnectionFactoryAdapter cfa = new XADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.connectionPool = new XAConnectionConnectionPool(cfa){
                    private final ConnectionProxyFactory cpf;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    {
                        this.cpf = new OtherConnectionProxyFactory();
                    }

                    @Override
                    protected ConnectionProxyFactory getProxyFactory() {
                        return this.cpf;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(PoolXADataSourceImpl.class, JDBCConnectionFactoryAdapter.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("getProxyFactory", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                };
                cfa.setUniversalConnectionPool(this.connectionPool);
                this.connectionPool.setOraclePool(false);
            }
            assert (this.connectionPool != null);
            this.connectionPool.setConnectionFactory(this.connectionFactory);
            this.ilogFine(null, null, null, null, "connection pool is created");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(errCode, e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ilogFinest(null, null, null, null, "PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(String username, @Blind String password) throws SQLException {
        this.ilogFinest(null, null, null, null, "PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(Properties labels) throws SQLException {
        this.ilogFinest(null, null, null, null, "PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(String username, @Blind String password, Properties labels) throws SQLException {
        this.ilogFinest(null, null, null, null, "PoolXADataSourceImpl.getConnection() is disabled");
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPasswordReal(), null);
    }

    @Override
    public XAConnection getXAConnection(String user, @Blind String password) throws SQLException {
        return this.getXAConnection(user, password, null);
    }

    @Override
    public XAConnection getXAConnection(Properties labels) throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPasswordReal(), labels);
    }

    @Override
    public XAConnection getXAConnection(String username, @Blind String password, Properties labels) throws SQLException {
        if (null == this.getUser()) {
            this.setUser(username);
        }
        if (null == this.getPasswordReal()) {
            this.setPassword(password);
        }
        return this.createXAConnectionBuilder().user(username).password(password).labels(labels).build();
    }

    XAConnection getXAConnection(UCPXAConnectionBuilderImpl builder) throws SQLException {
        this.startPool(Objects.equals(this.getUser(), builder.user) && Objects.equals(this.getPasswordReal(), builder.password.get()));
        XAConnection xaconn = null;
        try {
            if (builder.serviceName == null) {
                builder.serviceName(this.getServiceName());
            }
            if (builder.user == null) {
                builder.user(this.getUser());
            }
            if (builder.password == OpaqueString.NULL) {
                builder.internalPassword(this.getPasswordInternal());
            }
            if (builder.pdbRoles == null) {
                builder.pdbRoles(this.getPdbRoles());
            }
            if (builder.sslContext == null) {
                builder.sslContext(this.getSSLContext());
            }
            if (builder.hostnameResolver == null) {
                builder.hostnameResolver(this.getHostnameResolver());
            }
            if (!builder.readOnlyInstanceAllowed) {
                builder.readOnlyInstanceAllowed(this.isReadOnlyInstanceAllowed());
            }
            JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(builder);
            JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)this.connectionPool.borrowConnection(cri);
            jdbcPooledConnection.setMaxStatements(this.connectionPool.getMaxStatements());
            xaconn = this.connectionPool.getProxyFactory().proxyForXAConnection(this.connectionPool, jdbcPooledConnection);
        }
        catch (NoAvailableConnectionsException e) {
            UCPErrorHandler.throwSQLException(28, e);
        }
        catch (UniversalConnectionPoolException e) {
            UCPErrorHandler.throwSQLException(29, e);
        }
        return xaconn;
    }

    @Override
    public UCPXAConnectionBuilder createXAConnectionBuilder() {
        return new UCPXAConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public XAConnection build() throws SQLException {
                return PoolXADataSourceImpl.this.getXAConnection(this);
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(PoolXADataSourceImpl.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$12 = PoolXADataSourceImpl.class.getDeclaredConstructor(String.class, String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = PoolXADataSourceImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = PoolXADataSourceImpl.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", UCPXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = PoolXADataSourceImpl.class.getDeclaredMethod("createPoolWithDefaultProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

