/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.TimerTask;

@DefaultLogger(value="oracle.ucp.util")
public class UCPTimerManagerImpl
implements TimerManager {
    private static final int NUMBER_OF_THREADS = 5;
    private static final ScheduledThreadPoolExecutor scheduler;
    private final Set<ScheduledFuture<?>> setScheduledFutures = new LinkedHashSet();
    private boolean running = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    private synchronized TimerHandle scheduleHelper(TimerTask task, long delay, long interval) {
        if (Objects.isNull(task)) {
            throw new NullPointerException("task is null");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("negative delay");
        }
        if (interval < 0L) {
            throw new IllegalArgumentException("negative interval");
        }
        final ScheduledFuture<?> future = interval > 0L ? scheduler.scheduleAtFixedRate(task, delay, interval, TimeUnit.MILLISECONDS) : scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
        this.setScheduledFutures.add(future);
        final UCPTimerManagerImpl timerManagerThis = this;
        return new TimerHandle(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                Object object = timerManagerThis;
                synchronized (object) {
                    if (UCPTimerManagerImpl.this.setScheduledFutures.remove(future)) {
                        future.cancel(true);
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(UCPTimerManagerImpl.class, Object.class, ScheduledFuture.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("cancel", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public synchronized TimerHandle schedule(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(task, delay, interval);
    }

    @Override
    public synchronized TimerHandle scheduleAtFixedRate(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(task, delay, interval);
    }

    @Override
    public synchronized void start() {
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        this.running = false;
    }

    static {
        try {
            $$$methodRef$$$7 = UCPTimerManagerImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UCPTimerManagerImpl.class.getDeclaredMethod("lambda$static$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UCPTimerManagerImpl.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UCPTimerManagerImpl.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UCPTimerManagerImpl.class.getDeclaredMethod("scheduleAtFixedRate", TimerTask.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UCPTimerManagerImpl.class.getDeclaredMethod("schedule", TimerTask.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UCPTimerManagerImpl.class.getDeclaredMethod("isRunning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UCPTimerManagerImpl.class.getDeclaredMethod("scheduleHelper", TimerTask.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        scheduler = AccessController.doPrivileged(() -> {
            ThreadFactory tf = new ThreadFactory(){
                private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
                private static final String THREAD_NAME_PREFIX = "UCP-ScheduledThreadPoolExecutor-Thread-";
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Thread newThread(Runnable r) {
                    Thread newT = new Thread(null, r, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                    newT.setPriority(5);
                    newT.setDaemon(true);
                    return newT;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
            return new ScheduledThreadPoolExecutor(5, tf);
        });
    }
}

