/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.ucp.jdbc.oracle.RACAffinityContext;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.WEB_AFFINITY, Feature.TRANSACTION_AFFINITY})
class OracleConnectionAffinityContext
implements Serializable,
Cloneable,
RACAffinityContext {
    private static final long serialVersionUID = 1554319099870773354L;
    public static String DEFAULT_VERSION_NUMBER;
    public static String DEFAULT_SERVICE_NAME;
    public static String DEFAULT_DATATBASE_UNIQ_NAME;
    public static String DEFAULT_INSTANCE_NAME;
    public static String DEFAULT_CONNECTIONPOOL_ID;
    public static String DEFAULT_CONNECTION_ID;
    private String m_versionNumber = DEFAULT_VERSION_NUMBER;
    private String m_serviceName = DEFAULT_SERVICE_NAME;
    private String m_dbUniqName = DEFAULT_DATATBASE_UNIQ_NAME;
    private String m_instanceName = DEFAULT_INSTANCE_NAME;
    private String m_connectionPoolID = DEFAULT_CONNECTIONPOOL_ID;
    private boolean m_isForInstanceAffinity = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    OracleConnectionAffinityContext() {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_serviceName = DEFAULT_SERVICE_NAME;
        this.m_dbUniqName = DEFAULT_DATATBASE_UNIQ_NAME;
        this.m_instanceName = DEFAULT_INSTANCE_NAME;
        this.m_connectionPoolID = DEFAULT_CONNECTIONPOOL_ID;
        this.m_isForInstanceAffinity = false;
    }

    OracleConnectionAffinityContext(OracleDatabaseInstanceInfo dbInfo, String poolName) {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_serviceName = dbInfo.getServiceName();
        this.m_dbUniqName = dbInfo.getDatabaseName();
        this.m_instanceName = dbInfo.getInstanceName();
        this.m_connectionPoolID = poolName;
        this.m_isForInstanceAffinity = false;
    }

    public void setVersionNumber(String versionNumber) {
        this.m_versionNumber = versionNumber;
    }

    @Override
    public String getVersionNumber() {
        return this.m_versionNumber;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setDatabaseUniqueName(String dbUniqname) {
        this.m_dbUniqName = dbUniqname;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.m_dbUniqName;
    }

    public void setInstanceName(String instanceName) {
        this.m_instanceName = instanceName;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setConnectionPoolID(String poolID) {
        this.m_connectionPoolID = poolID;
    }

    public String getConnectionPoolID() {
        return this.m_connectionPoolID;
    }

    @Override
    public RACAffinityContext.AffinityType getAffinityType() {
        return this.isForInstanceAffinity() ? RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY : RACAffinityContext.AffinityType.WEBSESSION_BASED_AFFINITY;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OracleConnectionAffinityContext)) {
            return false;
        }
        OracleConnectionAffinityContext affinityContext = (OracleConnectionAffinityContext)obj;
        return this.isForInstanceAffinity() == affinityContext.isForInstanceAffinity() && Util.sameOrEqual(this.m_connectionPoolID, affinityContext.getConnectionPoolID()) && Util.sameOrEqual(this.m_serviceName, affinityContext.getServiceName()) && Util.sameOrEqual(this.m_dbUniqName, affinityContext.getDatabaseUniqueName()) && Util.sameOrEqual(this.m_instanceName, affinityContext.getInstanceName());
    }

    public int hashCode() {
        String result = this.m_connectionPoolID + "##" + this.m_serviceName + "##" + this.m_instanceName + "##" + this.m_dbUniqName + "##" + this.m_isForInstanceAffinity;
        return result.hashCode();
    }

    @DisableTrace
    public String toString() {
        return this.getClass().getName() + ": versionNumber=" + this.m_versionNumber + ", isForInstanceAffinity=" + this.m_isForInstanceAffinity + ", connectionPoolID=" + this.m_connectionPoolID + ", instanceName=" + this.m_instanceName + ", dbUniqName=" + this.m_dbUniqName + ", serviceName=" + this.m_serviceName;
    }

    public Object clone() {
        OracleConnectionAffinityContext acopy = new OracleConnectionAffinityContext();
        acopy.setConnectionPoolID(this.m_connectionPoolID);
        acopy.setServiceName(this.m_serviceName);
        acopy.setDatabaseUniqueName(this.m_dbUniqName);
        acopy.setInstanceName(this.m_instanceName);
        acopy.setVersionNumber(this.m_versionNumber);
        acopy.setForInstanceAffinity(this.m_isForInstanceAffinity);
        return acopy;
    }

    void setForInstanceAffinity(boolean isForInstanceAffinity) {
        this.m_isForInstanceAffinity = isForInstanceAffinity;
    }

    boolean isForInstanceAffinity() {
        return this.m_isForInstanceAffinity;
    }

    static {
        try {
            $$$methodRef$$$18 = OracleConnectionAffinityContext.class.getDeclaredConstructor(OracleDatabaseInstanceInfo.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = OracleConnectionAffinityContext.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = OracleConnectionAffinityContext.class.getDeclaredMethod("isForInstanceAffinity", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = OracleConnectionAffinityContext.class.getDeclaredMethod("setForInstanceAffinity", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = OracleConnectionAffinityContext.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = OracleConnectionAffinityContext.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = OracleConnectionAffinityContext.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = OracleConnectionAffinityContext.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = OracleConnectionAffinityContext.class.getDeclaredMethod("getAffinityType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = OracleConnectionAffinityContext.class.getDeclaredMethod("getConnectionPoolID", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = OracleConnectionAffinityContext.class.getDeclaredMethod("setConnectionPoolID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = OracleConnectionAffinityContext.class.getDeclaredMethod("getInstanceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = OracleConnectionAffinityContext.class.getDeclaredMethod("setInstanceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = OracleConnectionAffinityContext.class.getDeclaredMethod("getDatabaseUniqueName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = OracleConnectionAffinityContext.class.getDeclaredMethod("setDatabaseUniqueName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = OracleConnectionAffinityContext.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = OracleConnectionAffinityContext.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OracleConnectionAffinityContext.class.getDeclaredMethod("getVersionNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OracleConnectionAffinityContext.class.getDeclaredMethod("setVersionNumber", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        DEFAULT_VERSION_NUMBER = "1.0";
        DEFAULT_SERVICE_NAME = null;
        DEFAULT_DATATBASE_UNIQ_NAME = null;
        DEFAULT_INSTANCE_NAME = null;
        DEFAULT_CONNECTIONPOOL_ID = null;
        DEFAULT_CONNECTION_ID = null;
    }
}

