/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class XSSecureIdI
extends XSSecureId {
    byte[] kpxssidpmac = null;
    byte[] kpxssidpmtid = null;
    long kpxssidpnonce = 0L;

    XSSecureIdI() {
    }

    @Override
    public void setMac(byte[] byArray) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxssidpmac = (byte[])(byArray == null ? null : Arrays.copyOf(byArray, byArray.length));
    }

    @Override
    public void setMidtierId(byte[] byArray) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxssidpmtid = (byte[])(byArray == null ? null : Arrays.copyOf(byArray, byArray.length));
    }

    @Override
    public void setNonce(long l2) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxssidpnonce = l2;
    }

    @Override
    public byte[] getMac() {
        InternalFactory.xsSecurityCheck();
        if (this.kpxssidpmac == null) {
            return null;
        }
        return Arrays.copyOf(this.kpxssidpmac, this.kpxssidpmac.length);
    }

    @Override
    public byte[] getMidtierId() {
        InternalFactory.xsSecurityCheck();
        if (this.kpxssidpmtid == null) {
            return null;
        }
        return Arrays.copyOf(this.kpxssidpmtid, this.kpxssidpmtid.length);
    }

    @Override
    public long getNonce() {
        InternalFactory.xsSecurityCheck();
        return this.kpxssidpnonce;
    }

    void marshal(T4CMAREngine t4CMAREngine) throws IOException {
        if (this.kpxssidpmac != null) {
            t4CMAREngine.marshalUB4(this.kpxssidpmac.length);
            t4CMAREngine.marshalCLR(this.kpxssidpmac, this.kpxssidpmac.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        if (this.kpxssidpmtid != null) {
            t4CMAREngine.marshalUB4(this.kpxssidpmtid.length);
            t4CMAREngine.marshalCLR(this.kpxssidpmtid, this.kpxssidpmtid.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        t4CMAREngine.marshalUB4(this.kpxssidpnonce);
    }

    static XSSecureIdI unmarshal(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        int n2;
        byte[] byArray = null;
        byte[] byArray2 = null;
        long l2 = 0L;
        int n3 = (int)t4CMAREngine.unmarshalUB4();
        if (n3 > 0) {
            byArray = t4CMAREngine.unmarshalNBytes(n3);
        }
        if ((n2 = (int)t4CMAREngine.unmarshalUB4()) > 0) {
            byArray2 = t4CMAREngine.unmarshalNBytes(n2);
        }
        l2 = t4CMAREngine.unmarshalUB4();
        XSSecureIdI xSSecureIdI = new XSSecureIdI();
        xSSecureIdI.setMac(byArray);
        xSSecureIdI.setMidtierId(byArray2);
        xSSecureIdI.setNonce(l2);
        return xSSecureIdI;
    }
}

