/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.pool.OracleDataSource;

public class NTFDCNConnection
extends Thread {
    private String clientId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn = null;
    private T4CTTIoaqnfy oaqnfy = null;
    private volatile boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private int numberOfRegistrations = 0;
    private NTFDCNConnectionGroup connectionGroup = null;
    static final int STARTED = 0;
    static final int NOT_STARTED = 1;
    int status = 1;
    boolean dcnStartedException = false;
    private Properties connectionProps = null;

    NTFDCNConnection(String string, ArrayList<String> arrayList, String string2, String string3, String string4, @Blind String string5, Properties properties, String string6, int n2) {
        this.userName = string4;
        this.password = OpaqueString.newOpaqueString(string5);
        this.connectionProps = properties;
        this.serviceName = string3;
        this.clientId = string;
        this.listenerAddresses = arrayList;
        this.instanceName = string2;
        this.connClass = string6;
        this.numberOfRegistrations = n2;
        assert (arrayList != null) : "listenerAddresses is null";
        assert (string2 != null) : "instancename is null";
    }

    @Override
    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 2 && !this.needToBeClosed; ++i2) {
            try {
                if (i2 == 0 || bl2) {
                    this.conn = this.getConnection(n2);
                    this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.clientId, true);
                    this.oaqnfy.setDCNConnection(this);
                }
                if (bl || !this.needToBeClosed) {
                    bl = false;
                    bl2 = false;
                    i2 = 0;
                }
                this.oaqnfy.doRPC();
                continue;
            }
            catch (IOException iOException) {
                this.needToBeClosed = true;
                continue;
            }
            catch (Exception exception) {
                if (this.needToBeClosed || bl) {
                    this.dcnStartedException = true;
                    break;
                }
                if (exception instanceof SQLException) {
                    n3 = ((SQLException)exception).getErrorCode();
                }
                if (n3 == 17410) {
                    bl2 = true;
                    n3 = 0;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception2) {}
                } else {
                    bl2 = false;
                }
                bl = true;
            }
        }
    }

    Connection getConnection(int n2) throws SQLException, InterruptedException {
        Connection connection = null;
        OracleDataSource oracleDataSource = new OracleDataSource();
        Properties properties = new Properties();
        if (this.connectionProps != null) {
            properties.putAll((Map<?, ?>)this.connectionProps);
        }
        if (this.userName != null) {
            oracleDataSource.setUser(this.userName);
            oracleDataSource.setPassword(this.password.get());
        }
        if (this.connClass != null) {
            properties.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
            properties.put("oracle.jdbc.jmsNotification", "true");
            properties.put("oracle.jdbc.ReadTimeout", (Object)0);
            properties.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
        }
        oracleDataSource.setConnectionProperties(properties);
        while (connection == null && n2++ < 5 && !this.needToBeClosed) {
            connection = this.tryListenerAddressesToGetConnection(oracleDataSource);
            if (connection != null || n2 >= 5) continue;
            Thread.sleep(n2 * 5000);
        }
        if (connection == null && !this.needToBeClosed) {
            throw new SQLException("Failed to create notification connection to emon server");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource oracleDataSource) {
        for (String string : this.listenerAddresses) {
            String string2 = "jdbc:oracle:thin:@(DESCRIPTION=" + string + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
            oracleDataSource.setURL(string2);
            try {
                NTFDCNConnection nTFDCNConnection = this;
                synchronized (nTFDCNConnection) {
                    if (this.needToBeClosed) {
                        return null;
                    }
                    Connection connection = oracleDataSource.getConnection();
                    if (connection != null) {
                        return connection;
                    }
                }
            }
            catch (SQLException sQLException) {
            }
        }
        return null;
    }

    synchronized void closeThisListener() {
        this.needToBeClosed = true;
        try {
            if (this.oaqnfy != null) {
                this.oaqnfy.stopListening();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
        }
    }

    synchronized void signalConnectionStarted() {
        this.status = 0;
        this.notify();
    }

    void setNeedToBeClosed(boolean bl) {
        this.needToBeClosed = bl;
    }

    String getClientId() {
        return this.clientId;
    }

    int getNumberOfRegistrations() {
        return this.numberOfRegistrations;
    }

    void incrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations += n2;
    }

    void decrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations -= n2;
    }

    void setConnectionGroup(NTFDCNConnectionGroup nTFDCNConnectionGroup) {
        this.connectionGroup = nTFDCNConnectionGroup;
    }

    NTFDCNConnectionGroup getConnectionGroup() {
        if (this.connectionGroup == null) {
            this.connectionGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
        }
        return this.connectionGroup;
    }
}

