/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.util.Vector;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class DescriptionList
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    public boolean sourceRoute = false;
    public boolean loadBalance = true;
    public boolean failover = true;
    protected SchemaObjectFactoryInterface f = null;

    public DescriptionList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    @Override
    public int isA() {
        return 3;
    }

    @Override
    public String isA_String() {
        return "DESCRIPTION_LIST";
    }

    @Override
    public void initFromString(String string) throws NLException, SOException, NetException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    @Override
    public void initFromNVPair(NVPair nVPair) throws SOException, NetException {
        this.init();
        int n2 = nVPair.getListSize();
        if (n2 == 0) {
            throw new SOException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.childnv = nVPair.getListElement(i2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("DESCRIPTION")) {
                this.child = this.f.create(2);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            throw new SOException();
        }
        if (this.children.size() == 0) {
            throw new SOException();
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        String string = new String("");
        if (this.children.size() < 1) {
            return string;
        }
        String string2 = new String("");
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            string2 = ((SchemaObject)this.children.elementAt(i2)).toString();
            if (string2.equals("")) continue;
            string = string + string2;
        }
        if (string.equals("") && this.sourceRoute) {
            string = string + "(SOURCE_ROUTE=yes)";
        }
        if (string.equals("") && !this.loadBalance) {
            string = string + "(LOAD_BALANCE=no)";
        }
        if (string.equals("") && !this.failover) {
            string = string + "(FAILOVER=false)";
        }
        if (!string.equals("")) {
            string = "(DESCRIPTION_LIST=" + string + ")";
        }
        return string;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = true;
        this.failover = true;
    }
}

