/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.jdbc.nl.NVTokens;

public class NVFactory {
    public NVPair createNVPair(String nvString) throws InvalidSyntaxException, NLException {
        NVTokens nvt = new NVTokens();
        nvt.parseTokens(nvString);
        return this._readTopLevelNVPair(nvt);
    }

    private NVPair _readTopLevelNVPair(NVTokens nvt) throws InvalidSyntaxException, NLException {
        int tk = nvt.getToken();
        nvt.eatToken();
        if (tk != 1) {
            Object[] local = new Object[]{"(", this.getContext(nvt)};
            throw new InvalidSyntaxException("SyntaxError-04602", local);
        }
        String name = this._readNVLiteral(nvt);
        NVPair nvp = new NVPair(name);
        tk = nvt.getToken();
        if (tk == 3) {
            while (tk == 8 || tk == 3) {
                name = name + nvt.popLiteral();
                tk = nvt.getToken();
            }
            nvp.setName(name);
            return this._readRightHandSide(nvp, nvt);
        }
        return this._readRightHandSide(nvp, nvt);
    }

    private NVPair _readNVPair(NVTokens nvt) throws InvalidSyntaxException, NLException {
        int tk = nvt.getToken();
        nvt.eatToken();
        if (tk != 1 && tk != 3) {
            Object[] local = new Object[]{"( or ,", this.getContext(nvt)};
            throw new InvalidSyntaxException("SyntaxError-04602", local);
        }
        String name = this._readNVLiteral(nvt);
        NVPair nvp = new NVPair(name);
        return this._readRightHandSide(nvp, nvt);
    }

    private NVPair _readRightHandSide(NVPair nvp, NVTokens nvt) throws InvalidSyntaxException, NLException {
        int tk = nvt.getToken();
        switch (tk) {
            case 4: {
                nvt.eatToken();
                tk = nvt.getToken();
                if (tk == 8) {
                    String value = this._readNVLiteral(nvt);
                    nvp.setAtom(value);
                    break;
                }
                this._readNVList(nvt, nvp);
                break;
            }
            case 2: 
            case 3: {
                nvp.setAtom(nvp.getName());
                break;
            }
            default: {
                Object[] local = new Object[]{"=", this.getContext(nvt)};
                throw new InvalidSyntaxException("SyntaxError-04602", local);
            }
        }
        tk = nvt.getToken();
        if (tk == 2) {
            nvt.eatToken();
        } else if (tk != 3) {
            Object[] local = new Object[]{nvt.getLiteral(), this.getContext(nvt)};
            throw new InvalidSyntaxException("UnexpectedChar-04605", local);
        }
        return nvp;
    }

    private String _readNVLiteral(NVTokens nvt) throws InvalidSyntaxException, NLException {
        int tk = nvt.getToken();
        if (tk != 8) {
            Object[] local = new Object[]{"LITERAL", this.getContext(nvt)};
            throw new InvalidSyntaxException("SyntaxError-04602", local);
        }
        return nvt.popLiteral();
    }

    private void _readNVList(NVTokens nvt, NVPair parent) throws InvalidSyntaxException, NLException {
        int tk = nvt.getToken();
        if (tk != 1 && tk != 3) {
            return;
        }
        NVPair child = this._readNVPair(nvt);
        parent.addListElement(child);
        if ((tk == 3 || child.getName() == child.getAtom()) && parent.getListType() != NVPair.LIST_COMMASEP) {
            parent.setListType(NVPair.LIST_COMMASEP);
        }
        this._readNVList(nvt, parent);
    }

    private String getContext(NVTokens nvt) throws NLException {
        return " " + nvt.popLiteral() + " " + nvt.popLiteral() + " " + nvt.popLiteral();
    }
}

