/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public class SQLStateMapping {
    private static final String CLASS_NAME = SQLStateMapping.class.getName();
    static final SQLStateMapping DEFAULT_SQLSTATE = new SQLStateMapping(Integer.MIN_VALUE, Integer.MAX_VALUE, "99999", SqlExceptionType.SQLEXCEPTION);
    public final int low;
    final int high;
    public final String sqlState;
    public final SqlExceptionType exception;
    static final String mappingResource = "errorMap.xml";
    static SQLStateMapping[] all;
    private static final int NUMEBER_OF_MAPPINGS_IN_ERRORMAP_XML = 128;

    public SQLStateMapping(int l, int h, String s, SqlExceptionType ex) {
        this.low = l;
        this.sqlState = s;
        this.exception = ex;
        this.high = h;
    }

    public boolean isIncluded(int value) {
        return this.low <= value && value <= this.high;
    }

    public SQLException newSQLException(String reason, int vendorCode) {
        return this.exception.newInstance(reason, this.sqlState, vendorCode);
    }

    boolean lessThan(SQLStateMapping rhs) {
        if (this.low < rhs.low) {
            return this.high < rhs.high;
        }
        return this.high <= rhs.high;
    }

    public String toString() {
        return super.toString() + "(" + this.low + ", " + this.high + ", " + this.sqlState + ", " + this.exception + ")";
    }

    public static void main(String[] args) throws IOException {
        SQLStateMapping[] a = SQLStateMapping.doGetMappings();
        System.out.println("a\t" + a);
        for (int i = 0; i < a.length; ++i) {
            System.out.println("low:\t" + a[i].low + "\thigh:\t" + a[i].high + "\tsqlState:\t" + a[i].sqlState + "\tsqlException:\t" + a[i].exception);
        }
    }

    public static SQLStateMapping[] getMappings() {
        if (all == null) {
            try {
                all = SQLStateMapping.doGetMappings();
            }
            catch (Throwable e) {
                CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "getMappings", "ORA Error number to SQLState code mapping resource not loaded correctly ", null, e);
                all = new SQLStateMapping[0];
            }
        }
        return all;
    }

    static SQLStateMapping[] doGetMappings() throws IOException {
        InputStream s = SQLStateMapping.class.getResourceAsStream(mappingResource);
        ArrayList<SQLStateMapping> list = new ArrayList<SQLStateMapping>(128);
        SQLStateMapping.load(s, list);
        return list.toArray(new SQLStateMapping[0]);
    }

    static void load(InputStream is, List<SQLStateMapping> list) throws IOException {
        String token;
        BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        Tokenizer st = new Tokenizer(r);
        int oraErrorFrom = -1;
        int oraErrorTo = -1;
        String sqlState = null;
        SqlExceptionType sqlException = null;
        String comment = null;
        int s = 0;
        block39: while ((token = st.next()) != null) {
            switch (s) {
                case 0: {
                    if (!token.equals("<")) continue block39;
                    s = 1;
                    continue block39;
                }
                case 1: {
                    if (token.equals("!")) {
                        s = 2;
                        continue block39;
                    }
                    if (token.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        s = 6;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 2: {
                    if (token.equals("-")) {
                        s = 3;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 3: {
                    if (!token.equals("-")) continue block39;
                    s = 4;
                    continue block39;
                }
                case 4: {
                    if (token.equals("-")) {
                        s = 5;
                        continue block39;
                    }
                    s = 3;
                    continue block39;
                }
                case 5: {
                    if (token.equals(">")) {
                        s = 0;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 6: {
                    if (token.equals(">")) {
                        s = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 7: {
                    if (token.equals("<")) {
                        s = 8;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"<\".");
                }
                case 8: {
                    if (token.equals("!")) {
                        s = 9;
                        continue block39;
                    }
                    if (token.equals("error")) {
                        s = 14;
                        continue block39;
                    }
                    if (token.equals("/")) {
                        s = 16;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected one of \"!--\", \"error\", \"/\".");
                }
                case 9: {
                    if (token.equals("-")) {
                        s = 10;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 10: {
                    if (token.equals("-")) {
                        s = 11;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 11: {
                    if (!token.equals("-")) continue block39;
                    s = 12;
                    continue block39;
                }
                case 12: {
                    if (token.equals("-")) {
                        s = 13;
                        continue block39;
                    }
                    s = 11;
                    continue block39;
                }
                case 13: {
                    if (token.equals(">")) {
                        s = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 14: {
                    if (token.equals("/")) {
                        s = 15;
                        continue block39;
                    }
                    if (token.equals("oraErrorFrom")) {
                        s = 19;
                        continue block39;
                    }
                    if (token.equals("oraErrorTo")) {
                        s = 21;
                        continue block39;
                    }
                    if (token.equals("sqlState")) {
                        s = 23;
                        continue block39;
                    }
                    if (token.equals("sqlException")) {
                        s = 25;
                        continue block39;
                    }
                    if (token.equals("comment")) {
                        s = 27;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected one of \"oraErrorFrom\", \"oraErrorTo\", \"sqlState\", \"sqlException\", \"comment\", \"/\".");
                }
                case 15: {
                    if (token.equals(">")) {
                        try {
                            SQLStateMapping.createOne(list, oraErrorFrom, oraErrorTo, sqlState, sqlException, comment);
                        }
                        catch (IOException e) {
                            throw new IOException("Invalid error element at line " + st.lineno + " of errorMap.xml. " + e.getMessage());
                        }
                        oraErrorFrom = -1;
                        oraErrorTo = -1;
                        sqlState = null;
                        sqlException = null;
                        comment = null;
                        s = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 16: {
                    if (token.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        s = 17;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 17: {
                    if (token.equals(">")) {
                        s = 18;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 18: {
                    continue block39;
                }
                case 19: {
                    if (token.equals("=")) {
                        s = 20;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 20: {
                    try {
                        oraErrorFrom = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Unexpected value \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    s = 14;
                    continue block39;
                }
                case 21: {
                    if (token.equals("=")) {
                        s = 22;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 22: {
                    try {
                        oraErrorTo = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Unexpected value \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    s = 14;
                    continue block39;
                }
                case 23: {
                    if (token.equals("=")) {
                        s = 24;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 24: {
                    sqlState = token;
                    s = 14;
                    continue block39;
                }
                case 25: {
                    if (token.equals("=")) {
                        s = 26;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 26: {
                    try {
                        sqlException = SqlExceptionType.valueOf(token);
                    }
                    catch (Exception e) {
                        throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected SQLException subclass name.");
                    }
                    s = 14;
                    continue block39;
                }
                case 27: {
                    if (token.equals("=")) {
                        s = 28;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 28: {
                    comment = token;
                    s = 14;
                    continue block39;
                }
            }
            throw new IOException("Unknown parser state " + s + " at line " + st.lineno + " of errorMap.xml.");
        }
    }

    private static void createOne(List<SQLStateMapping> list, int oraErrorFrom, int oraErrorTo, String sqlState, SqlExceptionType sqlException, String comment) throws IOException {
        if (oraErrorFrom == -1) {
            throw new IOException("oraErrorFrom is a required attribute");
        }
        if (oraErrorTo == -1) {
            oraErrorTo = oraErrorFrom;
        }
        if (sqlState == null || sqlState.length() == 0) {
            throw new IOException("sqlState is a required attribute");
        }
        if (sqlException == null) {
            throw new IOException("sqlException is a required attribute");
        }
        if (comment == null || comment.length() < 8) {
            throw new IOException("a lengthy comment in required");
        }
        SQLStateMapping m = new SQLStateMapping(oraErrorFrom, oraErrorTo, sqlState, sqlException);
        SQLStateMapping.add(list, m);
    }

    static void add(List<SQLStateMapping> l, SQLStateMapping a) {
        int i;
        for (i = l.size(); i > 0 && !l.get(i - 1).lessThan(a); --i) {
        }
        l.add(i, a);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SqlExceptionType {
        SQLEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLNONTRANSIENTEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLNonTransientException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLTRANSIENTEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLTransientException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLDATAEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLDataException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLFEATURENOTSUPPORTEDEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLFeatureNotSupportedException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLIntegrityConstraintViolationException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLINVALIDAUTHORIZATIONSPECEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLInvalidAuthorizationSpecException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLNONTRANSIENTCONNECTIONEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLNonTransientConnectionException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLSYNTAXERROREXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLSyntaxErrorException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLTIMEOUTEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLTimeoutException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLTRANSACTIONROLLBACKEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLTransactionRollbackException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLTRANSIENTCONNECTIONEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLTransientConnectionException(reason, sqlState, vendorCode);
            }
        }
        ,
        SQLCLIENTINFOEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLClientInfoException(reason, sqlState, vendorCode, null);
            }
        }
        ,
        SQLRECOVERABLEEXCEPTION{

            @Override
            SQLException newInstance(String reason, String sqlState, int vendorCode) {
                return new SQLRecoverableException(reason, sqlState, vendorCode);
            }
        };


        abstract SQLException newInstance(String var1, String var2, int var3);
    }

    private static final class Tokenizer {
        int lineno = 1;
        Reader r;
        int c;

        Tokenizer(Reader r) throws IOException {
            this.r = r;
            this.c = r.read();
        }

        String next() throws IOException {
            StringBuffer b = new StringBuffer(16);
            boolean skipping = true;
            while (this.c != -1) {
                if (this.c == 10) {
                    ++this.lineno;
                }
                if (this.c <= 32 && skipping) {
                    this.c = this.r.read();
                    continue;
                }
                if (this.c <= 32 && !skipping) {
                    this.c = this.r.read();
                    break;
                }
                if (this.c == 34) {
                    while ((this.c = this.r.read()) != 34) {
                        b.append((char)this.c);
                    }
                    this.c = this.r.read();
                    break;
                }
                if (48 <= this.c && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95) {
                    do {
                        b.append((char)this.c);
                    } while (48 <= (this.c = this.r.read()) && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95);
                    break;
                }
                b.append((char)this.c);
                this.c = this.r.read();
                break;
            }
            if (b.length() > 0) {
                return b.toString();
            }
            return null;
        }
    }
}

