/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.driver.TxnReplayableArray;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;

public class ARRAY
extends DatumWithConnection
implements oracle.jdbc.internal.OracleArray,
OracleConcreteProxy {
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    protected oracle.jdbc.driver.OracleArray target = null;
    private oracle.jdbc.internal.OracleArray ojiOracleArray = null;

    public oracle.jdbc.driver.OracleArray getTarget() {
        return this.target;
    }

    private void setTarget(OracleConnection conn, oracle.jdbc.driver.OracleArray a, String typeName, Object elements, boolean recordConstructor) throws SQLException {
        Class<TxnReplayableArray> proxyClass = TxnReplayableArray.class;
        this.ojiOracleArray = ConcreteProxyUtil.getProxyObject(conn, a, proxyClass, this);
        this.target = a;
        this.setShareBytes(this.target.shareBytes());
        this.targetDatumWithConnection = this.target;
        this.targetDatum = this.target;
        if (this.ojiOracleArray != null) {
            try {
                Object proxyObj = ConcreteProxyUtil.checkAndGetACProxyConnection(conn);
                if (proxyObj != null && recordConstructor) {
                    ((TxnReplayableConnection)proxyObj).ARRAYConstructorRecording(typeName, elements, this);
                }
            }
            catch (SQLException sqe) {
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle/sql/ARRAY", "setTarget", sqe.getMessage(), null, null);
            }
            this.ojiOracleDatumWithConnection = this.ojiOracleArray;
        } else {
            this.ojiOracleArray = this.target;
        }
    }

    public void createAndSetShardingLobProxy(Class proxyClass, Object creator) {
        this.ojiOracleArray = ConcreteProxyUtil.getProxyObject(this.ojiOracleArray, proxyClass, creator);
        this.ojiOracleDatumWithConnection = this.ojiOracleArray;
    }

    @Override
    public TxnReplayableBase getConcreteProxy() {
        if (this.ojiOracleArray instanceof TxnReplayableBase) {
            return (TxnReplayableBase)((Object)this.ojiOracleArray);
        }
        return null;
    }

    public ARRAY(ArrayDescriptor type, Connection conn, Object elements) throws SQLException {
        OracleConnection delegateConn = null;
        String typeNameByUser = type != null ? type.typeNameByUser : null;
        delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate((OracleConnection)conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        oracle.jdbc.driver.OracleArray a = new oracle.jdbc.driver.OracleArray(type, conn, elements);
        this.setTarget((OracleConnection)conn, a, typeNameByUser, elements, delegateConn != null);
    }

    public ARRAY(ArrayDescriptor type, byte[] bytes, Connection conn) throws SQLException {
        oracle.jdbc.driver.OracleArray a = new oracle.jdbc.driver.OracleArray(type, bytes, conn);
        this.setTarget((OracleConnection)conn, a, null, null, false);
    }

    public static ARRAY toARRAY(Object obj, OracleConnection conn) throws SQLException {
        ARRAY s = null;
        if (obj != null) {
            if (obj instanceof ARRAY) {
                s = (ARRAY)obj;
            } else if (obj instanceof ORAData) {
                s = (ARRAY)((ORAData)obj).toDatum(conn);
            } else if (obj instanceof OracleData) {
                Object jdbcObject = ((OracleData)obj).toJDBCObject(conn);
                if (jdbcObject instanceof _Proxy_) {
                    final _Proxy_ proxiedJDBCObject = (_Proxy_)jdbcObject;
                    jdbcObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return ProxyFactory.extractDelegate(proxiedJDBCObject);
                        }
                    });
                }
                s = (ARRAY)jdbcObject;
            } else if (obj instanceof CustomDatum) {
                s = (ARRAY)conn.physicalConnectionWithin().toDatum((CustomDatum)obj);
            } else {
                throw (SQLException)DatabaseError.createSqlException(59, obj).fillInStackTrace();
            }
        }
        return s;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.ojiOracleArray.getBaseTypeName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.ojiOracleArray.getBaseType();
    }

    @Override
    public Object getArray() throws SQLException {
        return this.ojiOracleArray.getArray();
    }

    @Override
    public Map<?, ?> getJavaMap() throws SQLException {
        return this.ojiOracleArray.getJavaMap();
    }

    public Object getArray(Map map) throws SQLException {
        return this.ojiOracleArray.getArray(map);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getArray(index, count);
    }

    public Object getArray(long index, int count, Map map) throws SQLException {
        return this.ojiOracleArray.getArray(index, count, map);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ojiOracleArray.getResultSet();
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.ojiOracleArray.getResultSet(map);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.ojiOracleArray.getResultSet(index, count);
    }

    public ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        return this.ojiOracleArray.getResultSet(index, count, map);
    }

    @Override
    public Datum[] getOracleArray() throws SQLException {
        return this.ojiOracleArray.getOracleArray();
    }

    @Override
    public int length() throws SQLException {
        return this.ojiOracleArray.length();
    }

    @Override
    public Datum[] getOracleArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getOracleArray(index, count);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.ojiOracleArray.getSQLTypeName();
    }

    @Override
    public Map getMap() throws SQLException {
        return this.ojiOracleArray.getMap();
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.ojiOracleArray.getOracleMetaData();
    }

    @Override
    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.ojiOracleArray.getDescriptor();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        return this.ojiOracleArray.toBytes();
    }

    @Override
    public void setDatumArray(Datum[] darray) {
        this.ojiOracleArray.setDatumArray(darray);
    }

    @Override
    public void setObjArray(Object oarray) throws SQLException {
        this.ojiOracleArray.setObjArray(oarray);
    }

    @Override
    public void setJavaMap(Map<?, ?> map) throws SQLException {
        this.ojiOracleArray.setJavaMap(map);
    }

    @Override
    public void setLocator(byte[] pseg_bytes) {
        this.ojiOracleArray.setLocator(pseg_bytes);
    }

    @Override
    public void setPrefixSegment(byte[] pseg_bytes) {
        this.ojiOracleArray.setPrefixSegment(pseg_bytes);
    }

    @Override
    public void setPrefixFlag(byte psegFlag) {
        this.ojiOracleArray.setPrefixFlag(psegFlag);
    }

    @Override
    public byte[] getLocator() {
        return this.ojiOracleArray.getLocator();
    }

    @Override
    public void setLength(int len) {
        this.ojiOracleArray.setLength(len);
    }

    @Override
    public boolean hasDataSeg() {
        return this.ojiOracleArray.hasDataSeg();
    }

    @Override
    public boolean isInline() {
        return this.ojiOracleArray.isInline();
    }

    @Override
    public Object toJdbc() throws SQLException {
        this.target.toJdbc();
        Map<String, Class<?>> map = this.target.getMap();
        return this.toJdbc(map);
    }

    public Object toJdbc(Map map) throws SQLException {
        Class c;
        if (this.target.isFreed()) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        Object jdbcObject = this;
        if (map != null && (c = this.target.getDescriptor().getClass(map)) != null) {
            jdbcObject = this.toClass(c, map);
        }
        return jdbcObject;
    }

    Object toClass(Class clazz, Map map) throws SQLException {
        Object obj;
        block7: {
            if (this.target.isFreed()) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
            }
            obj = null;
            try {
                if (clazz == null || clazz == ARRAY.class || clazz == Array.class || clazz == OracleArray.class || clazz == oracle.jdbc.internal.OracleArray.class) {
                    obj = this;
                    break block7;
                }
                Object i = clazz.newInstance();
                if (i instanceof ORADataFactory) {
                    ORADataFactory f = (ORADataFactory)i;
                    obj = f.create(this, 2003);
                    break block7;
                }
                if (i instanceof OracleDataFactory) {
                    OracleDataFactory f = (OracleDataFactory)i;
                    obj = f.create(this, 2003);
                    break block7;
                }
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.target.getDescriptor().getName());
            }
            catch (InstantiationException ex) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage());
            }
        }
        return obj;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return this.ojiOracleArray.isConvertibleTo(jClass);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return this.ojiOracleArray.makeJdbcArray(arraySize);
    }

    @Override
    public int[] getIntArray() throws SQLException {
        return this.ojiOracleArray.getIntArray();
    }

    @Override
    public int[] getIntArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getIntArray(index, count);
    }

    @Override
    public double[] getDoubleArray() throws SQLException {
        return this.ojiOracleArray.getDoubleArray();
    }

    @Override
    public double[] getDoubleArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getDoubleArray(index, count);
    }

    @Override
    public short[] getShortArray() throws SQLException {
        return this.ojiOracleArray.getShortArray();
    }

    @Override
    public short[] getShortArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getShortArray(index, count);
    }

    @Override
    public long[] getLongArray() throws SQLException {
        return this.ojiOracleArray.getLongArray();
    }

    @Override
    public long[] getLongArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getLongArray(index, count);
    }

    @Override
    public float[] getFloatArray() throws SQLException {
        return this.ojiOracleArray.getFloatArray();
    }

    @Override
    public float[] getFloatArray(long index, int count) throws SQLException {
        return this.ojiOracleArray.getFloatArray(index, count);
    }

    @Override
    public void setAutoBuffering(boolean enable) throws SQLException {
        this.ojiOracleArray.setAutoBuffering(enable);
    }

    @Override
    public boolean getAutoBuffering() throws SQLException {
        return this.ojiOracleArray.getAutoBuffering();
    }

    @Override
    public void setAutoIndexing(boolean enable, int direction) throws SQLException {
        this.ojiOracleArray.setAutoIndexing(enable, direction);
    }

    @Override
    public void setAutoIndexing(boolean enable) throws SQLException {
        this.ojiOracleArray.setAutoIndexing(enable);
    }

    @Override
    public boolean getAutoIndexing() throws SQLException {
        return this.ojiOracleArray.getAutoIndexing();
    }

    @Override
    public int getAccessDirection() throws SQLException {
        return this.ojiOracleArray.getAccessDirection();
    }

    @Override
    public void setLastIndexOffset(long index, long offset) throws SQLException {
        this.ojiOracleArray.setLastIndexOffset(index, offset);
    }

    @Override
    public void setIndexOffset(long index, long offset) throws SQLException {
        this.ojiOracleArray.setIndexOffset(index, offset);
    }

    @Override
    public long getLastIndex() throws SQLException {
        return this.ojiOracleArray.getLastIndex();
    }

    @Override
    public long getLastOffset() throws SQLException {
        return this.ojiOracleArray.getLastOffset();
    }

    @Override
    public long getOffset(long index) throws SQLException {
        return this.ojiOracleArray.getOffset(index);
    }

    @Override
    public void setImage(byte[] image, long offset, long length) throws SQLException {
        this.ojiOracleArray.setImage(image, offset, length);
    }

    @Override
    public void setImageLength(long length) throws SQLException {
        this.ojiOracleArray.setImageLength(length);
    }

    @Override
    public long getImageOffset() {
        return this.ojiOracleArray.getImageOffset();
    }

    @Override
    public long getImageLength() {
        return this.ojiOracleArray.getImageLength();
    }

    public String dump() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        if (this.target.isFreed()) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return STRUCT.dump(this);
    }

    @Override
    public String stringValue() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.stringValue();
    }

    static void dump(ARRAY x, PrintWriter pw, int indent) throws SQLException {
        int i;
        if (indent > 0) {
            pw.println();
        }
        ArrayDescriptor desc = x.getDescriptor();
        for (i = 0; i < indent; ++i) {
            pw.print(' ');
        }
        pw.println("name = " + desc.getName());
        for (i = 0; i < indent; ++i) {
            pw.print(' ');
        }
        pw.println("max length = " + desc.getMaxLength());
        Object[] elems = (Object[])x.getArray();
        for (i = 0; i < indent; ++i) {
            pw.print(' ');
        }
        int length = elems.length;
        pw.println("length = " + length);
        for (i = 0; i < length; ++i) {
            for (int j = 0; j < indent; ++j) {
                pw.print(' ');
            }
            pw.print("element[" + i + "] = ");
            STRUCT.dump(elems[i], pw, indent + 4);
        }
    }

    @Override
    public void free() throws SQLException {
        this.ojiOracleArray.free();
    }

    @Override
    public int getNumElems() {
        return this.ojiOracleArray.getNumElems();
    }

    @Override
    public Datum[] getDatumArray() {
        return this.ojiOracleArray.getDatumArray();
    }

    @Override
    public Object getObjArray() {
        return this.ojiOracleArray.getObjArray();
    }

    @Override
    public void setNullObjArray() {
        this.ojiOracleArray.setNullObjArray();
    }

    @Override
    public void setACProxy(Object w) {
        this.ojiOracleArray.setACProxy(w);
    }

    @Override
    public Object getACProxy() {
        return this.ojiOracleArray.getACProxy();
    }
}

