/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.jdbc.OracleDriver;

class TcpFastOpenLibraryInstaller {
    private static final String LIBRARY_NAME = "libtfojdbc1.so";
    private static final String LIBRARY_HOME_PATH_IN_JAR = "/nativelib/tcpfastopen/linux/";
    private static final int BUFFER_SIZE = 8192;

    TcpFastOpenLibraryInstaller() {
    }

    protected static void install(String installationPath) {
        try {
            TcpFastOpenLibraryInstaller.installInternal(installationPath);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private static void installInternal(String installationPath) throws Exception {
        block17: {
            String libraryPathInJar = TcpFastOpenLibraryInstaller.getLibraryPathInJar();
            String targetPath = TcpFastOpenLibraryInstaller.getTargetPath(installationPath);
            try (InputStream sourceStream = OracleDriver.class.getResourceAsStream(libraryPathInJar);){
                if (sourceStream == null) {
                    throw new IOException("Cannot get resource \"" + libraryPathInJar + "\" from Jar file.");
                }
                File file = new File(targetPath);
                if (file.createNewFile()) {
                    byte[] buffer = new byte[8192];
                    try (FileOutputStream resStreamOut = new FileOutputStream(targetPath);){
                        int readBytes;
                        while ((readBytes = sourceStream.read(buffer)) > 0) {
                            ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
                        }
                    }
                    File directory = new File(installationPath);
                    file = new File(targetPath);
                    String displayMessage = String.format("Installed %s. File size: %d bytes.\n\nTo configure TCP Fast Open, set the following two environment variables: \nLD_PRELOAD: %s\nLD_LIBRARY_PATH: %s", TcpFastOpenLibraryInstaller.getPath(file.getCanonicalPath()), file.length(), TcpFastOpenLibraryInstaller.getPath(file.getCanonicalPath()), TcpFastOpenLibraryInstaller.getPath(directory.getCanonicalPath()));
                    System.out.println(displayMessage);
                    break block17;
                }
                if (TcpFastOpenLibraryInstaller.isSameFile(sourceStream, targetPath)) {
                    System.out.println("The library " + targetPath + " is already installed.");
                } else {
                    System.out.println("Previous installation exists: " + targetPath + ". Please remove and try again.");
                }
            }
        }
    }

    private static boolean isSameFile(InputStream stream1, String path) throws IOException {
        try (InputStream stream2 = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            byte[] buffer1 = new byte[8192];
            byte[] buffer2 = new byte[8192];
            while (true) {
                boolean bl;
                int nRead2;
                int nRead1;
                if ((nRead1 = stream1.read(buffer1, 0, 8192)) != (nRead2 = stream2.read(buffer2, 0, 8192))) {
                    bl = false;
                    return bl;
                }
                for (int i = 0; i < nRead1; ++i) {
                    if (buffer1[i] == buffer2[i]) continue;
                    boolean bl2 = false;
                    return bl2;
                }
                if (nRead1 >= 8192) continue;
                bl = true;
                return bl;
            }
        }
    }

    private static String getPath(String path) {
        return path.contains(" ") ? TcpFastOpenLibraryInstaller.getQuotedString(path) : path;
    }

    private static String getQuotedString(String string) {
        return "\"" + string + "\"";
    }

    private static String getLibraryPathInJar() throws Exception {
        String archDir;
        String osName = System.getProperty("os.name");
        if (!osName.equalsIgnoreCase("Linux")) {
            throw new Exception(String.format("Unsupported platform. Supported Linux distributions are %s.", TcpFastOpenLibraryInstaller.getTcpFastOpenSupportedDistributions()));
        }
        String osArch = System.getProperty("os.arch");
        if (osArch.equalsIgnoreCase("amd64") || osArch.equalsIgnoreCase("x86_64")) {
            archDir = "x86_64/";
        } else if (osArch.equalsIgnoreCase("aarch64") || osArch.equalsIgnoreCase("arm64")) {
            archDir = "aarch64/";
        } else {
            throw new Exception(String.format("Unsupported platform. Supported Linux distributions are %s.", TcpFastOpenLibraryInstaller.getTcpFastOpenSupportedDistributions()));
        }
        return LIBRARY_HOME_PATH_IN_JAR + archDir + LIBRARY_NAME;
    }

    private static String getTargetPath(String installationPath) {
        return installationPath.endsWith("/") ? installationPath + LIBRARY_NAME : installationPath + "/libtfojdbc1.so";
    }

    private static Set<String> getTcpFastOpenSupportedDistributions() throws IOException {
        CodeSource codeSource = OracleDriver.class.getProtectionDomain().getCodeSource();
        HashSet<String> setofSupportedDistro = new HashSet<String>();
        String pattern = LIBRARY_HOME_PATH_IN_JAR.substring(1);
        if (codeSource != null) {
            URL jar = codeSource.getLocation();
            try (ZipInputStream zipInputStream = new ZipInputStream(jar.openStream());){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String path = zipEntry.getName();
                    if (!path.startsWith(pattern) || path.equals(pattern)) continue;
                    String str1 = path.substring(LIBRARY_HOME_PATH_IN_JAR.length() - 1);
                    String str2 = str1.substring(0, str1.indexOf(47));
                    setofSupportedDistro.add(str2);
                }
            }
        }
        return setofSupportedDistro;
    }
}

