/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ucp.proxy.HashUtil;

class GeneratedProxiesRegistry {
    private Map<Key, Value> registry = new ConcurrentHashMap<Key, Value>();

    GeneratedProxiesRegistry() {
    }

    void put(String proxyPackage, Class<?> iface, Class<?> superclass, Value value) {
        this.registry.put(new Key(proxyPackage, iface, superclass), value);
    }

    Value get(String proxyPackage, Class<?> iface, Class<?> superclass) {
        return this.registry.get(new Key(proxyPackage, iface, superclass));
    }

    int size() {
        return this.registry.size();
    }

    Set<Key> keySet() {
        return this.registry.keySet();
    }

    Collection<Value> values() {
        return this.registry.values();
    }

    static class Key {
        private final String proxyPackage;
        private static final String SUFFIX = "$$$Proxy";
        private final Class<?> iface;
        private final Class<?> superclass;
        private Integer hashCode = null;

        Key(String proxyPackage, Class<?> iface, Class<?> superclass) {
            this.proxyPackage = Key.endWithDot(Objects.requireNonNull(proxyPackage).trim());
            this.iface = Objects.requireNonNull(iface);
            this.superclass = Objects.requireNonNull(superclass);
        }

        Key(String proxyPackage, String proxyClassName) {
            this(proxyPackage, Key.parseIface(proxyPackage, proxyClassName), Key.parseSuperclass(proxyPackage, proxyClassName));
        }

        private static String endWithDot(String prefix) {
            return prefix.endsWith(".") ? prefix : prefix + ".";
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            try {
                Key that = (Key)obj;
                return this.proxyPackage.equals(that.proxyPackage) && this.iface.equals(that.iface) && this.superclass.equals(that.superclass);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            if (null == this.hashCode) {
                this.hashCode = 23;
                this.hashCode = HashUtil.hash((int)this.hashCode, this.proxyPackage);
                this.hashCode = HashUtil.hash((int)this.hashCode, this.iface);
                this.hashCode = HashUtil.hash((int)this.hashCode, this.superclass);
            }
            return this.hashCode;
        }

        public String toString() {
            return this.proxyPackage + this.superclass.getName().replace(".", "$1") + "$2" + this.iface.getName().replace(".", "$1") + SUFFIX;
        }

        private static Class<?> parseSuperclass(String prefix, String name) {
            try {
                String s = name.substring(prefix.length());
                String ss = s.replaceAll("\\$1", ".");
                String sss = ss.substring(0, ss.indexOf("$2"));
                return Class.forName(sss);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private static Class<?> parseIface(String prefix, String name) {
            try {
                String s = name.substring(prefix.length());
                String ss = s.replaceAll("\\$1", ".");
                String sss = ss.substring(ss.indexOf("$2") + 2, ss.indexOf(SUFFIX));
                return Class.forName(sss);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public Class<?> getIface() {
            return this.iface;
        }

        public Class<?> getSuperclass() {
            return this.superclass;
        }

        public String makePathname() {
            return this.toString().replace(".", "/") + ".class";
        }
    }

    static class Value {
        private final String name;
        private final String source;
        private final Class<?> clazz;
        private final Constructor<?> constructor;

        Value(String name, String source, Class<?> clazz, Constructor<?> constructor) {
            this.name = name;
            this.source = source;
            this.clazz = clazz;
            this.constructor = constructor;
        }

        String getName() {
            return this.name;
        }

        String getSource() {
            return this.source;
        }

        Class<?> getClazz() {
            return this.clazz;
        }

        Constructor<?> getConstructor() {
            return this.constructor;
        }
    }
}

