/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLType;
import java.util.Collections;
import java.util.List;

public class ShardingMetadata {
    public static final int SUPER_SHARDING_KEY_LEVEL = 0;
    public static final int SHARDING_KEY_LEVEL = 1;
    private final int version;
    private final ShardingType shardingType;
    private final ShardingType superShardingType;
    private final List<SubKeyMetadata> shardingKeyColumns;
    private final List<SubKeyMetadata> superShardingKeyColumns;

    public ShardingMetadata(int version, ShardingType shardingType, ShardingType superShardingType, List<SubKeyMetadata> keyColumns, List<SubKeyMetadata> superKeyColumns) {
        this.version = version;
        this.shardingType = shardingType;
        this.superShardingType = superShardingType;
        if (keyColumns != null) {
            Collections.sort(keyColumns);
            this.shardingKeyColumns = Collections.unmodifiableList(keyColumns);
        } else {
            this.shardingKeyColumns = null;
        }
        if (superKeyColumns != null) {
            Collections.sort(superKeyColumns);
            this.superShardingKeyColumns = Collections.unmodifiableList(superKeyColumns);
        } else {
            this.superShardingKeyColumns = null;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public ShardingType getShardingType() {
        return this.shardingType;
    }

    public ShardingType getSuperShardingType() {
        return this.superShardingType;
    }

    public List<SubKeyMetadata> getShardingKeyColumns() {
        return this.shardingKeyColumns;
    }

    public List<SubKeyMetadata> getSuperShardingKeyColumns() {
        return this.superShardingKeyColumns;
    }

    public static enum ShardingType {
        HASH("HASH"),
        LIST("LIST"),
        RANGE("RANGE"),
        DIRECTORY("DIRECTORY"),
        NONE("NONE");

        String typeStr;

        private ShardingType(String typeStr) {
            this.typeStr = typeStr;
        }

        static ShardingType toShardType(String typeStr) {
            if (typeStr == null) {
                return NONE;
            }
            for (ShardingType type : ShardingType.values()) {
                if (!type.typeStr.equals(typeStr)) continue;
                return type;
            }
            return NONE;
        }
    }

    public static class SubKeyMetadata
    implements Comparable<SubKeyMetadata> {
        private final int colIndex;
        private final SQLType dataType;
        private final int charSet;

        public SubKeyMetadata(int index, SQLType dataType, int charSet) {
            this.dataType = dataType;
            this.charSet = charSet;
            this.colIndex = index;
        }

        SQLType getDataType() {
            return this.dataType;
        }

        int getCharSet() {
            return this.charSet;
        }

        @Override
        public int compareTo(SubKeyMetadata o) {
            if (this == o) {
                return 0;
            }
            if (this.colIndex == o.colIndex) {
                throw new IllegalStateException("Illegal Shard Column index in Metadata");
            }
            if (this.colIndex < o.colIndex) {
                return -1;
            }
            return 1;
        }
    }
}

