/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oracle.jdbc.OracleType;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.VectorData;
import oracle.jdbc.driver.utils.ThrowingFunction;
import oracle.sql.Datum;

public final class VECTOR
extends Datum {
    private static final Map<Class<?>, ThrowingFunction<VECTOR, ?, SQLException>> CONVERSIONS;
    private static final boolean IS_COMPUTING_NORM = false;

    private VECTOR(byte[] vectorEncoding) {
        super(vectorEncoding);
    }

    public static VECTOR fromData(byte[] data) {
        Objects.requireNonNull(data, "data is null");
        return new VECTOR(data);
    }

    public static VECTOR ofFloat64Values(Object object) throws SQLException {
        return VECTOR.createVector(object, OracleType.VECTOR_FLOAT64);
    }

    public static VECTOR ofFloat32Values(Object object) throws SQLException {
        return VECTOR.createVector(object, OracleType.VECTOR_FLOAT32);
    }

    public static VECTOR ofInt8Values(Object object) throws SQLException {
        return VECTOR.createVector(object, OracleType.VECTOR_INT8);
    }

    public static VECTOR ofBinaryValues(Object object) throws SQLException {
        return VECTOR.createVector(object, OracleType.VECTOR_BINARY);
    }

    private static VECTOR createVector(Object object, OracleType type) throws SQLException {
        Objects.requireNonNull(object, "object is null");
        byte[] data = VectorData.encode(object, type, false);
        return new VECTOR(data);
    }

    public OracleType getType() throws SQLException {
        return VectorData.decodeType(this.shareBytes());
    }

    public double[] toDoubleArray() throws SQLException {
        return VECTOR.toDoubleArray(this.shareBytes());
    }

    public static double[] toDoubleArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, double[].class, false);
    }

    public float[] toFloatArray() throws SQLException {
        return VECTOR.toFloatArray(this.shareBytes());
    }

    public static float[] toFloatArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, float[].class, false);
    }

    public long[] toLongArray() throws SQLException {
        return VECTOR.toLongArray(this.shareBytes());
    }

    public static long[] toLongArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, long[].class, false);
    }

    public int[] toIntArray() throws SQLException {
        return VECTOR.toIntArray(this.shareBytes());
    }

    public static int[] toIntArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, int[].class, false);
    }

    public short[] toShortArray() throws SQLException {
        return VECTOR.toShortArray(this.shareBytes());
    }

    public static short[] toShortArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, short[].class, false);
    }

    public byte[] toByteArray() throws SQLException {
        return VECTOR.toByteArray(this.shareBytes());
    }

    public static byte[] toByteArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, byte[].class, false);
    }

    public boolean[] toBooleanArray() throws SQLException {
        return VECTOR.toBooleanArray(this.shareBytes());
    }

    public static boolean[] toBooleanArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, boolean[].class, false);
    }

    @Override
    public String stringValue() throws SQLException {
        return VectorData.decode(this.shareBytes(), String.class, false);
    }

    public String toString() {
        try {
            return this.stringValue();
        }
        catch (SQLException sqlException) {
            return "INVALID VECTOR ENCODING: " + sqlException.getMessage();
        }
    }

    public int hashCode() {
        try {
            OracleType type = this.getType();
            Object values = this.toClass(this.preferredArrayClass());
            return Objects.hash(type, values);
        }
        catch (SQLException sqlException) {
            return this.bytesHashCode();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VECTOR)) {
            return false;
        }
        VECTOR vector = (VECTOR)object;
        try {
            if (this.getType() != vector.getType()) {
                return false;
            }
            return Objects.deepEquals(this.toClass(this.preferredArrayClass()), vector.toClass(vector.preferredArrayClass()));
        }
        catch (SQLException sqlException) {
            return false;
        }
    }

    public Class<?> preferredArrayClass() throws SQLException {
        OracleType type = this.getType();
        switch (type) {
            case VECTOR_FLOAT64: {
                return double[].class;
            }
            case VECTOR_FLOAT32: {
                return float[].class;
            }
            case VECTOR_INT8: {
                return byte[].class;
            }
            case VECTOR_BINARY: {
                return byte[].class;
            }
        }
        throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, type);
    }

    public int getVectorLength() {
        try {
            return VectorData.decodeLength(this.shareBytes());
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException(sqlException);
        }
    }

    @Override
    public <T> T toClass(Class<T> type) throws SQLException {
        ThrowingFunction<VECTOR, ?, SQLException> function = CONVERSIONS.get(type);
        if (function == null) {
            return super.toClass(type);
        }
        return type.cast(function.apply(this));
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return CONVERSIONS.containsKey(cls);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new VECTOR[arraySize];
    }

    public boolean isSparse() throws SQLException {
        return VectorData.isSparse(this.shareBytes());
    }

    public SparseDoubleArray toSparseDoubleArray() throws SQLException {
        return this.toSparseDoubleArray(this.shareBytes());
    }

    public SparseDoubleArray toSparseDoubleArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, SparseDoubleArray.class, false);
    }

    public SparseFloatArray toSparseFloatArray() throws SQLException {
        return this.toSparseFloatArray(this.shareBytes());
    }

    public SparseFloatArray toSparseFloatArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, SparseFloatArray.class, false);
    }

    public SparseByteArray toSparseByteArray() throws SQLException {
        return this.toSparseByteArray(this.shareBytes());
    }

    public SparseByteArray toSparseByteArray(byte[] data) throws SQLException {
        Objects.requireNonNull(data, "data is null");
        return VectorData.decode(data, SparseByteArray.class, false);
    }

    static {
        HashMap conversions = new HashMap();
        conversions.put(double[].class, VECTOR::toDoubleArray);
        conversions.put(float[].class, VECTOR::toFloatArray);
        conversions.put(long[].class, VECTOR::toLongArray);
        conversions.put(int[].class, VECTOR::toIntArray);
        conversions.put(short[].class, VECTOR::toShortArray);
        conversions.put(byte[].class, VECTOR::toByteArray);
        conversions.put(boolean[].class, VECTOR::toBooleanArray);
        conversions.put(String.class, VECTOR::stringValue);
        conversions.put(SparseDoubleArray.class, VECTOR::toSparseDoubleArray);
        conversions.put(SparseFloatArray.class, VECTOR::toSparseFloatArray);
        conversions.put(SparseByteArray.class, VECTOR::toSparseByteArray);
        CONVERSIONS = Collections.unmodifiableMap(conversions);
    }

    public static interface SparseDoubleArray
    extends SparseArray {
        public double[] values();

        public static SparseDoubleArray of(int length, int[] indices, double[] doubleValues) {
            return VectorData.createSparseDoubleArray(length, indices, doubleValues);
        }

        public static SparseDoubleArray fromDenseArray(double[] denseArray) {
            return VectorData.createSparseDoubleArray(denseArray);
        }
    }

    public static interface SparseFloatArray
    extends SparseArray {
        public float[] values();

        public static SparseFloatArray of(int length, int[] indices, float[] floatValues) {
            return VectorData.createSparseFloatArray(length, indices, floatValues);
        }

        public static SparseFloatArray fromDenseArray(float[] denseArray) {
            return VectorData.createSparseFloatArray(denseArray);
        }
    }

    public static interface SparseByteArray
    extends SparseArray {
        public byte[] values();

        public static SparseByteArray of(int length, int[] indices, byte[] byteValues) {
            return VectorData.createSparseByteArray(length, indices, byteValues);
        }

        public static SparseByteArray fromDenseArray(byte[] denseArray) {
            return VectorData.createSparseByteArray(denseArray);
        }
    }

    public static interface SparseArray {
        public int length();

        public int[] indices();

        public String toString();
    }
}

