/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.FDBigInt;
import oracle.jdbc.driver.VarnumCopyingBinder;
import oracle.jdbc.internal.Monitor;
import oracle.sql.NUMBER;

abstract class VarnumBinder
extends Binder {
    static final boolean DEBUG = false;
    static final boolean SLOW_CONVERSIONS = true;
    Binder theVarnumCopyingBinder = null;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final int LNXEXPMX = 127;
    static final double[] factorTable = new double[]{1.0E254, 1.0E252, 1.0E250, 1.0E248, 1.0E246, 1.0E244, 1.0E242, 1.0E240, 1.0E238, 1.0E236, 1.0E234, 1.0E232, 1.0E230, 1.0E228, 1.0E226, 1.0E224, 1.0E222, 1.0E220, 1.0E218, 1.0E216, 1.0E214, 1.0E212, 1.0E210, 1.0E208, 1.0E206, 1.0E204, 1.0E202, 1.0E200, 1.0E198, 1.0E196, 1.0E194, 1.0E192, 1.0E190, 1.0E188, 1.0E186, 1.0E184, 1.0E182, 1.0E180, 1.0E178, 1.0E176, 1.0E174, 1.0E172, 1.0E170, 1.0E168, 1.0E166, 1.0E164, 1.0E162, 1.0E160, 1.0E158, 1.0E156, 1.0E154, 1.0E152, 1.0E150, 1.0E148, 1.0E146, 1.0E144, 1.0E142, 1.0E140, 1.0E138, 1.0E136, 1.0E134, 1.0E132, 1.0E130, 1.0E128, 1.0E126, 1.0E124, 1.0E122, 1.0E120, 1.0E118, 1.0E116, 1.0E114, 1.0E112, 1.0E110, 1.0E108, 1.0E106, 1.0E104, 1.0E102, 1.0E100, 1.0E98, 1.0E96, 1.0E94, 1.0E92, 1.0E90, 1.0E88, 1.0E86, 1.0E84, 1.0E82, 1.0E80, 1.0E78, 1.0E76, 1.0E74, 1.0E72, 1.0E70, 1.0E68, 1.0E66, 1.0E64, 1.0E62, 1.0E60, 1.0E58, 1.0E56, 1.0E54, 1.0E52, 1.0E50, 1.0E48, 1.0E46, 1.0E44, 1.0E42, 1.0E40, 1.0E38, 1.0E36, 1.0E34, 1.0E32, 1.0E30, 1.0E28, 1.0E26, 1.0E24, 1.0E22, 1.0E20, 1.0E18, 1.0E16, 1.0E14, 1.0E12, 1.0E10, 1.0E8, 1000000.0, 10000.0, 100.0, 1.0, 0.01, 1.0E-4, 1.0E-6, 1.0E-8, 1.0E-10, 1.0E-12, 1.0E-14, 1.0E-16, 1.0E-18, 1.0E-20, 1.0E-22, 1.0E-24, 1.0E-26, 1.0E-28, 1.0E-30, 1.0E-32, 1.0E-34, 1.0E-36, 1.0E-38, 1.0E-40, 1.0E-42, 1.0E-44, 1.0E-46, 1.0E-48, 1.0E-50, 1.0E-52, 1.0E-54, 1.0E-56, 1.0E-58, 1.0E-60, 1.0E-62, 1.0E-64, 1.0E-66, 1.0E-68, 1.0E-70, 1.0E-72, 1.0E-74, 1.0E-76, 1.0E-78, 1.0E-80, 1.0E-82, 1.0E-84, 1.0E-86, 1.0E-88, 1.0E-90, 1.0E-92, 1.0E-94, 1.0E-96, 1.0E-98, 1.0E-100, 1.0E-102, 1.0E-104, 1.0E-106, 1.0E-108, 1.0E-110, 1.0E-112, 1.0E-114, 1.0E-116, 1.0E-118, 1.0E-120, 1.0E-122, 1.0E-124, 1.0E-126, 1.0E-128, 1.0E-130, 1.0E-132, 1.0E-134, 1.0E-136, 1.0E-138, 1.0E-140, 1.0E-142, 1.0E-144, 1.0E-146, 1.0E-148, 1.0E-150, 1.0E-152, 1.0E-154, 1.0E-156, 1.0E-158, 1.0E-160, 1.0E-162, 1.0E-164, 1.0E-166, 1.0E-168, 1.0E-170, 1.0E-172, 1.0E-174, 1.0E-176, 1.0E-178, 1.0E-180, 1.0E-182, 1.0E-184, 1.0E-186, 1.0E-188, 1.0E-190, 1.0E-192, 1.0E-194, 1.0E-196, 1.0E-198, 1.0E-200, 1.0E-202, 1.0E-204, 1.0E-206, 1.0E-208, 1.0E-210, 1.0E-212, 1.0E-214, 1.0E-216, 1.0E-218, 1.0E-220, 1.0E-222, 1.0E-224, 1.0E-226, 1.0E-228, 1.0E-230, 1.0E-232, 1.0E-234, 1.0E-236, 1.0E-238, 1.0E-240, 1.0E-242, 1.0E-244, 1.0E-246, 1.0E-248, 1.0E-250, 1.0E-252, 1.0E-254};
    static final int MANTISSA_SIZE = 53;
    static final int expShift = 52;
    static final long fractHOB = 0x10000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expBias = 1023;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final long expOne = 0x3FF0000000000000L;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int[] small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    static final long[] long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
    static final int[] n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
    static volatile FDBigInt[] b5p;
    private static final Monitor M5POW;

    static void init(Binder x) {
        x.type = (short)6;
        x.bytelen = 22;
    }

    VarnumBinder() {
        VarnumBinder.init(this);
    }

    @Override
    Binder copyingBinder() {
        if (this.theVarnumCopyingBinder == null) {
            this.theVarnumCopyingBinder = new VarnumCopyingBinder();
        }
        return this.theVarnumCopyingBinder;
    }

    static int setLongInternal(byte[] b, int offset, long val) {
        return NUMBER.toBytes(val, b, offset);
    }

    static int countBits(long v) {
        if (v == 0L) {
            return 0;
        }
        while ((v & 0xFF00000000000000L) == 0L) {
            v <<= 8;
        }
        while (v > 0L) {
            v <<= 1;
        }
        int n = 0;
        while ((v & 0xFFFFFFFFFFFFFFL) != 0L) {
            v <<= 8;
            n += 8;
        }
        while (v != 0L) {
            v <<= 1;
            ++n;
        }
        return n;
    }

    boolean roundup(char[] digits, int nDigits) {
        int i = nDigits - 1;
        char q = digits[i];
        if (q == '9') {
            while (q == '9' && i > 0) {
                digits[i] = 48;
                q = digits[--i];
            }
            if (q == '9') {
                digits[0] = 49;
                return true;
            }
        }
        digits[i] = (char)(q + '\u0001');
        return false;
    }

    static FDBigInt big5pow(int p) {
        if (p < 0) {
            throw new RuntimeException("Assertion botch: negative power of 5");
        }
        if (b5p != null && b5p.length > p && b5p[p] != null) {
            return b5p[p];
        }
        try (Monitor.CloseableLock lock = M5POW.acquireCloseableLock();){
            Object t;
            if (b5p != null && b5p.length > p && b5p[p] != null) {
                FDBigInt fDBigInt = b5p[p];
                return fDBigInt;
            }
            if (b5p == null) {
                b5p = new FDBigInt[p + 1];
            } else if (b5p.length <= p) {
                t = new FDBigInt[p + 1];
                System.arraycopy(b5p, 0, t, 0, b5p.length);
                b5p = t;
            }
            if (b5p[p] != null) {
                t = b5p[p];
                return t;
            }
            if (p < small5pow.length) {
                VarnumBinder.b5p[p] = new FDBigInt(small5pow[p]);
                t = VarnumBinder.b5p[p];
                return t;
            }
            if (p < long5pow.length) {
                VarnumBinder.b5p[p] = new FDBigInt(long5pow[p]);
                t = VarnumBinder.b5p[p];
                return t;
            }
            int q = p >> 1;
            int r = p - q;
            FDBigInt bigq = b5p[q];
            if (bigq == null) {
                bigq = VarnumBinder.big5pow(q);
            }
            if (r < small5pow.length) {
                FDBigInt fDBigInt = VarnumBinder.b5p[p] = bigq.mult(small5pow[r]);
                return fDBigInt;
            }
            FDBigInt bigr = b5p[r];
            if (bigr == null) {
                bigr = VarnumBinder.big5pow(r);
            }
            FDBigInt fDBigInt = VarnumBinder.b5p[p] = bigq.mult(bigr);
            return fDBigInt;
        }
    }

    static FDBigInt multPow52(FDBigInt v, int p5, int p2) {
        if (p5 != 0) {
            v = p5 < small5pow.length ? v.mult(small5pow[p5]) : v.mult(VarnumBinder.big5pow(p5));
        }
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    static FDBigInt constructPow52(int p5, int p2) {
        FDBigInt v = new FDBigInt(VarnumBinder.big5pow(p5));
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    int dtoa(byte[] b, int offset, double val, boolean neg, boolean forFloat, char[] digits, int binExp, long fractBits, int nSignificantBits) {
        int exp100;
        boolean oddExp;
        int decExponent = Integer.MAX_VALUE;
        int nDigits = -1;
        int nFractBits = VarnumBinder.countBits(fractBits);
        int nTinyBits = nFractBits - binExp - 1;
        boolean done = false;
        if (nTinyBits < 0) {
            nTinyBits = 0;
        }
        if (binExp <= 62 && binExp >= -21 && nTinyBits < long5pow.length && nFractBits + n5bits[nTinyBits] < 64 && nTinyBits == 0) {
            int digitno;
            int ndigits;
            long halfULP = binExp > nSignificantBits ? 1L << binExp - nSignificantBits - 1 : 0L;
            fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
            decExponent = 0;
            long lvalue = fractBits;
            long insignificant = halfULP;
            int i = 0;
            while (insignificant >= 10L) {
                insignificant /= 10L;
                ++i;
            }
            if (i != 0) {
                long pow10 = long5pow[i] << i;
                long residue = lvalue % pow10;
                lvalue /= pow10;
                decExponent += i;
                if (residue >= pow10 >> 1) {
                    ++lvalue;
                }
            }
            if (lvalue <= Integer.MAX_VALUE) {
                int ivalue = (int)lvalue;
                ndigits = 10;
                digitno = ndigits - 1;
                c = ivalue % 10;
                ivalue /= 10;
                while (c == 0) {
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                while (ivalue != 0) {
                    digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                digits[digitno] = (char)(c + 48);
            } else {
                ndigits = 20;
                digitno = ndigits - 1;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
                while (c == 0) {
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                while (lvalue != 0L) {
                    digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                digits[digitno] = (char)(c + 48);
            }
            ndigits -= digitno;
            if (digitno != 0) {
                System.arraycopy(digits, digitno, digits, 0, ndigits);
            }
            ++decExponent;
            nDigits = ndigits;
            done = true;
        }
        if (!done) {
            long lowDigitDifference;
            boolean high;
            boolean low;
            double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
            int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981);
            int B5 = Math.max(0, -decExp);
            int B2 = B5 + nTinyBits + binExp;
            int S5 = Math.max(0, decExp);
            int S2 = S5 + nTinyBits;
            int M5 = B5;
            int M2 = B2 - nSignificantBits;
            fractBits >>>= 53 - nFractBits;
            int common2factor = Math.min(B2 -= nFractBits - 1, S2);
            B2 -= common2factor;
            S2 -= common2factor;
            M2 -= common2factor;
            if (nFractBits == 1) {
                --M2;
            }
            if (M2 < 0) {
                B2 -= M2;
                S2 -= M2;
                M2 = 0;
            }
            int ndigit = 0;
            int Bbits = nFractBits + B2 + (B5 < n5bits.length ? n5bits[B5] : B5 * 3);
            int tenSbits = S2 + 1 + (S5 + 1 < n5bits.length ? n5bits[S5 + 1] : (S5 + 1) * 3);
            if (Bbits < 64 && tenSbits < 64) {
                if (Bbits < 32 && tenSbits < 32) {
                    int bi = (int)fractBits * small5pow[B5] << B2;
                    int s = small5pow[S5] << S2;
                    int m = small5pow[M5] << M2;
                    int tens = s * 10;
                    ndigit = 0;
                    q = bi / s;
                    low = (bi = 10 * (bi % s)) < (m *= 10);
                    boolean bl = high = bi + m > tens;
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        digits[ndigit++] = (char)(48 + q);
                    }
                    if (decExp <= -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = bi / s;
                        bi = 10 * (bi % s);
                        if ((long)(m *= 10) > 0L) {
                            low = bi < m;
                            high = bi + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (bi << 1) - tens;
                } else {
                    long bl = fractBits * long5pow[B5] << B2;
                    long s = long5pow[S5] << S2;
                    long m = long5pow[M5] << M2;
                    long tens = s * 10L;
                    ndigit = 0;
                    q = (int)(bl / s);
                    low = (bl = 10L * (bl % s)) < (m *= 10L);
                    boolean bl2 = high = bl + m > tens;
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        digits[ndigit++] = (char)(48 + q);
                    }
                    if (decExp <= -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = (int)(bl / s);
                        bl = 10L * (bl % s);
                        if ((m *= 10L) > 0L) {
                            low = bl < m;
                            high = bl + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (bl << 1) - tens;
                }
            } else {
                FDBigInt Bval = VarnumBinder.multPow52(new FDBigInt(fractBits), B5, B2);
                FDBigInt Sval = VarnumBinder.constructPow52(S5, S2);
                FDBigInt Mval = VarnumBinder.constructPow52(M5, M2);
                int shiftBias = Sval.normalizeMe();
                Bval.lshiftMe(shiftBias);
                Mval.lshiftMe(shiftBias);
                FDBigInt tenSval = Sval.mult(10);
                ndigit = 0;
                q = Bval.quoRemIteration(Sval);
                Mval = Mval.mult(10);
                low = Bval.cmp(Mval) < 0;
                boolean bl = high = Bval.add(Mval).cmp(tenSval) > 0;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (decExp <= -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = Bval.quoRemIteration(Sval);
                    low = Bval.cmp(Mval = Mval.mult(10)) < 0;
                    high = Bval.add(Mval).cmp(tenSval) > 0;
                    digits[ndigit++] = (char)(48 + q);
                }
                if (high && low) {
                    Bval.lshiftMe(1);
                    lowDigitDifference = Bval.cmp(tenSval);
                } else {
                    lowDigitDifference = 0L;
                }
            }
            decExponent = decExp + 1;
            nDigits = ndigit;
            if (high) {
                if (low) {
                    if (lowDigitDifference == 0L) {
                        if ((digits[nDigits - 1] & '\u0001') != 0 && this.roundup(digits, nDigits)) {
                            ++decExponent;
                        }
                    } else if (lowDigitDifference > 0L && this.roundup(digits, nDigits)) {
                        ++decExponent;
                    }
                } else if (this.roundup(digits, nDigits)) {
                    ++decExponent;
                }
            }
        }
        while (nDigits - decExponent > 0 && digits[nDigits - 1] == '0') {
            --nDigits;
        }
        boolean bl = oddExp = decExponent % 2 != 0;
        if (oddExp) {
            if (nDigits % 2 == 0) {
                digits[nDigits++] = 48;
            }
            exp100 = (decExponent - 1) / 2;
        } else {
            if (nDigits % 2 == 1) {
                digits[nDigits++] = 48;
            }
            exp100 = (decExponent - 2) / 2;
        }
        int expola = 117 - exp100;
        int digidx = 0;
        int len = 1;
        if (neg) {
            b[offset] = (byte)(62 - exp100);
            if (oddExp) {
                b[offset + len] = (byte)(101 - (digits[digidx++] - 48));
                ++len;
            }
            while (digidx < nDigits) {
                b[offset + len] = (byte)(101 - ((digits[digidx] - 48) * 10 + (digits[digidx + 1] - 48)));
                digidx += 2;
                ++len;
            }
            b[offset + len++] = 102;
        } else {
            b[offset] = (byte)(192 + (exp100 + 1));
            if (oddExp) {
                b[offset + len] = (byte)(digits[digidx++] - 48 + 1);
                ++len;
            }
            while (digidx < nDigits) {
                b[offset + len] = (byte)((digits[digidx] - 48) * 10 + (digits[digidx + 1] - 48) + 1);
                digidx += 2;
                ++len;
            }
        }
        if (neg) {
            trimmedLen = len;
            for (i = offset + (len - 2); i > offset && b[i] == 101; --i) {
                --trimmedLen;
            }
            if (trimmedLen != len) {
                b[offset + (trimmedLen - 1)] = 102;
                len = trimmedLen;
            }
        } else {
            trimmedLen = len;
            for (i = offset + (len - 1); i > offset && b[i] == 1; --i) {
                --trimmedLen;
            }
            if (trimmedLen != len) {
                len = trimmedLen;
            }
        }
        return len;
    }

    static {
        M5POW = Monitor.newInstance();
    }
}

