/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.GeneratedResultSet;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OldUpdatableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;

abstract class OracleResultSet
extends GeneratedResultSet
implements Diagnosable {
    static final boolean DEBUG = false;
    boolean closed = false;
    SQLWarning sqlWarning = null;
    protected boolean needCommitAtClose = false;

    @Override
    public Diagnosable getDiagnosable() {
        return this.connection.getDiagnosable();
    }

    static OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
        if (!stmt.sqlKind.isSELECT()) {
            stmt.realRsetType = ResultSetType.FORWARD_READ_ONLY;
            stmt.described = true;
        }
        if (stmt.realRsetType == ResultSetType.UNKNOWN) {
            return stmt.userRsetType.createResultSet(stmt);
        }
        return stmt.realRsetType.createResultSet(stmt);
    }

    protected OracleResultSet(PhysicalConnection c) {
        super(c);
    }

    protected abstract void doneFetchingRows(boolean var1) throws SQLException;

    @Override
    public abstract OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int var1) throws SQLException;

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(String columnName) throws SQLException {
        return this.getAuthorizationIndicator(this.findColumn(columnName));
    }

    boolean isValidRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "isValidRow").fillInStackTrace();
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.getOracleStatement().connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    protected void doClose() throws SQLException {
        OracleStatement ostmt;
        if (this.needCommitAtClose && (ostmt = this.getOracleStatement()) != null && ostmt.connection != null) {
            ostmt.connection.assertLockHeldByCurrentThread();
            boolean _origFlag = ostmt.connection.autoCommitSpecCompliant;
            ostmt.connection.autoCommitSpecCompliant = false;
            ostmt.connection.commit();
            ostmt.connection.autoCommitSpecCompliant = _origFlag;
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
        }
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public abstract String getCursorName() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract boolean wasNull() throws SQLException;

    @Override
    public abstract boolean isBeforeFirst() throws SQLException;

    @Override
    public abstract boolean isAfterLast() throws SQLException;

    @Override
    public abstract boolean isFirst() throws SQLException;

    @Override
    public abstract boolean isLast() throws SQLException;

    @Override
    public abstract void beforeFirst() throws SQLException;

    @Override
    public abstract void afterLast() throws SQLException;

    @Override
    public abstract boolean first() throws SQLException;

    @Override
    public abstract boolean last() throws SQLException;

    @Override
    public abstract int getRow() throws SQLException;

    @Override
    public abstract boolean absolute(int var1) throws SQLException;

    @Override
    public abstract boolean relative(int var1) throws SQLException;

    @Override
    public abstract boolean previous() throws SQLException;

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
        }
        return 1000;
    }

    @Override
    public abstract void setFetchSize(int var1) throws SQLException;

    @Override
    public abstract int getFetchSize() throws SQLException;

    @Override
    public abstract int getType() throws SQLException;

    protected abstract int doGetType();

    @Override
    public abstract int getConcurrency() throws SQLException;

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, null).fillInStackTrace();
        }
        return 1;
    }

    @Override
    public void insertRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "insertRow").fillInStackTrace();
    }

    @Override
    public void updateRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateRow").fillInStackTrace();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "deleteRow").fillInStackTrace();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, null).fillInStackTrace();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "moveToInsertRow").fillInStackTrace();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "cancelRowUpdates").fillInStackTrace();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "moveToCurrentRow").fillInStackTrace();
    }

    @Override
    public abstract Statement getStatement() throws SQLException;

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateNull").fillInStackTrace();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public abstract <T> T getObject(int var1, Class<T> var2) throws SQLException;

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public void updateObject(int columnIndex, Object value, SQLType targetSqlType) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateObject").fillInStackTrace();
    }

    @Override
    public void updateObject(int columnIndex, Object value, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateObject").fillInStackTrace();
    }

    @Override
    public void updateObject(String columnLabel, Object value, SQLType targetSqlType) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), value, targetSqlType);
    }

    @Override
    public void updateObject(String columnLabel, Object value, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), value, targetSqlType, scaleOrLength);
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    abstract OracleStatement getOracleStatement() throws SQLException;

    abstract int refreshRows(long var1, int var3) throws SQLException;

    void insertRow(RowId rowId) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "call appendRow").fillInStackTrace();
    }

    abstract void removeCurrentRowFromCache() throws SQLException;

    abstract int getColumnCount() throws SQLException;

    boolean isComplete() throws SQLException {
        return this.closed;
    }

    @Override
    public int getBytes(int columnIndex, byte[] buffer, int offset) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    protected void awaitPublishing() throws SQLException {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ResultSetType {
        UNKNOWN(-1, -1, false){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException(23, null).fillInStackTrace();
            }

            @Override
            ResultSetType downgrade() {
                return UNKNOWN;
            }
        }
        ,
        FORWARD_READ_ONLY(1003, 1007, false){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                return new ForwardOnlyResultSet(stmt.connection, stmt);
            }

            @Override
            ResultSetType downgrade() {
                return FORWARD_READ_ONLY;
            }
        }
        ,
        FORWARD_UPDATABLE(1003, 1008, true){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                ForwardOnlyResultSet rs = new ForwardOnlyResultSet(stmt.connection, stmt);
                if (stmt.connection.isOldUpdateableResultSet) {
                    return new OldUpdatableResultSet(stmt, rs);
                }
                return new UpdatableResultSet(stmt, rs);
            }

            @Override
            ResultSetType downgrade() {
                return FORWARD_READ_ONLY;
            }
        }
        ,
        INSENSITIVE_READ_ONLY(1004, 1007, false){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                return new InsensitiveScrollableResultSet(stmt.connection, stmt);
            }

            @Override
            ResultSetType downgrade() {
                return FORWARD_READ_ONLY;
            }
        }
        ,
        INSENSITIVE_UPDATABLE(1004, 1008, true){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                InsensitiveScrollableResultSet rs = new InsensitiveScrollableResultSet(stmt.connection, stmt);
                if (stmt.connection.isOldUpdateableResultSet) {
                    return new OldUpdatableResultSet(stmt, rs);
                }
                return new UpdatableResultSet(stmt, rs);
            }

            @Override
            ResultSetType downgrade() {
                return INSENSITIVE_READ_ONLY;
            }
        }
        ,
        SENSITIVE_READ_ONLY(1005, 1007, true){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                return new SensitiveScrollableResultSet(stmt.connection, stmt);
            }

            @Override
            ResultSetType downgrade() {
                return INSENSITIVE_READ_ONLY;
            }
        }
        ,
        SENSITIVE_UPDATABLE(1005, 1008, true){

            @Override
            OracleResultSet createResultSet(OracleStatement stmt) throws SQLException {
                SensitiveScrollableResultSet rs = new SensitiveScrollableResultSet(stmt.connection, stmt);
                if (stmt.connection.isOldUpdateableResultSet) {
                    return new OldUpdatableResultSet(stmt, rs);
                }
                return new UpdatableResultSet(stmt, rs);
            }

            @Override
            ResultSetType downgrade() {
                return INSENSITIVE_READ_ONLY;
            }
        };

        private final int type;
        private final int concur;
        private final boolean isIdentifierRequired;

        static ResultSetType typeFor(int type, int concur) throws SQLException {
            if (type == ResultSetType.UNKNOWN.type && concur == ResultSetType.UNKNOWN.concur) {
                return UNKNOWN;
            }
            if (type == 1003) {
                if (concur == 1007) {
                    return FORWARD_READ_ONLY;
                }
                if (concur == 1008) {
                    return FORWARD_UPDATABLE;
                }
            } else if (type == 1004) {
                if (concur == 1007) {
                    return INSENSITIVE_READ_ONLY;
                }
                if (concur == 1008) {
                    return INSENSITIVE_UPDATABLE;
                }
            } else if (type == 1005) {
                if (concur == 1007) {
                    return SENSITIVE_READ_ONLY;
                }
                if (concur == 1008) {
                    return SENSITIVE_UPDATABLE;
                }
            }
            throw (SQLException)DatabaseError.createSqlException(68, "type: " + type + " concurency: " + concur).fillInStackTrace();
        }

        private ResultSetType(int t, int c, boolean id) {
            this.type = t;
            this.concur = c;
            this.isIdentifierRequired = id;
        }

        int getType() {
            return this.type;
        }

        int getConcur() {
            return this.concur;
        }

        boolean isIdentifierRequired() {
            return this.isIdentifierRequired;
        }

        boolean isForwardOnly() {
            return this.type == 1003;
        }

        boolean isScrollable() {
            return this.type != 1003;
        }

        boolean isUpdatable() {
            return this.concur == 1008;
        }

        abstract OracleResultSet createResultSet(OracleStatement var1) throws SQLException;

        abstract ResultSetType downgrade();
    }
}

