/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte uptCode = 0;
    OracleNamedType realType = null;

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, (Connection)conn);
    }

    public OracleTypeUPT(OracleTypeADT parent, int id, OracleConnection conn) throws SQLException {
        super(parent, id, (Connection)conn);
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (value != null) {
            return this.realType.toDatum(value, conn);
        }
        return null;
    }

    @Override
    public Datum[] toDatumArray(Object value, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (value != null) {
            return this.realType.toDatumArray(value, conn, beginIdx, count);
        }
        return null;
    }

    @Override
    public int getTypeCode() throws SQLException {
        switch (this.uptCode) {
            case -6: {
                return this.realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid type code").fillInStackTrace();
    }

    @Override
    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        return false;
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        long offsetPosition = tdsReader.readLong();
        this.uptCode = tdsReader.readByte();
        tdsReader.addNormalPatch(offsetPosition, this.uptCode, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        int imglen = 0;
        if (data == null) {
            imglen += ctx.writeElementNull();
            return imglen;
        } else {
            int lenOffset = ctx.offset();
            imglen += ctx.writeLength(PickleContext.KOPI20_LN_MAXV + 1);
            int realLen = 0;
            if (this.uptCode == -6 && !((OracleTypeADT)this.realType).isFinalType()) {
                if (!(data instanceof STRUCT)) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "invalid upt state").fillInStackTrace();
                realLen = ((STRUCT)data).getDescriptor().getOracleTypeADT().pickle81(ctx, data);
            } else {
                realLen = this.realType.pickle81(ctx, data);
            }
            imglen += realLen;
            ctx.patchImageLen(lenOffset, realLen);
        }
        return imglen;
    }

    @Override
    protected Object unpickle81rec(PickleContext context, int type, Map map) throws SQLException {
        byte lengthbyte = context.readByte();
        if (PickleContext.isElementNull(lengthbyte)) {
            return null;
        }
        if (type == 9) {
            context.skipBytes(context.readRestOfLength(lengthbyte));
            return null;
        }
        context.skipRestOfLength(lengthbyte);
        return this.unpickle81UPT(context, type, map);
    }

    @Override
    protected Object unpickle81rec(PickleContext context, byte length, int type, Map map) throws SQLException {
        long len = context.readRestOfLength(length);
        if (type == 9) {
            context.skipBytes((int)len);
            return null;
        }
        return this.unpickle81UPT(context, type, map);
    }

    private Object unpickle81UPT(PickleContext context, int style, Map map) throws SQLException {
        switch (this.uptCode) {
            case -6: {
                switch (style) {
                    case 1: {
                        return ((OracleTypeADT)this.realType).unpickle81(context, null, 3, style, map);
                    }
                    case 2: {
                        OracleStruct result = ((OracleTypeADT)this.realType).unpickle81(context, null, 1, style, map);
                        return result == null ? result : result.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.realType).unpickle81(context, null, 9, 1, map);
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.realType).unpickle81(context, (OracleArray)null, style == 9 ? style : 3, style, map);
            }
            case 58: {
                switch (style) {
                    case 1: 
                    case 9: {
                        return ((OracleTypeOPAQUE)this.realType).unpickle81(context, null, style, map);
                    }
                    case 2: {
                        OPAQUE result = ((OracleTypeOPAQUE)this.realType).unpickle81(context, null, style, map);
                        return result == null ? result : result.toJdbc(map);
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unrecognized UPT code").fillInStackTrace();
    }

    @Override
    protected Datum unpickle81datumAsNull(PickleContext context, byte len_flags, byte immemb) throws SQLException {
        return null;
    }

    @Override
    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor desc = null;
        desc = this.sqlName == null ? new StructDescriptor((OracleTypeADT)this.realType, (Connection)this.connection) : StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return desc;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor desc = null;
        desc = this.sqlName == null ? new ArrayDescriptor((OracleTypeCOLLECTION)this.realType, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return desc;
    }

    public OracleType getRealType() throws SQLException {
        return this.realType;
    }

    @Override
    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.realType).getNumAttrs();
    }

    @Override
    public OracleType getAttrTypeAt(int idx) throws SQLException {
        return ((OracleTypeADT)this.realType).getAttrTypeAt(idx);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.uptCode);
        out.writeObject(this.realType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uptCode = in.readByte();
        this.realType = (OracleNamedType)in.readObject();
    }

    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        this.connection = conn;
        this.realType.setConnection(conn);
    }

    @Override
    public void initChildNamesRecursively(Map typesMap) throws SQLException {
        if (this.realType != null) {
            this.realType.setSqlName(this.sqlName);
            this.realType.initChildNamesRecursively(typesMap);
        }
    }

    @Override
    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.realType != null) {
            this.realType.initMetadataRecursively();
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
    }

    @Override
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        int i;
        for (i = 0; i < indent; ++i) {
            pw.print("  ");
        }
        pw.println("<OracleTypeUPT sqlName=\"" + String.valueOf(this.sqlName) + "\"  toid=\"" + String.valueOf(this.toid) + "\" >");
        if (this.realType != null) {
            this.realType.printXML(pw, indent + 1, fetchAllMetaDataAsNeeded);
        }
        for (i = 0; i < indent; ++i) {
            pw.print("  ");
        }
        pw.println("</OracleTypeUPT>");
    }

    @Override
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        this.printXML(pw, indent, false);
    }
}

