/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.util.Objects;
import java.util.logging.Level;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

public abstract class PooledConnectionConnectionPool
extends JDBCConnectionPool
implements ConnectionEventListener {
    static final String CLASS_NAME = PooledConnectionConnectionPool.class.getName();

    public PooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
        this.validateConstructor(connectionFactoryAdapter);
    }

    public PooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    public PooledConnection getPooledConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return (PooledConnection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
    }

    public boolean returnPooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        return this.returnUsedPhysicalConnection(pooledConnection);
    }

    protected void validateConstructor(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (!(connectionFactoryAdapter instanceof ConnectionPoolDataSourceConnectionFactoryAdapter)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(105);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (Objects.nonNull(pc)) {
            pc.removeConnectionEventListener(this);
            this.trace(Level.FINEST, CLASS_NAME, "connectionErrorOccurred", "connection error event occurred: {0}", null, null, event);
        }
    }
}

