/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.NTFRegistration;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpsConfigure;
import oracle.sql.CharacterSet;

class NTFConnection
extends Thread
implements Diagnosable {
    private static final String CLASS_NAME = NTFConnection.class.getName();
    private static final int NS_HEADER_SIZE = 10;
    private SocketChannel channel = null;
    private ByteBuffer inBuffer = null;
    private ByteBuffer outBuffer = null;
    private int currentNSPacketLength;
    private int currentNSPacketType;
    private ByteBuffer currentNSPacketDataBuffer;
    private boolean needsToBeClosed = false;
    private NTFManager ntfManager;
    private NTFListener ntfListener;
    private Selector selector = null;
    private Iterator<SelectionKey> iterator = null;
    int remotePort;
    String remoteAddress;
    String remoteName;
    int localPort;
    String localAddress;
    String localName;
    String connectionDescription;
    CharacterSet charset = null;
    boolean useSSL = false;
    static final int NSPTCN = 1;
    static final int NSPTAC = 2;
    static final int NSPTAK = 3;
    static final int NSPTRF = 4;
    static final int NSPTRD = 5;
    static final int NSPTDA = 6;
    static final int NSPTNL = 7;
    static final int NSPTAB = 9;
    static final int NSPTRS = 11;
    static final int NSPTMK = 12;
    static final int NSPTAT = 13;
    static final int NSPTCNL = 14;
    static final int NSPTHI = 19;
    static final short KPDNFY_TIMEOUT = 1;
    static final short KPDNFY_GROUPING = 2;

    NTFConnection(NTFManager _ntfManager, SocketChannel _channel, NTFListener _ntfListener) throws IOException {
        try {
            this.ntfManager = _ntfManager;
            this.ntfListener = _ntfListener;
            boolean bl = this.useSSL = this.ntfListener.socketOptions != null;
            if (this.useSSL) {
                this.prepareSSL(_channel);
            } else {
                this.channel = _channel;
            }
            this.channel.configureBlocking(false);
            this.channel.socket().setKeepAlive(true);
            this.inBuffer = ByteBuffer.allocate(4096);
            this.outBuffer = ByteBuffer.allocate(2048);
            Socket socket = this.channel.socket();
            InetAddress desIa = socket.getInetAddress();
            InetAddress locIa = socket.getLocalAddress();
            this.remotePort = socket.getPort();
            this.localPort = socket.getLocalPort();
            this.remoteAddress = desIa.getHostAddress();
            this.remoteName = desIa.getHostName();
            this.localAddress = locIa.getHostAddress();
            this.localName = locIa.getHostName();
            this.connectionDescription = "local=" + this.localName + "/" + this.localAddress + ":" + this.localPort + ", remote=" + this.remoteName + "/" + this.remoteAddress + ":" + this.remotePort;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "NTFConnection", "established. desc={0}. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
        }
        catch (IOException ioex) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "NTFConnection", "conn desc={0}. ", (String)null, ioex, (Object)this.connectionDescription);
            throw ioex;
        }
    }

    private void prepareSSL(SocketChannel underlyingSocketChannel) throws IOException {
        try {
            SSLEngine sslEngine = CustomSSLSocketFactory.getSSLSocketEngine(null, 0, this.ntfListener.socketOptions);
            TcpsConfigure.configureVersion(null, sslEngine, (String)this.ntfListener.socketOptions.get(6), true);
            TcpsConfigure.configureCipherSuites(null, sslEngine, (String)this.ntfListener.socketOptions.get(7), true);
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(false);
            this.channel = new SSLSocketChannel(underlyingSocketChannel, sslEngine, this.getDiagnosable());
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareSSL", "SSL channel established successfully. ", null, null);
        }
        catch (IOException e) {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareSSL", "SSL channel cannot be established. conn desc={0}, Reason={1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            this.selector = Selector.open();
            if (this.useSSL) {
                ((SSLSocketChannel)this.channel).getUnderlyingChannel().register(this.selector, 1);
            } else {
                this.channel.register(this.selector, 1);
            }
            int bytesReadFromNetwork = 0;
            this.inBuffer.limit(0);
            while (!this.needsToBeClosed) {
                if (!this.inBuffer.hasRemaining()) {
                    while ((bytesReadFromNetwork = this.readFromNetwork()) == 0) {
                    }
                }
                this.unmarshalOneNSPacket();
            }
        }
        catch (IOException ioex) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "conn desc={0}. {1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)ioex.getMessage());
        }
        catch (InterruptedException intex) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "conn desc={0}. {1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)intex.getMessage());
        }
        finally {
            try {
                if (!this.needsToBeClosed) {
                    this.ntfListener.releaseConnection(this);
                }
                if (this.selector != null) {
                    this.selector.close();
                }
                this.channel.close();
            }
            catch (IOException ioex2) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "conn desc={0}. {1}", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)ioex2.getMessage());
            }
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "conn desc={0}, end of run method. Thread will be closed.", (String)null, (Throwable)null, (Object)this.connectionDescription);
    }

    private int readFromNetwork() throws IOException, InterruptedException {
        this.inBuffer.compact();
        boolean needSelect = true;
        if (this.useSSL) {
            boolean bl = needSelect = !((SSLSocketChannel)this.channel).hasRemaining();
        }
        while (needSelect) {
            while (this.iterator == null || !this.iterator.hasNext()) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromNetwork", "conn desc={0}. thread=select(). ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                this.selector.select();
                if (this.needsToBeClosed) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromNetwork", "conn was interrupted. desc={0}. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                    throw new InterruptedException();
                }
                this.iterator = this.selector.selectedKeys().iterator();
            }
            SelectionKey aKey = this.iterator.next();
            if (!aKey.isReadable()) continue;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromNetwork", "conn desc={0}. thread=OP_READ. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
        int ret = this.channel.read(this.inBuffer);
        if (ret < 0) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromNetwork", "conn dec={0}. Connection was closed by remote peer. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
            throw new EOFException();
        }
        if (ret > 0) {
            this.inBuffer.flip();
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromNetwork", "conn desc={0}. received packet:\n{1}", null, null, () -> {
                try {
                    return new Object[]{this.connectionDescription, this.packetToString(this.inBuffer)};
                }
                catch (IOException e) {
                    return new Object[]{this.connectionDescription, "Got an exception generating the debug message: " + e.getMessage()};
                }
            });
        }
        if (needSelect) {
            this.iterator.remove();
        }
        return ret;
    }

    private void getNextNSPacket() throws IOException, InterruptedException {
        int bytesReadFromNetwork;
        while (!this.inBuffer.hasRemaining() || this.inBuffer.remaining() < 10) {
            bytesReadFromNetwork = this.readFromNetwork();
        }
        this.currentNSPacketLength = this.inBuffer.getShort();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getNextNSPacket", "conn desc={0}. currentNSPacketLength={1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)this.currentNSPacketLength);
        if (this.currentNSPacketLength <= 0) {
            throw new IOException("Invalid NS packet length.");
        }
        this.inBuffer.position(this.inBuffer.position() + 2);
        this.currentNSPacketType = this.inBuffer.get();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getNextNSPacket", "conn desc={0}. currentNSPacketType={1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)this.currentNSPacketType);
        this.validatePacketType();
        this.inBuffer.position(this.inBuffer.position() + 5);
        while (this.inBuffer.remaining() < this.currentNSPacketLength - 10) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getNextNSPacket", "conn desc={0}. need to read another {1} bytes. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)(this.currentNSPacketLength - 10));
            bytesReadFromNetwork = this.readFromNetwork();
        }
        int limitBack = this.inBuffer.limit();
        int positionOfEndOfNSPacket = this.inBuffer.position() + this.currentNSPacketLength - 10;
        this.inBuffer.limit(positionOfEndOfNSPacket);
        this.currentNSPacketDataBuffer = this.inBuffer.slice();
        this.inBuffer.limit(limitBack);
        this.inBuffer.position(positionOfEndOfNSPacket);
    }

    private void unmarshalOneNSPacket() throws IOException, InterruptedException {
        this.getNextNSPacket();
        if (this.currentNSPacketDataBuffer.hasRemaining()) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}, switching on packet type={1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)this.currentNSPacketType);
            switch (this.currentNSPacketType) {
                case 1: {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}. got a NSPTCN packet.", (String)null, (Throwable)null, (Object)this.connectionDescription);
                    byte[] answer = new byte[]{0, 24, 0, 0, 2, 0, 0, 0, 1, 52, 0, 0, 8, 0, 127, -1, 1, 0, 0, 0, 0, 24, 65, 1};
                    this.outBuffer.clear();
                    this.outBuffer.put(answer);
                    this.outBuffer.limit(24);
                    this.outBuffer.rewind();
                    this.channel.write(this.outBuffer);
                    break;
                }
                case 6: {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}. got a NSPTDA packet. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                    if (this.currentNSPacketDataBuffer.get(0) == -34 && this.currentNSPacketDataBuffer.get(1) == -83) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}. NSPTDA packet is DEADBEEF. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                        byte[] anoAnswer = new byte[]{0, 127, 0, 0, 6, 0, 0, 0, 0, 0, -34, -83, -66, -17, 0, 117, 10, 32, 1, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, 0, 31, 0, 14, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 2, 0, 4, 0, 1, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, -5, -1, 0, 2, 0, 2, 0, 0, 49, 106, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0};
                        this.outBuffer.clear();
                        this.outBuffer.put(anoAnswer);
                        this.outBuffer.limit(anoAnswer.length);
                        this.outBuffer.rewind();
                        this.channel.write(this.outBuffer);
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}. Response to DEADBEEF sent. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                        break;
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}. Got a notification.", (String)null, (Throwable)null, (Object)this.connectionDescription);
                    this.unmarshalNSDataPacket();
                }
            }
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalOneNSPacket", "conn desc={0}. there was no NS data. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
        }
    }

    private void unmarshalNSDataPacket() throws IOException, InterruptedException {
        int i;
        short nbOfHandles = this.readShort();
        int lengthOfHeaderHandler = this.readInt();
        byte csidType = this.readByte();
        int csidLength = this.readInt();
        short csid = this.readShort();
        if (this.charset == null || this.charset.getOracleId() != csid) {
            this.charset = CharacterSet.make(csid);
        }
        byte presentationType = this.readByte();
        int presentationLength = this.readInt();
        short presentation = this.readShort();
        byte versionType = this.readByte();
        int versionLength = this.readInt();
        short version = this.readShort();
        int nbOfRegistrations = (lengthOfHeaderHandler - 21) / 9;
        int[] contextArr = new int[nbOfRegistrations];
        for (int i2 = 0; i2 < nbOfRegistrations; ++i2) {
            byte contextType = this.readByte();
            int contextLength = this.readInt();
            byte[] contextBuffer = new byte[contextLength];
            this.readBuffer(contextBuffer, 0, contextLength);
            for (int j = 0; j < contextLength; ++j) {
                if (j >= 4) continue;
                int n = i2;
                contextArr[n] = contextArr[n] | (contextBuffer[j] & 0xFF) << 8 * (contextLength - j - 1);
            }
        }
        NTFDCNEvent dcnevent = null;
        NTFAQEvent aqevent = null;
        int namespace = 0;
        short databaseVersion = 0;
        NTFRegistration[] ntfRegistrationArr = null;
        if (nbOfHandles >= 2) {
            short ignore = this.readShort();
            ntfRegistrationArr = new NTFRegistration[contextArr.length];
            for (i = 0; i < contextArr.length; ++i) {
                ntfRegistrationArr[i] = this.ntfManager.getRegistration(contextArr[i]);
                if (ntfRegistrationArr[i] == null) continue;
                namespace = ntfRegistrationArr[i].getNamespace();
                databaseVersion = ntfRegistrationArr[i].getDatabaseVersion();
            }
            if (namespace == 2) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}. Got a DCN notification. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                dcnevent = new NTFDCNEvent(this, databaseVersion);
            } else if (namespace == 1) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}, Got an AQ notification. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                aqevent = new NTFAQEvent(this, databaseVersion);
            } else if (namespace == 0) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}, Got an ANONYMOUS notification. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0} Error: unrecognized namespace. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
            }
        }
        short notifyDescriptor = 0;
        if (nbOfHandles >= 3) {
            short ignore = this.readShort();
            int lengthThirdHandle = this.readInt();
            byte ttype = this.readByte();
            int llength = this.readInt();
            notifyDescriptor = this.readShort();
            if (namespace == 2 && dcnevent != null) {
                dcnevent.setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType.getEventType(notifyDescriptor));
                if (notifyDescriptor == 1) {
                    dcnevent.setEventType(DatabaseChangeEvent.EventType.DEREG);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}. DCN timeout flag received. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                }
            } else if (namespace == 1 && aqevent != null) {
                aqevent.setAdditionalEventType(AQNotificationEvent.AdditionalEventType.getEventType(notifyDescriptor));
                if (notifyDescriptor == 1) {
                    aqevent.setEventType(AQNotificationEvent.EventType.DEREG);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}. AQ timeout flag received. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
                }
            }
        }
        if (nbOfHandles > 3) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}. Error: The notification contains more than 3 handles. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
        }
        if (ntfRegistrationArr != null) {
            if (namespace == 2) {
                for (i = 0; i < ntfRegistrationArr.length; ++i) {
                    if (ntfRegistrationArr[i] == null || dcnevent == null) continue;
                    ntfRegistrationArr[i].notify(dcnevent);
                }
            } else if (namespace == 1) {
                for (i = 0; i < ntfRegistrationArr.length; ++i) {
                    if (ntfRegistrationArr[i] == null || aqevent == null) continue;
                    ntfRegistrationArr[i].notify(aqevent);
                }
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}. unknown namespace. ", (String)null, (Throwable)null, (Object)this.connectionDescription);
            }
        }
    }

    void closeThisConnection() {
        this.needsToBeClosed = true;
    }

    byte readByte() throws IOException, InterruptedException {
        byte ret = 0;
        if (this.currentNSPacketDataBuffer.hasRemaining()) {
            ret = this.currentNSPacketDataBuffer.get();
        } else {
            this.getNextNSPacket();
            ret = this.currentNSPacketDataBuffer.get();
        }
        return ret;
    }

    short readShort() throws IOException, InterruptedException {
        short ret = 0;
        if (this.currentNSPacketDataBuffer.remaining() >= 2) {
            ret = this.currentNSPacketDataBuffer.getShort();
        } else {
            int b1 = this.readByte() & 0xFF;
            int b2 = this.readByte() & 0xFF;
            ret = (short)(b1 << 8 | b2);
        }
        return ret;
    }

    int readInt() throws IOException, InterruptedException {
        int ret = 0;
        if (this.currentNSPacketDataBuffer.remaining() >= 4) {
            ret = this.currentNSPacketDataBuffer.getInt();
        } else {
            int b1 = this.readByte() & 0xFF;
            int b2 = this.readByte() & 0xFF;
            int b3 = this.readByte() & 0xFF;
            int b4 = this.readByte() & 0xFF;
            ret = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        return ret;
    }

    long readLong() throws IOException, InterruptedException {
        long ret = 0L;
        if (this.currentNSPacketDataBuffer.remaining() >= 8) {
            ret = this.currentNSPacketDataBuffer.getLong();
        } else {
            long b1 = this.readByte() & 0xFF;
            long b2 = this.readByte() & 0xFF;
            long b3 = this.readByte() & 0xFF;
            long b4 = this.readByte() & 0xFF;
            long b5 = this.readByte() & 0xFF;
            long b6 = this.readByte() & 0xFF;
            long b7 = this.readByte() & 0xFF;
            long b8 = this.readByte() & 0xFF;
            ret = b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8;
        }
        return ret;
    }

    void readBuffer(byte[] buff, int offset, int length) throws IOException, InterruptedException {
        if (this.currentNSPacketDataBuffer.remaining() >= length) {
            this.currentNSPacketDataBuffer.get(buff, offset, length);
        } else {
            boolean done = false;
            int bytesAlreadyRead = 0;
            int bytesToRead = 0;
            int remainingBytesInCurrentBuffer = this.currentNSPacketDataBuffer.remaining();
            this.currentNSPacketDataBuffer.get(buff, offset, remainingBytesInCurrentBuffer);
            offset += remainingBytesInCurrentBuffer;
            bytesAlreadyRead += remainingBytesInCurrentBuffer;
            while (!done) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}, bytesAlreadyRead={1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)bytesAlreadyRead);
                this.getNextNSPacket();
                remainingBytesInCurrentBuffer = this.currentNSPacketDataBuffer.remaining();
                bytesToRead = Math.min(remainingBytesInCurrentBuffer, length - bytesAlreadyRead);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalNSDataPacket", "conn desc={0}, bytesToRead={1}. ", (String)null, (Throwable)null, (Object)this.connectionDescription, (Object)bytesToRead);
                this.currentNSPacketDataBuffer.get(buff, offset, bytesToRead);
                offset += bytesToRead;
                if ((bytesAlreadyRead += bytesToRead) != length) continue;
                done = true;
            }
        }
    }

    private String packetToString(ByteBuffer buff) throws IOException {
        int offset = 0;
        char[] byteArr = new char[8];
        StringBuffer strbuff = new StringBuffer();
        int initialPosition = buff.position();
        while (buff.hasRemaining()) {
            byte b = buff.get();
            String hexRep = Integer.toHexString(b & 0xFF);
            if ((hexRep = hexRep.toUpperCase()).length() == 1) {
                hexRep = "0" + hexRep;
            }
            strbuff.append(hexRep);
            strbuff.append(' ');
            byteArr[offset] = b > 32 && b < 127 ? (int)b : 46;
            if (++offset != 8) continue;
            strbuff.append('|');
            strbuff.append(byteArr);
            strbuff.append('|');
            strbuff.append('\n');
            offset = 0;
        }
        if (offset != 0) {
            int i;
            int nbSpacesMissing = 8 - offset;
            for (i = 0; i < nbSpacesMissing * 3; ++i) {
                strbuff.append(' ');
            }
            strbuff.append('|');
            strbuff.append(byteArr, 0, offset);
            for (i = 0; i < nbSpacesMissing; ++i) {
                strbuff.append(' ');
            }
            strbuff.append('|');
            strbuff.append('\n');
        }
        strbuff.append("\nEnd of Packet\n\n");
        buff.position(initialPosition);
        return strbuff.toString();
    }

    private void validatePacketType() throws IOException {
        if (this.currentNSPacketType < 1 || this.currentNSPacketType > 19) {
            throw new IOException("Invalid NS packet type.");
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

