/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;

abstract class Accessor
extends GeneratedAccessor
implements Cloneable,
Diagnosable {
    private static final String CLASS_NAME = Accessor.class.getName();
    static final int FIXED_CHAR = 999;
    static final int CHAR = 96;
    static final int VARCHAR = 1;
    static final int VCS = 9;
    static final int LONG = 8;
    static final int NUMBER = 2;
    static final int VARNUM = 6;
    static final int BINARY_FLOAT = 100;
    static final int BINARY_DOUBLE = 101;
    static final int RAW = 23;
    static final int VBI = 15;
    static final int LONG_RAW = 24;
    static final int ROWID = 104;
    static final int RESULT_SET = 102;
    static final int RSET = 116;
    static final int DATE = 12;
    static final int BLOB = 113;
    static final int JSON = 119;
    static final int CLOB = 112;
    static final int BFILE = 114;
    static final int NAMED_TYPE = 109;
    static final int REF_TYPE = 111;
    static final int TIMESTAMP = 180;
    static final int TIMESTAMPTZ = 181;
    static final int TIMESTAMPLTZ = 231;
    static final int INTERVALYM = 182;
    static final int INTERVALDS = 183;
    static final int UROWID = 208;
    static final int BOOLEAN = 252;
    static final int PLSQL_INDEX_TABLE = 998;
    static final int T2S_OVERLONG_RAW = 997;
    static final int SET_CHAR_BYTES = 996;
    static final int NULL_TYPE = 995;
    static final int DML_RETURN_PARAM = 994;
    static final int XMLTYPE = 257;
    static final int VECTOR = 127;
    static final int ONLY_FORM_USABLE = 0;
    static final int NOT_USABLE = 1;
    static final int NO_NEED_TO_PREPARE = 2;
    static final int NEED_TO_PREPARE = 3;
    static final byte DATA_UNAUTHORIZED = 1;
    static final int NO_LOB_PREFETCH = -1;
    OracleStatement statement;
    boolean outBind;
    int internalType;
    boolean isStream = false;
    boolean isColumnNumberAware = false;
    short formOfUse = (short)2;
    OracleType internalOtype;
    int externalType;
    String internalTypeName;
    String columnName;
    int describeType;
    int describeMaxLength;
    int describeMaxLengthChars;
    short describeFormOfUse;
    long contflag;
    boolean nullable;
    int precision;
    int scale;
    int flags;
    int total_elems;
    OracleType describeOtype;
    String describeTypeName;
    int definedColumnType = 0;
    int definedColumnSize = 0;
    int oacmxl = 0;
    short udskpos = (short)-1;
    int lobPrefetchSizeForThisColumn = -1;
    OracleResultSetMetaData.SecurityAttribute securityAttribute;
    protected boolean columnInvisible = false;
    protected boolean columnJSON = false;
    String domainName;
    String domainSchema;
    private Map<String, String> annotations;
    short[] rowSpaceIndicator = null;
    int columnDataOffset = 0;
    int lengthIndex = 0;
    int indicatorIndex = 0;
    int byteLength = 0;
    int charLength = 0;
    int defineType;
    boolean isDMLReturnedParam = false;
    int lastRowProcessed = 0;
    boolean isUseLess = false;
    int physicalColumnIndex = -2;
    boolean isNullByDescribe = false;
    int lastCopyRow = -1;
    long lastCopyRowOffset = 0L;
    int lastCopyRowLength = 0;
    byte lastCopyRowMetaData = 0;
    boolean lastCopyRowIsNull = false;
    static final byte[] NULL_DATA_BYTES = new byte[]{2, 3, 5, 7, 11, 13, 17, 19};
    static final int ROW_METADATA_LENGTH = 1;
    final Representation representation;
    final int representationMaxLength;
    ByteArray rowData;
    long[] rowOffset = null;
    int[] rowLength = null;
    boolean[] rowNull = null;
    byte[] rowMetadata = null;
    Object driverSpecificData;
    int previousRowProcessed = -1;
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];

    void setNoPrefetch() {
    }

    void setPrefetchLength(int length) {
    }

    PlsqlIbtBindInfo plsqlIndexTableBindInfo() throws SQLException {
        return null;
    }

    void unimpl(String methodName) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, methodName + " not implemented for " + this.getClass()).fillInStackTrace();
    }

    long updateChecksum(long checksum, int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return CRC64.updateChecksum(checksum, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
        }
        return this.rowData.updateChecksum(this.getOffset(currentRow), this.getLength(currentRow), PhysicalConnection.CHECKSUM, checksum);
    }

    void init(OracleStatement stmt, int internal_type, int database_type, short form, boolean isOutBind) throws SQLException {
        this.statement = stmt;
        this.outBind = isOutBind;
        this.internalType = internal_type;
        this.defineType = database_type;
        this.formOfUse = form;
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.byteLength = max_len > 0 && max_len < this.representationMaxLength ? max_len : this.representationMaxLength;
    }

    void initForDescribe(int type, int maxLength, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        this.nullable = nullable;
        this.precision = precision;
        this.scale = scale;
        this.flags = flags;
        this.contflag = contflag;
        this.total_elems = total_elems;
        this.describeType = type;
        this.describeMaxLength = maxLength;
        this.describeFormOfUse = form;
        if (!this.statement.columnsDefinedByUser) {
            this.formOfUse = form;
        }
    }

    void initForDescribe(int type, int maxLength, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName) throws SQLException {
        this.describeTypeName = typeName;
        this.describeOtype = null;
        this.initForDescribe(type, maxLength, nullable, flags, precision, scale, contflag, total_elems, form);
    }

    void initForDescribe(int type, int maxLength, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName, int maxCodePointLength) throws SQLException {
        this.initForDescribe(type, maxLength, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.describeMaxLengthChars = maxCodePointLength;
    }

    OracleInputStream initForNewRow() throws SQLException {
        this.unimpl("initForNewRow");
        return null;
    }

    int useForDataAccessIfPossible(int internal_type, int external_type, int max_len, String typeName) throws SQLException {
        int result = 3;
        int oldByteLength = 0;
        int oldCharLength = 0;
        if (this.internalType != 0) {
            if (this.internalType != internal_type) {
                result = 0;
            } else if (this.rowSpaceIndicator != null) {
                oldByteLength = this.byteLength;
                oldCharLength = this.charLength;
            }
        }
        if (result == 3) {
            this.initForDataAccess(external_type, max_len, typeName);
            if (!this.outBind && oldByteLength >= this.byteLength && oldCharLength >= this.charLength) {
                result = 2;
            }
        }
        return result;
    }

    boolean useForDescribeIfPossible(int type, int maxLength, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short formOfUse, String typeName) throws SQLException {
        if (!this.statement.columnsDefinedByUser && this.externalType == 0 && this.describeType == 0 && type != this.describeType) {
            return false;
        }
        this.initForDescribe(type, maxLength, nullable, flags, precision, scale, contflag, total_elems, formOfUse, typeName);
        return true;
    }

    void setFormOfUse(short form) {
        this.formOfUse = form;
    }

    void updateColumnNumber(int colNumber) {
    }

    public String toString() {
        return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowData=" + this.rowData + ", rowOffset=" + this.rowOffset + ", rowLength=" + this.rowLength + ", rowNull=" + this.rowNull + ", rowMetadata=" + this.rowMetadata + ", driverSpecificData=" + this.driverSpecificData + ", describeMaxLengthChars=" + this.describeMaxLengthChars;
    }

    void fetchNextColumns() throws SQLException {
    }

    void calculateSizeTmpByteArray() {
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    void copyRow() throws SQLException, IOException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    int readStream(byte[] buffer, int length) throws SQLException, IOException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    int getPreviousRowProcessed() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    void initMetadata() throws SQLException {
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }

    protected Accessor(Representation _representation, OracleStatement _statement, int _representationMaxLength, boolean isStoredInBindData) {
        this.representation = _representation;
        this.statement = _statement;
        this.representationMaxLength = _representationMaxLength;
        this.rowData = isStoredInBindData ? this.statement.bindData : this.statement.rowData;
        this.statement.setDriverSpecificData(this);
    }

    protected final long getOffset(int currentRow) {
        return this.rowOffset[currentRow];
    }

    protected final void setOffset(int currentRow, long offset) {
        this.rowOffset[currentRow] = offset;
    }

    protected final void setOffset(int currentRow) {
        long offset;
        this.rowOffset[currentRow] = offset = this.rowData.getPosition();
    }

    protected final int getLength(int currentRow) {
        return this.rowLength[currentRow];
    }

    protected final void setLength(int currentRow, int length) {
        this.rowLength[currentRow] = length;
    }

    protected final void setLengthAndNull(int currentRow, int length) throws SQLException {
        if (length == 0) {
            this.setNull(currentRow, true);
        } else {
            this.setNull(currentRow, false);
            this.setLength(currentRow, length);
        }
    }

    final byte getRowMetadata(int currentRow) {
        return this.rowMetadata[currentRow];
    }

    final void setRowMetadata(int currentRow, byte meta) {
        this.rowMetadata[currentRow] = meta;
    }

    @Override
    boolean isNull(int currentRow) throws SQLException {
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        return this.rowNull[currentRow];
    }

    void setNull(int currentRow, boolean value) throws SQLException {
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        this.rowNull[currentRow] = value;
        if (value && this.statement.connection.protocolId != 3) {
            this.setOffset(currentRow, -1L);
            this.setLength(currentRow, -1);
        }
    }

    boolean isNullByDescribe() {
        return this.isNullByDescribe;
    }

    boolean isUseless() {
        return this.isUseLess;
    }

    boolean isUnexpected() {
        return this.rowNull == null;
    }

    void setColumnInvisible(boolean columnInvisible) {
        this.columnInvisible = columnInvisible;
    }

    boolean isColumnInvisible() {
        return this.columnInvisible;
    }

    void setColumnJSON(boolean columnJSON) {
        this.columnJSON = columnJSON;
    }

    void setDomainSchema(String domainSchema) {
        this.domainSchema = domainSchema;
    }

    void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    Map<String, String> getAnnotations() {
        return this.annotations;
    }

    boolean isColumnJSON() {
        return this.columnJSON;
    }

    VectorMetaData getVectorMetaData() {
        return null;
    }

    void setCapacity(int capacity) {
        if (this.rowNull == null) {
            this.rowLength = new int[capacity];
            this.rowOffset = new long[capacity];
            this.rowNull = new boolean[capacity];
            this.rowMetadata = new byte[capacity];
        } else if (this.rowNull.length < capacity) {
            Object[] tmp = new int[capacity];
            System.arraycopy(this.rowLength, 0, tmp, 0, this.rowLength.length);
            this.rowLength = tmp;
            tmp = new long[capacity];
            System.arraycopy(this.rowOffset, 0, tmp, 0, this.rowOffset.length);
            this.rowOffset = tmp;
            tmp = new boolean[capacity];
            System.arraycopy(this.rowNull, 0, tmp, 0, this.rowNull.length);
            this.rowNull = (boolean[])tmp;
            tmp = new byte[capacity];
            System.arraycopy(this.rowMetadata, 0, tmp, 0, this.rowMetadata.length);
            this.rowMetadata = (byte[])tmp;
        }
    }

    void insertNull(int rowIndex) throws SQLException {
        System.arraycopy(this.rowNull, rowIndex, this.rowNull, rowIndex + 1, this.rowNull.length - rowIndex - 1);
        System.arraycopy(this.rowLength, rowIndex, this.rowLength, rowIndex + 1, this.rowLength.length - rowIndex - 1);
        System.arraycopy(this.rowOffset, rowIndex, this.rowOffset, rowIndex + 1, this.rowOffset.length - rowIndex - 1);
        System.arraycopy(this.rowMetadata, rowIndex, this.rowMetadata, rowIndex + 1, this.rowMetadata.length - rowIndex - 1);
        this.setNull(rowIndex, true);
    }

    Accessor copyForDefine(OracleStatement dest) {
        Accessor acc = null;
        try {
            acc = (Accessor)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        acc.rowNull = null;
        acc.rowLength = null;
        acc.rowOffset = null;
        acc.rowMetadata = null;
        acc.statement = dest;
        acc.rowData = dest.rowData;
        dest.setDriverSpecificData(acc);
        return acc;
    }

    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int currentRow) throws SQLException {
        byte metaDataByte1 = this.getRowMetadata(currentRow);
        if ((metaDataByte1 & 1) != 0) {
            return OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
        }
        if (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED || this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE) {
            return OracleResultSet.AuthorizationIndicator.NONE;
        }
        return OracleResultSet.AuthorizationIndicator.UNKNOWN;
    }

    byte[] getBytesInternal(int currentRow) throws SQLException {
        assert (!this.isNull(currentRow));
        int len = this.getLength(currentRow);
        long off = this.getOffset(currentRow);
        return this.rowData.get(off, len);
    }

    final void getBytesInternal(int currentRow, byte[] data) throws SQLException {
        int len = this.getLength(currentRow);
        assert (data.length >= len) : "data.length: " + data.length + " len: " + len;
        long off = this.getOffset(currentRow);
        this.rowData.get(off, data, 0, len);
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.getBytesInternal(currentRow);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        return null;
    }

    <T> T getObject(int currentRow, Class<T> type) throws SQLException {
        if (type == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 282).fillInStackTrace();
        }
        return this.representation.getObject(this, currentRow, type);
    }

    @Override
    Object getObject(int currentRow, OracleDataFactory factory) throws SQLException {
        if (factory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
        }
        Object jdbcObject = this.getObject(currentRow, (Map)null);
        return factory.create(jdbcObject, 0);
    }

    @Override
    ORAData getORAData(int currentRow, ORADataFactory factory) throws SQLException {
        if (factory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
        }
        Datum d = this.getOracleObject(currentRow);
        return factory.create(d, 0);
    }

    Datum[] getOraclePlsqlIndexTable(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOraclePlsqlIndexTable not implemented for " + this.getClass().getName()).fillInStackTrace();
    }

    @Override
    NClob getNClob(int currentRow) throws SQLException {
        if (this.formOfUse != 2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
        return (NClob)((Object)this.getCLOB(currentRow));
    }

    @Override
    String getNString(int currentRow) throws SQLException {
        return this.getString(currentRow);
    }

    @Override
    Reader getNCharacterStream(int currentRow) throws SQLException {
        return this.getCharacterStream(currentRow);
    }

    int getBytes(int currentRow, byte[] buffer, int offset) throws SQLException {
        if (this.isNull(currentRow)) {
            return 0;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes not implemented for class " + this.getClass().getName()).fillInStackTrace();
    }

    final void copyFrom(Accessor srcAcc, int srcRow, int destRow) throws SQLException {
        assert (this.getClass() == srcAcc.getClass()) : "srcAcc.class: " + srcAcc.getClass();
        assert (0 <= srcRow && srcRow < srcAcc.rowNull.length) : "srcRow: " + srcRow + " srcAcc.capacity: " + srcAcc.rowNull.length;
        assert (0 <= destRow && destRow < this.rowNull.length) : "destRow: " + destRow + " capacity: " + this.rowNull.length;
        if (srcAcc.isNull(srcRow)) {
            this.setNull(destRow, true);
        } else {
            this.releaseRowData();
            this.copyFromInternal(srcAcc, srcRow, destRow);
        }
    }

    protected void copyFromInternal(Accessor srcAcc, int srcRow, int destRow) throws SQLException {
        boolean rowCopy;
        boolean bl = rowCopy = destRow > 0 && this.getOffset(destRow - 1) == this.getOffset(destRow) || destRow + 1 < this.statement.storedRowCount && this.getOffset(destRow + 1) == this.getOffset(destRow);
        if (rowCopy && this.getLength(destRow) == srcAcc.getLength(srcRow) && this.rowData.equalBytes(this.getOffset(destRow), this.getLength(destRow), srcAcc.rowData, srcAcc.getOffset(srcRow))) {
            this.setRowMetadata(destRow, srcAcc.getRowMetadata(srcRow));
        } else {
            boolean saveLastCopyRow;
            boolean bl2 = saveLastCopyRow = destRow + 1 == this.statement.storedRowCount;
            if (rowCopy || srcAcc.getLength(srcRow) > this.getLength(destRow) || saveLastCopyRow) {
                if (saveLastCopyRow) {
                    this.lastCopyRow = destRow;
                    this.lastCopyRowOffset = this.getOffset(destRow);
                    this.lastCopyRowLength = this.getLength(destRow);
                    this.lastCopyRowMetaData = this.getRowMetadata(destRow);
                    this.lastCopyRowIsNull = this.isNull(destRow);
                }
                this.statement.locationToPutBytes(this, destRow, srcAcc.getLength(srcRow));
            }
            this.rowData.put(this.getOffset(destRow), srcAcc.rowData, srcAcc.getOffset(srcRow), srcAcc.getLength(srcRow));
            this.setLength(destRow, srcAcc.getLength(srcRow));
            this.setRowMetadata(destRow, srcAcc.getRowMetadata(srcRow));
        }
        this.setNull(destRow, false);
    }

    void deleteRow(int row) throws SQLException {
        this.releaseRowData();
        this.rowData.freeSpace(this.getOffset(row), this.getLength(row));
        this.delete(this.rowNull, row);
        this.delete(this.rowOffset, row);
        this.delete(this.rowLength, row);
        this.delete(this.rowMetadata, row);
    }

    protected final void delete(Object array, int row) {
        int len = Array.getLength(array);
        assert (row >= 0 && row < len) : "row: " + row + " len: " + len;
        System.arraycopy(array, row + 1, array, row, len - row - 1);
    }

    AccessorPrototype newPrototype(int numRows) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "newPrototype not overridden in " + this.getClass().getName()).fillInStackTrace();
    }

    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "reinitForResultSetCache not overridden in " + this.getClass().getName()).fillInStackTrace();
    }

    long previousOffset() {
        if (this.previousRowProcessed == -1) {
            return 0L;
        }
        if (this.lastCopyRow == this.previousRowProcessed) {
            return this.lastCopyRowOffset;
        }
        return this.getOffset(this.previousRowProcessed);
    }

    boolean isLengthSemanticChar() {
        return 0L != (0x1000L & this.contflag);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.statement.connection.getDiagnosable();
    }

    protected void releaseRowData() {
    }
}

