/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.net.SocketFactory;
import jdk.net.Sockets;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.AbstractAdapter;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpNTAdapter
extends AbstractAdapter
implements Diagnosable {
    private static final String CLASS_NAME = TcpNTAdapter.class.getName();
    private static final int[] SUPPORTED_SOCKET_OPTIONS = new int[]{0, 1, 33, 34, 35};
    private static Proxy DEFAULT_SOCKS_PROXY = null;
    private final String addressInfo;
    private final Diagnosable diagnosable;
    NetStatImpl netStat = null;
    Boolean useNio;
    String protocol;
    String uri;
    protected SocketChannelWrapper socketChannel;
    private String httpProxy;
    private int httpProxyPort;
    protected InetSocketAddress inetSocketAddress;
    protected Proxy proxy = null;
    protected boolean isRemoteDNS = true;
    protected int connectTimeout = 0;
    private final ConnOption connOption;
    SocketFactory sockFactory;
    private volatile boolean isRegisteredEver = false;

    public TcpNTAdapter(String address, @Blind(value=PropertiesBlinder.class) Properties socketOptions, Diagnosable diagnosable, ConnOption connOption) throws NLException {
        this.connOption = connOption;
        this.diagnosable = diagnosable;
        this.socketOptions = socketOptions;
        this.addressInfo = address;
        this.inetSocketAddress = connOption.inetSocketAddress;
        this.useNio = true;
        this.isRemoteDNS = Boolean.parseBoolean((String)socketOptions.getOrDefault((Object)45, "true"));
        this.connectTimeout = Integer.parseInt((String)socketOptions.getOrDefault((Object)2, "0"));
        this.netStat = new NetStatImpl();
        this.host = connOption.host;
        this.port = this.inetSocketAddress.getPort();
        this.protocol = connOption.protocol;
        this.initializeProxy(connOption);
    }

    protected void initializeProxy(ConnOption connOption) {
        this.readHttpsProxyConfig(connOption);
        this.proxy = this.httpProxy != null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxy, this.httpProxyPort)) : (this.socketOptions.containsKey(36) && this.socketOptions.containsKey(37) ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress((String)this.socketOptions.get(36), Integer.parseInt((String)this.socketOptions.get(37)))) : DEFAULT_SOCKS_PROXY);
    }

    private void readHttpsProxyConfig(ConnOption connOption) {
        this.httpProxy = connOption.httpsProxy;
        this.httpProxyPort = connOption.httpsProxyPort;
        if (this.httpProxy == null) {
            String proxyPortStr;
            this.httpProxy = (String)this.socketOptions.get(30);
            if (this.httpProxy != null && (proxyPortStr = (String)this.socketOptions.get(31)) != null) {
                this.httpProxyPort = Integer.parseInt(proxyPortStr);
            }
        }
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        this.sockFactory = new MetricsEnabledSocketFactory(dmsParent);
        long startTime = System.currentTimeMillis();
        try {
            this.establishSocket(this.inetSocketAddress, dmsParent);
        }
        catch (IOException ea) {
            if (!this.isRemoteDNS || this.proxy == null) {
                DownHostsCache.getInstance().markDownHost(this.inetSocketAddress.getAddress(), this.port);
            }
            throw ea;
        }
        long connectTime = System.currentTimeMillis() - startTime;
        this.setSocketOptions();
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "connect", "Connect succeeded. {0}, protocol={1}, proxy={2}, isRemoteDNS={3},connectTimeout={4}ms, connectTime={5} ms. ", (String)null, null, (Object)this, (Object)this.protocol, this.proxy == null ? "null" : this.proxy, (Object)this.isRemoteDNS, (Object)this.connectTimeout, (Object)connectTime);
    }

    private byte[] prepareTcpFastOpenDataAndGet() throws UnsupportedEncodingException, NetException {
        byte[] tfoBytes = null;
        if (SQLnetDef.isTcpFastOpenEnabled((String)this.socketOptions.get(109))) {
            tfoBytes = this.getTFOBytes(this.connOption.getConnectData());
            if (tfoBytes == null) {
                tfoBytes = this.getTFOBytes(this.connOption.getOriginalConnOption().getConnectData());
            }
            if (tfoBytes != null) {
                this.connOption.setConnectData(new String(tfoBytes));
            }
        }
        return tfoBytes;
    }

    private byte[] getTFOBytes(String url) throws NetException {
        if (url == null || url.isEmpty()) {
            return null;
        }
        try {
            NVPair tfoNVPair;
            NVPair descriptionNVPair = new NVFactory().createNVPair(url);
            NVNavigator navigator = new NVNavigator();
            NVPair connectDataNVPair = navigator.findNVPair(descriptionNVPair, "CONNECT_DATA");
            if (connectDataNVPair == null) {
                return null;
            }
            NVPair nVPair = tfoNVPair = navigator.findNVPair(connectDataNVPair, "USE_TCP_FAST_OPEN") != null ? navigator.findNVPair(connectDataNVPair, "USE_TCP_FAST_OPEN") : navigator.findNVPair(connectDataNVPair, "TFO");
            if (tfoNVPair == null) {
                connectDataNVPair.addListElement(new NVPair("USE_TCP_FAST_OPEN", "yes"));
            } else {
                tfoNVPair.setAtom("yes");
            }
            String newUrl = descriptionNVPair.toString();
            return newUrl.getBytes("ASCII");
        }
        catch (Exception e) {
            throw new NetException(17852);
        }
    }

    protected void establishSocket(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        long socketConnectStartTime = System.currentTimeMillis();
        try {
            this.begin(Metrics.ConnectionEvent.SOCKET_ESTABLISHMENT);
            if (this.useNio.booleanValue()) {
                this.socketChannel = new TimeoutSocketChannel(inetAddr, this.connectTimeout, this.netStat, this.proxy, this.diagnosable, this.prepareTcpFastOpenDataAndGet());
                this.socket = this.socketChannel.socket();
            } else {
                this.socket = this.sockFactory.createSocket();
                this.socket.connect(inetAddr, this.connectTimeout);
            }
            this.setReadTimeoutIfRequired(this.socketOptions);
            this.end(Metrics.ConnectionEvent.SOCKET_ESTABLISHMENT);
        }
        catch (IOException ioException) {
            throw this.handleEstablishSocketException(ioException, socketConnectStartTime, inetAddr);
        }
    }

    private IOException handleEstablishSocketException(IOException ioException, long socketConnectStartTime, InetSocketAddress inetAddr) {
        if (ioException instanceof TimeoutInterruptHandler.IOReadTimeoutException) {
            this.trySocketClose();
            if (this.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCP || this.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS) {
                return new NetException(12170, this.describeConnectionFailure(ioException, socketConnectStartTime, inetAddr), false, this.getNetworkAdapterType().toString() + " connect", this.connectTimeout + "ms", "host " + this.host + " port " + this.port);
            }
            return new IOException(this.describeConnectionFailure(ioException, socketConnectStartTime, inetAddr), ioException);
        }
        if (ioException instanceof InterruptedIOException) {
            this.trySocketClose();
            InterruptedIOException describedInterruptException = new InterruptedIOException(this.describeConnectionFailure(ioException, socketConnectStartTime, inetAddr));
            describedInterruptException.initCause(ioException);
            return describedInterruptException;
        }
        if (ioException instanceof ConnectException) {
            NetException netException;
            if (this.protocol.equalsIgnoreCase("tcp") || this.protocol.equalsIgnoreCase("tcps") || this.protocol.equalsIgnoreCase("wss")) {
                String message = "host " + this.host + " port " + this.port;
                netException = new NetException(12541, null, false, message);
            } else if (this.protocol.equalsIgnoreCase("ipc")) {
                String message = "key " + this.socketOptions.keySet();
                netException = new NetException(12541, null, false, message);
            } else {
                netException = new NetException(12541, "at " + inetAddr.toString() + (String)(this.proxy == null ? "" : ", connecting via proxy [" + this.proxy.toString() + "]"));
            }
            netException.initCause(ioException);
            return netException;
        }
        this.trySocketClose();
        return new IOException(this.describeConnectionFailure(ioException, socketConnectStartTime, inetAddr), ioException);
    }

    private void trySocketClose() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    private String describeConnectionFailure(IOException connectionError, long connectStartTime, InetSocketAddress inetAddr) {
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, this.protocol, "describeConnectionFailure", String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", connectionError.getMessage(), System.currentTimeMillis() - connectStartTime, inetAddr.getHostString(), this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.host, this.useNio), null, null);
        return this.proxy == null ? "" : "Proxy = " + this.proxy.toString();
    }

    @Override
    public CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with proxies"));
        }
        this.sockFactory = new MetricsEnabledSocketFactory(dmsParent);
        long startTime = System.currentTimeMillis();
        return this.establishSocketAsync(this.inetSocketAddress, dmsParent, outboundTimeout, asyncExecutor).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, ioException -> {
            if (!this.isRemoteDNS || this.proxy == null) {
                DownHostsCache.getInstance().markDownHost(this.inetSocketAddress.getAddress(), this.port);
            }
            throw ioException;
        })).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
            long connectTime = System.currentTimeMillis() - startTime;
            this.setSocketOptions();
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "connectAsync", "Connect succeeded. {0}, protocol={1}, proxy={2}, isRemoteDNS={3}, connectTimeout={4}ms, connectTime={5} ms. ", (String)null, null, (Object)this, (Object)this.protocol, this.proxy == null ? "null" : this.proxy, (Object)this.isRemoteDNS, (Object)this.connectTimeout, (Object)connectTime);
            return nil;
        }));
    }

    protected CompletionStage<Void> establishSocketAsync(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        long socketConnectStartTime = System.currentTimeMillis();
        this.begin(Metrics.ConnectionEvent.SOCKET_ESTABLISHMENT);
        return TimeoutSocketChannel.openAsync(inetAddr, this.connectTimeout, this.netStat, this.diagnosable, outboundTimeout, asyncExecutor).thenAccept(connectedChannel -> {
            this.socketChannel = connectedChannel;
            this.socket = this.socketChannel.socket();
            try {
                this.setReadTimeoutIfRequired(this.socketOptions);
            }
            catch (IOException exception) {
                throw new CompletionException(exception);
            }
            this.end(Metrics.ConnectionEvent.SOCKET_ESTABLISHMENT);
        }).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, ioException -> {
            throw this.handleEstablishSocketException((IOException)ioException, socketConnectStartTime, inetAddr);
        }));
    }

    @Override
    public NetStat getNetStat() {
        return this.netStat;
    }

    final void setSocketOptions() throws IOException {
        for (int option : SUPPORTED_SOCKET_OPTIONS) {
            Integer key = option;
            String value = (String)this.socketOptions.get(key);
            if (value == null) continue;
            this.setOption(option, value);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel.disconnect();
            } else if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(17900);
        }
        switch (option) {
            case 0: {
                this.setTcpNoDelay((String)value);
                break;
            }
            case 1: {
                this.setTcpKeepAlive((String)value);
                break;
            }
            case 3: 
            case 101: {
                this.setTcpReadTimeout((String)value);
                break;
            }
            case 33: {
                this.setTcpKeepAliveIdleTime((String)value);
                break;
            }
            case 34: {
                this.setTcpKeepAliveProbeInterval((String)value);
                break;
            }
            case 35: {
                this.setTcpKeepAliveProbeCount((String)value);
                break;
            }
        }
    }

    private final void setTcpNoDelay(String setting) throws IOException {
        this.socket.setTcpNoDelay(setting.equals("YES"));
    }

    private final void setTcpKeepAlive(String setting) throws IOException {
        if (setting.equals("YES")) {
            try {
                this.socket.setKeepAlive(true);
            }
            catch (IOException ioEx) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setTcpKeepAlive", "Failed to set keep alive. Exception " + ioEx.getMessage(), (String)null, null, (Object)ioEx);
            }
        }
    }

    private final void setTcpReadTimeout(String timeoutMillis) throws IOException {
        this.readTimeout = Integer.parseInt(timeoutMillis);
        if (!this.useNio.booleanValue()) {
            this.socket.setSoTimeout(this.readTimeout);
        } else {
            this.socketChannel.setSoTimeout(this.readTimeout);
        }
    }

    private final void setTcpKeepAliveIdleTime(String idleTimeSeconds) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPIDLE", Integer.class), Integer.valueOf(idleTimeSeconds));
    }

    private final void setTcpKeepAliveProbeInterval(String intervalSeconds) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPINTERVAL", Integer.class), Integer.valueOf(intervalSeconds));
    }

    private final void setTcpKeepAliveProbeCount(String count) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPCOUNT", Integer.class), Integer.valueOf(count));
    }

    private final <T> SocketOption<T> getSocketOptionByNameAndType(String name, Class<T> type) throws IOException {
        Set<SocketOption<?>> supportedOptions = this.useNio != false ? this.socketChannel.supportedOptions() : Sockets.supportedOptions(this.socket.getClass());
        SocketOption namedOption = supportedOptions.stream().filter(option -> name.equals(option.name())).findFirst().orElseThrow(() -> new IOException("Socket option " + name + " is not supported by SocketChannels opened in this JVM"));
        if (!namedOption.type().equals(type)) {
            throw new IOException("Unexpected type for socket option " + name + ". SocketOption.type() to returns " + namedOption.type() + " Expected type is: " + type);
        }
        return namedOption;
    }

    private final <T> void setSocketOption(SocketOption<T> option, T value) throws IOException {
        if (this.useNio.booleanValue()) {
            this.socketChannel.setOption((SocketOption)option, (Object)value);
        } else {
            Sockets.setOption(this.socket, option, value);
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(17900);
        }
        switch (option) {
            case 101: {
                return "" + this.readTimeout;
            }
            case 3: {
                if (!this.useNio.booleanValue()) {
                    return Integer.toString(this.socket.getSoTimeout());
                }
                return this.socketChannel.getSoTimeout();
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            if (this.socket != null) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.abortTcpMultiplexerRegistration();
    }

    private final void abortTcpMultiplexerRegistration() {
        if (!this.useNio.booleanValue()) {
            return;
        }
        if (this.socketChannel == null) {
            return;
        }
        if (!this.isRegisteredEver) {
            return;
        }
        this.forceCallback(new IOException("Connection aborted"));
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties prop) throws IOException, NetException {
        String tmp = (String)prop.get("oracle.net.READ_TIMEOUT");
        if (tmp == null) {
            tmp = (String)prop.get(3);
        }
        if (tmp == null) {
            tmp = "0";
        }
        this.setOption(3, tmp);
    }

    public String getAddressInfo() {
        return this.addressInfo;
    }

    @Override
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCP;
    }

    @Override
    public void registerForNonBlockingRead(Consumer<Throwable> onReady) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingRead(onReady);
    }

    @Override
    public final void registerForNonBlockingWrite(Consumer<Throwable> onReady) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingWrite(onReady);
    }

    @Override
    public final void forceCallback(Throwable onReadyError) {
        TcpMultiplexer.forceCallback(this.socketChannel.getUnderlyingChannel(), onReadyError);
    }

    @Override
    public final void restoreBlockingMode() throws IOException {
        if (!this.isRegisteredEver) {
            return;
        }
        SocketChannel underlyingChannel = this.socketChannel.getUnderlyingChannel();
        if (underlyingChannel.isBlocking()) {
            return;
        }
        TcpMultiplexer.restoreBlockingMode(underlyingChannel);
    }

    @Override
    @Blind
    public Properties getSqlNetOptions() {
        return (Properties)this.socketOptions.clone();
    }

    @Override
    public void enqueueBlockedWrites(boolean isEnabled) {
        this.socketChannel.enqueueBlockedWrites(isEnabled);
    }

    @Override
    public boolean completeBlockedWrites() throws IOException {
        return this.socketChannel.completeBlockedWrites();
    }

    @Override
    public void enqueueAllWrites(boolean isEnabled) {
        this.socketChannel.enqueueAllWrites(isEnabled);
    }

    @Override
    public boolean getEnqueueAllWrites() {
        return this.socketChannel.getEnqueueAllWrites();
    }

    @Override
    public void completeWrites() throws IOException {
        this.socketChannel.completeWrites();
    }

    @Override
    public final boolean awaitWriteReadiness(long timeoutMillis) throws IOException {
        SocketChannel channel = SocketChannelWrapper.unwrap(this.getSocketChannel());
        if (channel == null) {
            throw new ClosedChannelException();
        }
        boolean isBlockingBefore = channel.isBlocking();
        try {
            boolean bl;
            block10: {
                Selector selector = Selector.open();
                try {
                    channel.configureBlocking(false);
                    channel.register(selector, 4);
                    boolean bl2 = bl = 0 != selector.select(timeoutMillis);
                    if (selector == null) break block10;
                }
                catch (Throwable throwable) {
                    if (selector != null) {
                        try {
                            selector.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                selector.close();
            }
            return bl;
        }
        finally {
            channel.configureBlocking(isBlockingBefore);
        }
    }

    static {
        try {
            String globalProxyHost = System.getProperty("socksProxyHost", null);
            if (globalProxyHost != null) {
                DEFAULT_SOCKS_PROXY = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(globalProxyHost, Integer.parseInt(System.getProperty("socksProxyPort", "1080"))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

