/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.jdbc.AccessToken;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionCreationInformation;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.PoolMBeans;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollector;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.BorrowContext;
import oracle.ucp.jdbc.BorrowContextUpdater;
import oracle.ucp.jdbc.ConnectionConnectionPool;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.ConnectionLabelingCallback;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.DatasourceConfigManager;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.JDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.jdbc.UCPConnectionBuilder;
import oracle.ucp.jdbc.UCPConnectionBuilderImpl;
import oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.other.OtherConnectionProxyFactory;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.logging.annotations.PropertiesBlinder;
import oracle.ucp.logging.annotations.StringBlinder;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.Strings;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class PoolDataSourceImpl
implements PoolDataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    static final String CLASS_NAME = PoolDataSourceImpl.class.getName();
    private static final long serialVersionUID = 4343640747507L;
    static final String loggerName = "oracle.ucp.jdbc";
    private static final Logger logger = Logger.getLogger("oracle.ucp.jdbc");
    public static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
    public static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
    public static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";
    public static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
    public static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
    private static final String AC_POOL_NAME = "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool";
    private static final String AC_PROXY_CLASS_NAME_KEYWORD = "replay";
    protected static final Pattern COLOCATION_URL = Pattern.compile(Pattern.quote("colocation_tag="), 2);
    private final ReentrantLock networkProtocolLock = new ReentrantLock();
    private final ReentrantLock poolStartedLock = new ReentrantLock();
    private final ReentrantLock connectionFactoryClassNameLock = new ReentrantLock();
    private final ReentrantLock sqlForValidateConnectionLock = new ReentrantLock();
    private final AtomicBoolean fcfExplicitlySet = new AtomicBoolean(false);
    private final List<AutoProperty<?>> autoProperties = new ArrayList();
    private volatile String username = null;
    private volatile OpaqueString password = OpaqueString.NULL;
    private volatile String url = null;
    private volatile String serverName = null;
    private volatile int portNumber = 0;
    private volatile String databaseName = null;
    private volatile String serviceName = null;
    private volatile Properties pdbRoles = null;
    private volatile SSLContext sslContext = null;
    private volatile PoolDataSource.HostnameResolver hostnameResolver = null;
    private final AtomicBoolean isXmlUsed = new AtomicBoolean(false);
    private volatile boolean disableAPI = false;
    private final AtomicBoolean isConfigureNewDS = new AtomicBoolean(false);
    volatile transient JDBCConnectionPool connectionPool = null;
    private volatile String roleName = null;
    private final Properties connectionProperties = new Properties();
    private final Properties connectionFactoryProperties = new Properties();
    private volatile String connectionFactoryClassName = "";
    private final AtomicBoolean connectionPoolFactoryClassNameWasSet = new AtomicBoolean(false);
    private volatile boolean isDriverFactory = false;
    private final AtomicReference<String> connectionPoolName = new AtomicReference();
    volatile Object connectionFactory = null;
    private volatile Boolean acActive = null;
    private transient AtomicBoolean poolCreated = new AtomicBoolean(false);
    private transient AtomicBoolean poolStarted = new AtomicBoolean(false);
    private volatile String onsConfiguration = null;
    private transient UniversalConnectionPoolManager manager = null;
    private transient AtomicReference<DiagnosticsCollector> diagnosticsCollector = new AtomicReference<Object>(null);
    private Supplier<? extends AccessToken> tokenSupplier;
    private final AutoProperty<String> dataSourceName = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 52;
        PoolDataSourceImpl.setProperty(this.connectionFactory, "dataSourceName", p, true, true);
    });
    private final AutoProperty<String> dataSourceDescription = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 53;
        PoolDataSourceImpl.setProperty(this.connectionFactory, "description", p, true, true);
    });
    private final AutoProperty<String> networkProtocol = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 54;
        PoolDataSourceImpl.setProperty(this.connectionFactory, "networkProtocol", p, true, true);
    });
    private final AutoProperty<Boolean> validateConnectionOnBorrow = this.newAutoProperty(false, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setValidateConnectionOnBorrow((boolean)p);
    }, ap -> this.connectionPool.getValidateConnectionOnBorrow());
    private final AutoProperty<String> sqlForValidateConnection = this.newAutoProperty(null, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setSQLForValidateConnection((String)p);
    }, ap -> this.connectionPool.getSQLForValidateConnection());
    private final AutoProperty<Integer> initialPoolSize = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setInitialPoolSize((int)p);
    }, ap -> this.connectionPool.getInitialPoolSize());
    private final AutoProperty<Integer> minPoolSize = this.newAutoProperty(1, (ap, p) -> {
        ap.errcode = 2;
        this.connectionPool.setMinPoolSize((int)p);
    }, ap -> this.connectionPool.getMinPoolSize());
    private final AutoProperty<Integer> minIdle = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 85;
        this.connectionPool.setMinIdle((int)p);
    }, ap -> this.connectionPool.getMinIdle());
    private final AutoProperty<Integer> maxPoolSize = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 3;
        this.connectionPool.setMaxPoolSize((int)p);
    }, ap -> this.connectionPool.getMaxPoolSize());
    private final AutoProperty<Integer> maxConnectionsPerService = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 77;
        this.connectionPool.setMaxConnectionsPerService((int)p);
    }, ap -> this.connectionPool.getMaxConnectionsPerService());
    private final AutoProperty<Integer> abandonedConnectionTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 7;
        this.connectionPool.setAbandonedConnectionTimeout((int)p);
    }, ap -> this.connectionPool.getAbandonedConnectionTimeout());
    private final AutoProperty<Integer> timeToLiveConnectionTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setTimeToLiveConnectionTimeout((int)p);
    }, ap -> this.connectionPool.getTimeToLiveConnectionTimeout());
    private final AutoProperty<Integer> inactiveConnectionTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 4;
        this.connectionPool.setInactiveConnectionTimeout((int)p);
    }, ap -> this.connectionPool.getInactiveConnectionTimeout());
    private final AutoProperty<Integer> timeoutCheckInterval = this.newAutoProperty(30, (ap, p) -> {
        ap.errcode = 8;
        this.connectionPool.setTimeoutCheckInterval((int)p);
    }, ap -> this.connectionPool.getTimeoutCheckInterval());
    private final AutoProperty<Integer> maxStatements = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 10;
        this.connectionPool.setMaxStatements((int)p);
    }, ap -> this.connectionPool.getMaxStatements(), p -> p >= 0);
    private final AutoProperty<Long> connectionWaitDurationInMillis = this.newAutoProperty(UniversalConnectionPoolBase.DEFAULT_CONNECTION_WAIT_DURATION.toMillis(), (ap, p) -> {
        ap.errcode = 5;
        if (Objects.nonNull(this.connectionPool)) {
            this.connectionPool.setConnectionWaitDurationInMillis((Long)p);
        }
    }, ap -> Objects.nonNull(this.connectionPool) ? this.connectionPool.getConnectionWaitDurationInMillis() : (Long)ap.value);
    private final AutoProperty<Long> maxConnectionReuseTime = this.newAutoProperty(0L, (ap, p) -> {
        ap.errcode = 56;
        this.connectionPool.setMaxConnectionReuseTime((long)p);
    }, ap -> this.connectionPool.getMaxConnectionReuseTime());
    private final AutoProperty<Integer> maxConnectionReuseCount = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 57;
        this.connectionPool.setMaxConnectionReuseCount((int)p);
    }, ap -> this.connectionPool.getMaxConnectionReuseCount());
    private final Properties connectionLabelingCallbackRequestedLabels = new Properties();
    private final AutoProperty<oracle.ucp.ConnectionLabelingCallback> connectionLabelingCallback = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 18;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "registering labeling callback", null, null, new Object[0]);
            this.connectionPool.registerConnectionLabelingCallback((oracle.ucp.ConnectionLabelingCallback)p);
            this.setConnectionLabelingCallbackRequestedLabels((oracle.ucp.ConnectionLabelingCallback)p);
        } else {
            ap.errcode = 19;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "removing labeling callback", null, null, new Object[0]);
            this.connectionPool.removeConnectionLabelingCallback();
            this.clearConnectionLabelingCallbackRequestedLabels();
        }
    }, ap -> {
        oracle.ucp.ConnectionLabelingCallback cbk;
        oracle.ucp.ConnectionLabelingCallback connectionLabelingCallback = cbk = null != this.connectionPool ? this.connectionPool.getConnectionLabelingCallback() : (oracle.ucp.ConnectionLabelingCallback)ap.value;
        if (logger.getLevel() == Level.FINE) {
            this.connectionPool.trace(Level.FINEST, CLASS_NAME, "newAutoProperty", "obtained labeling callback {0}", null, null, cbk);
        }
        return cbk;
    });
    private final AutoProperty<ConnectionAffinityCallback> connectionAffinityCallback = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 20;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "registering affinity callback", null, null, new Object[0]);
            this.connectionPool.registerConnectionAffinityCallback((ConnectionAffinityCallback)p);
        } else {
            ap.errcode = 21;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "removing affinity callback", null, null, new Object[0]);
            this.connectionPool.removeConnectionAffinityCallback();
        }
    }, ap -> {
        ConnectionAffinityCallback cbk = null != this.connectionPool ? this.connectionPool.getConnectionAffinityCallback() : (ConnectionAffinityCallback)ap.value;
        this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "obtained affinity callback {0}", null, null, cbk);
        return cbk;
    });
    private final AutoProperty<Integer> connectionHarvestTriggerCount = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 12;
        this.connectionPool.setConnectionHarvestTriggerCount((int)p);
    }, ap -> this.connectionPool.getConnectionHarvestTriggerCount());
    private final AutoProperty<Integer> connectionHarvestMaxCount = this.newAutoProperty(1, (ap, p) -> {
        ap.errcode = 13;
        this.connectionPool.setConnectionHarvestMaxCount((int)p);
    }, ap -> this.connectionPool.getConnectionHarvestMaxCount());
    private final AutoProperty<Integer> queryTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setQueryTimeout((int)p);
    }, ap -> this.connectionPool.getQueryTimeout());
    private final AutoProperty<Integer> maxConnectionsPerShard = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setMaxConnectionsPerShard((Integer)p);
    }, ap -> this.connectionPool.getMaxConnectionsPerShard());
    private final AutoProperty<Boolean> shardingMode = this.newAutoProperty(true, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setShardingMode((boolean)p);
    }, ap -> this.connectionPool.getShardingMode());
    private final AutoProperty<Boolean> fastConnectionFailoverEnabled = this.newAutoProperty(false, (ap, p) -> {
        ap.errcode = 9;
        if (this.fcfExplicitlySet.get() || ap.get() != p) {
            this.connectionPool.setFailoverEnabled((boolean)p);
        } else {
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "FCF-Enabled not explicitly set, skip internal setting to: {0}", null, null, p);
        }
    }, ap -> this.connectionPool.isFailoverEnabled());
    private final AutoProperty<ConnectionInitializationCallback> connectionInitializationCallback = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 60;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "registering initialization callback", null, null, new Object[0]);
            this.connectionPool.registerConnectionInitializationCallback((ConnectionInitializationCallback)p);
        } else {
            ap.errcode = 61;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "removing initialization callback", null, null, new Object[0]);
            this.connectionPool.unregisterConnectionInitializationCallback();
        }
    }, ap -> this.connectionPool.getConnectionInitializationCallback());
    private final AutoProperty<Consumer<ConnectionCreationInformation>> connectionCreationConsumer = this.newAutoProperty(null, (ap, p) -> {
        if (null != p) {
            ap.errcode = 83;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "registering connection creation consumer", null, null, new Object[0]);
            this.connectionPool.registerConnectionCreationConsumer((Consumer<ConnectionCreationInformation>)p);
        } else {
            ap.errcode = 84;
            this.connectionPool.trace(Level.FINE, CLASS_NAME, "newAutoProperty", "removing connection creation consumer", null, null, new Object[0]);
            this.connectionPool.unregisterConnectionCreationConsumer();
        }
    }, ap -> this.connectionPool.getConnectionCreationConsumer());
    private final AutoProperty<Integer> connectionLabelingHighCost = this.newAutoProperty(Integer.MAX_VALUE, (ap, p) -> {
        ap.errcode = 63;
        this.connectionPool.setConnectionLabelingHighCost((int)p);
    }, ap -> this.connectionPool.getConnectionLabelingHighCost());
    private final AutoProperty<Integer> highCostConnectionReuseThreshold = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 64;
        this.connectionPool.setHighCostConnectionReuseThreshold((int)p);
    }, ap -> this.connectionPool.getHighCostConnectionReuseThreshold());
    private final AutoProperty<Boolean> isPoolShareable = this.newAutoProperty(false, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setShareable((boolean)p);
    }, ap -> this.connectionPool.isShareable());
    private final AutoProperty<Integer> repurposeThreshold = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 22;
        this.connectionPool.setConnectionRepurposeThreshold((Integer)p);
    }, ap -> this.connectionPool.getConnectionRepurposeThreshold());
    private final AutoProperty<Integer> secondsToTrustIdleConnection = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 68;
        this.connectionPool.setSecondsToTrustIdleConnection((int)p);
    }, ap -> this.connectionPool.getSecondsToTrustIdleConnection());
    private final AutoProperty<Integer> loginTimeout = this.newAutoProperty(0, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setLoginTimeout((int)p);
        PoolDataSourceImpl.setProperty(this.connectionFactory, "loginTimeout", p, true, true);
        if (this.connectionFactory instanceof Driver) {
            String key = "oracle.jdbc.loginTimeout";
            String value = Integer.toString(p);
            this.connectionFactoryProperties.setProperty("oracle.jdbc.loginTimeout", value);
        }
    }, ap -> this.connectionPool.getLoginTimeout());
    private final AutoProperty<Integer> connectionValidationTimeout = this.newAutoProperty(15, (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setConnectionValidationTimeout((int)p);
    }, ap -> this.connectionPool.getConnectionValidationTimeout());
    private final AutoProperty<Boolean> readOnlyInstanceAllowed = this.newAutoProperty(false, (ap, p) -> {
        if (Objects.nonNull(this.connectionPool)) {
            this.connectionPool.setReadOnlyInstanceAllowed((boolean)p);
        }
    }, ap -> Objects.nonNull(this.connectionPool) ? this.connectionPool.isReadOnlyInstanceAllowed() : ((Boolean)ap.value).booleanValue());
    private final AutoProperty<Boolean> createConnectionInBorrowThread = this.newAutoProperty(Util.createConnectionInBorrowThread(), (ap, p) -> {
        ap.errcode = 6;
        this.connectionPool.setCreateConnectionInBorrowThread((boolean)p);
    }, ap -> this.connectionPool.isCreateConnectionInBorrowThread());
    private transient UniversalConnectionPoolManagerMBean managerMBean = null;
    private transient CriStats defaultCriMetadata = null;
    private transient BorrowContext thisPdsBorrowContext = BorrowContext.build(this);
    private static final String UCP_IS_XML_USED_FOR_POOL_CONFIGURATION = "isXmlUsed";

    private final <T> AutoProperty<T> newAutoProperty(T value, AutoPropertySetter<T> setter, AutoPropertyGetter<T> getter, AutoPropertyValidator<T> validator) {
        return new AutoProperty<T>(value, setter, getter, validator);
    }

    private final <T> AutoProperty<T> newAutoProperty(T value, AutoPropertySetter<T> setter, AutoPropertyGetter<T> getter) {
        return new AutoProperty<Object>(value, setter, getter, p -> true);
    }

    private final <T> AutoProperty<T> newAutoProperty(T value, AutoPropertySetter<T> setter) {
        return new AutoProperty<Object>(value, setter, ap -> ap.value, p -> true);
    }

    private void setConnectionLabelingCallbackRequestedLabels(oracle.ucp.ConnectionLabelingCallback cbk) {
        ConnectionLabelingCallback jdbcCbk;
        Properties connectionLabelingCallbackRequestedLabels;
        if (null != cbk && cbk instanceof ConnectionLabelingCallback && null != (connectionLabelingCallbackRequestedLabels = (jdbcCbk = (ConnectionLabelingCallback)cbk).getRequestedLabels())) {
            this.connectionLabelingCallbackRequestedLabels.clear();
            this.connectionLabelingCallbackRequestedLabels.putAll((Map<?, ?>)connectionLabelingCallbackRequestedLabels);
        }
    }

    private void clearConnectionLabelingCallbackRequestedLabels() {
        this.connectionLabelingCallbackRequestedLabels.clear();
    }

    void setConfigureNewDataSource(boolean isNewDatasource) {
        this.isConfigureNewDS.set(isNewDatasource);
    }

    private UniversalConnectionPoolManager getManager() {
        if (null != this.manager) {
            return this.manager;
        }
        try {
            this.manager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(this.getDiagnosable());
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.SEVERE, CLASS_NAME, "getManager", "pool manager was not initialized", null, e, new Object[0]);
        }
        return this.manager;
    }

    private UniversalConnectionPoolManagerMBean getManagerMBean() {
        if (null != this.managerMBean) {
            return this.managerMBean;
        }
        try {
            this.managerMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.SEVERE, CLASS_NAME, "getManagerMBean", "pool manager MBean was not initialized", null, e, new Object[0]);
        }
        return this.managerMBean;
    }

    public PoolDataSourceImpl() {
    }

    @Debug(level=Debug.Level.FINEST)
    PoolDataSourceImpl(String poolName, String dsName, Map<String, Object> config) throws UniversalConnectionPoolException, Exception {
        this();
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "<init>", "entering args ({0}, {1}, {2})", null, null, poolName, dsName, config);
            this.createSharedPoolFromXml(poolName, dsName, config);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public void startPool() throws SQLException {
        JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(this);
        this.startPool(cri, false);
    }

    public void startPool(JDBCConnectionRetrievalInfo cri) throws SQLException {
        this.startPool(cri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPool(JDBCConnectionRetrievalInfo cri, boolean keepMetadataConn) throws SQLException {
        block9: {
            this.poolStartedLock.lock();
            try {
                if (this.connectionPool != null && this.connectionPool.isShareable()) {
                    return;
                }
                if (this.poolStarted.get()) break block9;
                try {
                    if (this.connectionPool == null) {
                        this.createPool();
                    }
                    if (this.connectionPool.isLifecycleStopped() || this.connectionPool.isLifecycleFailed()) {
                        this.connectionPool.start(cri, keepMetadataConn);
                    }
                    this.trace(Level.FINE, CLASS_NAME, "getManagerMBean", "connection pool is started", null, null, new Object[0]);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(0, e);
                }
                this.poolStarted.set(true);
            }
            finally {
                this.poolStartedLock.unlock();
            }
        }
    }

    @Debug(level=Debug.Level.FINEST)
    protected void createPoolWithDefaultProperties() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createPoolWithDefaultProperties", "entering args ()", null, null, new Object[0]);
            try {
                if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.startsWith("oracle.jdbc")) {
                    if (!this.isDriverFactory) {
                        if (!(this.connectionFactoryClassName.startsWith("oracle.jdbc.replay") || this.connectionFactoryClassName.equals("oracle.jdbc.pool.OracleDataSource") || this.connectionFactoryClassName.startsWith("oracle.jdbc.datasource.impl"))) {
                            OracleDataSourceConnectionFactoryAdapter ocfa = new OracleDataSourceConnectionFactoryAdapter((DataSource)this.connectionFactory, this.getDiagnosable());
                            this.connectionPool = new OracleConnectionConnectionPool(ocfa, this.getDiagnosable());
                            ocfa.setUniversalConnectionPool(this.connectionPool);
                        } else {
                            ReplayDataSourceConnectionFactoryAdapter ocfa = new ReplayDataSourceConnectionFactoryAdapter((DataSource)this.connectionFactory, this.getDiagnosable());
                            try {
                                Class<?> cls = Class.forName(AC_POOL_NAME);
                                this.trace(Level.FINEST, CLASS_NAME, "createPoolWithDefaultProperties", "OracleReplayableConnectionConnectionPool loaded", null, null, new Object[0]);
                                Constructor<?> c = cls.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class, Diagnosable.class);
                                this.trace(Level.FINEST, CLASS_NAME, "createPoolWithDefaultProperties", "OracleReplayableConnectionConnectionPool constructor found", null, null, new Object[0]);
                                this.connectionPool = (JDBCConnectionPool)c.newInstance(ocfa, this.getDiagnosable());
                                this.trace(Level.FINEST, CLASS_NAME, "createPoolWithDefaultProperties", "OracleReplayableConnectionConnectionPool instantiated", null, null, new Object[0]);
                                ocfa.setUniversalConnectionPool(this.connectionPool);
                            }
                            catch (Throwable t) {
                                UCPErrorHandler.throwSQLException(1, t);
                            }
                        }
                    } else {
                        OracleDriverConnectionFactoryAdapter odcfa = new OracleDriverConnectionFactoryAdapter((Driver)this.connectionFactory, this.url, this.connectionFactoryProperties, this.connectionProperties, this.getDiagnosable());
                        this.connectionPool = new OracleConnectionConnectionPool(odcfa, this.getDiagnosable());
                        odcfa.setUniversalConnectionPool(this.connectionPool);
                    }
                    this.connectionPool.setOraclePool(true);
                    this.connectionPool.setColocation(COLOCATION_URL.matcher(this.getURL()).find());
                    this.trace(Level.FINE, CLASS_NAME, "createPoolWithDefaultProperties", "Using COLOCATION: {0}", null, null, this.connectionPool.useColocation());
                } else {
                    if (!this.isDriverFactory) {
                        DataSourceConnectionFactoryAdapter cfa = new DataSourceConnectionFactoryAdapter((DataSource)this.connectionFactory, this.getDiagnosable());
                        this.connectionPool = new ConnectionConnectionPool(cfa, this.getDiagnosable()){
                            private final ConnectionProxyFactory cpf;
                            {
                                this.cpf = new OtherConnectionProxyFactory();
                            }

                            @Override
                            public ConnectionProxyFactory getProxyFactory() {
                                return this.cpf;
                            }
                        };
                        cfa.setUniversalConnectionPool(this.connectionPool);
                    } else {
                        DriverConnectionFactoryAdapter dcfa = new DriverConnectionFactoryAdapter((Driver)this.connectionFactory, this.url, this.connectionFactoryProperties, this.connectionProperties, this.getDiagnosable());
                        this.connectionPool = new ConnectionConnectionPool(dcfa, this.getDiagnosable()){
                            private final ConnectionProxyFactory cpf;
                            {
                                this.cpf = new OtherConnectionProxyFactory();
                            }

                            @Override
                            public ConnectionProxyFactory getProxyFactory() {
                                return this.cpf;
                            }
                        };
                        dcfa.setUniversalConnectionPool(this.connectionPool);
                    }
                    this.connectionPool.setOraclePool(false);
                }
                assert (this.connectionPool != null);
                this.connectionPool.setConnectionFactory(this.connectionFactory);
                this.trace(Level.FINE, CLASS_NAME, "createPoolWithDefaultProperties", "Connection pool instance is created with default properties", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(1, e);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createPoolWithDefaultProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createPoolWithDefaultProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void useExistingPool() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "useExistingPool", "entering args ()", null, null, new Object[0]);
            this.connectionPool = (JDBCConnectionPool)this.getManager().getConnectionPool(this.connectionPoolName.get());
            this.connectionFactory = this.connectionPool.getConnectionFactory();
            this.poolCreated.set(true);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "useExistingPool", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "useExistingPool", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalConnectionPool createUniversalConnectionPool() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createUniversalConnectionPool", "entering args ()", null, null, new Object[0]);
            this.poolStartedLock.lock();
            try {
                try {
                    if (!this.poolCreated.get()) {
                        boolean poolExists = Arrays.asList(this.getManager().getConnectionPoolNames()).contains(this.connectionPoolName.get());
                        if (poolExists) {
                            if (Util.isDestroyOnReloadEnabled()) {
                                if (this.getManager().isJmxEnabled()) {
                                    this.getManagerMBean().destroyConnectionPool(this.connectionPoolName.get());
                                } else {
                                    this.getManager().destroyConnectionPool(this.connectionPoolName.get());
                                }
                            } else {
                                UCPErrorHandler.throwUniversalConnectionPoolException(350);
                            }
                        }
                        if (this.connectionPool == null) {
                            this.initConnectionFactory();
                            this.createPoolWithDefaultProperties();
                            assert (this.connectionPool != null);
                            String poolName = this.connectionPoolName.get();
                            if (poolName != null && !poolName.equals("")) {
                                this.connectionPool.setName(poolName);
                            }
                            this.poolCreated.set(true);
                            for (AutoProperty<?> param : this.autoProperties) {
                                param.set();
                            }
                            if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.startsWith("oracle.jdbc")) {
                                ((OracleJDBCConnectionPool)this.connectionPool).setONSConfiguration(this.onsConfiguration);
                            }
                            if (this.connectionFactoryClassName != null) {
                                try {
                                    boolean needToRemoveConnectionClass = false;
                                    boolean needToRemoveConnectionPurity = false;
                                    if (!this.connectionProperties.containsKey("oracle.jdbc.DRCPConnectionClass")) {
                                        if (this.connectionPoolName != null) {
                                            if (this.connectionPoolName.get() != null) {
                                                this.connectionProperties.put("oracle.jdbc.DRCPConnectionClass", this.connectionPoolName.get());
                                            }
                                        } else {
                                            this.connectionProperties.put("oracle.jdbc.DRCPConnectionClass", this.connectionPool.getName());
                                        }
                                        needToRemoveConnectionClass = true;
                                    }
                                    if (!this.connectionProperties.containsKey("oracle.jdbc.DRCPConnectionPurity")) {
                                        this.connectionProperties.put("oracle.jdbc.DRCPConnectionPurity", "SELF");
                                        needToRemoveConnectionPurity = true;
                                    }
                                    PoolDataSourceImpl.setProperty(this.connectionFactory, "connectionProperties", this.connectionProperties, true, true);
                                    if (needToRemoveConnectionClass) {
                                        this.connectionProperties.remove("oracle.jdbc.DRCPConnectionClass");
                                    }
                                    if (needToRemoveConnectionPurity) {
                                        this.connectionProperties.remove("oracle.jdbc.DRCPConnectionPurity");
                                    }
                                    this.trace(Level.FINEST, CLASS_NAME, "createUniversalConnectionPool", "Connection properties are set", null, null, new Object[0]);
                                }
                                catch (Exception e) {
                                    UCPErrorHandler.throwSQLException(48, e);
                                }
                            }
                            this.trace(Level.FINEST, CLASS_NAME, "createUniversalConnectionPool", "connection pool is configured", null, null, new Object[0]);
                            assert (this.connectionPool != null);
                            this.connectionPool.setConnectionRetrievalInfo(new JDBCConnectionRetrievalInfo(this));
                        }
                    }
                    if (UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(this.getDiagnosable()).isJmxEnabled()) {
                        this.getManagerMBean();
                        this.createUniversalConnectionPoolMBean();
                    }
                }
                catch (Exception exc) {
                    this.connectionPool = null;
                    UCPErrorHandler.throwSQLException(22, exc);
                }
            }
            finally {
                this.poolStartedLock.unlock();
            }
            JDBCConnectionPool jDBCConnectionPool = this.connectionPool;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createUniversalConnectionPool", "returning {0}", null, null, jDBCConnectionPool);
            return jDBCConnectionPool;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createUniversalConnectionPool", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void createSharedPoolFromXml(String string, String string2, Map<String, Object> map) throws Exception {
        try {
            void poolName;
            void dataSourceName;
            void poolPropertiesMap;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createSharedPoolFromXml", "entering args ({0}, {1}, {2})", null, null, string, string2, map);
            this.isXmlUsed.set(true);
            this.applyPoolProperties((Map<String, Object>)poolPropertiesMap);
            this.setDataSourceName((String)dataSourceName);
            this.applyDataSourcProperties((Map<? extends String, ? extends Object>)poolPropertiesMap);
            this.setConnectionPoolName((String)poolName);
            if (Boolean.parseBoolean((String)poolPropertiesMap.get("shared"))) {
                boolean poolExists = Arrays.asList(this.getManager().getConnectionPoolNames()).contains(poolName);
                if (poolExists) {
                    if (this.getManager().getConnectionPool((String)poolName).isShareable()) {
                        this.useExistingPool();
                    } else if (Util.isDestroyOnReloadEnabled()) {
                        if (this.getManager().isJmxEnabled()) {
                            this.getManagerMBean().destroyConnectionPool((String)poolName);
                        } else {
                            this.getManager().destroyConnectionPool((String)poolName);
                        }
                        this.startPool();
                    } else {
                        UCPErrorHandler.throwUniversalConnectionPoolException(350);
                    }
                } else {
                    this.startPool();
                }
                this.disableAPI = true;
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createSharedPoolFromXml", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createSharedPoolFromXml", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void createPool() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createPool", "entering args ()", null, null, new Object[0]);
            if (this.getManager().isJmxEnabled()) {
                this.getManagerMBean().createConnectionPool(this);
            } else {
                this.getManager().createConnectionPool(this);
            }
            this.trace(Level.FINE, CLASS_NAME, "createPool", "Connection pool instance is created", null, null, new Object[0]);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createPool", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createPool", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private boolean allowSetter() {
        boolean allowedSetter;
        boolean bl = allowedSetter = !this.disableAPI;
        if (!allowedSetter) {
            this.trace(Level.WARNING, CLASS_NAME, "allowSetter", "setters are blocked, use reconfiguration APIs to modify pool/datasource properties.", null, null, new Object[0]);
        }
        return allowedSetter;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void applyDataSourcProperties(Map<? extends String, ? extends Object> map) throws UniversalConnectionPoolException, Exception {
        try {
            void poolPropertiesMap;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "applyDataSourcProperties", "entering args ({0})", null, null, map);
            String dataSourceName = this.dataSourceName.get();
            HashMap selectedDatasourceMap = new HashMap();
            String datasourceTag = "data-source-" + dataSourceName;
            if (poolPropertiesMap.containsKey(datasourceTag)) {
                selectedDatasourceMap.putAll((Map)poolPropertiesMap.get(datasourceTag));
            }
            try {
                if (selectedDatasourceMap.containsKey("service")) {
                    this.setServiceName((String)selectedDatasourceMap.get("service"));
                }
                if (selectedDatasourceMap.containsKey("pdb-role")) {
                    this.setPdbRoles((Properties)selectedDatasourceMap.get("pdb-role"));
                }
                if (selectedDatasourceMap.containsKey("description")) {
                    this.dataSourceDescription.set((String)selectedDatasourceMap.get("description"));
                }
                String user = null;
                OpaqueString password = OpaqueString.NULL;
                String walletFile = null;
                if (poolPropertiesMap.containsKey("user")) {
                    user = (String)poolPropertiesMap.get("user");
                }
                if (selectedDatasourceMap.containsKey("user")) {
                    user = (String)selectedDatasourceMap.get("user");
                }
                if (null != user) {
                    this.username = user;
                }
                password = this.getPasswordFromPoolElement((Map<? extends String, ? extends Object>)poolPropertiesMap);
                if (selectedDatasourceMap.containsKey("password")) {
                    password = (OpaqueString)selectedDatasourceMap.get("password");
                }
                if (selectedDatasourceMap.containsKey("wallet-file")) {
                    walletFile = (String)selectedDatasourceMap.get("wallet-file");
                    OpaqueString walletFilePassword = OpaqueString.NULL;
                    if (selectedDatasourceMap.containsKey("wallet-password")) {
                        walletFilePassword = (OpaqueString)selectedDatasourceMap.get("wallet-password");
                    }
                    try {
                        password = this.getPasswordFromWallet(this.url, walletFile, walletFilePassword);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid Wallet location/Wrong Wallet password");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Exception while accessing Oracle Wallet", e);
                    }
                }
                if (OpaqueString.NULL != password) {
                    this.password = password;
                }
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("invalid property type set ");
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "applyDataSourcProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "applyDataSourcProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void applyPoolProperties(Map<String, Object> map) throws UniversalConnectionPoolException, Exception {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "applyPoolProperties", "entering args ({0})", null, null, map);
            try {
                void poolPropertiesMap;
                block94: for (String property : poolPropertiesMap.keySet()) {
                    if (property.startsWith("data-source-")) continue;
                    switch (property) {
                        case "user": 
                        case "password": 
                        case "wallet-file": 
                        case "wallet-password": 
                        case "connection-pool-name": {
                            continue block94;
                        }
                        case "shared": {
                            this.isPoolShareable.set(Boolean.parseBoolean((String)poolPropertiesMap.get("shared")));
                            continue block94;
                        }
                        case "url": {
                            this.url = (String)poolPropertiesMap.get("url");
                            continue block94;
                        }
                        case "max-pool-size": {
                            this.maxPoolSize.set(Integer.parseInt((String)poolPropertiesMap.get("max-pool-size")));
                            continue block94;
                        }
                        case "initial-pool-size": {
                            this.initialPoolSize.set(Integer.parseInt((String)poolPropertiesMap.get("initial-pool-size")));
                            continue block94;
                        }
                        case "min-pool-size": {
                            this.minPoolSize.set(Integer.parseInt((String)poolPropertiesMap.get("min-pool-size")));
                            continue block94;
                        }
                        case "min-idle": {
                            this.minIdle.set(Integer.parseInt((String)poolPropertiesMap.get("min-idle")));
                            continue block94;
                        }
                        case "fast-connection-failover-enabled": {
                            this.fastConnectionFailoverEnabled.set(Boolean.parseBoolean((String)poolPropertiesMap.get("fast-connection-failover-enabled")));
                            this.fcfExplicitlySet.set(true);
                            continue block94;
                        }
                        case "max-connection-reuse-count": {
                            this.maxConnectionReuseCount.set(Integer.parseInt((String)poolPropertiesMap.get("max-connection-reuse-count")));
                            continue block94;
                        }
                        case "max-connection-reuse-time": {
                            this.maxConnectionReuseTime.set(Long.parseLong((String)poolPropertiesMap.get("max-connection-reuse-time")));
                            continue block94;
                        }
                        case "max-idle-time": {
                            this.inactiveConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("max-idle-time")));
                            continue block94;
                        }
                        case "max-statements": {
                            this.maxStatements.set(Integer.parseInt((String)poolPropertiesMap.get("max-statements")));
                            continue block94;
                        }
                        case "abandoned-connection-timeout": {
                            this.abandonedConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("abandoned-connection-timeout")));
                            continue block94;
                        }
                        case "connection-harvest-max-count": {
                            this.connectionHarvestMaxCount.set(Integer.parseInt((String)poolPropertiesMap.get("connection-harvest-max-count")));
                            continue block94;
                        }
                        case "connection-harvest-trigger-count": {
                            this.connectionHarvestTriggerCount.set(Integer.parseInt((String)poolPropertiesMap.get("connection-harvest-trigger-count")));
                            continue block94;
                        }
                        case "inactive-connection-timeout": {
                            this.inactiveConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("inactive-connection-timeout")));
                            continue block94;
                        }
                        case "connection-wait-timeout": {
                            this.connectionWaitDurationInMillis.set(Duration.ofSeconds(Integer.parseInt((String)poolPropertiesMap.get("connection-wait-timeout"))).toMillis());
                            continue block94;
                        }
                        case "connection-wait-duration": {
                            this.connectionWaitDurationInMillis.set(Duration.parse((String)poolPropertiesMap.get("connection-wait-duration")).toMillis());
                            continue block94;
                        }
                        case "validate-connection-on-borrow": {
                            this.validateConnectionOnBorrow.set(Boolean.parseBoolean((String)poolPropertiesMap.get("validate-connection-on-borrow")));
                            continue block94;
                        }
                        case "sql-for-validate-connection": {
                            this.sqlForValidateConnection.set((String)poolPropertiesMap.get("sql-for-validate-connection"));
                            continue block94;
                        }
                        case "timeout-check-interval": {
                            this.timeoutCheckInterval.set(Integer.parseInt((String)poolPropertiesMap.get("timeout-check-interval")));
                            continue block94;
                        }
                        case "property-cycle": {
                            this.timeoutCheckInterval.set(Integer.parseInt((String)poolPropertiesMap.get("property-cycle")));
                            continue block94;
                        }
                        case "time-to-live-connection-timeout": {
                            this.timeToLiveConnectionTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("time-to-live-connection-timeout")));
                            continue block94;
                        }
                        case "high-cost-connection-reuse-threshold": {
                            this.highCostConnectionReuseThreshold.set(Integer.parseInt((String)poolPropertiesMap.get("high-cost-connection-reuse-threshold")));
                            continue block94;
                        }
                        case "connection-labeling-high-cost": {
                            this.connectionLabelingHighCost.set(Integer.parseInt((String)poolPropertiesMap.get("connection-labeling-high-cost")));
                            continue block94;
                        }
                        case "ons-configuration": {
                            this.setONSConfiguration((String)poolPropertiesMap.get("ons-configuration"));
                            continue block94;
                        }
                        case "connection-labeling-callback": {
                            Class<?> labelingClass = Class.forName((String)poolPropertiesMap.get("connection-labeling-callback"));
                            oracle.ucp.ConnectionLabelingCallback labelingObject = (oracle.ucp.ConnectionLabelingCallback)labelingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (labelingObject == null) {
                                throw new IllegalArgumentException("callback has to be non-null");
                            }
                            this.connectionLabelingCallback.set(labelingObject);
                            continue block94;
                        }
                        case "connection-affinity-callback": {
                            Class<?> affinityClass = Class.forName((String)poolPropertiesMap.get("connection-affinity-callback"));
                            ConnectionAffinityCallback affinityObject = (ConnectionAffinityCallback)affinityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (affinityObject == null) {
                                throw new IllegalArgumentException("callback has to be non-null");
                            }
                            this.connectionAffinityCallback.set(affinityObject);
                            continue block94;
                        }
                        case "connection-initialization-callback": {
                            Class<?> initializationClass = Class.forName((String)poolPropertiesMap.get("connection-initialization-callback"));
                            ConnectionInitializationCallback initializationObject = (ConnectionInitializationCallback)initializationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (initializationObject == null) {
                                throw new IllegalArgumentException("callback has to be non-null");
                            }
                            this.connectionInitializationCallback.set(initializationObject);
                            continue block94;
                        }
                        case "connection-creation-consumer": {
                            Class<?> connCreationConsumerClass = Class.forName((String)poolPropertiesMap.get("connection-creation-consumer"));
                            Consumer connCreationConsumerObject = (Consumer)connCreationConsumerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (connCreationConsumerObject == null) {
                                throw new IllegalArgumentException("connection creation error consumer has to be non-null");
                            }
                            this.connectionCreationConsumer.set(connCreationConsumerObject);
                            continue block94;
                        }
                        case "login-timeout": {
                            this.loginTimeout.set(Integer.parseInt((String)poolPropertiesMap.get("login-timeout")));
                            continue block94;
                        }
                        case "seconds-to-trust-idle-connection": {
                            this.secondsToTrustIdleConnection.set(Integer.parseInt((String)poolPropertiesMap.get("seconds-to-trust-idle-connection")));
                            continue block94;
                        }
                        case "connection-repurpose-threshold": {
                            this.repurposeThreshold.set(Integer.parseInt((String)poolPropertiesMap.get("connection-repurpose-threshold")));
                            continue block94;
                        }
                        case "connection-factory-class-name": {
                            this.setConnectionFactoryClassName((String)poolPropertiesMap.get("connection-factory-class-name"));
                            continue block94;
                        }
                        case "connection-factory-property": {
                            this.setConnectionFactoryProperties((Properties)poolPropertiesMap.get("connection-factory-property"));
                            continue block94;
                        }
                        case "connection-property": {
                            this.setConnectionProperties((Properties)poolPropertiesMap.get("connection-property"));
                            continue block94;
                        }
                        case "is-xa-pool": {
                            continue block94;
                        }
                        case "max-connections-per-service": {
                            this.maxConnectionsPerService.set(Integer.parseInt((String)poolPropertiesMap.get("max-connections-per-service")));
                            continue block94;
                        }
                        case "max-connections-per-shard": {
                            this.maxConnectionsPerShard.set(Integer.parseInt((String)poolPropertiesMap.get("max-connections-per-shard")));
                            continue block94;
                        }
                        case "readonly-instance-allowed": {
                            this.readOnlyInstanceAllowed.set(Boolean.parseBoolean((String)poolPropertiesMap.get("readonly-instance-allowed")));
                            continue block94;
                        }
                        case "create-connection-in-borrow-thread": {
                            this.createConnectionInBorrowThread.set(Boolean.parseBoolean((String)poolPropertiesMap.get("create-connection-in-borrow-thread")));
                            continue block94;
                        }
                    }
                    throw new IllegalArgumentException("Invalid property name " + property);
                }
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("invalid property type set ");
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "applyPoolProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "applyPoolProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void reconfigureDataSource(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        try {
            String configPoolName;
            void configuration;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "reconfigureDataSource", "entering args ({0})", null, null, new PropertiesBlinder().blind(properties));
            if (configuration == null) {
                throw new IllegalArgumentException("Invalid datasource input configuration");
            }
            if (this.connectionPool == null && !this.isConfigureNewDS.get()) {
                UCPErrorHandler.throwSQLException(76, null);
            }
            if ((configPoolName = configuration.getProperty("connectionPoolName")) == null) {
                configPoolName = this.getConnectionPoolName();
            }
            try {
                boolean poolExists = Arrays.asList(this.getManager().getConnectionPoolNames()).contains(configPoolName);
                if (!poolExists) {
                    throw new UniversalConnectionPoolException("Invalid configuration attempt, pool " + configPoolName + " does not exist, datasource can be configured on existing pools only");
                }
                JDBCConnectionPool pool = (JDBCConnectionPool)this.getManager().getConnectionPool(configPoolName);
                if (this.connectionPool != null && !configPoolName.equals(this.getConnectionPoolName())) {
                    throw new UniversalConnectionPoolException("Invalid configuration input, Pool name " + configPoolName + " for the datasource in the configuration input does not match the actual pool name of the datasource which is " + this.getConnectionPoolName());
                }
                if (!pool.isShareable() && this.connectionPool == null) {
                    throw new UniversalConnectionPoolException("Pool  " + configPoolName + " is not shareable, hence cannot configure a new  datasource on it");
                }
                if (!pool.isLifecycleRunning()) {
                    throw new UniversalConnectionPoolException("Cannot confiure datasource as underlying pool : " + pool.getName() + " is not running");
                }
                for (Map.Entry<Object, Object> prop : configuration.entrySet()) {
                    String name;
                    switch (name = (String)prop.getKey()) {
                        case "connectionPoolName": {
                            this.connectionPoolName.set((String)prop.getValue());
                            break;
                        }
                        case "user": {
                            this.username = (String)prop.getValue();
                            break;
                        }
                        case "password": {
                            this.password = OpaqueString.newOpaqueString((String)prop.getValue());
                            break;
                        }
                        case "serviceName": {
                            this.serviceName = (String)prop.getValue();
                            break;
                        }
                        case "pdbRoles": {
                            Properties roles = (Properties)prop.getValue();
                            this.pdbRoles = new Properties();
                            if (roles == null) break;
                            this.pdbRoles.putAll((Map<?, ?>)roles);
                            break;
                        }
                        case "description": {
                            this.dataSourceDescription.internalSet((String)prop.getValue());
                        }
                    }
                }
                if (this.connectionPool == null) {
                    Map<String, Object> poolProperties = DatasourceConfigManager.getPoolConfigFromXML(this.getConnectionPoolName());
                    this.url = (String)poolProperties.get("url");
                    this.setConnectionFactoryClassName((String)poolProperties.get("connection-factory-class-name"));
                    Properties connectionFactoryProps = (Properties)poolProperties.get("connection-factory-property");
                    if (connectionFactoryProps != null && connectionFactoryProps.size() > 0) {
                        this.setConnectionFactoryProperties(connectionFactoryProps);
                    }
                    this.setConnectionProperties((Properties)poolProperties.get("connection-property"));
                    if (this.username == null) {
                        this.username = (String)poolProperties.get("user");
                    }
                    if (this.password == OpaqueString.NULL) {
                        this.password = (OpaqueString)poolProperties.get("password");
                    }
                    this.useExistingPool();
                }
                if (pool.isShareable()) {
                    this.disableAPI = true;
                }
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(72, e);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "reconfigureDataSource", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "reconfigureDataSource", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind
    @Debug(level=Debug.Level.FINEST)
    private OpaqueString getPasswordFromPoolElement(Map<? extends String, ? extends Object> map) {
        try {
            void propertiesMap;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromPoolElement", "entering args ({0})", null, null, map);
            if (propertiesMap.containsKey("wallet-file")) {
                String walletFile = (String)propertiesMap.get("wallet-file");
                OpaqueString walletFilePassword = OpaqueString.NULL;
                if (propertiesMap.containsKey("wallet-password")) {
                    walletFilePassword = (OpaqueString)propertiesMap.get("wallet-password");
                }
                if (null == this.url || "".equals(this.url)) {
                    throw new IllegalArgumentException("Invalid Arguments, url is required to access password from wallet");
                }
                OpaqueString passwordFromWallet = OpaqueString.NULL;
                try {
                    passwordFromWallet = this.getPasswordFromWallet(this.url, walletFile, walletFilePassword);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid Wallet location/Wrong Wallet password");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Exception while accessing Oracle Wallet", e);
                }
                OpaqueString opaqueString = passwordFromWallet;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromPoolElement", "returning {0}", null, null, opaqueString);
                return opaqueString;
            }
            if (propertiesMap.containsKey("password")) {
                OpaqueString opaqueString = (OpaqueString)propertiesMap.get("password");
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromPoolElement", "returning {0}", null, null, opaqueString);
                return opaqueString;
            }
            OpaqueString opaqueString = OpaqueString.NULL;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromPoolElement", "returning {0}", null, null, opaqueString);
            return opaqueString;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromPoolElement", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private OpaqueString getPasswordFromWallet(String string, String string2, OpaqueString opaqueString) throws Exception {
        try {
            String walletFileLocation;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromWallet", "entering args ({0}, {1}, {2})", null, null, string, string2, opaqueString);
            String user = null;
            OpaqueString password = OpaqueString.NULL;
            OracleWallet wallet = new OracleWallet();
            walletFileLocation = "file:" + walletFileLocation;
            if (wallet.exists(walletFileLocation)) {
                OracleSecretStore secretStore;
                void walletFilePassword;
                char[] walletPasswordInChars = null;
                if (walletFilePassword != OpaqueString.NULL) {
                    walletPasswordInChars = walletFilePassword.getChars();
                }
                wallet.open(walletFileLocation, walletPasswordInChars);
                if (walletPasswordInChars != null) {
                    Arrays.fill(walletPasswordInChars, '\u0000');
                }
                if ((secretStore = wallet.getSecretStore()).containsAlias(SECRET_STORE_DEFAULT_USERNAME)) {
                    user = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_USERNAME));
                }
                if (secretStore.containsAlias(SECRET_STORE_DEFAULT_PASSWORD)) {
                    password = OpaqueString.newOpaqueString(secretStore.getSecret(SECRET_STORE_DEFAULT_PASSWORD));
                }
                Enumeration list = wallet.getSecretStore().internalAliases();
                String alias = null;
                while (list.hasMoreElements()) {
                    void connectString;
                    alias = (String)list.nextElement();
                    if (!alias.contains(SECRET_STORE_CONNECT) || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                    String idx = alias.substring(SECRET_STORE_CONNECT.length());
                    user = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                    password = OpaqueString.newOpaqueString(secretStore.getSecret(SECRET_STORE_PASSWORD + idx));
                    break;
                }
            }
            OpaqueString opaqueString2 = password;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromWallet", "returning {0}", null, null, opaqueString2);
            return opaqueString2;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getPasswordFromWallet", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalConnectionPoolMBean createUniversalConnectionPoolMBean() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createUniversalConnectionPoolMBean", "entering args ()", null, null, new Object[0]);
            Objects.requireNonNull(this.connectionPool);
            UniversalConnectionPoolMBean universalConnectionPoolMBean = PoolMBeans.getOrCreateBean(this.connectionPool);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createUniversalConnectionPoolMBean", "returning {0}", null, null, universalConnectionPoolMBean);
            return universalConnectionPoolMBean;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createUniversalConnectionPoolMBean", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, null);
    }

    @Override
    public Connection getConnection(Properties labels) throws SQLException {
        return this.getConnection(null, null, labels);
    }

    @Override
    public Connection getConnection(String username, String password, Properties labels) throws SQLException {
        UCPConnectionBuilder cb = null;
        if (null != username) {
            cb = this.createConnectionBuilder();
            cb.user(username);
            if (null == this.getUser()) {
                this.setUser(username);
            }
        }
        if (null != password) {
            cb = null == cb ? this.createConnectionBuilder() : cb;
            cb.password(password);
            if (null == this.password) {
                this.setPassword(password);
            }
        }
        if (null != labels && !labels.isEmpty()) {
            cb = null == cb ? this.createConnectionBuilder() : cb;
            cb.labels(labels);
        } else if (!this.connectionLabelingCallbackRequestedLabels.isEmpty()) {
            UCPConnectionBuilder uCPConnectionBuilder = cb = null == cb ? this.createConnectionBuilder() : cb;
        }
        if (null != cb) {
            return cb.build();
        }
        CriStats criMetadata = this.defaultCriMetadata;
        if (null == criMetadata) {
            this.defaultCriMetadata = criMetadata = new JDBCConnectionRetrievalInfo(this).getCriMetadata();
        }
        return this.getConnection(new JDBCConnectionRetrievalInfo(this.thisPdsBorrowContext, new BorrowContextUpdater(), criMetadata));
    }

    private void addLabelsToBuilder(UCPConnectionBuilderImpl builder) {
        if (null == builder.getBorrowContextUpdater().getLabels() && !this.connectionLabelingCallbackRequestedLabels.isEmpty()) {
            builder.labels(this.connectionLabelingCallbackRequestedLabels);
        }
    }

    protected Connection getConnection(UCPConnectionBuilderImpl builder) throws SQLException {
        this.addLabelsToBuilder(builder);
        return this.getConnection(new JDBCConnectionRetrievalInfo(this.thisPdsBorrowContext, builder.getBorrowContextUpdater()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection getConnection(JDBCConnectionRetrievalInfo jcri) throws SQLException {
        BorrowContextUpdater bcu = jcri.getBorrowContextUpdater();
        boolean sameCredentials = Objects.equals(this.getUser(), bcu.getUser()) && Objects.equals(this.password, bcu.getPassword());
        this.startPool(jcri, sameCredentials);
        Connection conn = null;
        JDBCUniversalPooledConnection jdbcPooledConnection = null;
        jdbcPooledConnection = (JDBCUniversalPooledConnection)this.connectionPool.borrowConnection(jcri);
        conn = this.connectionPool.getProxyFactory().proxyForConnection(Objects.requireNonNull(this.connectionPool), jdbcPooledConnection);
        if (this.acActive == null) {
            this.acActive = jdbcPooledConnection.getPhysicalConnection().getClass().getName().indexOf(AC_PROXY_CLASS_NAME_KEYWORD) >= 0;
        }
        if (this.acActive.booleanValue()) {
            ReplayableConnection rconn = (ReplayableConnection)jdbcPooledConnection.getPhysicalConnection();
            BorrowContextUpdater updater = jcri.getBorrowContextUpdater();
            rconn.setProxyObject((Object)conn, (OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)rconn.getConnectionBuilder().serviceName(updater.getServiceName())).shardingKey(updater.getShardingKey())).superShardingKey(updater.getSuperShardingKey()));
        }
        if (conn != null || jdbcPooledConnection == null) return conn;
        try {
            this.connectionPool.returnConnection(jdbcPooledConnection);
            return conn;
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.FINE, CLASS_NAME, "getConnection", "returnConnection() failed for {0}", null, null, jdbcPooledConnection);
            this.trace(Level.WARNING, CLASS_NAME, "getConnection", "", null, e, new Object[0]);
        }
        return conn;
        catch (NoAvailableConnectionsException e) {
            UCPErrorHandler.throwSQLException(28, e);
            if (conn != null || jdbcPooledConnection == null) return conn;
            try {
                this.connectionPool.returnConnection(jdbcPooledConnection);
                return conn;
            }
            catch (UniversalConnectionPoolException e2) {
                this.trace(Level.FINE, CLASS_NAME, "getConnection", "returnConnection() failed for {0}", null, null, jdbcPooledConnection);
                this.trace(Level.WARNING, CLASS_NAME, "getConnection", "", null, e2, new Object[0]);
            }
            return conn;
        }
        catch (UniversalConnectionPoolException e2) {
            UCPErrorHandler.throwSQLException(29, e2);
            if (conn != null || jdbcPooledConnection == null) return conn;
            {
                catch (Throwable throwable) {
                    if (conn != null || jdbcPooledConnection == null) throw throwable;
                    try {
                        this.connectionPool.returnConnection(jdbcPooledConnection);
                        throw throwable;
                    }
                    catch (UniversalConnectionPoolException e3) {
                        this.trace(Level.FINE, CLASS_NAME, "getConnection", "returnConnection() failed for {0}", null, null, jdbcPooledConnection);
                        this.trace(Level.WARNING, CLASS_NAME, "getConnection", "", null, e3, new Object[0]);
                    }
                    throw throwable;
                }
            }
            try {
                this.connectionPool.returnConnection(jdbcPooledConnection);
                return conn;
            }
            catch (UniversalConnectionPoolException e4) {
                this.trace(Level.FINE, CLASS_NAME, "getConnection", "returnConnection() failed for {0}", null, null, jdbcPooledConnection);
                this.trace(Level.WARNING, CLASS_NAME, "getConnection", "", null, e4, new Object[0]);
            }
            return conn;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        JDBCConnectionPool pool = this.connectionPool;
        if (null == pool) {
            UCPErrorHandler.throwSQLException(30, null);
        }
        return pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        JDBCConnectionPool pool = this.connectionPool;
        if (null == pool) {
            UCPErrorHandler.throwSQLException(30, null);
        }
        pool.setLogWriter(logWriter);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout.set(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout.get();
    }

    @Override
    public String getUser() {
        return this.username;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setUser(String string) throws SQLException {
        try {
            void username;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setUser", "entering args ({0})", null, null, string);
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setUser", "returning void", null, null, new Object[0]);
                return;
            }
            if (this.poolCreated.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "user", username, true, true);
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "userName", username, true, true);
                    ConnectionRetrievalInfo poolDefaultCri = this.connectionPool.getConnectionRetrievalInfo();
                    if (poolDefaultCri instanceof JDBCConnectionRetrievalInfo) {
                        JDBCConnectionRetrievalInfo jcri = (JDBCConnectionRetrievalInfo)poolDefaultCri;
                        if (username != null && !username.equals(jcri.getUser())) {
                            this.defaultCriMetadata = null;
                        }
                    }
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(24, e);
                }
            }
            this.username = username;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setUser", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setUser", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Blind
    final String getPasswordReal() {
        return this.password.get();
    }

    OpaqueString getPasswordInternal() {
        return this.password;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setPassword(@Blind String string) throws SQLException {
        try {
            void password;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPassword", "entering args ({0})", null, null, new StringBlinder().blind(string));
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPassword", "returning void", null, null, new Object[0]);
                return;
            }
            if (this.poolCreated.get()) {
                try {
                    JDBCConnectionRetrievalInfo jcri;
                    assert (this.connectionFactory != null);
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "password", password, true, true);
                    ConnectionRetrievalInfo poolDefaultCri = this.connectionPool.getConnectionRetrievalInfo();
                    if (poolDefaultCri instanceof JDBCConnectionRetrievalInfo && !(jcri = (JDBCConnectionRetrievalInfo)poolDefaultCri).getPassword().equals(OpaqueString.newOpaqueString((String)password))) {
                        this.defaultCriMetadata = null;
                    }
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(25, e);
                }
            }
            this.password = OpaqueString.newOpaqueString((String)password);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPassword", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPassword", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setURL(String string) throws SQLException {
        try {
            void url;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURL", "entering args ({0})", null, null, string);
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURL", "returning void", null, null, new Object[0]);
                return;
            }
            if (this.poolCreated.get()) {
                try {
                    this.setURLProperties((String)url);
                    try {
                        this.connectionPool.stop();
                        this.connectionPool.start();
                    }
                    catch (Exception e) {
                        this.setURLProperties(this.url);
                        this.connectionPool.stop();
                        this.connectionPool.start();
                        UCPErrorHandler.throwSQLException(22, e);
                    }
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(26, e);
                }
            }
            this.url = url;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURL", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURL", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setServerName(String string) throws SQLException {
        try {
            void serverName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServerName", "entering args ({0})", null, null, string);
            if (this.poolCreated.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "serverName", serverName, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(49, e);
                }
            }
            this.serverName = serverName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServerName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServerName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setPortNumber(int n) throws SQLException {
        try {
            void portNumber;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPortNumber", "entering args ({0})", null, null, n);
            if (this.poolCreated.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "portNumber", (int)portNumber, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(50, e);
                }
            }
            this.portNumber = portNumber;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPortNumber", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPortNumber", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setDatabaseName(String string) throws SQLException {
        try {
            void databaseName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDatabaseName", "entering args ({0})", null, null, string);
            if (this.poolCreated.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "databaseName", databaseName, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(51, e);
                }
            }
            this.databaseName = databaseName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDatabaseName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDatabaseName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setDataSourceName(String string) throws SQLException {
        try {
            void dataSourceName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDataSourceName", "entering args ({0})", null, null, string);
            this.dataSourceName.set((String)dataSourceName);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDataSourceName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDataSourceName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setDescription(String string) throws SQLException {
        try {
            void dataSourceDescription;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDescription", "entering args ({0})", null, null, string);
            this.dataSourceDescription.set((String)dataSourceDescription);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDescription", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setDescription", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getDescription() {
        return this.dataSourceDescription.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setNetworkProtocol(String string) throws SQLException {
        try {
            void networkProtocol;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setNetworkProtocol", "entering args ({0})", null, null, string);
            this.networkProtocol.set((String)networkProtocol);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setNetworkProtocol", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setNetworkProtocol", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getNetworkProtocol() {
        return this.networkProtocol.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setRoleName(String string) throws SQLException {
        try {
            void roleName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setRoleName", "entering args ({0})", null, null, string);
            if (this.poolCreated.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "roleName", roleName, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(55, e);
                }
            }
            this.roleName = roleName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setRoleName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setRoleName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setInitialPoolSize(int n) throws SQLException {
        try {
            void initialPoolSize;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setInitialPoolSize", "entering args ({0})", null, null, n);
            this.initialPoolSize.set((int)initialPoolSize);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setInitialPoolSize", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setInitialPoolSize", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getInitialPoolSize() {
        return this.initialPoolSize.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMinPoolSize(int n) throws SQLException {
        try {
            void minPoolSize;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMinPoolSize", "entering args ({0})", null, null, n);
            this.minPoolSize.set((int)minPoolSize);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMinPoolSize", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMinPoolSize", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMinIdle(int n) throws SQLException {
        try {
            void minIdle;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMinIdle", "entering args ({0})", null, null, n);
            this.minIdle.set((int)minIdle);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMinIdle", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMinIdle", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMinIdle() {
        return this.minIdle.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMaxPoolSize(int n) throws SQLException {
        try {
            void maxPoolSize;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxPoolSize", "entering args ({0})", null, null, n);
            this.maxPoolSize.set((int)maxPoolSize);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxPoolSize", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxPoolSize", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize.get();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void setMaxConnectionsPerService(int n) throws SQLException {
        try {
            void maxPerService;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionsPerService", "entering args ({0})", null, null, n);
            this.maxConnectionsPerService.set((int)maxPerService);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionsPerService", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionsPerService", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMaxConnectionsPerService() {
        return this.maxConnectionsPerService.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setInactiveConnectionTimeout(int n) throws SQLException {
        try {
            void inactivityTimeout;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setInactiveConnectionTimeout", "entering args ({0})", null, null, n);
            this.inactiveConnectionTimeout.set((int)inactivityTimeout);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setInactiveConnectionTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setInactiveConnectionTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.inactiveConnectionTimeout.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionWaitTimeout(int n) throws SQLException {
        try {
            void waitTimeout;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionWaitTimeout", "entering args ({0})", null, null, n);
            this.connectionWaitDurationInMillis.set(Duration.ofSeconds((long)waitTimeout).toMillis());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionWaitTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionWaitTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public int getConnectionWaitTimeout() {
        return Math.toIntExact(Duration.ofMillis(this.connectionWaitDurationInMillis.get()).getSeconds());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionWaitDuration(Duration duration) throws SQLException {
        try {
            void duration2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionWaitDuration", "entering args ({0})", null, null, duration);
            this.connectionWaitDurationInMillis.set(duration2.toMillis());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionWaitDuration", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionWaitDuration", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Duration getConnectionWaitDuration() {
        return Duration.ofMillis(this.connectionWaitDurationInMillis.get());
    }

    public void setConnectionWaitDurationInMillis(long duration) throws SQLException {
        this.connectionWaitDurationInMillis.set(duration);
    }

    public long getConnectionWaitDurationInMillis() {
        return this.connectionWaitDurationInMillis.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setTimeToLiveConnectionTimeout(int n) throws SQLException {
        try {
            void timeToLiveConnectionTimeout;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTimeToLiveConnectionTimeout", "entering args ({0})", null, null, n);
            this.timeToLiveConnectionTimeout.set((int)timeToLiveConnectionTimeout);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTimeToLiveConnectionTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTimeToLiveConnectionTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.timeToLiveConnectionTimeout.get();
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.abandonedConnectionTimeout.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setAbandonedConnectionTimeout(int n) throws SQLException {
        try {
            void abandonedConnectionTimeout;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setAbandonedConnectionTimeout", "entering args ({0})", null, null, n);
            this.abandonedConnectionTimeout.set((int)abandonedConnectionTimeout);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setAbandonedConnectionTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setAbandonedConnectionTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setTimeoutCheckInterval(int n) throws SQLException {
        try {
            void timeInterval;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTimeoutCheckInterval", "entering args ({0})", null, null, n);
            this.timeoutCheckInterval.set((int)timeInterval);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTimeoutCheckInterval", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTimeoutCheckInterval", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.timeoutCheckInterval.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        try {
            void failoverEnabled;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setFastConnectionFailoverEnabled", "entering args ({0})", null, null, bl);
            this.fastConnectionFailoverEnabled.set((boolean)failoverEnabled);
            this.fcfExplicitlySet.set(true);
            this.trace(Level.FINE, CLASS_NAME, "setFastConnectionFailoverEnabled", "explicitly set FCF-Enabled={0}", null, null, (boolean)failoverEnabled);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setFastConnectionFailoverEnabled", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setFastConnectionFailoverEnabled", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean getFastConnectionFailoverEnabled() {
        return this.fastConnectionFailoverEnabled.get();
    }

    @Override
    public String getConnectionFactoryClassName() {
        this.connectionFactoryClassNameLock.lock();
        try {
            String string = this.connectionFactoryClassName;
            return string;
        }
        finally {
            this.connectionFactoryClassNameLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionFactoryClassName(String string) throws SQLException {
        try {
            void factoryClassName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryClassName", "entering args ({0})", null, null, string);
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryClassName", "returning void", null, null, new Object[0]);
                return;
            }
            if (factoryClassName == null) {
                UCPErrorHandler.throwSQLException(22, null);
            }
            this.connectionFactoryClassNameLock.lock();
            try {
                this.connectionFactoryClassName = factoryClassName;
            }
            finally {
                this.connectionFactoryClassNameLock.unlock();
            }
            if (this.connectionPoolFactoryClassNameWasSet.compareAndSet(false, true) && this.poolCreated.get()) {
                try {
                    this.connectionPool.refresh();
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwSQLException(22, e);
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryClassName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryClassName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMaxStatements(int n) throws SQLException {
        try {
            void maxStatements;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxStatements", "entering args ({0})", null, null, n);
            this.maxStatements.set((int)maxStatements);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxStatements", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxStatements", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMaxStatements() {
        return this.maxStatements.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMaxIdleTime(int n) throws SQLException {
        try {
            void idleTime;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxIdleTime", "entering args ({0})", null, null, n);
            this.setInactiveConnectionTimeout((int)idleTime);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxIdleTime", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxIdleTime", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMaxIdleTime() {
        return this.getInactiveConnectionTimeout();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setPropertyCycle(int n) throws SQLException {
        try {
            void propertyCycle;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPropertyCycle", "entering args ({0})", null, null, n);
            this.setTimeoutCheckInterval((int)propertyCycle);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPropertyCycle", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPropertyCycle", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getPropertyCycle() {
        return this.getTimeoutCheckInterval();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionPoolName(String string) throws SQLException {
        try {
            void connectionPoolName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionPoolName", "entering args ({0})", null, null, string);
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionPoolName", "returning void", null, null, new Object[0]);
                return;
            }
            if (!Strings.isNullOrEmpty((String)connectionPoolName)) {
                Diagnosable diagnosable = this.getDiagnosable();
                if (diagnosable instanceof DiagnosticsCollectorImpl) {
                    DiagnosticsCollectorImpl collector = (DiagnosticsCollectorImpl)diagnosable;
                    Objects.requireNonNull(collector).setLoggerName((String)connectionPoolName);
                }
                if (this.poolCreated.get()) {
                    try {
                        UniversalConnectionPoolManagerHelper umh = new UniversalConnectionPoolManagerHelper(this.connectionPool);
                        umh.setManagerPoolID((String)connectionPoolName);
                    }
                    catch (UniversalConnectionPoolException e) {
                        UCPErrorHandler.throwSQLException(45, e);
                    }
                    this.connectionPool.setName((String)connectionPoolName);
                }
            }
            this.connectionPoolName.set((String)connectionPoolName);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionPoolName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionPoolName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getConnectionPoolName() {
        return this.poolCreated.get() ? this.connectionPool.getName() : this.connectionPoolName.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setValidateConnectionOnBorrow(boolean bl) throws SQLException {
        try {
            void validateConnectionOnBorrow;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setValidateConnectionOnBorrow", "entering args ({0})", null, null, bl);
            this.validateConnectionOnBorrow.set((boolean)validateConnectionOnBorrow);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setValidateConnectionOnBorrow", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setValidateConnectionOnBorrow", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.validateConnectionOnBorrow.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setSQLForValidateConnection(String string) throws SQLException {
        try {
            void SQLString;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSQLForValidateConnection", "entering args ({0})", null, null, string);
            if (SQLString != null && SQLString.equals("")) {
                UCPErrorHandler.throwSQLException(22, null);
            }
            this.sqlForValidateConnection.set((String)SQLString);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSQLForValidateConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSQLForValidateConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getSQLForValidateConnection() {
        return this.sqlForValidateConnection.get();
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.connectionHarvestTriggerCount.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionHarvestTriggerCount(int n) throws SQLException {
        try {
            void connectionHarvestTriggerCount;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionHarvestTriggerCount", "entering args ({0})", null, null, n);
            this.connectionHarvestTriggerCount.set((int)connectionHarvestTriggerCount);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionHarvestTriggerCount", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionHarvestTriggerCount", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.connectionHarvestMaxCount.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionHarvestMaxCount(int n) throws SQLException {
        try {
            void connectionHarvestMaxCount;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionHarvestMaxCount", "entering args ({0})", null, null, n);
            this.connectionHarvestMaxCount.set((int)connectionHarvestMaxCount);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionHarvestMaxCount", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionHarvestMaxCount", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.maxConnectionReuseTime.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMaxConnectionReuseTime(long l) throws SQLException {
        try {
            void maxConnectionReuseTime;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionReuseTime", "entering args ({0})", null, null, l);
            this.maxConnectionReuseTime.set((long)maxConnectionReuseTime);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionReuseTime", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionReuseTime", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.maxConnectionReuseCount.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMaxConnectionReuseCount(int n) throws SQLException {
        try {
            void maxConnectionReuseCount;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionReuseCount", "entering args ({0})", null, null, n);
            this.maxConnectionReuseCount.set((int)maxConnectionReuseCount);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionReuseCount", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionReuseCount", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getAvailableConnectionsCount() {
        if (this.connectionPool == null) {
            return 0;
        }
        return this.connectionPool.getAvailableConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        if (this.connectionPool == null) {
            return 0;
        }
        return this.connectionPool.getBorrowedConnectionsCount();
    }

    @Override
    public String getONSConfiguration() {
        if (this.poolCreated.get()) {
            return this.connectionPool.getONSConfiguration();
        }
        return this.onsConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setONSConfiguration(String string) {
        try {
            void onsConfigStr;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setONSConfiguration", "entering args ({0})", null, null, string);
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setONSConfiguration", "returning void", null, null, new Object[0]);
                return;
            }
            this.trace(Level.FINE, CLASS_NAME, "setONSConfiguration", "onsConfigStr: {0}", null, null, Util.maskONSConfigurationString((String)onsConfigStr));
            if (this.poolCreated.get()) {
                this.connectionPool.setONSConfiguration((String)onsConfigStr);
            }
            this.onsConfiguration = onsConfigStr;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setONSConfiguration", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setONSConfiguration", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerConnectionLabelingCallback(oracle.ucp.ConnectionLabelingCallback connectionLabelingCallback) throws SQLException {
        try {
            void cbk;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionLabelingCallback", "entering args ({0})", null, null, connectionLabelingCallback);
            if (cbk == null) {
                throw new IllegalArgumentException("callback has to be non-null");
            }
            this.connectionLabelingCallback.set((oracle.ucp.ConnectionLabelingCallback)cbk);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionLabelingCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionLabelingCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void removeConnectionLabelingCallback() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "removeConnectionLabelingCallback", "entering args ()", null, null, new Object[0]);
            this.connectionLabelingCallback.set(null);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "removeConnectionLabelingCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "removeConnectionLabelingCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback connectionAffinityCallback) throws SQLException {
        try {
            void cbk;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionAffinityCallback", "entering args ({0})", null, null, connectionAffinityCallback);
            if (cbk == null) {
                throw new IllegalArgumentException("callback has to be non-null");
            }
            this.connectionAffinityCallback.set((ConnectionAffinityCallback)cbk);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionAffinityCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionAffinityCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void removeConnectionAffinityCallback() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "removeConnectionAffinityCallback", "entering args ()", null, null, new Object[0]);
            this.connectionAffinityCallback.set(null);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "removeConnectionAffinityCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "removeConnectionAffinityCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public JDBCConnectionPoolStatistics getStatistics() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getStatistics", "entering args ()", null, null, new Object[0]);
            JDBCConnectionPool cp = this.connectionPool;
            if (cp == null) {
                JDBCConnectionPoolStatistics jDBCConnectionPoolStatistics = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getStatistics", "returning {0}", null, null, jDBCConnectionPoolStatistics);
                return jDBCConnectionPoolStatistics;
            }
            if (cp instanceof OracleJDBCConnectionPool) {
                OracleJDBCConnectionPoolStatisticsImpl oracleJDBCConnectionPoolStatisticsImpl = new OracleJDBCConnectionPoolStatisticsImpl((OracleJDBCConnectionPool)this.connectionPool);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getStatistics", "returning {0}", null, null, oracleJDBCConnectionPoolStatisticsImpl);
                return oracleJDBCConnectionPoolStatisticsImpl;
            }
            JDBCConnectionPoolStatisticsImpl jDBCConnectionPoolStatisticsImpl = new JDBCConnectionPoolStatisticsImpl(cp);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getStatistics", "returning {0}", null, null, jDBCConnectionPoolStatisticsImpl);
            return jDBCConnectionPoolStatisticsImpl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "getStatistics", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    void setServiceName(String string) {
        try {
            void serviceName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServiceName", "entering args ({0})", null, null, string);
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServiceName", "returning void", null, null, new Object[0]);
                return;
            }
            this.serviceName = null != serviceName ? serviceName.toLowerCase() : null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServiceName", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setServiceName", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getConnectionProperties() {
        Properties filteredProperties = (Properties)this.connectionProperties.clone();
        filteredProperties.entrySet().removeIf(entry -> entry.getKey() instanceof String && PoolDataSourceImpl.isSensitiveProperty((String)entry.getKey()));
        return filteredProperties;
    }

    @Override
    public String getConnectionProperty(String propertyName) {
        return PoolDataSourceImpl.isSensitiveProperty(propertyName) ? null : this.connectionProperties.getProperty(propertyName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionProperty(String string, String string2) throws SQLException {
        try {
            void name;
            void value;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperty", "entering args ({0}, {1})", null, null, string, string2);
            if (value == null || value.equals("")) {
                throw new IllegalArgumentException();
            }
            Properties connProps = new Properties();
            connProps.setProperty((String)name, (String)value);
            this.setConnectionProperties(connProps);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperty", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperty", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        try {
            void connectionProperties;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperties", "entering args ({0})", null, null, new PropertiesBlinder().blind(properties));
            boolean doRefresh = false;
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperties", "returning void", null, null, new Object[0]);
                return;
            }
            if (connectionProperties == null || connectionProperties.size() == 0) {
                this.connectionProperties.clear();
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperties", "returning void", null, null, new Object[0]);
                return;
            }
            for (Map.Entry<Object, Object> prop : connectionProperties.entrySet()) {
                String key = (String)prop.getKey();
                if (null != this.connectionProperties.getProperty(key) && PoolDataSourceImpl.isSetOnceProperty(key)) {
                    doRefresh = true;
                }
                this.connectionProperties.put(key, prop.getValue());
            }
            if (this.poolCreated.get()) {
                if (this.connectionFactoryClassName != null) {
                    try {
                        PoolDataSourceImpl.setProperty(this.connectionFactory, "connectionProperties", this.connectionProperties, true, true);
                    }
                    catch (Exception e) {
                        UCPErrorHandler.throwSQLException(48, e);
                    }
                }
                if (doRefresh) {
                    this.refreshConnectionPool();
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void refreshConnectionPool() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "refreshConnectionPool", "entering args ()", null, null, new Object[0]);
            assert (this.poolCreated.get()) : "poolCreated is false";
            try {
                this.connectionPool.refresh();
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "refreshConnectionPool", "", null, e, new Object[0]);
                try {
                    this.connectionPool.stop();
                    this.connectionPool.start();
                }
                catch (UniversalConnectionPoolException ex) {
                    UCPErrorHandler.throwSQLException(22, ex);
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "refreshConnectionPool", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "refreshConnectionPool", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    @Override
    public String getConnectionFactoryProperty(String propertyName) {
        return this.connectionFactoryProperties.getProperty(propertyName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionFactoryProperty(String string, String string2) throws SQLException {
        try {
            void name;
            void value;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperty", "entering args ({0}, {1})", null, null, string, string2);
            if (value == null || value.equals("")) {
                throw new IllegalArgumentException();
            }
            Properties connFactoryProps = new Properties();
            connFactoryProps.setProperty((String)name, (String)value);
            this.setConnectionFactoryProperties(connFactoryProps);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperty", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperty", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionFactoryProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        try {
            void factoryProperties;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperties", "entering args ({0})", null, null, new PropertiesBlinder().blind(properties));
            boolean doRefresh = false;
            if (!this.allowSetter()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperties", "returning void", null, null, new Object[0]);
                return;
            }
            if (factoryProperties.size() <= 0) {
                throw new IllegalArgumentException();
            }
            for (Map.Entry<Object, Object> prop : factoryProperties.entrySet()) {
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (null != this.connectionFactoryProperties.getProperty(key) && PoolDataSourceImpl.isSetOnceProperty(key)) {
                    doRefresh = true;
                }
                if (this.poolCreated.get() && !this.isDriverFactory) {
                    try {
                        PoolDataSourceImpl.setProperty(this.connectionFactory, key, value, true, false);
                    }
                    catch (Exception e) {
                        UCPErrorHandler.throwSQLException(59, e);
                    }
                }
                this.connectionFactoryProperties.setProperty(key, value);
            }
            if (this.username == null || this.username.equals("")) {
                this.username = this.connectionFactoryProperties.getProperty("user");
                if (this.username == null || this.username.equals("")) {
                    this.username = this.connectionFactoryProperties.getProperty("username");
                }
            }
            if (this.password == OpaqueString.NULL || this.password == OpaqueString.EMPTY) {
                this.password = OpaqueString.newOpaqueString(this.connectionFactoryProperties.getProperty("password"));
            }
            if (this.url == null || this.url.equals("")) {
                this.url = this.connectionFactoryProperties.getProperty("url");
            }
            if (this.poolCreated.get() && doRefresh) {
                try {
                    this.connectionPool.refresh();
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwSQLException(22, e);
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionFactoryProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public static boolean isSetOnceProperty(String key) {
        for (String authKey : new String[]{"oracle.net.wallet_location", "oracle.net.wallet_password", "oracle.net.ssl_version", "oracle.net.ssl_cipher_suites", "oracle.net.ssl_server_dn_match", "oracle.net.authentication_services", "oracle.net.kerberos5_mutual_authentication", "oracle.net.kerberos5_cc_name", "oracle.net.encryption_client", "oracle.net.encryption_types_client", "oracle.net.crypto_checksum_client", "oracle.net.crypto_checksum_types_client", "javax.net.ssl.keyStore", "javax.net.ssl.keyStoreType", "javax.net.ssl.keyStorePassword", "javax.net.ssl.trustStore", "javax.net.ssl.trustStoreType", "javax.net.ssl.trustStorePassword", "oracle.jdbc.tokenAuthentication", "oracle.jdbc.tokenLocation", "oracle.jdbc.passwordAuthentication", "oracle.jdbc.ociIamUrl", "oracle.jdbc.ociTenancy", "oracle.jdbc.ociCompartment", "oracle.jdbc.ociDatabase", "oracle.jdbc.accessToken"}) {
            if (!authKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Debug(level=Debug.Level.FINEST)
    private void initConnectionFactory() throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "initConnectionFactory", "entering args ()", null, null, new Object[0]);
            String className = this.getClass().getName();
            this.connectionFactoryClassNameLock.lock();
            try {
                this.connectionFactory = Util.getClassForName(this.connectionFactoryClassName, true, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.isDriverFactory = this.connectionFactory instanceof Driver;
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "factory class created", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(23, e);
            }
            finally {
                this.connectionFactoryClassNameLock.unlock();
            }
            try {
                int lt = this.getLoginTimeout();
                PoolDataSourceImpl.setProperty(this.connectionFactory, "loginTimeout", lt, true, true);
                if (this.isDriverFactory) {
                    String key = "oracle.jdbc.loginTimeout";
                    String value = Integer.toString(lt);
                    this.connectionFactoryProperties.setProperty("oracle.jdbc.loginTimeout", value);
                }
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(69, e);
            }
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "user", this.username, true, true);
                PoolDataSourceImpl.setProperty(this.connectionFactory, "userName", this.username, true, true);
                if (this.isDriverFactory && this.username != null && !this.username.equals("")) {
                    this.connectionFactoryProperties.setProperty("user", this.username);
                }
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "user is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(24, e);
            }
            try {
                String password = this.password.get();
                PoolDataSourceImpl.setProperty(this.connectionFactory, "password", password, true, true);
                if (this.isDriverFactory && password != null && !password.equals("")) {
                    this.connectionFactoryProperties.setProperty("password", password);
                }
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "password is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(25, e);
            }
            try {
                this.setURLProperties(this.url);
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "URL is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(26, e);
            }
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "serverName", this.serverName, true, true);
                if (this.isDriverFactory && this.serverName != null && !this.serverName.equals("")) {
                    this.connectionFactoryProperties.setProperty("serverName", this.serverName);
                }
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "Database Server Name is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(49, e);
            }
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "portNumber", this.portNumber, true, true);
                if (this.isDriverFactory && this.portNumber != 0) {
                    this.connectionFactoryProperties.setProperty("portNumber", "" + this.portNumber);
                }
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "Port Number is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(50, e);
            }
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "databaseName", this.databaseName, true, true);
                if (this.isDriverFactory && this.databaseName != null && !this.databaseName.equals("")) {
                    this.connectionFactoryProperties.setProperty("databaseName", this.databaseName);
                }
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "Database name is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(51, e);
            }
            this.dataSourceName.set();
            this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "DataSource name is set", null, null, new Object[0]);
            this.dataSourceDescription.set();
            this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "DataSource description is set", null, null, new Object[0]);
            this.networkProtocolLock.lock();
            try {
                this.networkProtocol.set();
                if (this.isDriverFactory && this.networkProtocol.get() != null && !this.networkProtocol.get().equals("")) {
                    try {
                        this.connectionFactoryProperties.setProperty("networkProtocol", this.networkProtocol.get());
                    }
                    catch (Exception e) {
                        UCPErrorHandler.throwSQLException(54, e);
                    }
                }
            }
            finally {
                this.networkProtocolLock.unlock();
            }
            this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "DataSource network protocol is set", null, null, new Object[0]);
            try {
                PoolDataSourceImpl.setProperty(this.connectionFactory, "roleName", this.roleName, true, true);
                if (this.isDriverFactory && this.roleName != null && !this.roleName.equals("")) {
                    this.connectionFactoryProperties.setProperty("roleName", this.roleName);
                }
                this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "DataSource role name is set", null, null, new Object[0]);
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(55, e);
            }
            if (this.tokenSupplier != null) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "tokenSupplier", this.tokenSupplier, true, false);
                    this.trace(Level.FINEST, CLASS_NAME, "initConnectionFactory", "Token supplier is set", null, null, new Object[0]);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(81, e);
                }
            }
            if (!this.isDriverFactory && this.connectionFactoryProperties.size() > 0) {
                for (Map.Entry<Object, Object> prop : this.connectionFactoryProperties.entrySet()) {
                    try {
                        PoolDataSourceImpl.setProperty(this.connectionFactory, (String)prop.getKey(), (String)prop.getValue(), true, false);
                    }
                    catch (Exception e) {
                        UCPErrorHandler.throwSQLException(59, e);
                    }
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "initConnectionFactory", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "initConnectionFactory", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private static void setProperty(Object object, String name, Object value, boolean caseSensitive, boolean lenient) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        Object loggedValue = "password".equalsIgnoreCase(name) ? "*****" : value;
        Class<?> type = object.getClass();
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getWriteMethod() == null) continue;
            if (caseSensitive && descriptors[i].getName().equals(name) || !caseSensitive && descriptors[i].getName().equalsIgnoreCase(name)) {
                Method method = descriptors[i].getWriteMethod();
                Class<?> paramType = method.getParameterTypes()[0];
                if (value instanceof String) {
                    value = PoolDataSourceImpl.toBasicType(value.toString(), paramType.getName());
                }
                method.invoke(object, value);
                return;
            }
            names.add(descriptors[i].getName());
        }
        if (!lenient) {
            throw new IllegalArgumentException("No such property: " + name + ", existing writable properties are: " + names);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void setSpecialProperty(String string, String string2) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        try {
            void url;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSpecialProperty", "entering args ({0}, {1})", null, null, string, string2);
            if (url == null) {
                throw new NullPointerException("no url");
            }
            StringTokenizer tokens = new StringTokenizer((String)url, ";");
            while (tokens.hasMoreTokens()) {
                void propertyName;
                String currToken = tokens.nextToken();
                if (!currToken.startsWith((String)propertyName + "=")) continue;
                PoolDataSourceImpl.setProperty(this.connectionFactory, (String)propertyName, currToken.substring(currToken.indexOf("=") + 1), true, true);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSpecialProperty", "returning void", null, null, new Object[0]);
                return;
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSpecialProperty", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSpecialProperty", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void setURLProperties(String string) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        try {
            void url;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURLProperties", "entering args ({0})", null, null, string);
            if (Objects.isNull(url) || "".equals(url)) {
                throw new IllegalArgumentException("attempt to set an empty or null database URL in a connection factory");
            }
            PoolDataSourceImpl.setProperty(this.connectionFactory, "url", url, true, true);
            PoolDataSourceImpl.setProperty(this.connectionFactory, "URL", url, true, true);
            if (this.connectionFactoryClassName != null && this.connectionFactoryClassName.endsWith("ias.jdbcx.informix.InformixDataSource")) {
                this.setSpecialProperty("informixServer", (String)url);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURLProperties", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setURLProperties", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public static Object toBasicType(String value, String type) {
        Object retVal = null;
        String eMsg = null;
        try {
            if (value == null) {
                retVal = null;
            } else if (type == null || type.equals("java.lang.String")) {
                retVal = value;
            } else if (type.equals("java.lang.Character") || type.equals("char")) {
                if (value.length() == 1) {
                    retVal = new Character(value.charAt(0));
                } else {
                    eMsg = "Invalid Character value";
                }
            } else if (type.equals("java.lang.Integer") || type.equals("int")) {
                retVal = Integer.valueOf(value);
            } else if (type.equals("java.lang.Float") || type.equals("float")) {
                retVal = Float.valueOf(value);
            } else if (type.equals("java.lang.Long") || type.equals("long")) {
                retVal = Long.valueOf(value);
            } else if (type.equals("java.lang.Double") || type.equals("double")) {
                retVal = Double.valueOf(value);
            } else if (type.equals("java.lang.Byte") || type.equals("byte")) {
                retVal = Byte.valueOf(value);
            } else if (type.equals("java.lang.Short") || type.equals("short")) {
                retVal = Short.valueOf(value);
            } else if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
                retVal = Boolean.valueOf(value);
            } else {
                eMsg = "Invalid attribute type" + type;
            }
        }
        catch (NumberFormatException e) {
            eMsg = "Invalid " + type + " value";
        }
        if (null != eMsg) {
            throw new IllegalArgumentException(eMsg);
        }
        return retVal;
    }

    @Override
    public Reference getReference() {
        Reference ref = new Reference(this.getClass().getName(), "oracle.ucp.jdbc.PoolDataSourceImpl", null);
        if (this.username != null) {
            ref.add(new StringRefAddr("user", this.username));
        }
        if (this.password != OpaqueString.NULL) {
            ref.add(new StringRefAddr("password", this.password.get()));
        }
        if (this.serviceName != null) {
            ref.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.url != null) {
            ref.add(new StringRefAddr("url", this.url));
        }
        if (this.serverName != null) {
            ref.add(new StringRefAddr("serverName", this.serverName));
        }
        ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        if (this.databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName.get() != null) {
            ref.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
        }
        if (this.dataSourceDescription.get() != null) {
            ref.add(new StringRefAddr("description", this.dataSourceDescription.toString()));
        }
        if (this.networkProtocol.get() != null) {
            ref.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
        }
        if (this.roleName != null) {
            ref.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.connectionFactoryClassName != null) {
            ref.add(new StringRefAddr("connectionFactoryClassName", this.connectionFactoryClassName));
        }
        if (this.connectionProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
        }
        if (this.pdbRoles != null && this.pdbRoles.size() > 0) {
            ref.add(new StringRefAddr("pdbRoles", this.pdbRoles.toString()));
        }
        if (this.connectionFactoryProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionFactoryProperties", this.connectionFactoryProperties.toString()));
        }
        if (this.validateConnectionOnBorrow.get().booleanValue()) {
            ref.add(new StringRefAddr("validateConnectionOnBorrow", "true"));
        }
        this.sqlForValidateConnectionLock.lock();
        try {
            String str = this.sqlForValidateConnection.get();
            if (str != null) {
                ref.add(new StringRefAddr("sqlForValidateConnection", str));
            }
        }
        finally {
            this.sqlForValidateConnectionLock.unlock();
        }
        if (this.connectionPoolName != null) {
            ref.add(new StringRefAddr("connectionPoolName", this.connectionPoolName.get()));
        }
        ref.add(new StringRefAddr("initialPoolSize", this.initialPoolSize.toString()));
        ref.add(new StringRefAddr("minPoolSize", this.minPoolSize.toString()));
        ref.add(new StringRefAddr("minIdle", this.minIdle.toString()));
        ref.add(new StringRefAddr("maxPoolSize", this.maxPoolSize.toString()));
        ref.add(new StringRefAddr("abandonedConnectionTimeout", this.abandonedConnectionTimeout.toString()));
        ref.add(new StringRefAddr("timeToLiveConnectionTimeout", this.timeToLiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("inactiveConnectionTimeout", this.inactiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("maxIdleTime", this.inactiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("timeoutCheckInterval", this.timeoutCheckInterval.toString()));
        ref.add(new StringRefAddr("propertyCycle", this.timeoutCheckInterval.toString()));
        ref.add(new StringRefAddr("maxStatements", this.maxStatements.toString()));
        ref.add(new StringRefAddr("connectionWaitTimeout", Integer.toString(Math.toIntExact(Duration.ofMillis(this.connectionWaitDurationInMillis.get()).getSeconds()))));
        ref.add(new StringRefAddr("connectionWaitDuration", Duration.ofMillis(this.connectionWaitDurationInMillis.get()).toString()));
        ref.add(new StringRefAddr("maxConnectionReuseTime", this.maxConnectionReuseTime.toString()));
        ref.add(new StringRefAddr("maxConnectionReuseCount", this.maxConnectionReuseCount.toString()));
        ref.add(new StringRefAddr("connectionHarvestTriggerCount", this.connectionHarvestTriggerCount.toString()));
        ref.add(new StringRefAddr("connectionHarvestMaxCount", this.connectionHarvestMaxCount.toString()));
        if (this.fastConnectionFailoverEnabled.get().booleanValue()) {
            ref.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        ref.add(new StringRefAddr("secondsToTrustIdleConnection", this.secondsToTrustIdleConnection.toString()));
        ref.add(new StringRefAddr("maxConnectionsPerService", String.valueOf(this.maxConnectionsPerService.toString())));
        ref.add(new StringRefAddr("loginTimeout", this.loginTimeout.toString()));
        ref.add(new StringRefAddr("maxConnectionsPerShard", this.maxConnectionsPerShard.toString()));
        ref.add(new StringRefAddr("connectionRepurposeThreshold", this.repurposeThreshold.toString()));
        if (this.onsConfiguration != null) {
            ref.add(new StringRefAddr("onsConfiguration", this.onsConfiguration));
        }
        if (this.isXmlUsed.get()) {
            ref.add(new StringRefAddr(UCP_IS_XML_USED_FOR_POOL_CONFIGURATION, "true"));
        }
        if (!this.shardingMode.get().booleanValue()) {
            ref.add(new StringRefAddr("shardingMode", "false"));
        }
        ref.add(new StringRefAddr("connectionValidationTimeout", this.connectionValidationTimeout.toString()));
        if (this.readOnlyInstanceAllowed.get().booleanValue()) {
            ref.add(new StringRefAddr("readOnlyInstanceAllowed", "true"));
        }
        if (this.createConnectionInBorrowThread.get().booleanValue()) {
            ref.add(new StringRefAddr("createConnectionInBorrowThread", "true"));
        }
        return ref;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            this.getManager().destroyConnectionPool(this.connectionPoolName.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SQLException {
        in.defaultReadObject();
        this.poolCreated = new AtomicBoolean(false);
        this.poolStarted = new AtomicBoolean(false);
        this.diagnosticsCollector = new AtomicReference<Object>(null);
        this.thisPdsBorrowContext = BorrowContext.build(this);
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        String[] nvPair;
        String[] propStrs;
        Reference ref = (Reference)refObj;
        String cn = ref.getClassName();
        PoolDataSourceImpl pd = null;
        StringRefAddr ra = (StringRefAddr)ref.get("dataSourceFromConfiguration");
        if (cn.equals("oracle.ucp.jdbc.PoolDataSource") || cn.equals("oracle.ucp.jdbc.PoolDataSourceImpl")) {
            if (ra != null) {
                return PoolDataSourceFactory.getPoolDataSource((String)ra.getContent());
            }
            pd = new PoolDataSourceImpl();
        } else if (cn.equals("oracle.ucp.jdbc.PoolXADataSource") || cn.equals("oracle.ucp.jdbc.PoolXADataSourceImpl")) {
            if (ra != null) {
                return PoolDataSourceFactory.getPoolXADataSource((String)ra.getContent());
            }
            pd = new PoolXADataSourceImpl();
        }
        if (pd == null) {
            return null;
        }
        ra = (StringRefAddr)ref.get("user");
        if (ra != null) {
            pd.setUser((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("password")) != null) {
            pd.setPassword((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("serviceName")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setServiceName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("url")) != null) {
            pd.setURL((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("serverName")) != null) {
            pd.setServerName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("portNumber")) != null) {
            pd.setPortNumber(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("databaseName")) != null) {
            pd.setDatabaseName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("dataSourceName")) != null) {
            pd.setDataSourceName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("description")) != null) {
            pd.setDescription((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("networkProtocol")) != null) {
            pd.setNetworkProtocol((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("roleName")) != null) {
            pd.setRoleName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionFactoryClassName")) != null) {
            pd.setConnectionFactoryClassName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("pdbRoles")) != null && pd instanceof PoolDataSourceImpl) {
            String pdbRolesStr = (String)ra.getContent();
            Properties pdbRoleProps = new Properties();
            for (String onePropStr : propStrs = pdbRolesStr.substring(1, pdbRolesStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                pdbRoleProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setPdbRoles(pdbRoleProps);
        }
        if ((ra = (StringRefAddr)ref.get("connectionProperties")) != null) {
            String connPropsStr = (String)ra.getContent();
            Properties connProps = new Properties();
            for (String onePropStr : propStrs = connPropsStr.substring(1, connPropsStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                connProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionProperties(connProps);
        }
        if ((ra = (StringRefAddr)ref.get("connectionFactoryProperties")) != null) {
            String cfPropsStr = (String)ra.getContent();
            Properties cfProps = new Properties();
            for (String onePropStr : propStrs = cfPropsStr.substring(1, cfPropsStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                cfProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionFactoryProperties(cfProps);
        }
        if ((ra = (StringRefAddr)ref.get("validateConnectionOnBorrow")) != null) {
            pd.setValidateConnectionOnBorrow(Boolean.parseBoolean((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("sqlForValidateConnection")) != null) {
            pd.setSQLForValidateConnection((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionPoolName")) != null) {
            pd.setConnectionPoolName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("initialPoolSize")) != null) {
            pd.setInitialPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("minPoolSize")) != null) {
            pd.setMinPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("minIdle")) != null) {
            pd.setMinIdle(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxPoolSize")) != null) {
            pd.setMaxPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("abandonedConnectionTimeout")) != null) {
            pd.setAbandonedConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("timeToLiveConnectionTimeout")) != null) {
            pd.setTimeToLiveConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("inactiveConnectionTimeout")) != null) {
            pd.setInactiveConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("timeoutCheckInterval")) != null) {
            pd.setTimeoutCheckInterval(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxStatements")) != null) {
            pd.setMaxStatements(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionWaitTimeout")) != null) {
            pd.setConnectionWaitTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionWaitDuration")) != null) {
            pd.setConnectionWaitDuration(Duration.parse((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionReuseTime")) != null) {
            pd.setMaxConnectionReuseTime(Long.parseLong((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionReuseCount")) != null) {
            pd.setMaxConnectionReuseCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionHarvestTriggerCount")) != null) {
            pd.setConnectionHarvestTriggerCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionHarvestMaxCount")) != null) {
            pd.setConnectionHarvestMaxCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("fastConnectionFailoverEnabled")) != null) {
            pd.setFastConnectionFailoverEnabled(Boolean.parseBoolean((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("onsConfiguration")) != null) {
            pd.setONSConfiguration((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("secondsToTrustIdleConnection")) != null) {
            pd.setSecondsToTrustIdleConnection(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionsPerService")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setMaxConnectionsPerService(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionsPerShard")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setMaxConnectionsPerShard(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionRepurposeThreshold")) != null && pd instanceof PoolDataSourceImpl) {
            pd.setConnectionRepurposeThreshold(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("loginTimeout")) != null) {
            pd.setLoginTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("shardingMode")) != null) {
            pd.setShardingMode(Boolean.parseBoolean((String)ra.getContent()));
        }
        ra = (StringRefAddr)ref.get(UCP_IS_XML_USED_FOR_POOL_CONFIGURATION);
        boolean xmlUsed = false;
        if (ra != null && pd instanceof PoolDataSourceImpl) {
            xmlUsed = Boolean.parseBoolean((String)ra.getContent());
            pd.setXmlUsed(xmlUsed);
            UniversalConnectionPoolManager ucpMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(this.getDiagnosable());
            boolean poolExists = Arrays.asList(ucpMgr.getConnectionPoolNames()).contains(pd.getConnectionPoolName());
            if (poolExists && ucpMgr.getConnectionPool(pd.getConnectionPoolName()).isShareable()) {
                pd.useExistingPool();
            }
        }
        if ((ra = (StringRefAddr)ref.get("connectionValidationTimeout")) != null) {
            pd.setConnectionValidationTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("readOnlyInstanceAllowed")) != null) {
            pd.setReadOnlyInstanceAllowed(Boolean.parseBoolean((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("createConnectionInBorrowThread")) != null) {
            pd.setCreateConnectionInBorrowThread(Boolean.parseBoolean((String)ra.getContent()));
        }
        return pd;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface != null && iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw UCPErrorHandler.newSQLException(62, iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface != null && iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw UCPErrorHandler.newSQLException(82, iface);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        try {
            void cbk;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionInitializationCallback", "entering args ({0})", null, null, connectionInitializationCallback);
            if (cbk == null) {
                throw new IllegalArgumentException("callback has to be non-null");
            }
            this.connectionInitializationCallback.set((ConnectionInitializationCallback)cbk);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionInitializationCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionInitializationCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINE)
    public void unregisterConnectionInitializationCallback() throws SQLException {
        try {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "unregisterConnectionInitializationCallback", "entering args ()", null, null, new Object[0]);
            this.connectionInitializationCallback.set(null);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "unregisterConnectionInitializationCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "unregisterConnectionInitializationCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        return this.connectionInitializationCallback.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void registerConnectionCreationConsumer(Consumer<ConnectionCreationInformation> consumer) {
        try {
            block4: {
                this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionCreationConsumer", "entering args ({0})", null, null, consumer);
                try {
                    void consumer2;
                    this.connectionCreationConsumer.set((Consumer<ConnectionCreationInformation>)consumer2);
                }
                catch (SQLException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionCreationConsumer", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "registerConnectionCreationConsumer", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINE)
    public void unregisterConnectionCreationConsumer() {
        try {
            block4: {
                this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "unregisterConnectionCreationConsumer", "entering args ()", null, null, new Object[0]);
                try {
                    this.connectionCreationConsumer.set(null);
                }
                catch (SQLException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "unregisterConnectionCreationConsumer", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "unregisterConnectionCreationConsumer", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Consumer<ConnectionCreationInformation> getConnectionCreationConsumer() {
        return this.connectionCreationConsumer.get();
    }

    @Override
    public int getConnectionLabelingHighCost() {
        return this.connectionLabelingHighCost.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setConnectionLabelingHighCost(int n) throws SQLException {
        try {
            void highCost;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionLabelingHighCost", "entering args ({0})", null, null, n);
            this.connectionLabelingHighCost.set((int)highCost);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionLabelingHighCost", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionLabelingHighCost", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getConnectionRepurposeThreshold() {
        return this.repurposeThreshold.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setConnectionRepurposeThreshold(int n) throws SQLException {
        try {
            void threshold;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionRepurposeThreshold", "entering args ({0})", null, null, n);
            this.repurposeThreshold.set((int)threshold);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionRepurposeThreshold", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionRepurposeThreshold", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getHighCostConnectionReuseThreshold() {
        return this.highCostConnectionReuseThreshold.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setHighCostConnectionReuseThreshold(int n) throws SQLException {
        try {
            void threshold;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setHighCostConnectionReuseThreshold", "entering args ({0})", null, null, n);
            this.highCostConnectionReuseThreshold.set((int)threshold);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setHighCostConnectionReuseThreshold", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setHighCostConnectionReuseThreshold", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINE)
    void setPdbRoles(Properties properties) {
        try {
            void roles;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPdbRoles", "entering args ({0})", null, null, properties);
            if (!this.allowSetter()) {
                this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPdbRoles", "returning void", null, null, new Object[0]);
                return;
            }
            this.pdbRoles = new Properties();
            if (roles != null) {
                this.pdbRoles.putAll((Map<?, ?>)roles);
            }
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPdbRoles", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setPdbRoles", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Properties getPdbRoles() {
        if (this.pdbRoles == null) {
            return null;
        }
        Properties lPdbRoles = new Properties();
        lPdbRoles.putAll((Map<?, ?>)this.pdbRoles);
        return lPdbRoles;
    }

    @Override
    public int getSecondsToTrustIdleConnection() {
        return this.secondsToTrustIdleConnection.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setSecondsToTrustIdleConnection(int n) throws SQLException {
        try {
            void secondsToTrustIdleConnection;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSecondsToTrustIdleConnection", "entering args ({0})", null, null, n);
            this.secondsToTrustIdleConnection.set((int)secondsToTrustIdleConnection);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSecondsToTrustIdleConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSecondsToTrustIdleConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public UCPConnectionBuilder createConnectionBuilder() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createConnectionBuilder", "entering args ()", null, null, new Object[0]);
            UCPConnectionBuilderImpl uCPConnectionBuilderImpl = new UCPConnectionBuilderImpl(){

                @Override
                public Connection build() throws SQLException {
                    return PoolDataSourceImpl.this.getConnection(this);
                }

                @Override
                public CompletionStage<Connection> buildAsyncOracle() {
                    throw new IllegalStateException("feature is not available in JDK8");
                }

                private CompletionStage<Connection> buildAsyncOracleSimulate() {
                    CompletableFuture<Connection> f = new CompletableFuture<Connection>();
                    CompletableFuture.runAsync(() -> {
                        try {
                            Connection conn = this.build();
                            f.complete(conn);
                        }
                        catch (Throwable e) {
                            f.completeExceptionally(e);
                        }
                    }, this.executor);
                    return f;
                }
            };
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createConnectionBuilder", "returning {0}", null, null, uCPConnectionBuilderImpl);
            return uCPConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "createConnectionBuilder", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getCanonicalName());
    }

    private void setXmlUsed(boolean isXmlUsed) {
        if (!this.allowSetter()) {
            return;
        }
        this.isXmlUsed.set(isXmlUsed);
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setQueryTimeout(int n) throws SQLException {
        try {
            void queryTimeout;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setQueryTimeout", "entering args ({0})", null, null, n);
            this.queryTimeout.set((int)queryTimeout);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setQueryTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setQueryTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getMaxConnectionsPerShard() {
        return this.maxConnectionsPerShard.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setMaxConnectionsPerShard(int n) throws SQLException {
        try {
            void maxConnectionsPerShard;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionsPerShard", "entering args ({0})", null, null, n);
            this.maxConnectionsPerShard.set((int)maxConnectionsPerShard);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionsPerShard", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setMaxConnectionsPerShard", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setShardingMode(boolean bl) throws SQLException {
        try {
            void shardingMode;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setShardingMode", "entering args ({0})", null, null, bl);
            this.shardingMode.set((boolean)shardingMode);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setShardingMode", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setShardingMode", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean getShardingMode() {
        return this.shardingMode.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setConnectionValidationTimeout(int n) throws SQLException {
        try {
            void connectionValidationTimeout;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionValidationTimeout", "entering args ({0})", null, null, n);
            this.connectionValidationTimeout.set((int)connectionValidationTimeout);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionValidationTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setConnectionValidationTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getConnectionValidationTimeout() {
        return this.connectionValidationTimeout.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setSSLContext(SSLContext sSLContext) {
        try {
            void sslContext;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSSLContext", "entering args ({0})", null, null, sSLContext);
            this.sslContext = sslContext;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSSLContext", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setSSLContext", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected SSLContext getSSLContext() {
        return this.sslContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setHostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        try {
            void hostnameResolver2;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setHostnameResolver", "entering args ({0})", null, null, hostnameResolver);
            this.hostnameResolver = hostnameResolver2;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setHostnameResolver", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setHostnameResolver", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public PoolDataSource.HostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }

    @Override
    public boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public void setReadOnlyInstanceAllowed(boolean bl) throws SQLException {
        try {
            void readOnlyInstanceAllowed;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setReadOnlyInstanceAllowed", "entering args ({0})", null, null, bl);
            this.readOnlyInstanceAllowed.set((boolean)readOnlyInstanceAllowed);
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setReadOnlyInstanceAllowed", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setReadOnlyInstanceAllowed", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINE)
    public final void setTokenSupplier(Supplier<? extends AccessToken> supplier) throws SQLException {
        try {
            void tokenSupplier;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTokenSupplier", "entering args ({0})", null, null, supplier);
            Objects.requireNonNull(tokenSupplier, "tokenSuplier is null");
            if (this.poolCreated.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.connectionFactory, "tokenSupplier", tokenSupplier, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(81, e);
                }
                if (this.tokenSupplier != tokenSupplier) {
                    this.refreshConnectionPool();
                }
            }
            this.tokenSupplier = tokenSupplier;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTokenSupplier", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.PoolDataSourceImpl", "setTokenSupplier", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector.updateAndGet(p -> {
            if (Objects.isNull(p)) {
                DiagnosticsCollectorImpl collector = new DiagnosticsCollectorImpl("oracle.ucp");
                String poolName = this.getConnectionPoolName();
                if (!Strings.isNullOrEmpty(poolName)) {
                    collector.setLoggerName(poolName);
                }
                return collector;
            }
            return p;
        });
    }

    private static boolean isSensitiveProperty(String name) {
        if (name == null) {
            return false;
        }
        return name.toLowerCase().contains("password") && !name.equals("oracle.jdbc.passwordAuthentication") || "oracle.jdbc.accessToken".equals(name);
    }

    @Override
    public boolean isCreateConnectionInBorrowThread() {
        return this.createConnectionInBorrowThread.get();
    }

    @Override
    public void setCreateConnectionInBorrowThread(boolean createConnectionInBorrowThread) throws SQLException {
        this.createConnectionInBorrowThread.set(createConnectionInBorrowThread);
    }

    class AutoProperty<T>
    implements Serializable {
        private static final long serialVersionUID = 4343640747504L;
        private volatile T value;
        private volatile Integer errcode = 22;
        private final AutoPropertySetter<T> setter;
        private final AutoPropertyGetter<T> getter;
        private final AutoPropertyValidator<T> validator;

        AutoProperty(T value, AutoPropertySetter<T> setter, AutoPropertyGetter<T> getter, AutoPropertyValidator<T> validator) {
            this.value = value;
            this.errcode = this.errcode;
            this.setter = setter;
            this.getter = getter;
            this.validator = validator;
            PoolDataSourceImpl.this.autoProperties.add(this);
        }

        void set(T value) throws SQLException {
            if (!PoolDataSourceImpl.this.allowSetter()) {
                return;
            }
            this.internalSet(value);
        }

        void internalSet(T value) throws SQLException {
            if (!this.validator.test(value)) {
                UCPErrorHandler.throwSQLException(22, null);
            }
            try {
                if (PoolDataSourceImpl.this.poolCreated.get()) {
                    this.setter.set(this, value);
                }
                this.value = value;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(this.errcode, e);
            }
        }

        void set() throws SQLException {
            this.set(this.value);
        }

        T get() {
            return PoolDataSourceImpl.this.poolCreated.get() ? this.getter.get(this) : this.value;
        }

        public String toString() {
            return null != this.value ? this.value.toString() : "null";
        }
    }

    @FunctionalInterface
    private static interface AutoPropertyValidator<T>
    extends Serializable {
        public boolean test(T var1);
    }

    @FunctionalInterface
    private static interface AutoPropertyGetter<T>
    extends Serializable {
        public T get(AutoProperty<T> var1);
    }

    @FunctionalInterface
    private static interface AutoPropertySetter<T>
    extends Serializable {
        public void set(AutoProperty<T> var1, T var2) throws Exception;
    }
}

