/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolMBeanBase;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class JDBCUniversalConnectionPoolMBeanImpl
extends UniversalConnectionPoolMBeanBase {
    static final String CLASS_NAME = JDBCUniversalConnectionPoolMBeanImpl.class.getName();
    private JDBCConnectionPool jdbcConnectionPool;
    private OracleJDBCConnectionPool oracleJdbcConnectionPool;

    @Debug(level=Debug.Level.FINEST)
    public JDBCUniversalConnectionPoolMBeanImpl(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        super(connectionPool);
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "<init>", "entering args ({0})", null, null, connectionPool);
            this.jdbcConnectionPool = null;
            this.oracleJdbcConnectionPool = null;
            if (connectionPool instanceof JDBCConnectionPool) {
                this.jdbcConnectionPool = (JDBCConnectionPool)connectionPool;
                if (connectionPool instanceof OracleJDBCConnectionPool) {
                    this.oracleJdbcConnectionPool = (OracleJDBCConnectionPool)connectionPool;
                }
            } else {
                UCPErrorHandler.throwUniversalConnectionPoolException(365);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setSQLForValidateConnection(String string) throws SQLException {
        try {
            void SQLString;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setSQLForValidateConnection", "entering args ({0})", null, null, string);
            if (SQLString == null) {
                throw UCPErrorHandler.newSQLException(46);
            }
            this.jdbcConnectionPool.setSQLForValidateConnection((String)SQLString);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setSQLForValidateConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setSQLForValidateConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public String getSQLForValidateConnection() {
        return this.jdbcConnectionPool.getSQLForValidateConnection();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setMaxStatements(Integer n) throws SQLException {
        try {
            void maxStatements;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxStatements", "entering args ({0})", null, null, n);
            this.jdbcConnectionPool.setMaxStatements(maxStatements.intValue());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxStatements", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxStatements", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public Integer getMaxStatements() {
        return this.jdbcConnectionPool.getMaxStatements();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setMaxIdleTime(Integer n) throws UniversalConnectionPoolException {
        try {
            void idleTime;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxIdleTime", "entering args ({0})", null, null, n);
            this.setInactiveConnectionTimeout((Integer)idleTime);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxIdleTime", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxIdleTime", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public Integer getMaxIdleTime() {
        return this.getInactiveConnectionTimeout();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setPropertyCycle(Integer n) throws UniversalConnectionPoolException {
        try {
            void propertyCycle;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setPropertyCycle", "entering args ({0})", null, null, n);
            this.setTimeoutCheckInterval((Integer)propertyCycle);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setPropertyCycle", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setPropertyCycle", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public Integer getPropertyCycle() {
        return this.getTimeoutCheckInterval();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setFastConnectionFailoverEnabled(Boolean bl) throws UniversalConnectionPoolException {
        try {
            void failoverEnabled;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setFastConnectionFailoverEnabled", "entering args ({0})", null, null, bl);
            this.jdbcConnectionPool.setFailoverEnabled(failoverEnabled.booleanValue());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setFastConnectionFailoverEnabled", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setFastConnectionFailoverEnabled", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public Boolean getFastConnectionFailoverEnabled() {
        return this.jdbcConnectionPool.isFailoverEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setONSConfiguration(String string) throws UniversalConnectionPoolException {
        try {
            void onsConfigStr;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setONSConfiguration", "entering args ({0})", null, null, string);
            this.trace(Level.FINEST, CLASS_NAME, "setONSConfiguration", "onsConfigStr: {0}", null, null, Util.maskONSConfigurationString((String)onsConfigStr));
            if (this.oracleJdbcConnectionPool != null) {
                this.oracleJdbcConnectionPool.setONSConfiguration((String)onsConfigStr);
            } else {
                UCPErrorHandler.throwUniversalConnectionPoolException(378);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setONSConfiguration", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setONSConfiguration", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public String getONSConfiguration() throws UniversalConnectionPoolException {
        String onsConfigString = null;
        if (this.oracleJdbcConnectionPool != null) {
            onsConfigString = this.oracleJdbcConnectionPool.getONSConfiguration();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
        return onsConfigString;
    }

    public Integer getMaxConnectionsPerService() throws UniversalConnectionPoolException {
        int maxPerService = Integer.MAX_VALUE;
        if (this.oracleJdbcConnectionPool != null) {
            maxPerService = this.oracleJdbcConnectionPool.getMaxConnectionsPerService();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
        return maxPerService;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setMaxConnectionsPerService(Integer n) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxConnectionsPerService", "entering args ({0})", null, null, n);
            if (this.oracleJdbcConnectionPool != null) {
                void maxConnectionsPerService;
                this.oracleJdbcConnectionPool.setMaxConnectionsPerService(maxConnectionsPerService.intValue());
            } else {
                UCPErrorHandler.throwUniversalConnectionPoolException(378);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxConnectionsPerService", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl", "setMaxConnectionsPerService", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanDisplayName) throws UniversalConnectionPoolException {
        this.trace(Level.FINEST, CLASS_NAME, "getMBeanInfo", "constructing MBeanInfo", null, null, new Object[0]);
        if (mbeanObjName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(381);
        }
        if (mbeanDisplayName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(382);
        }
        ModelMBeanInfoSupport jdbcPoolMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanName = "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl";
            String mbeanDescription = "JDBCUniversalConnectionPoolMBeanImpl Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + String.valueOf(mbeanObjName), "descriptorType=" + descriptorType, "displayName=" + mbeanDisplayName);
            jdbcPoolMBeanInfo = new ModelMBeanInfoSupport(mbeanName, mbeanDescription, this.getJDBCPoolAttributesInfo(), JDBCUniversalConnectionPoolMBeanImpl.getConstructorsInfo(), this.getJDBCPoolOperationsInfo(), JDBCUniversalConnectionPoolMBeanImpl.getNotificationsInfo());
            jdbcPoolMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(367, e);
        }
        catch (MBeanException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(366, e);
        }
        return jdbcPoolMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] jdbcPoolConstructorsInfo = new ModelMBeanConstructorInfo[1];
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getConstructorsInfo", "constructing ConstructorsInfo", null, null, new Object[0]);
        try {
            Class<JDBCUniversalConnectionPoolMBeanImpl> mBeanClass = JDBCUniversalConnectionPoolMBeanImpl.class;
            Constructor<?>[] constructors = mBeanClass.getConstructors();
            DescriptorSupport jdbcPoolConstructor = new DescriptorSupport();
            jdbcPoolConstructor.setField("name", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            jdbcPoolConstructor.setField("descriptorType", "operation");
            jdbcPoolConstructor.setField("role", "constructor");
            jdbcPoolConstructorsInfo[0] = new ModelMBeanConstructorInfo(UCPErrorHandler.findMessage("JDBCMBeanConstructorDescription"), constructors[0], (Descriptor)jdbcPoolConstructor);
        }
        catch (RuntimeOperationsException ex) {
            UCPErrorHandler.throwUniversalConnectionPoolException(368, ex);
        }
        return jdbcPoolConstructorsInfo;
    }

    private ModelMBeanAttributeInfo[] getJDBCPoolAttributesInfo() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanAttributeInfo> attributes = new ArrayList<ModelMBeanAttributeInfo>();
        this.trace(Level.FINEST, CLASS_NAME, "getJDBCPoolAttributesInfo", "constructing AttributesInfo", null, null, new Object[0]);
        try {
            attributes.addAll(Arrays.asList(this.getUCPMBeanAttributes()));
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "SQLForValidateConnection");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SQLForValidateConnectionAttrDisplayName"));
            desc.setField("getMethod", "getSQLForValidateConnection");
            desc.setField("setMethod", "setSQLForValidateConnection");
            attributes.add(new ModelMBeanAttributeInfo("SQLForValidateConnection", "java.lang.String", UCPErrorHandler.findMessage("SQLForValidateConnectionAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxStatements");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxStatementsAttrDisplayName"));
            desc.setField("getMethod", "getMaxStatements");
            desc.setField("setMethod", "setMaxStatements");
            attributes.add(new ModelMBeanAttributeInfo("maxStatements", "java.lang.Integer", UCPErrorHandler.findMessage("MaxStatementsAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxIdleTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxIdleTimeAttrDisplayName"));
            desc.setField("getMethod", "getMaxIdleTime");
            desc.setField("setMethod", "setMaxIdleTime");
            attributes.add(new ModelMBeanAttributeInfo("maxIdleTime", "java.lang.Integer", UCPErrorHandler.findMessage("MaxIdleTimeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "propertyCycle");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PropertyCycleAttrDisplayName"));
            desc.setField("getMethod", "getPropertyCycle");
            desc.setField("setMethod", "setPropertyCycle");
            attributes.add(new ModelMBeanAttributeInfo("propertyCycle", "java.lang.Integer", UCPErrorHandler.findMessage("PropertyCycleAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "failoverEnabled");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FailoverEnabledAttrDisplayName"));
            desc.setField("getMethod", "getFastConnectionFailoverEnabled");
            desc.setField("setMethod", "setFastConnectionFailoverEnabled");
            attributes.add(new ModelMBeanAttributeInfo("failoverEnabled", "java.lang.Boolean", UCPErrorHandler.findMessage("FailoverEnabledAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "onsConfiguration");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ONSConfigurationAttrDisplayName"));
            desc.setField("getMethod", "getONSConfiguration");
            desc.setField("setMethod", "setONSConfiguration");
            attributes.add(new ModelMBeanAttributeInfo("onsConfiguration", "java.lang.String", UCPErrorHandler.findMessage("ONSConfigurationAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxConnectionsPerService");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxConnectionsPerServiceAttrDisplayName"));
            desc.setField("getMethod", "getMaxConnectionsPerService");
            desc.setField("setMethod", "setMaxConnectionsPerService");
            attributes.add(new ModelMBeanAttributeInfo("maxConnectionsPerService", "java.lang.Integer", UCPErrorHandler.findMessage("MaxConnectionsPerServiceAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "successfulAffinityBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SuccessfulAffinityBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getSuccessfulAffinityBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("successfulAffinityBasedBorrowCount", "java.lang.Long", UCPErrorHandler.findMessage("SuccessfulAffinityBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "failedAffinityBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FailedAffinityBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getFailedAffinityBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("failedAffinityBasedBorrowCount", "java.lang.Long", UCPErrorHandler.findMessage("FailedAffinityBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "successfulRCLBBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SuccessfulRCLBBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getSuccessfulRCLBBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("successfulRCLBBasedBorrowCount", "java.lang.Long", UCPErrorHandler.findMessage("SuccessfulRCLBBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "failedRCLBBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FailedRCLBBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getFailedRCLBBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("failedRCLBBasedBorrowCount", "java.lang.Long", UCPErrorHandler.findMessage("FailedRCLBBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "fcfProcessingInfo");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FcfProcessingInfoAttrDisplayName"));
            desc.setField("getMethod", "getFcfProcessingInfo");
            attributes.add(new ModelMBeanAttributeInfo("fcfProcessingInfo", "java.lang.String", UCPErrorHandler.findMessage("FcfProcessingInfoAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "fcfProcessingInfoProcessedOnly");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FcfProcessingInfoProcessedOnlyAttrDisplayName"));
            desc.setField("getMethod", "getFcfProcessingInfoProcessedOnly");
            attributes.add(new ModelMBeanAttributeInfo("fcfProcessingInfoProcessedOnly", "java.lang.String", UCPErrorHandler.findMessage("FcfProcessingInfoProcessedOnlyAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionRepurposeCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionRepurposeCountAttrDisplayName"));
            desc.setField("getMethod", "getConnectionRepurposeCount");
            attributes.add(new ModelMBeanAttributeInfo("connectionRepurposeCount", "java.lang.Long", UCPErrorHandler.findMessage("ConnectionRepurposeCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "colocationStats");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ColocationStatsAttrDisplayName"));
            desc.setField("getMethod", "getColocationStats");
            attributes.add(new ModelMBeanAttributeInfo("colocationStats", "java.lang.String", UCPErrorHandler.findMessage("ColocationStatsAttrDescription"), true, false, false, desc));
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(369, e);
        }
        return attributes.toArray(new ModelMBeanAttributeInfo[0]);
    }

    private ModelMBeanOperationInfo[] getJDBCPoolOperationsInfo() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        this.trace(Level.FINEST, CLASS_NAME, "getJDBCPoolOperationsInfo", "constructing OperationsInfo", null, null, new Object[0]);
        try {
            operations.addAll(Arrays.asList(this.getUCPMBeanOperations()));
            String mBeanName = "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl";
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "getSQLForValidateConnection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSQLForValidateConnection", UCPErrorHandler.findMessage("GetSQLForValidateConnectionOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setSQLForValidateConnection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            String sDesc = UCPErrorHandler.findMessage("SetSQLForValidateConnectionOperationDescription");
            MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("SQLForValidateConnection", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setSQLForValidateConnection", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxStatements");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxStatements", UCPErrorHandler.findMessage("GetMaxStatementsOperationDescription"), null, "java.lang.Integer", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxStatements");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxStatementsOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxStatements", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxStatements", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxIdleTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxIdleTime", UCPErrorHandler.findMessage("GetMaxIdleTimeOperationDescription"), null, "java.lang.Integer", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxIdleTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxIdleTimeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxIdleTime", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxIdleTime", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getPropertyCycle");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getPropertyCycle", UCPErrorHandler.findMessage("GetPropertyCycleOperationDescription"), null, "java.lang.Integer", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setPropertyCycle");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetPropertyCycleOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyCycle", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setPropertyCycle", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFastConnectionFailoverEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFastConnectionFailoverEnabled", UCPErrorHandler.findMessage("GetFastConnectionFailoverEnabledOperationDescription"), null, "java.lang.Boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setFastConnectionFailoverEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetFastConnectionFailoverEnabledOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("failoverEnabled", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setFastConnectionFailoverEnabled", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getONSConfiguration");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getONSConfiguration", UCPErrorHandler.findMessage("GetONSConfigurationOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setONSConfiguration");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetONSConfigurationOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("onsConfiguration", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setONSConfiguration", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxConnectionsPerService");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxConnectionsPerService", UCPErrorHandler.findMessage("GetMaxConnectionsPerServiceOperationDescription"), null, "java.lang.Integer", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxConnectionsPerService");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxConnectionsPerServiceOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxConnectionsPerService", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxConnectionsPerService", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getSuccessfulAffinityBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSuccessfulAffinityBasedBorrowCount", UCPErrorHandler.findMessage("GetSuccessfulAffinityBasedBorrowCountOperationDescription"), null, "lava.lang.Long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFailedAffinityBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFailedAffinityBasedBorrowCount", UCPErrorHandler.findMessage("GetFailedAffinityBasedBorrowCountOperationDescription"), null, "java.lang.Long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getSuccessfulRCLBBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSuccessfulRCLBBasedBorrowCount", UCPErrorHandler.findMessage("GetSuccessfulRCLBBasedBorrowCountOperationDescription"), null, "java.lang.Long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFailedRCLBBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFailedRCLBBasedBorrowCount", UCPErrorHandler.findMessage("GetFailedRCLBBasedBorrowCountOperationDescription"), null, "java.lang.Long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFcfProcessingInfo");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFcfProcessingInfo", UCPErrorHandler.findMessage("GetFcfProcessingInfoOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFcfProcessingInfoProcessedOnly");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFcfProcessingInfoProcessedOnly", UCPErrorHandler.findMessage("GetFcfProcessingInfoProcessedOnlyOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionRepurposeCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionRepurposeCount", UCPErrorHandler.findMessage("GetConnectionRepurposeCountOperationDescription"), null, "java.lang.Long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getColocationStats");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getColocationStats", UCPErrorHandler.findMessage("GetColocationStatsOperationDescription"), null, "java.lang.String", 0, desc));
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(370, e);
        }
        return operations.toArray(new ModelMBeanOperationInfo[0]);
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() {
        ModelMBeanNotificationInfo[] JDBCPoolNotificationInfo = new ModelMBeanNotificationInfo[]{};
        return JDBCPoolNotificationInfo;
    }

    @Override
    public void useStrictWebSessionAffinity(Boolean strict) {
        this.oracleJdbcConnectionPool.useStrictWebSessionAffinity(strict);
    }

    @Override
    public void useStrictXAAffinity(Boolean strict) {
        this.oracleJdbcConnectionPool.useStrictXAAffinity(strict);
    }

    @Override
    public Long getSuccessfulAffinityBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getSuccessfulAffinityBasedBorrowCount();
    }

    @Override
    public Long getFailedAffinityBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getFailedAffinityBasedBorrowCount();
    }

    @Override
    public Long getSuccessfulRCLBBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getSuccessfulRCLBBasedBorrowCount();
    }

    @Override
    public Long getFailedRCLBBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getFailedRCLBBasedBorrowCount();
    }

    @Override
    public String getFcfProcessingInfo() {
        return this.oracleJdbcConnectionPool.getStatistics().getFCFProcessingInfo();
    }

    @Override
    public String getFcfProcessingInfoProcessedOnly() {
        return this.oracleJdbcConnectionPool.getStatistics().getFCFProcessingInfoProcessedOnly();
    }

    @Override
    public Long getConnectionRepurposeCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getConnectionRepurposeCount();
    }

    @Override
    public String getColocationStats() {
        return this.oracleJdbcConnectionPool.getStatistics().getColocationStats();
    }
}

