/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.OffsetDST;
import oracle.sql.TRANSDUMP;
import oracle.sql.ZONEIDMAP;

public class TIMEZONETAB
implements Monitor {
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int BYTE_SIZE = 10;
    private final Hashtable zonetab = new Hashtable();
    private static Map<Integer, TIMEZONETAB> instanceCache = new ConcurrentHashMap<Integer, TIMEZONETAB>(5);
    private int instanceCount = 0;
    private int versionNumber = 0;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    private TIMEZONETAB(int _versionNumber) {
        this.versionNumber = _versionNumber;
    }

    public static TIMEZONETAB getInstance(int versionNumber) throws SQLException {
        TIMEZONETAB tzTab = instanceCache.computeIfAbsent(versionNumber, TIMEZONETAB::new);
        return tzTab.returnInstance();
    }

    private TIMEZONETAB returnInstance() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ++this.instanceCount;
            instanceCache.put(this.versionNumber, this);
            TIMEZONETAB tIMEZONETAB = this;
            return tIMEZONETAB;
        }
    }

    public void freeInstance() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            --this.instanceCount;
            if (this.instanceCount < 1) {
                instanceCache.remove(this.versionNumber);
            }
        }
    }

    public void addTrans(Connection conn, byte[] transarray, int regionID) throws SQLException {
        int[] result = new int[BYTE_SIZE];
        OracleConnection physicalConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        boolean bigTZTC = physicalConn.isConnectionBigTZTC();
        int num_trans = transarray[0] & 0xFF;
        if (regionID == ZONEIDMAP.getID("GMT") || !bigTZTC && num_trans > 0) {
            startIndex = 1;
        } else {
            num_trans = (transarray[0] & 0xFF) << 24 | (transarray[1] & 0xFF) << 16 | (transarray[2] & 0xFF) << 8 | (transarray[3] & 0xFF) << 0;
            startIndex = 4;
        }
        OffsetDST[] trans = new OffsetDST[num_trans];
        int transIndex = 0;
        for (int i = startIndex; i < num_trans * BYTE_SIZE; i += BYTE_SIZE) {
            for (int j = 0; j < BYTE_SIZE; ++j) {
                result[j] = transarray[j + i] & 0xFF;
            }
            int year = (result[0] - 100) * 100 + (result[1] - 100);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            cal.set(14, 0);
            long millis = cal.getTime().getTime();
            int offset = (result[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (result[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
            byte dstflag = (byte)result[9];
            trans[transIndex++] = new OffsetDST(new Timestamp(millis), offset, dstflag);
        }
        this.zonetab.put(regionID & 0x1FF, trans);
    }

    public byte getLocalOffset(Calendar cal, int regionID, OffsetDST trans_data) throws SQLException {
        byte olap;
        block13: {
            byte isdst2;
            byte isdst1;
            boolean tempdate1 = false;
            boolean tempdate2 = false;
            olap = 0;
            Calendar tempCal1 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar tempCal2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar caltemp = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            caltemp.set(1, cal.get(1));
            caltemp.set(2, cal.get(2));
            caltemp.set(5, cal.get(5));
            caltemp.set(11, cal.get(11));
            caltemp.set(12, cal.get(12));
            caltemp.set(13, cal.get(13));
            caltemp.set(14, cal.get(14));
            Calendar auxCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            auxCal.set(1, caltemp.get(1));
            auxCal.set(2, caltemp.get(2));
            auxCal.set(5, 1);
            auxCal.set(11, 0);
            auxCal.set(12, 0);
            auxCal.set(13, 0);
            auxCal.set(14, 0);
            OffsetDST[] localTrans = this.getOffsetDST(regionID);
            int i = this.findCloseMatch(localTrans, auxCal.getTimeInMillis());
            while (true) {
                tempCal1.setTime(localTrans[i].getTimestamp());
                int offset1 = localTrans[i].getOFFSET();
                tempCal1.add(10, offset1 / HOUR_MILLISECOND);
                tempCal1.add(12, offset1 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                isdst1 = localTrans[i].getDSTFLAG();
                if (caltemp.equals(tempCal1)) {
                    trans_data.setOFFSET(localTrans[i].getOFFSET());
                    trans_data.setDSTFLAG(localTrans[i].getDSTFLAG());
                    olap = 0;
                    if (i > 0) {
                        isdst2 = localTrans[i - 1].getDSTFLAG();
                        if (isdst1 == 0 && isdst2 == 1) {
                            olap = 1;
                        }
                    }
                    break block13;
                }
                if (caltemp.before(tempCal1)) {
                    if (i == 0) {
                        trans_data.setOFFSET(0);
                        trans_data.setDSTFLAG((byte)0);
                        olap = 0;
                        if (isdst1 == 1) {
                            tempCal1.add(10, -1);
                            if (!caltemp.before(tempCal1)) {
                                throw new SQLException("Illegal local time.");
                            }
                        }
                        break block13;
                    }
                    if (--i < 0) continue;
                    isdst2 = localTrans[i].getDSTFLAG();
                    if (isdst1 != 1 || isdst2 != 0) continue;
                    tempCal1.add(10, -1);
                    if (caltemp.before(tempCal1)) continue;
                    throw new SQLException("Illegal local time.");
                }
                if (i == localTrans.length - 1) break;
                tempCal2.setTime(localTrans[i + 1].getTimestamp());
                int offset2 = localTrans[i + 1].getOFFSET();
                tempCal2.add(10, offset2 / HOUR_MILLISECOND);
                tempCal2.add(12, offset2 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                if (caltemp.before(tempCal2)) break;
                ++i;
            }
            trans_data.setOFFSET(localTrans[i].getOFFSET());
            trans_data.setDSTFLAG(localTrans[i].getDSTFLAG());
            olap = 0;
            if (isdst1 == 0) {
                if (i > 0 && (isdst2 = localTrans[i - 1].getDSTFLAG()) == 1) {
                    tempCal1.add(10, 1);
                    if (caltemp.before(tempCal1)) {
                        olap = 1;
                    }
                }
                if (i != localTrans.length - 1 && (isdst2 = localTrans[i + 1].getDSTFLAG()) == 1) {
                    tempCal2.add(10, -1);
                    if (!caltemp.before(tempCal2)) {
                        throw new SQLException("Illegal local time.");
                    }
                }
            }
        }
        return olap;
    }

    public int getOffset(Calendar cal, int regionID) throws SQLException {
        OffsetDST[] localTrans = this.getOffsetDST(regionID);
        return this.getOffset(cal, localTrans);
    }

    public int getOffset(long millis, int regionID) throws SQLException {
        OffsetDST[] localTrans = this.getOffsetDST(regionID);
        int index = this.findCloseMatch(localTrans, millis);
        return localTrans[index].getOFFSET();
    }

    public int getOffset(Calendar cal, OffsetDST[] localTrans) throws SQLException {
        boolean dateindex = false;
        Timestamp date = new Timestamp(cal.getTime().getTime());
        int index = this.findCloseMatch(localTrans, date.getTime());
        return localTrans[index].getOFFSET();
    }

    public boolean isDST(Calendar cal, OffsetDST[] localTrans) throws SQLException {
        boolean dateindex = false;
        Timestamp date = new Timestamp(cal.getTime().getTime());
        int index = this.findCloseMatch(localTrans, date.getTime());
        return localTrans[index].getDSTFLAG() == 1;
    }

    public OffsetDST[] getOffsetDST(int regionID) {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        return localTrans;
    }

    final int findCloseMatch(OffsetDST[] localTrans, long keyDate) {
        int mid;
        int max = localTrans.length;
        int min = 0;
        int mid2 = mid = max / 2;
        if (keyDate < localTrans[min].getTime()) {
            int n;
            for (n = 0; n < localTrans.length && localTrans[n].getDSTFLAG() == 1; ++n) {
            }
            return n < localTrans.length ? n : 0;
        }
        while (mid > 0) {
            if (keyDate > localTrans[mid].getTime()) {
                min = mid;
            } else if (keyDate < localTrans[mid].getTime()) {
                max = mid;
            } else if (mid == min) break;
            mid = min + (max - min) / 2;
            if (mid2 == mid) break;
            mid2 = mid;
        }
        return mid;
    }

    public void displayTable(int regionID) {
        OffsetDST[] localTrans = this.getOffsetDST(regionID);
        if (localTrans == null) {
            return;
        }
        for (OffsetDST lOffset : localTrans) {
            System.out.print(lOffset.getTimestamp().toString());
            System.out.print("    " + lOffset.getOFFSET());
            System.out.println("    " + lOffset.getDSTFLAG());
        }
    }

    public boolean checkID(int regionID) {
        return this.zonetab.get(regionID & 0x1FF) == null;
    }

    public void updateTable(Connection conn, int regionID) throws SQLException, NullPointerException {
        byte[] transarray = TRANSDUMP.getTransitions(conn, regionID);
        if (transarray == null) {
            throw new NullPointerException();
        }
        this.addTrans(conn, transarray, regionID);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

