/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFDCNQueryChanges;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.internal.Monitor;

class NTFDCNEvent
extends DatabaseChangeEvent {
    private static final String CLASS_NAME = NTFDCNEvent.class.getName();
    private static final long serialVersionUID = -1176415051550965782L;
    private int notifVersion = 0;
    private int notifRegid = 0;
    private DatabaseChangeEvent.EventType eventType;
    private DatabaseChangeEvent.AdditionalEventType additionalEventType = DatabaseChangeEvent.AdditionalEventType.NONE;
    private String databaseName = null;
    private byte[] notifXid = new byte[8];
    private int notifScn1 = 0;
    private int notifScn2 = 0;
    private int numberOfTables = 0;
    private NTFDCNTableChanges[] tcdesc = null;
    private int numberOfQueries = 0;
    private NTFDCNQueryChanges[] qdesc = null;
    private long registrationId;
    private NTFConnection conn;
    private int csid;
    private boolean isReady = false;
    private final Monitor lock = Monitor.newInstance();
    private ByteBuffer dataBuffer;
    private boolean isDeregistrationEvent = false;
    private short databaseVersion;
    private boolean isClientInitiatedConnection = false;

    NTFDCNEvent(long regId, byte[] rawBytes, short databaseVersion, int csid, DatabaseChangeEvent.EventType eventType) {
        super(new Object());
        this.dataBuffer = ByteBuffer.wrap(rawBytes);
        this.databaseVersion = databaseVersion;
        this.isClientInitiatedConnection = true;
        this.registrationId = regId;
        this.csid = csid;
        this.eventType = eventType;
        this.initEvent();
    }

    NTFDCNEvent(NTFConnection _conn, short _databaseVersion) throws IOException, InterruptedException {
        super(_conn);
        this.conn = _conn;
        this.csid = this.conn.charset.getOracleId();
        int lengthDataHandle = this.conn.readInt();
        byte[] data = new byte[lengthDataHandle];
        this.conn.readBuffer(data, 0, lengthDataHandle);
        this.dataBuffer = ByteBuffer.wrap(data);
        this.databaseVersion = _databaseVersion;
        this.initEvent();
    }

    private void initEvent() {
        block18: {
            try (Monitor.CloseableLock lock = this.lock.acquireCloseableLock();){
                if (this.isReady) break block18;
                if (!this.isClientInitiatedConnection) {
                    byte registrationType = this.dataBuffer.get();
                    int registrationLength = this.dataBuffer.getInt();
                    byte[] registrationBuffer = new byte[registrationLength];
                    this.dataBuffer.get(registrationBuffer, 0, registrationLength);
                    String registrationString = null;
                    try {
                        registrationString = new String(registrationBuffer, "UTF-8");
                        registrationString = registrationString.replaceFirst("CHNF", "");
                        this.registrationId = Long.parseLong(registrationString);
                    }
                    catch (Exception ex1) {
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initEvent", null, null, ex1);
                    }
                    byte namespaceType = this.dataBuffer.get();
                    int namespaceLength = this.dataBuffer.getInt();
                    byte[] namespaceBuffer = new byte[namespaceLength];
                    this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
                    byte notificationType = this.dataBuffer.get();
                    int n = this.dataBuffer.getInt();
                }
                if (this.dataBuffer.hasRemaining()) {
                    this.notifVersion = this.dataBuffer.getShort();
                    this.notifRegid = this.dataBuffer.getInt();
                    DatabaseChangeEvent.EventType event = DatabaseChangeEvent.EventType.getEventType(this.dataBuffer.getInt());
                    if (this.eventType == null) {
                        this.setEventType(event);
                    }
                    short notifDatabaseNameLength = this.dataBuffer.getShort();
                    byte[] notifDatabaseNameBuffer = new byte[notifDatabaseNameLength];
                    this.dataBuffer.get(notifDatabaseNameBuffer, 0, notifDatabaseNameLength);
                    try {
                        this.databaseName = new String(notifDatabaseNameBuffer, "UTF-8");
                    }
                    catch (Exception ex) {
                        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.INTERNAL, CLASS_NAME, "initEvent", null, "Failed to read database name from buffer.", ex);
                    }
                    this.dataBuffer.get(this.notifXid);
                    this.notifScn1 = this.dataBuffer.getInt();
                    this.notifScn2 = this.dataBuffer.getShort();
                    if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                        this.numberOfTables = this.dataBuffer.getShort();
                        this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
                        for (int i = 0; i < this.tcdesc.length; ++i) {
                            this.tcdesc[i] = new NTFDCNTableChanges(this.dataBuffer, this.csid);
                        }
                    } else if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
                        this.numberOfQueries = this.dataBuffer.getShort();
                        this.qdesc = new NTFDCNQueryChanges[this.numberOfQueries];
                        for (int i = 0; i < this.numberOfQueries; ++i) {
                            this.qdesc[i] = new NTFDCNQueryChanges(this.dataBuffer, this.csid);
                        }
                    }
                }
                this.isReady = true;
            }
        }
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
            return this.tcdesc;
        }
        return null;
    }

    @Override
    public QueryChangeDescription[] getQueryChangeDescription() {
        if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
            return this.qdesc;
        }
        return null;
    }

    @Override
    public byte[] getTransactionId() {
        return this.notifXid;
    }

    @Override
    public String getTransactionId(boolean isLittleEndian) {
        long xid_seq;
        int xid_slot;
        int xid_undo_seg;
        if (!isLittleEndian) {
            xid_undo_seg = (this.notifXid[0] & 0xFF) << 8 | this.notifXid[1] & 0xFF;
            xid_slot = (this.notifXid[2] & 0xFF) << 8 | this.notifXid[3] & 0xFF;
            xid_seq = ((this.notifXid[4] & 0xFF) << 24 | (this.notifXid[5] & 0xFF) << 16 | (this.notifXid[6] & 0xFF) << 8 | this.notifXid[7] & 0xFF) & 0xFFFFFFFF;
        } else {
            xid_undo_seg = (this.notifXid[1] & 0xFF) << 8 | this.notifXid[0] & 0xFF;
            xid_slot = (this.notifXid[3] & 0xFF) << 8 | this.notifXid[2] & 0xFF;
            xid_seq = ((this.notifXid[7] & 0xFF) << 24 | (this.notifXid[6] & 0xFF) << 16 | (this.notifXid[5] & 0xFF) << 8 | this.notifXid[4] & 0xFF) & 0xFFFFFFFF;
        }
        String ret = xid_undo_seg + "." + xid_slot + "." + xid_seq;
        return ret;
    }

    void setEventType(DatabaseChangeEvent.EventType _type) {
        this.eventType = _type;
        if (this.eventType == DatabaseChangeEvent.EventType.DEREG) {
            this.isDeregistrationEvent = true;
        }
    }

    void setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType _adtype) {
        this.additionalEventType = _adtype;
    }

    @Override
    public DatabaseChangeEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public DatabaseChangeEvent.AdditionalEventType getAdditionalEventType() {
        return this.additionalEventType;
    }

    boolean isDeregistrationEvent() {
        return this.isDeregistrationEvent;
    }

    @Override
    public String getConnectionInformation() {
        if (this.conn == null) {
            return null;
        }
        return this.conn.connectionDescription;
    }

    @Override
    public int getRegistrationId() {
        return (int)this.registrationId;
    }

    @Override
    public long getRegId() {
        return this.registrationId;
    }

    @Override
    public String toString() {
        QueryChangeDescription[] qcd;
        TableChangeDescription[] tcd;
        StringBuffer sb = new StringBuffer();
        if (this.conn != null) {
            sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
        }
        sb.append("Registration ID         : " + this.registrationId + "\n");
        sb.append("Notification version    : " + this.notifVersion + "\n");
        sb.append("Event type              : " + this.eventType + "\n");
        if (this.additionalEventType != DatabaseChangeEvent.AdditionalEventType.NONE) {
            sb.append("Additional event type   : " + this.additionalEventType + "\n");
        }
        if (this.databaseName != null) {
            sb.append("Database name           : " + this.databaseName + "\n");
        }
        if ((tcd = this.getTableChangeDescription()) != null) {
            sb.append("Table Change Description (length=" + this.numberOfTables + ")\n");
            for (int i = 0; i < tcd.length; ++i) {
                sb.append(tcd[i].toString());
            }
        }
        if ((qcd = this.getQueryChangeDescription()) != null) {
            sb.append("Query Change Description (length=" + this.numberOfQueries + ")\n");
            for (int i = 0; i < qcd.length; ++i) {
                sb.append(qcd[i].toString());
            }
        }
        return sb.toString();
    }
}

