/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import oracle.jdbc.internal.OracleConnection;

class BufferCache<T> {
    private static final double ln2 = Math.log(2.0);
    private static final int BUFFERS_PER_BUCKET = 8;
    private static final int MIN_INDEX = 12;
    private final InternalStatistics stats;
    private final int[] bufferSize;
    private final SoftReference<T>[][] buckets;
    private final int[] top;

    BufferCache(int maxCachedBufferSize) {
        int maxIndex = maxCachedBufferSize < 31 ? maxCachedBufferSize : (int)Math.ceil(Math.log(maxCachedBufferSize) / ln2);
        int numBuckets = Math.max(0, maxIndex - 12 + 1);
        this.buckets = new SoftReference[numBuckets][8];
        this.top = new int[numBuckets];
        this.bufferSize = new int[numBuckets];
        int s = 4096;
        for (int i = 0; i < this.bufferSize.length; ++i) {
            this.bufferSize[i] = s;
            s <<= 1;
        }
        this.stats = new InternalStatistics(this.bufferSize);
    }

    T get(Class<?> baseType, int length) {
        int b = this.bufferIndex(length);
        if (b >= this.buckets.length) {
            this.stats.requestTooBig();
            return (T)Array.newInstance(baseType, length);
        }
        while (this.top[b] > 0) {
            int n = b;
            int n2 = this.top[n] - 1;
            this.top[n] = n2;
            SoftReference<T> ref = this.buckets[b][n2];
            this.buckets[b][this.top[b]] = null;
            T buf = ref.get();
            if (buf == null) continue;
            this.stats.cacheHit(b);
            return buf;
        }
        this.stats.cacheMiss(b);
        return (T)Array.newInstance(baseType, this.bufferSize[b]);
    }

    void put(T buffer) {
        int len = Array.getLength(buffer);
        int b = this.bufferIndex(len);
        if (b >= this.buckets.length || len != this.bufferSize[b]) {
            this.stats.cacheTooBig();
            return;
        }
        if (this.top[b] < 8) {
            this.stats.bufferCached(b);
            int n = b;
            int n2 = this.top[n];
            this.top[n] = n2 + 1;
            this.buckets[b][n2] = new SoftReference<T>(buffer);
        } else {
            int i = this.top[b];
            while (i > 0) {
                if (this.buckets[b][--i].get() != null) continue;
                this.stats.refCleared(b);
                this.buckets[b][i] = new SoftReference<T>(buffer);
                return;
            }
            this.stats.bucketFull(b);
        }
    }

    OracleConnection.BufferCacheStatistics getStatistics() {
        return this.stats;
    }

    private int bufferIndex(int n) {
        for (int i = 0; i < this.bufferSize.length; ++i) {
            if (n > this.bufferSize[i]) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private static final class InternalStatistics
    implements OracleConnection.BufferCacheStatistics {
        private static int CACHE_COUNT = 0;
        private final int cacheId = ++CACHE_COUNT;
        private final int[] sizes;
        private final int[] nCacheHit;
        private final int[] nCacheMiss;
        private int nRequestTooBig;
        private final int[] nBufferCached;
        private final int[] nBucketFull;
        private final int[] nRefCleared;
        private int nCacheTooBig;

        InternalStatistics(int[] sizes) {
            this.sizes = sizes;
            int n = sizes.length;
            this.nCacheHit = new int[n];
            this.nCacheMiss = new int[n];
            this.nRequestTooBig = 0;
            this.nBufferCached = new int[n];
            this.nBucketFull = new int[n];
            this.nRefCleared = new int[n];
            this.nCacheTooBig = 0;
        }

        void cacheHit(int b) {
            int n = b;
            this.nCacheHit[n] = this.nCacheHit[n] + 1;
        }

        void cacheMiss(int b) {
            int n = b;
            this.nCacheMiss[n] = this.nCacheMiss[n] + 1;
        }

        void requestTooBig() {
            ++this.nRequestTooBig;
        }

        void bufferCached(int b) {
            int n = b;
            this.nBufferCached[n] = this.nBufferCached[n] + 1;
        }

        void bucketFull(int b) {
            int n = b;
            this.nBucketFull[n] = this.nBucketFull[n] + 1;
        }

        void refCleared(int b) {
            int n = b;
            this.nRefCleared[n] = this.nRefCleared[n] + 1;
        }

        void cacheTooBig() {
            ++this.nCacheTooBig;
        }

        @Override
        public int getId() {
            return this.cacheId;
        }

        @Override
        public int[] getBufferSizes() {
            int[] a = new int[this.sizes.length];
            System.arraycopy(this.sizes, 0, a, 0, this.sizes.length);
            return a;
        }

        @Override
        public int getCacheHits(int n) {
            return this.nCacheHit[n];
        }

        @Override
        public int getCacheMisses(int n) {
            return this.nCacheMiss[n];
        }

        public int getRequestsTooBig() {
            return this.nRequestTooBig;
        }

        @Override
        public int getBuffersCached(int n) {
            return this.nBufferCached[n];
        }

        @Override
        public int getBucketsFull(int n) {
            return this.nBucketFull[n];
        }

        @Override
        public int getReferencesCleared(int n) {
            return this.nRefCleared[n];
        }

        @Override
        public int getTooBigToCache() {
            return this.nCacheTooBig;
        }

        public String toString() {
            int totalHits = 0;
            int totalMisses = 0;
            int totalCached = 0;
            int totalDropped = 0;
            int totalCleared = 0;
            for (int i = 0; i < this.sizes.length; ++i) {
                totalHits += this.nCacheHit[i];
                totalMisses += this.nCacheMiss[i];
                totalCached += this.nBufferCached[i];
                totalDropped += this.nBucketFull[i];
                totalCleared += this.nRefCleared[i];
            }
            String s = "oracle.jdbc.driver.BufferCache<" + this.cacheId + ">\n\tTotal Hits   :\t" + totalHits + "\n\tTotal Misses :\t" + (totalMisses + this.nRequestTooBig) + "\n\tTotal Cached :\t" + totalCached + "\n\tTotal Dropped:\t" + (totalDropped + this.nCacheTooBig) + "\n\tTotal Cleared:\t" + totalCleared + "\n";
            return s;
        }
    }
}

