/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import oracle.ucp.util.Chain;

public class ArrayChain<T>
implements Chain<T> {
    private final Object[] atomArray = new Object[32];
    private final AtomicInteger bitmap = new AtomicInteger(0);
    private final AtomicReference<Set<Atom>> atomSet = new AtomicReference();

    @Override
    public Chain.Atom<T> add(T data) {
        Atom atom;
        int[] bitmask = new int[]{0};
        int[] index = new int[]{-1};
        this.bitmap.getAndUpdate(p -> {
            bitmask[0] = 0;
            index[0] = -1;
            int i = 0;
            int b = 1;
            while (i < 32) {
                if (0 == (p & b)) {
                    bitmask[0] = b;
                    index[0] = i;
                    return p | b;
                }
                ++i;
                b <<= 1;
            }
            return p;
        });
        int i = index[0];
        int b = bitmask[0];
        if (-1 != i) {
            atom = new ArrayAtom(data, i, b);
            this.atomArray[i] = atom;
        } else {
            atom = new SetAtom(data);
            this.atomSet.updateAndGet(p -> Objects.isNull(p) ? ConcurrentHashMap.newKeySet() : p).add(atom);
        }
        return atom;
    }

    @Override
    public void forEach(Consumer<T> consumer) {
        Set<Atom> as;
        int bitmap = this.bitmap.get();
        if (0 != bitmap) {
            int i = 0;
            int bitmask = 1;
            while (i < 32) {
                Object data;
                Atom atom;
                if (0 != (bitmap & bitmask) && null != (atom = (Atom)this.atomArray[i]) && null != (data = atom.getData())) {
                    consumer.accept(data);
                }
                ++i;
                bitmask <<= 1;
            }
        }
        if (null != (as = this.atomSet.get()) && !as.isEmpty()) {
            as.forEach((? super T p) -> consumer.accept(p.getData()));
        }
    }

    @Override
    public List<T> toList() {
        ArrayList list = new ArrayList();
        this.forEach(p -> list.add(p));
        return list;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public void clear() {
        this.bitmap.set(0);
        Arrays.fill(this.atomArray, null);
        Set<Atom> as = this.atomSet.get();
        if (null != as) {
            as.clear();
        }
    }

    private int countFilledSpots() {
        int x = this.bitmap.get();
        x = (x & 0x55555555) + (x >>> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >>> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >>> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >>> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >>> 16 & 0xFFFF);
        return x;
    }

    @Override
    public int size() {
        Set<Atom> as = this.atomSet.get();
        return this.countFilledSpots() + (Objects.nonNull(as) ? as.size() : 0);
    }

    @Override
    public boolean isEmpty() {
        Set<Atom> as = this.atomSet.get();
        return 0 == this.bitmap.get() && (Objects.isNull(as) || as.isEmpty());
    }

    public class ArrayAtom
    extends Atom {
        protected final int bitmask;
        protected final int index;

        public ArrayAtom(T data, int index, int bitmask) {
            super(data);
            this.bitmask = bitmask;
            this.index = index;
        }

        @Override
        public void remove() {
            ArrayChain.this.atomArray[this.index] = null;
            ArrayChain.this.bitmap.getAndUpdate(p -> p & ~this.bitmask);
        }
    }

    public class SetAtom
    extends Atom {
        public SetAtom(T data) {
            super(data);
        }

        @Override
        public void remove() {
            ArrayChain.this.atomSet.get().remove(this);
        }
    }

    protected abstract class Atom
    implements Chain.Atom<T> {
        private final T data;

        protected Atom(T data) {
            this.data = data;
        }

        @Override
        public T getData() {
            return this.data;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

