/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.resource.ClearTextParameters;
import oracle.jdbc.driver.resource.InstalledProviders;
import oracle.jdbc.driver.resource.ResourceProvider;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.spi.OracleResourceProvider;

final class DriverResourceProvider<T extends OracleResourceProvider, U>
implements ResourceProvider<T, U> {
    private final ResourceType<T, U> resourceType;
    private final T provider;
    private final Set<ParameterValue> parameterValues;

    private DriverResourceProvider(Builder<T, U> builder) throws SQLException {
        this.resourceType = builder.resourceType;
        this.provider = builder.provider;
        this.parameterValues = Collections.unmodifiableSet(builder.copyParameterValues());
    }

    @Override
    public U getResource() throws SQLException {
        U resource;
        try (ClearTextParameters clearTextParameters = this.getClearTextParameters();){
            resource = this.resourceType.getResource(this.provider, clearTextParameters.getParameterValues());
        }
        catch (Exception exception) {
            throw DriverResourceProvider.createSQLException(null, exception);
        }
        if (resource == null) {
            throw DriverResourceProvider.createSQLException("Invocation of getResource returned null with OracleResourceProvider: " + this.provider.getClass().getName());
        }
        return resource;
    }

    private ClearTextParameters getClearTextParameters() {
        ClearTextParameters.Builder builder = ClearTextParameters.builder();
        for (ParameterValue parameterValue : this.parameterValues) {
            parameterValue.addClearText(builder);
        }
        return builder.build();
    }

    private static SQLException createSQLException(String message) {
        return DriverResourceProvider.createSQLException(message, null);
    }

    private static SQLException createSQLException(String message, Throwable cause) {
        return (SQLException)DatabaseError.createSqlException(null, 1726, message, cause).fillInStackTrace();
    }

    static <T extends OracleResourceProvider, U> Builder<T, U> builder(String providerName, ResourceType<T, U> resourceType) throws SQLException {
        T provider = providerName.equalsIgnoreCase(resourceType.getDefaultProviderName()) ? DriverResourceProvider.loadDefaultProvider(resourceType) : DriverResourceProvider.loadInstalledProvider(providerName, resourceType);
        Map<String, OracleResourceProvider.Parameter> providerParameters = DriverResourceProvider.getProviderParameters(provider);
        return new Builder<T, U>(resourceType, provider, providerParameters);
    }

    private static <T extends OracleResourceProvider> T loadInstalledProvider(String providerName, ResourceType<T, ?> resourceType) throws SQLException {
        InstalledProviders<T> installedProviders = InstalledProviders.load(resourceType);
        T provider = installedProviders.get(providerName);
        if (provider == null) {
            throw DriverResourceProvider.createSQLException(String.format("No implementation of %s with name: \"%s\" can be located. Implementations of %1$s that can be located have the following names : %s", resourceType.getProviderClass().getName(), providerName, installedProviders.getNames()));
        }
        return provider;
    }

    private static <T extends OracleResourceProvider> T loadDefaultProvider(ResourceType<T, ?> resourceType) throws SQLException {
        try {
            return resourceType.getDefaultProvider();
        }
        catch (Exception exception) {
            throw DriverResourceProvider.createSQLException("Failed to load default provider for resource type: " + String.valueOf(resourceType), exception);
        }
    }

    private static Map<String, OracleResourceProvider.Parameter> getProviderParameters(OracleResourceProvider resourceProvider) throws SQLException {
        Collection<? extends OracleResourceProvider.Parameter> parameters = resourceProvider.getParameters();
        if (parameters == null) {
            throw DriverResourceProvider.createSQLException(String.format("Invocation of getParameters() on %s returned null", resourceProvider.getClass().getName()));
        }
        TreeMap<String, OracleResourceProvider.Parameter> namedParameters = new TreeMap<String, OracleResourceProvider.Parameter>(String.CASE_INSENSITIVE_ORDER);
        for (OracleResourceProvider.Parameter parameter : parameters) {
            if (parameter == null) {
                throw DriverResourceProvider.createSQLException("Invocation of getParameters() on %s returns a collection containing a null value.");
            }
            String name = parameter.name();
            OracleResourceProvider.Parameter duplicate = namedParameters.put(name, parameter);
            if (duplicate == null) continue;
            throw DriverResourceProvider.createSQLException(String.format("Invocation of getParameters() on %s returns multiple parameters with the name \"%s\"", resourceProvider.getClass().getName(), name));
        }
        return namedParameters;
    }

    private static final class SensitiveParameterValue
    implements ParameterValue {
        private final OracleResourceProvider.Parameter parameter;
        private final OpaqueString opaqueString;

        private SensitiveParameterValue(OracleResourceProvider.Parameter parameter, CharSequence value) {
            this(parameter, OpaqueString.newOpaqueString(value));
        }

        private SensitiveParameterValue(OracleResourceProvider.Parameter parameter, OpaqueString opaqueString) {
            this.parameter = parameter;
            this.opaqueString = opaqueString;
        }

        @Override
        public void addClearText(ClearTextParameters.Builder builder) {
            builder.addSensitiveValue(this.parameter, this.opaqueString);
        }
    }

    private static final class InsensitiveParameterValue
    implements ParameterValue {
        private final OracleResourceProvider.Parameter parameter;
        private final CharSequence charSequence;

        private InsensitiveParameterValue(OracleResourceProvider.Parameter parameter, CharSequence charSequence) {
            this.parameter = parameter;
            this.charSequence = charSequence;
        }

        @Override
        public void addClearText(ClearTextParameters.Builder builder) {
            builder.addInsensitiveValue(this.parameter, this.charSequence);
        }
    }

    private static interface ParameterValue {
        public void addClearText(ClearTextParameters.Builder var1);

        public static ParameterValue create(OracleResourceProvider.Parameter parameter, CharSequence value) {
            return parameter.isSensitive() ? new SensitiveParameterValue(parameter, value) : new InsensitiveParameterValue(parameter, value);
        }
    }

    private static final class Builder<T extends OracleResourceProvider, U>
    implements ResourceProvider.Builder<T, U> {
        private final ResourceType<T, U> resourceType;
        private final T provider;
        private final Map<String, OracleResourceProvider.Parameter> providerParameters;
        private final Map<OracleResourceProvider.Parameter, ParameterValue> parameterValues = new HashMap<OracleResourceProvider.Parameter, ParameterValue>();

        private Builder(ResourceType<T, U> resourceType, T provider, Map<String, OracleResourceProvider.Parameter> providerParameters) {
            this.resourceType = resourceType;
            this.provider = provider;
            this.providerParameters = providerParameters;
        }

        @Override
        public Builder<T, U> parameterValue(String name, CharSequence value) throws SQLException {
            Objects.requireNonNull(name);
            OracleResourceProvider.Parameter parameter = this.getParameter(name);
            this.addParameterValue(parameter, value);
            return this;
        }

        @Override
        public Builder<T, U> parameterValue(String name, OpaqueString value) throws SQLException {
            Objects.requireNonNull(name);
            OracleResourceProvider.Parameter parameter = this.getParameter(name);
            if (OpaqueString.isNull(value)) {
                return this;
            }
            SensitiveParameterValue parameterValue = new SensitiveParameterValue(parameter, value);
            this.parameterValues.put(parameter, parameterValue);
            return this;
        }

        @Override
        public DriverResourceProvider<T, U> build() throws SQLException {
            return new DriverResourceProvider(this);
        }

        private Set<ParameterValue> copyParameterValues() throws SQLException {
            HashSet<ParameterValue> copy = new HashSet<ParameterValue>(this.parameterValues.values());
            for (OracleResourceProvider.Parameter parameter : this.providerParameters.values()) {
                if (this.parameterValues.containsKey(parameter)) continue;
                CharSequence defaultValue = parameter.defaultValue();
                if (defaultValue != null) {
                    copy.add(ParameterValue.create(parameter, defaultValue));
                    continue;
                }
                if (!parameter.isRequired()) continue;
                throw DriverResourceProvider.createSQLException(String.format("No value is configured for parameter \"%s\", which is a required parameter of %s", parameter.name(), this.provider.getClass().getName()));
            }
            return copy;
        }

        private OracleResourceProvider.Parameter getParameter(String name) throws SQLException {
            OracleResourceProvider.Parameter parameter = this.providerParameters.get(name);
            if (parameter == null) {
                throw DriverResourceProvider.createSQLException(String.format("\"%s\" is not a parameter name recognized by %s. Recognized parameter names are: %s", name, this.provider.getClass().getName(), this.providerParameters.keySet()));
            }
            return parameter;
        }

        private void addParameterValue(OracleResourceProvider.Parameter parameter, CharSequence value) {
            if (value == null) {
                return;
            }
            ParameterValue parameterValue = ParameterValue.create(parameter, value);
            this.parameterValues.put(parameter, parameterValue);
        }
    }
}

