/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Arrays;

class ReplayContext
implements oracle.jdbc.internal.ReplayContext {
    long flags_kpdxcAppContCtl;
    short queue_kpdxcAppContCtl;
    byte[] replayctx_kpdxcAppContCtl;
    long errcode_kpdxcAppContCtl;

    ReplayContext(long flags_kpdxcAppContCtl, short queue_kpdxcAppContCtl, byte[] replayctx_kpdxcAppContCtl, long errcode_kpdxcAppContCtl) {
        this.flags_kpdxcAppContCtl = flags_kpdxcAppContCtl;
        this.queue_kpdxcAppContCtl = queue_kpdxcAppContCtl;
        this.errcode_kpdxcAppContCtl = errcode_kpdxcAppContCtl;
        this.replayctx_kpdxcAppContCtl = replayctx_kpdxcAppContCtl;
    }

    @Override
    public byte[] getContext() {
        return this.replayctx_kpdxcAppContCtl;
    }

    @Override
    public short getQueue() {
        return this.queue_kpdxcAppContCtl;
    }

    @Override
    public long getDirectives() {
        return this.flags_kpdxcAppContCtl;
    }

    @Override
    public long getErrorCode() {
        return this.errcode_kpdxcAppContCtl;
    }

    private String getDirectivesAsString() {
        Object ret = "[0";
        if ((this.flags_kpdxcAppContCtl & 1L) == 1L) {
            ret = (String)ret + "|DIRECTIVE_ENQUEUE_CALL";
        }
        if ((this.flags_kpdxcAppContCtl & 2L) == 2L) {
            ret = (String)ret + "|DIRECTIVE_SESSSTATE_STABLE_CRSR";
        }
        if ((this.flags_kpdxcAppContCtl & 4L) == 4L) {
            ret = (String)ret + "|DIRECTIVE_REPLAY_ENABLED";
        }
        if ((this.flags_kpdxcAppContCtl & 8L) == 8L) {
            ret = (String)ret + "|DIRECTIVE_EMPTY_QUEUE";
        }
        return (String)ret + "]";
    }

    boolean isDuplicate(ReplayContext cxt) {
        if (cxt == null) {
            return false;
        }
        return this.flags_kpdxcAppContCtl == cxt.flags_kpdxcAppContCtl && this.queue_kpdxcAppContCtl == cxt.queue_kpdxcAppContCtl && this.errcode_kpdxcAppContCtl == cxt.errcode_kpdxcAppContCtl && Arrays.equals(this.replayctx_kpdxcAppContCtl, cxt.replayctx_kpdxcAppContCtl);
    }

    public String toString() {
        return "ReplayContext[Directives=" + this.getDirectivesAsString() + ",Queue=" + this.queue_kpdxcAppContCtl + ",ErrorCode=" + this.errcode_kpdxcAppContCtl + ",Context=" + String.valueOf(this.replayctx_kpdxcAppContCtl) + "]";
    }
}

