/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Stack;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterSet;

abstract class ByteArray
implements Diagnosable {
    private static final String CLASS_NAME = ByteArray.class.getName();
    protected long position = 0L;
    final Diagnosable diagnosable;
    private Stack<Long> positions = new Stack();

    ByteArray(Diagnosable diagnosable) {
        this.diagnosable = diagnosable;
    }

    abstract long length();

    abstract long getCapacity();

    final long getPosition() {
        return this.position;
    }

    final void setPosition(long index) {
        assert (index >= 0L) : "index: " + index;
        assert (this.positions.isEmpty()) : "positions: " + this.positions.size();
        this.position = index;
    }

    final void pushPosition(long newPosition) {
        assert (newPosition >= 0L) : "newPosition: " + newPosition;
        this.positions.push(this.position);
        this.position = newPosition;
    }

    final long popPosition() {
        assert (!this.positions.isEmpty()) : "positions: " + this.positions.size();
        this.position = this.positions.pop();
        return this.position;
    }

    final void reset() {
        this.setPosition(0L);
    }

    final byte get() {
        assert (this.position < this.length()) : "position: " + this.position + " length: " + this.length();
        return this.get(this.position++);
    }

    final byte[] getBytes(int length) {
        assert (length >= 0 && this.length() >= this.getPosition() + (long)length) : "this.length: " + this.length() + " position: " + this.position + " length: " + length;
        byte[] result = this.get(this.position, length);
        this.position += (long)length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getBytes", "position increased by={0}, to={1}. ", (String)null, (Throwable)null, (Object)length, (Object)this.position);
        return result;
    }

    final void getBytes(byte[] dest, int destOffset, int length) {
        assert (dest != null) : "dest is null";
        assert (destOffset >= 0 && length >= 0 && dest.length >= destOffset + length) : "destOffset: " + destOffset + " length: " + length + " dest.length: " + dest.length;
        assert (this.length() >= this.position + (long)length) : " this.length: " + this.length() + " this.position: " + this.position + " length: " + length;
        this.get(this.position, dest, destOffset, length);
        this.position += (long)length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getBytes", "position increased by={0}, to={1}. ", (String)null, (Throwable)null, (Object)length, (Object)this.position);
    }

    final int getShort() {
        int value = this.getShort(this.position);
        this.position += 2L;
        return value;
    }

    final int getShort(long position) {
        assert (position + 1L < this.length()) : "position: " + position + " length: " + this.length();
        return (this.get(position) & 0xFF) << 8 | this.get(position + 1L) & 0xFF;
    }

    final int getInt() {
        int value = this.getInt(this.position);
        this.position += 4L;
        return value;
    }

    final long getLong() {
        long value = this.getLong(this.position);
        this.position += 8L;
        return value;
    }

    final String getString(int lengthInBytes, CharacterSet charSet) throws SQLException {
        String result = this.getString(this.position, lengthInBytes, charSet);
        this.position += (long)lengthInBytes;
        return result;
    }

    final int putString(String val, CharacterSet charSet) throws SQLException {
        int result = this.putString(this.position, val, charSet);
        this.position += (long)result;
        return result;
    }

    final int putStringWithReplacement(String val, CharacterSet charSet) throws SQLException {
        int result = this.putStringWithReplacement(this.position, val, charSet);
        this.position += (long)result;
        return result;
    }

    final int putAsciiString(String asciiString) throws SQLException {
        int result = this.putAsciiString(this.position, asciiString);
        this.position += (long)result;
        return result;
    }

    final void put(byte val) throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "put(byte)", "position increased by 1, to={0}. ", (String)null, (Throwable)null, (Object)this.position);
        this.put(this.position++, val);
    }

    final void putShort(short val) throws SQLException {
        this.putShort(this.position, val);
        this.position += 2L;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "putShort", "position increased by 2, to={0}. ", (String)null, (Throwable)null, (Object)this.position);
    }

    final void putInt(int val) throws SQLException {
        this.putInt(this.position, val);
        this.position += 4L;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "putInt", "position increased by 4 to={0}. ", (String)null, (Throwable)null, (Object)this.position);
    }

    final void putLong(long val) throws SQLException {
        this.putLong(this.position, val);
        this.position += 8L;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "putLong", "position increased by 8 to={0}. ", (String)null, (Throwable)null, (Object)this.position);
    }

    final void put(byte[] src) throws SQLException {
        this.put(this.position, src);
        this.position += (long)src.length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "put", "position increased by {0}, to={1}. ", (String)null, (Throwable)null, (Object)src.length, (Object)this.position);
    }

    final void put(byte[] src, int srcOffset, int length) throws SQLException {
        assert (src != null) : "src is null";
        assert (srcOffset >= 0 && length >= 0) : "srcOffset: " + srcOffset + " length: " + length;
        assert (src.length >= srcOffset + length) : "src.length: " + src.length + " srcOffset: " + srcOffset + " length: " + length;
        this.put(this.position, src, srcOffset, length);
        this.position += (long)length;
    }

    abstract void put(long var1, byte var3) throws SQLException;

    abstract byte get(long var1);

    final void putShort(long offset, short val) throws SQLException {
        this.put(offset, (byte)(val >> 8 & 0xFF));
        this.put(offset + 1L, (byte)(val & 0xFF));
    }

    final void putInt(long offset, int val) throws SQLException {
        for (int i = 3; i >= 0; --i) {
            this.put(offset + (long)i, (byte)(val & 0xFF));
            val >>= 8;
        }
    }

    final void putLong(long offset, long val) throws SQLException {
        for (int i = 7; i >= 0; --i) {
            this.put(offset + (long)i, (byte)(val & 0xFFL));
            val >>= 8;
        }
    }

    final void put(long offset, byte[] src) throws SQLException {
        assert (offset >= 0L && src != null) : "offset: " + offset + " src: " + String.valueOf(src);
        this.put(offset, src, 0, src.length);
    }

    abstract void put(long var1, byte[] var3, int var4, int var5) throws SQLException;

    void put(long offset, ByteArray src, long srcOffset, int length) throws SQLException {
        assert (offset >= 0L && src != null && srcOffset >= 0L) : "offset: " + offset + " src: " + String.valueOf(src) + " srcOffset: " + srcOffset;
        byte[] b = src.get(srcOffset, length);
        this.put(offset, b, 0, length);
    }

    final byte[] get(long offset, int length) {
        assert (offset >= 0L && length >= 0 && this.length() >= offset + (long)length) : "this.length: " + this.length() + " offset: " + offset + " length: " + length;
        byte[] result = new byte[length];
        this.get(offset, result, 0, length);
        return result;
    }

    abstract void get(long var1, byte[] var3, int var4, int var5);

    String getString(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] lengthInChars = new int[1];
        char[] chars = this.getChars(offset, lengthInBytes, charSet, lengthInChars);
        if (lengthInChars[0] == chars.length) {
            return new String(chars);
        }
        return String.valueOf(chars, 0, lengthInChars[0]);
    }

    int putString(long offset, String val, CharacterSet charSet) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0;
        }
        byte[] srcBytes = charSet.convert(val);
        this.put(offset, srcBytes);
        return srcBytes.length;
    }

    int putStringWithReplacement(long offset, String val, CharacterSet charSet) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0;
        }
        byte[] srcBytes = charSet.convertWithReplacement(val);
        this.put(offset, srcBytes);
        return srcBytes.length;
    }

    int putAsciiString(long offset, String asciiString) throws SQLException {
        if (asciiString == null || asciiString.length() == 0) {
            return 0;
        }
        int length = asciiString.length();
        byte[] asciiBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            asciiBytes[i] = (byte)asciiString.charAt(i);
        }
        this.put(offset, asciiBytes);
        return length;
    }

    char[] getChars(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] lengthInChars = new int[1];
        char[] result = this.getChars(offset, lengthInBytes, charSet, lengthInChars);
        if (lengthInChars[0] == result.length) {
            return result;
        }
        char[] r = new char[lengthInChars[0]];
        System.arraycopy(result, 0, r, 0, r.length);
        return r;
    }

    abstract char[] getChars(long var1, int var3, CharacterSet var4, int[] var5) throws SQLException;

    int getChars(long offset, int lengthInBytes, CharacterSet charSet, char[] dst, int dstOffset) throws SQLException {
        int[] lengthHolder = new int[1];
        System.arraycopy(this.getChars(offset, lengthInBytes, charSet, lengthHolder), 0, dst, dstOffset, lengthHolder[0]);
        return lengthHolder[0];
    }

    boolean equalBytes(long thisOffset, int length, ByteArray that, long thatOffset) throws SQLException {
        if (thisOffset + (long)length >= this.length() || thatOffset + (long)length >= that.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.get(thisOffset + (long)i) == that.get(thatOffset + (long)i)) continue;
            return false;
        }
        return true;
    }

    abstract long updateChecksum(long var1, int var3, CRC64 var4, long var5);

    abstract void updateDigest(MessageDigest var1, long var2, int var4);

    byte[] getBytesFromHex(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] out_lengthInChars = new int[1];
        char[] chars = this.getChars(offset, lengthInBytes, charSet, out_lengthInChars);
        int len = out_lengthInChars[0];
        byte[] result = new byte[(len + 1) / 2];
        boolean hi = true;
        int i = 0;
        for (char c : chars) {
            if (hi) {
                result[i] = (byte)(this.hexDigit2Nibble(c) << 4);
            } else {
                int n = i++;
                result[n] = (byte)(result[n] + (this.hexDigit2Nibble(c) & 0xF));
            }
            hi = !hi;
        }
        return result;
    }

    final int hexDigit2Nibble(char hex) throws SQLException {
        int result = Character.digit(hex, 16);
        if (result == -1) {
            throw (SQLException)DatabaseError.createSqlException(59, "Invalid hex digit: " + hex).fillInStackTrace();
        }
        return result;
    }

    final void freeSpace(long offset, int length) {
    }

    byte[] getBlockBasic(long offset, int[] initialByteIndex) {
        throw new Error("not implemented");
    }

    void free() {
        this.free(true);
    }

    abstract void free(boolean var1);

    ByteArray compact() {
        return this;
    }

    int getUtf8Bytes(long dataOffset, int dataLength, byte[] buffer, int bufferOffset, CharacterSet charSet) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    void startFetch(long maxBytes) {
    }

    void endFetch() {
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    int getInt(long offset) {
        assert (offset + 3L < this.length()) : "offset: " + offset + " length: " + this.length();
        return (this.get(offset) & 0xFF) << 24 | (this.get(offset + 1L) & 0xFF) << 16 | (this.get(offset + 2L) & 0xFF) << 8 | this.get(offset + 3L) & 0xFF;
    }

    long getLong(long offset) {
        assert (offset + 7L < this.length()) : "offset: " + offset + " length: " + this.length();
        return ((long)this.get(offset) & 0xFFL) << 56 | ((long)this.get(offset + 1L) & 0xFFL) << 48 | ((long)this.get(offset + 2L) & 0xFFL) << 40 | ((long)this.get(offset + 3L) & 0xFFL) << 32 | ((long)this.get(offset + 4L) & 0xFFL) << 24 | ((long)this.get(offset + 5L) & 0xFFL) << 16 | ((long)this.get(offset + 6L) & 0xFFL) << 8 | (long)this.get(offset + 7L) & 0xFFL;
    }

    final void putFloats(float[] array, NumberEncoding encoding) throws SQLException {
        this.putFloats(array, 0, array.length, encoding);
    }

    final void putFloats(float[] array, int arrayOffset, int length, NumberEncoding encoding) throws SQLException {
        this.putFloats(this.position, array, arrayOffset, length, encoding);
        this.position += (long)length << 2;
    }

    void putFloats(long offset, float[] array, int arrayOffset, int length, NumberEncoding encoding) throws SQLException {
        for (int i = 0; i < length; ++i) {
            float value = array[arrayOffset + i];
            this.putFloat(offset, value, encoding);
            offset += 4L;
        }
    }

    final void putFloat(long offset, float value, NumberEncoding encoding) throws SQLException {
        int bits;
        int n = bits = encoding.isIeee() ? Float.floatToRawIntBits(value) : BinaryFloatAccessor.floatToIntBits(value);
        if (encoding.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bits = Integer.reverseBytes(bits);
        }
        this.putInt(offset, bits);
    }

    final void putDoubles(double[] array, NumberEncoding encoding) throws SQLException {
        this.putDoubles(array, 0, array.length, encoding);
    }

    final void putDoubles(double[] array, int arrayOffset, int length, NumberEncoding encoding) throws SQLException {
        this.putDoubles(this.position, array, arrayOffset, length, encoding);
        this.position += (long)length << 3;
    }

    void putDoubles(long offset, double[] array, int arrayOffset, int length, NumberEncoding encoding) throws SQLException {
        for (int i = 0; i < length; ++i) {
            double value = array[arrayOffset + i];
            this.putDouble(offset, value, encoding);
            offset += 8L;
        }
    }

    final void putDouble(double value, NumberEncoding encoding) throws SQLException {
        this.putDouble(this.position, value, encoding);
        this.position += 8L;
    }

    final void putDouble(long offset, double value, NumberEncoding encoding) throws SQLException {
        long bits;
        long l = bits = encoding.isIeee() ? Double.doubleToRawLongBits(value) : BinaryDoubleAccessor.doubleToLongBits(value);
        if (encoding.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bits = Long.reverseBytes(bits);
        }
        this.putLong(offset, bits);
    }

    final void getFloats(float[] array, int arrayOffset, int length, NumberEncoding encoding) {
        this.getFloats(this.position, array, arrayOffset, length, encoding);
        this.position += (long)length << 2;
    }

    void getFloats(long offset, float[] array, int arrayOffset, int length, NumberEncoding encoding) {
        for (int i = 0; i < length; ++i) {
            array[arrayOffset + i] = this.getFloat(offset, encoding);
            offset += 4L;
        }
    }

    final float getFloat(long offset, NumberEncoding encoding) {
        int bits = this.getInt(offset);
        if (encoding.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bits = Integer.reverseBytes(bits);
        }
        return encoding.isIeee ? Float.intBitsToFloat(bits) : BinaryFloatAccessor.intBitsToFloat(bits);
    }

    final void getDoubles(double[] array, int arrayOffset, int length, NumberEncoding encoding) {
        this.getDoubles(this.position, array, arrayOffset, length, encoding);
        this.position += (long)length << 3;
    }

    void getDoubles(long offset, double[] array, int arrayOffset, int length, NumberEncoding encoding) {
        for (int i = 0; i < length; ++i) {
            array[arrayOffset + i] = this.getDouble(offset, encoding);
            offset += 8L;
        }
    }

    final double getDouble(long offset, NumberEncoding encoding) {
        long bits = this.getLong(offset);
        if (encoding.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bits = Long.reverseBytes(bits);
        }
        return encoding.isIeee ? Double.longBitsToDouble(bits) : BinaryDoubleAccessor.longBitsToDouble(bits);
    }

    protected void copyLeft(long srcOffset, int length) throws SQLException {
        if (srcOffset == this.position) {
            return;
        }
        if (srcOffset < this.position) {
            throw new IllegalArgumentException("srcOffset must be greater than the position. srcOffset=" + srcOffset + ", position=" + this.position);
        }
        byte[] buffer = new byte[Math.min(length, 16386)];
        while (length > 0) {
            int copyLength = Math.min(length, buffer.length);
            this.get(srcOffset, buffer, 0, copyLength);
            this.put(buffer, 0, copyLength);
            srcOffset += (long)copyLength;
            length -= copyLength;
        }
    }

    final void getInts(int[] array, int arrayOffset, int length) {
        this.getInts(this.position, array, arrayOffset, length);
        this.position += (long)length << 2;
    }

    void getInts(long offset, int[] array, int arrayOffset, int length) {
        for (int i = 0; i < length; ++i) {
            array[arrayOffset + i] = this.getInt(offset);
            offset += 4L;
        }
    }

    final void putInts(int[] array) throws SQLException {
        this.putInts(array, 0, array.length);
    }

    final void putInts(int[] array, int arrayOffset, int length) throws SQLException {
        this.putInts(this.position, array, arrayOffset, length);
        this.position += (long)length << 2;
    }

    void putInts(long offset, int[] array, int arrayOffset, int length) throws SQLException {
        for (int i = 0; i < length; ++i) {
            int value = array[arrayOffset + i];
            this.putInt(offset, value);
            offset += 4L;
        }
    }

    static enum NumberEncoding {
        IEEE_BIG_ENDIAN(true, ByteOrder.BIG_ENDIAN),
        IEEE_LITTLE_ENDIAN(true, ByteOrder.LITTLE_ENDIAN),
        ORACLE_BIG_ENDIAN(false, ByteOrder.BIG_ENDIAN),
        ORACLE_LITTLE_ENDIAN(false, ByteOrder.LITTLE_ENDIAN);

        private final boolean isIeee;
        private final ByteOrder byteOrder;

        private NumberEncoding(boolean isIeee, ByteOrder byteOrder) {
            this.isIeee = isIeee;
            this.byteOrder = byteOrder;
        }

        boolean isIeee() {
            return this.isIeee;
        }

        ByteOrder byteOrder() {
            return this.byteOrder;
        }
    }
}

