/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.diagnostics;

import java.io.FileInputStream;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.clio.annotations.Sensitive;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollector;
import oracle.ucp.util.Util;

public class DiagnosticsCollectorImpl
implements DiagnosticsCollector {
    private volatile String loggerName;
    private volatile Logger debugLogger;
    private volatile Handler traceTargetHandler;
    private final AtomicReference<MemoryHandler> traceHandler = new AtomicReference<Object>(null);
    private volatile boolean traceEnabled = Util.isTraceEnabled();
    private volatile boolean loggingEnabled = Util.isLoggingEnabled();
    private volatile Level loggingLevel = Util.getLoggingLevel();
    private volatile int bufferSize = Util.getBufferSize();
    private static volatile String errorCodesToWatchList = Util.getErrorCodesToWatchList();
    private static final AtomicReference<Map<Class<? extends Throwable>, Set<Integer>>> parsedErrorCodes = new AtomicReference<Object>(null);
    public static final String DEFAULT_DIAGNOSTIC_ERROR_CODES_TO_WATCH_LIST = "[ \"oracle.ucp.UniversalConnectionPoolException:45054,45066\", \"java.lang.IllegalStateException\", \"java.lang.NullPointerException\" ]";
    private static final List<DiagnosticsCollectorImpl> diagnosticsCollectorsList = Collections.synchronizedList(new ArrayList());
    private static final AtomicReference<DiagnosticsCollectorImpl> commonDiagnosticsCollector = new AtomicReference<Object>(null);
    private static final Pattern BRACKETS_PATTERN = Pattern.compile("(?<=^)\\[(.*?)\\](?=$)");
    private static final Pattern TOTAL_STRING_PATTERN = Pattern.compile("^(\"([^\"\\\\]|\\\\.)*\"(,\\s*(?!$)|$))+$");
    private static final Pattern PARTIAL_STRING_PATTERN = Pattern.compile("\"((?:[^\"\\\\]|\\\\.)*)\"");
    private static final AtomicLong currentSequenceNumber = new AtomicLong(0L);
    private static final Map<Class<? extends Throwable>, Set<Integer>> ANY_EXCEPTION_CONFIG = Stream.of(Throwable.class).collect(Collectors.toMap(p -> p, p -> Collections.emptySet()));

    public DiagnosticsCollectorImpl(String loggerName) {
        this.loggerName = Objects.requireNonNull(loggerName);
        this.prepareHandlers(true);
        this.traceHandler.set(new MemoryHandler(this.traceTargetHandler, this.bufferSize, Level.SEVERE));
        diagnosticsCollectorsList.add(this);
    }

    private void prepareHandlers(boolean reinitLoggingLevel) {
        Logger l;
        this.debugLogger = Logger.getLogger(this.loggerName);
        if (reinitLoggingLevel) {
            Level defaultLoggingLevel = Util.getLoggingLevel(this.loggingLevel);
            assert (Objects.nonNull(defaultLoggingLevel)) : "defaultLoggingLevel should not be null";
            Level thisLoggerLevel = Objects.nonNull(this.debugLogger) ? this.debugLogger.getLevel() : null;
            Level level = this.loggingLevel = Objects.nonNull(thisLoggerLevel) ? thisLoggerLevel : defaultLoggingLevel;
        }
        if (Objects.nonNull(this.debugLogger)) {
            this.debugLogger.setLevel(this.loggingLevel);
        }
        for (l = this.debugLogger; l != null && l.getHandlers().length == 0; l = l.getParent()) {
        }
        this.traceTargetHandler = Objects.isNull(l) ? new ConsoleHandler() : l.getHandlers()[0];
    }

    public static DiagnosticsCollector getCommon() {
        return commonDiagnosticsCollector.updateAndGet(p -> Objects.isNull(p) ? new DiagnosticsCollectorImpl("oracle.ucp") : p);
    }

    @Override
    public boolean getTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void setTraceEnabled(boolean enabled) {
        this.traceEnabled = enabled;
    }

    @Override
    public boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    @Override
    public Level getLogLevel() {
        return this.loggingLevel;
    }

    @Override
    public void setLogLevel(Level level) {
        this.loggingLevel = level;
        this.traceHandler.get().setPushLevel(this.loggingLevel);
    }

    @Override
    public boolean isLoggingLevelFinest() {
        return Level.FINEST == this.loggingLevel;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int size) {
        this.bufferSize = size;
        this.prepareHandlers(false);
        MemoryHandler prev = this.traceHandler.getAndSet(new MemoryHandler(this.traceTargetHandler, this.bufferSize, Level.SEVERE));
        prev.push();
        prev.close();
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
        this.prepareHandlers(true);
        MemoryHandler prev = this.traceHandler.getAndSet(new MemoryHandler(this.traceTargetHandler, this.bufferSize, Level.SEVERE));
        prev.flush();
    }

    @Override
    public void destroy() {
        diagnosticsCollectorsList.remove(this);
    }

    public static String getErrorCodesToWatchList() {
        return errorCodesToWatchList;
    }

    public static void setErrorCodesToWatchList(String errorCodesToWatchList) {
        DiagnosticsCollectorImpl.errorCodesToWatchList = errorCodesToWatchList;
        parsedErrorCodes.set(null);
    }

    private Map<Class<? extends Throwable>, Set<Integer>> parseErrorCodes(String input) {
        ArrayList parseClassErrors = new ArrayList();
        ArrayList parseIntErrors = new ArrayList();
        Function<String, Class> classParser = str -> {
            int colonIndex = str.indexOf(58);
            String className = (-1 == colonIndex ? str : str.substring(0, colonIndex)).trim();
            if (Objects.isNull(className) || "".equals(className)) {
                parseClassErrors.add(new IllegalStateException("empty class name"));
                return Throwable.class;
            }
            try {
                return Class.forName(className).asSubclass(Throwable.class);
            }
            catch (ClassNotFoundException e) {
                parseClassErrors.add(e);
                return Throwable.class;
            }
        };
        Function<String, Set> errorCodesParser = str -> {
            int colonIndex = str.indexOf(58);
            if (-1 == colonIndex) {
                return Collections.emptySet();
            }
            String strNumbers = str.substring(colonIndex + 1);
            return Arrays.stream(strNumbers.split(",")).map(p -> {
                try {
                    return Integer.parseInt(p.trim());
                }
                catch (NumberFormatException e) {
                    parseIntErrors.add(e);
                    return 0;
                }
            }).collect(Collectors.toMap(p -> p, p -> p, (p1, p2) -> p1)).keySet();
        };
        Map<Class<? extends Throwable>, Set<Integer>> result = this.parseErrorPatterns(input).stream().collect(Collectors.toMap(classParser, errorCodesParser, (p1, p2) -> p1));
        if (parseClassErrors.size() > 0) {
            throw new IllegalArgumentException("parsing failed: " + parseClassErrors);
        }
        if (parseIntErrors.size() > 0) {
            throw new IllegalArgumentException("parsing failed: " + parseIntErrors);
        }
        return result;
    }

    private Set<String> parseErrorPatterns(String input) {
        Objects.requireNonNull(input);
        Matcher bracketsMatcher = BRACKETS_PATTERN.matcher(input);
        if (!bracketsMatcher.find()) {
            throw new IllegalArgumentException("no brackets or brackets mismatch or characters beyond brackets");
        }
        String insideBrackets = bracketsMatcher.group(1).trim();
        if (0 == insideBrackets.length()) {
            return Collections.emptySet();
        }
        if (!TOTAL_STRING_PATTERN.matcher(insideBrackets).matches()) {
            throw new IllegalArgumentException("failed to parse string literals");
        }
        Matcher stringMatcher = PARTIAL_STRING_PATTERN.matcher(insideBrackets);
        HashSet<String> stringsSet = new HashSet<String>();
        while (stringMatcher.find()) {
            stringsSet.add(this.processEscapes(stringMatcher.group(1)));
        }
        return Collections.unmodifiableSet(stringsSet);
    }

    private String processEscapes(String input) {
        Objects.requireNonNull(input);
        String[] splitted = input.split("\\\\\"");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splitted.length; ++i) {
            sb.append(splitted[i]);
            if (i >= splitted.length - 1) continue;
            sb.append('\"');
        }
        return sb.toString();
    }

    public static String getLoggingConfigFile() {
        return Util.getLoggingConfigFileName();
    }

    public static void setLoggingConfigFile(String loggingConfigFileName) {
        AccessController.doPrivileged(() -> {
            try {
                Util.setLoggingConfigFileName(loggingConfigFileName);
                LogManager.getLogManager().readConfiguration(new FileInputStream(loggingConfigFileName));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return null;
        });
        for (DiagnosticsCollectorImpl collector : diagnosticsCollectorsList) {
            collector.prepareHandlers(true);
            MemoryHandler prev = collector.traceHandler.getAndSet(new MemoryHandler(collector.traceTargetHandler, collector.bufferSize, Level.SEVERE));
            prev.close();
        }
    }

    public static void dumpTraceBuffer() {
        for (DiagnosticsCollectorImpl collector : diagnosticsCollectorsList) {
            collector.traceHandler.get().push();
        }
    }

    @Override
    public Object secure(@Sensitive Object value) {
        return value;
    }

    @Override
    @Sensitive(value=Sensitive.Dependency.DEPENDENT)
    public Object format(Format.Style f, Object value, long ... args) {
        return value;
    }

    @Override
    public <T extends Throwable> T trace(Level level, SecurityLabel securityLabel, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        if (!this.traceEnabled && !this.loggingEnabled) {
            return thrown;
        }
        return this.debugTraceCommon(false, level, securityLabel, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    @Override
    public <T extends Throwable> T debug(Level level, SecurityLabel securityLabel, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        if (!this.loggingEnabled) {
            return thrown;
        }
        return this.debugTraceCommon(true, level, securityLabel, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    private <T extends Throwable> T debugTraceCommon(boolean debug, Level level, SecurityLabel securityLabel, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        DiagnosticsCollector dc = DiagnosticsCollectorImpl.getCommon();
        if (this != dc && "oracle.ucp".equals(this.loggerName)) {
            return ((DiagnosticsCollectorImpl)dc).debugTraceCommon(debug, level, securityLabel, className, methodName, publicMessage, privateMessage, thrown, args);
        }
        LogRecord record = new LogRecord(level, publicMessage);
        record.setLevel(level);
        record.setLoggerName(this.loggerName);
        record.setSourceClassName(className);
        record.setSourceMethodName(methodName);
        record.setSequenceNumber(currentSequenceNumber.getAndIncrement());
        record.setThreadID((int)Thread.currentThread().getId());
        record.setParameters(args);
        if (Objects.nonNull(thrown)) {
            record.setThrown(thrown);
        }
        if (this.loggingEnabled) {
            this.debugLogger.log(record);
        }
        if (!debug && this.traceEnabled && !this.loggingEnabled) {
            if (level.intValue() >= this.loggingLevel.intValue()) {
                this.traceHandler.get().publish(record);
            }
            if (Objects.nonNull(thrown)) {
                Map<Class<? extends Throwable>, Set<Integer>> errorCodesToWatch;
                try {
                    errorCodesToWatch = parsedErrorCodes.updateAndGet(p -> Objects.isNull(p) ? this.parseErrorCodes(DiagnosticsCollectorImpl.getErrorCodesToWatchList()) : p);
                }
                catch (Throwable e) {
                    this.logParseCodeToWatchError("error codes to watch parse failure", e);
                    parsedErrorCodes.set(ANY_EXCEPTION_CONFIG);
                    return thrown;
                }
                if (errorCodesToWatch.containsKey(Throwable.class)) {
                    DiagnosticsCollectorImpl.dumpTraceBuffer();
                    return thrown;
                }
                Object e = thrown;
                while (Objects.nonNull(e)) {
                    Set<Integer> codes = errorCodesToWatch.get(e.getClass());
                    if (Objects.nonNull(codes)) {
                        if (e instanceof UniversalConnectionPoolException) {
                            if (0 == codes.size() || codes.contains(((UniversalConnectionPoolException)e).getErrorCode())) {
                                DiagnosticsCollectorImpl.dumpTraceBuffer();
                                return thrown;
                            }
                        } else if (e instanceof SQLException) {
                            if (0 == codes.size() || codes.contains(((SQLException)e).getErrorCode())) {
                                DiagnosticsCollectorImpl.dumpTraceBuffer();
                                return thrown;
                            }
                        } else {
                            DiagnosticsCollectorImpl.dumpTraceBuffer();
                            return thrown;
                        }
                    }
                    e = e.getCause();
                }
            }
        }
        return thrown;
    }

    private void logParseCodeToWatchError(String msg, Throwable e) {
        LogRecord rec = new LogRecord(Level.WARNING, msg);
        rec.setLoggerName(this.loggerName);
        rec.setSourceClassName("DiagnosticsCollectorImpl");
        rec.setSourceMethodName("debugTraceCommon");
        rec.setSequenceNumber(currentSequenceNumber.getAndIncrement());
        rec.setThreadID((int)Thread.currentThread().getId());
        rec.setThrown(e);
        this.traceHandler.get().publish(rec);
        DiagnosticsCollectorImpl.dumpTraceBuffer();
    }

    @Override
    public void suspendLogging() {
    }

    @Override
    public void resumeLogging() {
    }

    @Override
    public void beginCurrentSql(String sql) {
    }

    @Override
    public void endCurrentSql() {
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this;
    }

    public String toString() {
        return "loggerName=" + this.loggerName;
    }
}

