/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.Service;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.util.RingBuffer;

public class ServiceMember
implements Diagnosable {
    static final String CLASS_NAME = ServiceMember.class.getName();
    static final String NONAME_INSTANCE = "***noname***";
    private static final int ADVISED_LOAD_RING_SIZE = 6;
    private static final int PEAK_BORROW_RING_SIZE = 3;
    private Key memberKey = null;
    private final String name;
    private String database = null;
    private String serviceName = null;
    private String host = null;
    private AtomicInteger dbInstanceId = new AtomicInteger(0);
    private String dbUniqueId = null;
    final Service serviceRef;
    public final AtomicInteger activeCount = new AtomicInteger(0);
    final AtomicInteger borrowedCount = new AtomicInteger(0);
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final AtomicBoolean affined = new AtomicBoolean(true);
    private final AtomicBoolean violating = new AtomicBoolean(false);
    private final AtomicInteger id = new AtomicInteger(-1);
    final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    private final AdvisedLoadHistory advisedLoadHistory = new AdvisedLoadHistory();
    private final RingBuffer<Integer> peakBorrowsHistory = new RingBuffer(3);
    final AtomicInteger connsToRebalance = new AtomicInteger(0);
    private boolean isRLBHistoryClean = true;

    public ServiceMember(Properties connProps, Service service) {
        this(connProps.getProperty("INSTANCE_NAME", NONAME_INSTANCE), connProps.getProperty("DATABASE_NAME", ""), connProps.getProperty("SERVER_HOST", ""), connProps.getProperty("SERVICE_NAME", ""), connProps.getProperty("AUTH_GLOBALLY_UNIQUE_DBID", ""), connProps.getProperty("AUTH_SC_INSTANCE_ID", ""), service);
    }

    public ServiceMember(String name, String database, String host, String serviceName, Service service) {
        this(name, database, host, serviceName, null, "0", service);
    }

    private ServiceMember(String name, String database, String host, String serviceName, String dbUniqueId, String instIdStr, Service service) {
        this.name = null == name || "".equals(name) ? NONAME_INSTANCE : ServiceMember.toLowerCase(name);
        this.database = ServiceMember.toLowerCase(database);
        this.host = ServiceMember.toLowerCase(host);
        this.serviceName = ServiceMember.toLowerCase(serviceName);
        this.dbInstanceId.set(Integer.parseInt(instIdStr.isEmpty() ? "0" : instIdStr));
        this.serviceRef = service;
        this.dbUniqueId = dbUniqueId;
        this.memberKey = new Key(this.name, this.database, this.host, this.serviceName);
    }

    public Key key() {
        return this.memberKey;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceMember) {
            return this.key().equals(((ServiceMember)obj).key());
        }
        return false;
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    void saveAdvisedLoad(float load) {
        this.advisedLoadHistory.addItem(Float.valueOf(load));
        this.isRLBHistoryClean = false;
    }

    void clearRLBHistory() {
        this.trace(Level.FINEST, CLASS_NAME, "addItem", "Clearing RLB advised load and peak borrow history", null, null, new Object[0]);
        this.isRLBHistoryClean = true;
        this.advisedLoadHistory.clear();
        this.peakBorrowsHistory.clear();
    }

    void savePeakBorrows() {
        this.peakBorrowsHistory.addItem(this.lbStats.peakBorrows.delta());
        String msg = "peakBorrowHistory=" + this.peakBorrowsHistory.getAsList() + (this.peaked() ? ", " : ", un") + "peaked";
        this.trace(Level.FINEST, CLASS_NAME, "savePeakBorrows", "{0}", null, null, msg);
    }

    boolean isRLBHistoryClean() {
        return this.isRLBHistoryClean;
    }

    float averageAdvisedLoad() {
        return this.advisedLoadHistory.averageAdvisedLoad();
    }

    float averageAdvisedLoad(ConnectionRetrievalInfo cri, Collection<ServiceMember> allMembers) {
        if (cri == null) {
            return this.averageAdvisedLoad();
        }
        float totalAdvisedLoad = (float)allMembers.stream().mapToDouble(sm -> sm.averageAdvisedLoad()).sum();
        return this.averageAdvisedLoad() / totalAdvisedLoad * 100.0f;
    }

    boolean peaked() {
        List<Integer> list = this.peakBorrowsHistory.getAsList();
        int ac = this.activeCount.get();
        int sumBorrowed = 0;
        if (!this.active.get()) {
            return false;
        }
        if (ac == 0) {
            if (this.averageAdvisedLoad() > 0.0f) {
                return true;
            }
            for (int bc : list) {
                sumBorrowed += bc;
            }
            if (sumBorrowed == 0) {
                return false;
            }
        }
        boolean peaked = true;
        for (int pb : list) {
            if (pb >= ac) continue;
            peaked = false;
            break;
        }
        return peaked;
    }

    void initId() {
        this.id.compareAndSet(-1, this.serviceRef.idCount.getAndIncrement());
    }

    public boolean active() {
        return this.serviceRef.isActive() && this.active.get();
    }

    void markActive(boolean active) {
        if (this.active.compareAndSet(!active, active)) {
            if (active) {
                this.serviceRef.activeMembers.getAndIncrement();
            } else {
                this.serviceRef.activeMembers.getAndDecrement();
            }
            this.trace(Level.FINEST, CLASS_NAME, "markActive", "about to interrupt pending connection creation operations", null, null, new Object[0]);
            this.serviceRef.interruptPendingCreations();
        }
    }

    public String name() {
        return this.name;
    }

    public String database() {
        return null == this.database ? "" : this.database;
    }

    public String service() {
        return null == this.serviceName ? "" : this.serviceName;
    }

    public String host() {
        return null == this.host ? "" : this.host;
    }

    public String dbUniqueId() {
        return null == this.dbUniqueId ? "" : this.dbUniqueId;
    }

    public int dbInstanceId() {
        return this.dbInstanceId.get();
    }

    public void markAffined(boolean affined) {
        this.affined.set(affined);
    }

    public boolean affined() {
        return this.affined.get();
    }

    public boolean violating() {
        return this.violating.get();
    }

    public void markViolating(boolean violating) {
        this.violating.set(violating);
    }

    public int id() {
        return this.id.get();
    }

    public String toString() {
        return this.name() + ",db=" + this.database() + ",service=" + this.service() + ",host=" + this.host() + ":(activeCount:" + this.activeCount.get() + ",borrowedCount:" + this.borrowedCount.get() + ",active:" + this.active.get() + ",aff=" + this.affined.get() + ",violating=" + this.violating.get() + ",id=" + this.id.get() + ')';
    }

    private static String toLowerCase(String s) {
        return null == s ? null : s.toLowerCase();
    }

    boolean violatingRLBAdvisory() {
        float instanceLoad;
        if (!this.active()) {
            return false;
        }
        if (this.advisedLoadHistory.isEmpty()) {
            return false;
        }
        float advisedLoad = this.averageAdvisedLoad();
        long instBorrowedTime = this.lbStats.borrowTimes.totalDelta();
        long totalBorrowedTime = this.serviceRef.lbStats.borrowTimes.totalDelta();
        float f = instanceLoad = 0L != totalBorrowedTime ? (float)instBorrowedTime * 100.0f / (float)totalBorrowedTime : 0.0f;
        return !(instanceLoad <= advisedLoad);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.serviceRef.getDiagnosable();
    }

    static class Key {
        private final String key;

        Key(String inst, String db, String host, String service) {
            this.key = this.norm(inst) + ':' + this.norm(db) + ':' + this.norm(service);
        }

        private String norm(String str) {
            return null != str ? str : "";
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object that) {
            if (that instanceof Key) {
                Key thatKey = (Key)that;
                return this.key.equals(thatKey.key);
            }
            return false;
        }

        public String toString() {
            return this.key;
        }
    }

    private class AdvisedLoadHistory {
        private RingBuffer<Float> history = new RingBuffer(6);
        private volatile float averageAdvisedLoad = 0.0f;

        private AdvisedLoadHistory() {
        }

        private void addItem(Float load) {
            this.history.addItem(load);
            this.computeAverageAdvisedLoad();
            String msg = "advisedLoadHistory=" + this.history.getAsList() + ", average=" + this.averageAdvisedLoad();
            ServiceMember.this.trace(Level.FINEST, CLASS_NAME, "addItem", "{0}", null, null, msg);
        }

        private void clear() {
            this.history.clear();
            this.computeAverageAdvisedLoad();
        }

        private void computeAverageAdvisedLoad() {
            List<Float> list = this.history.getAsList();
            if (list.isEmpty()) {
                int instanceCount = ServiceMember.this.serviceRef.activeMembers.get();
                this.averageAdvisedLoad = instanceCount == 0 ? 100.0f : 100.0f / (float)instanceCount;
            }
            float sumLoad = 0.0f;
            for (float load : list) {
                sumLoad += load;
            }
            this.averageAdvisedLoad = sumLoad / (float)list.size();
        }

        private float averageAdvisedLoad() {
            return this.averageAdvisedLoad;
        }

        private boolean isEmpty() {
            return this.history.getAsList().isEmpty();
        }
    }
}

