/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

public class UniqueIdentifier {
    static final String CLASS_NAME = UniqueIdentifier.class.getName();
    private static final AtomicInteger idNum = new AtomicInteger(0);
    private static final String jvmInstanceId = new UniqueIdentifier("").initJvmInstanceId();
    private static final String hostName = new UniqueIdentifier("").initHostName();
    private final String uniqueID;

    String initHostName() {
        String hostName = null;
        try {
            hostName = this.getLocalHostName();
        }
        catch (UnknownHostException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "initHostName", "failed to get this host's name", null, e, new Object[0]);
        }
        if ("localhost".equals(hostName)) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "initHostName", "'localhost' is not a unique hostname", null, null, new Object[0]);
            hostName = null;
        }
        return hostName;
    }

    String initJvmInstanceId() {
        String jvmInstanceId = null;
        try {
            String tempUID = new UID().toString();
            if (tempUID != null && (jvmInstanceId = tempUID.split(":", 2)[0]) != null) {
                jvmInstanceId = jvmInstanceId.replace('-', 'a');
            }
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "initJvmInstanceId", "", null, e, new Object[0]);
        }
        return jvmInstanceId;
    }

    public UniqueIdentifier(String prefix) {
        this.uniqueID = null != jvmInstanceId && null != hostName ? new StringBuilder(256).append(prefix).append(jvmInstanceId).append('-').append(idNum.incrementAndGet()).append('-').append(hostName).toString() : UUID.randomUUID().toString();
    }

    public boolean equals(Object uniqueID) {
        boolean ret_Value = false;
        if (uniqueID != null && uniqueID instanceof UniqueIdentifier && this == uniqueID) {
            ret_Value = true;
        }
        return ret_Value;
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    public String toString() {
        return this.uniqueID;
    }

    public static UniqueIdentifier generateUniqueID(String prefix) {
        return new UniqueIdentifier(prefix);
    }

    protected String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }
}

