/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.Pair;

class RangeSuperShardingKeys
implements SuperShardingKeys {
    private final OracleShardingKey superKeyLow;
    private final OracleShardingKey superKeyHigh;

    RangeSuperShardingKeys(OracleShardingKey high, OracleShardingKey low) {
        this.superKeyHigh = high;
        this.superKeyLow = low;
    }

    @Override
    public boolean contains(OracleShardingKey superKey) {
        return superKey.compareTo((Object)this.superKeyLow) >= 0 && superKey.compareTo((Object)this.superKeyHigh) < 0;
    }

    public String toString() {
        return "[Low:" + String.valueOf(this.superKeyLow) + ", High:" + String.valueOf(this.superKeyHigh) + "]";
    }

    public int hashCode() {
        return 31 * this.superKeyLow.hashCode() + this.superKeyHigh.hashCode();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof RangeSuperShardingKeys)) {
            return false;
        }
        RangeSuperShardingKeys otherKeys = (RangeSuperShardingKeys)otherObj;
        return this.superKeyLow.equals(otherKeys.superKeyLow) && this.superKeyHigh.equals(otherKeys.superKeyHigh);
    }

    @Override
    public int compareTo(SuperShardingKeys other) {
        RangeSuperShardingKeys otherSuperKeys = (RangeSuperShardingKeys)other;
        int lowCompare = this.superKeyLow.compareTo((Object)otherSuperKeys.superKeyLow);
        if (lowCompare != 0) {
            return lowCompare;
        }
        return this.superKeyHigh.compareTo((Object)otherSuperKeys.superKeyHigh);
    }

    @Override
    public List<Pair<OracleShardingKey, OracleShardingKey>> getKeys() {
        ArrayList<Pair<OracleShardingKey, OracleShardingKey>> pairs = new ArrayList<Pair<OracleShardingKey, OracleShardingKey>>();
        pairs.add(new Pair<OracleShardingKey, OracleShardingKey>(this.superKeyLow, this.superKeyHigh));
        return pairs;
    }
}

