/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.Limits;
import oracle.ucp.common.Policies;
import oracle.ucp.common.SelectorsUtil;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.common.waitfreepool.Factory;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.Predicates;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

public final class Core
implements Diagnosable {
    static final String CLASS_NAME = Core.class.getName();
    private final Pool<CoreConnection> waitFreePool = Factory.create();
    private static final boolean isAffinityStrict = Util.isAffinityStrict();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private Set<String> knownServices = ConcurrentHashMap.newKeySet();
    private AtomicReference<ConnectionSource> connectionSource = new AtomicReference<1>(new ConnectionSource(){});
    private AtomicReference<Limits> limits = new AtomicReference<2>(new Limits(){});
    private AtomicReference<Policies> policies = new AtomicReference<3>(new Policies(){
        private final IllegalStateException err = new IllegalStateException("policies are not set up yet");

        @Override
        public ConnectionRetrievalInfo getMostPopularCri() {
            throw this.err;
        }

        @Override
        public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
            throw this.err;
        }
    });
    private final AtomicInteger pendingAvailableGrows = new AtomicInteger();
    private final AtomicInteger pendingBorrowedGrows = new AtomicInteger();
    private volatile boolean noMoreGrows = false;
    private final ReentrantLock stoppingLock = new ReentrantLock();
    private final Condition stoppingCondition = this.stoppingLock.newCondition();
    private final AtomicLong repurposeCount = new AtomicLong(0L);
    private final Throwable[] connectionCreationError = new Throwable[]{null};
    private final long[] connectionCreationErrorTimestamp = new long[]{0L};
    private static final int REBORROW_DELAY = 100;
    private ReentrantLock handlersLock = new ReentrantLock();
    private static final Predicate<CoreConnection> markedAlready = conn -> conn.markedCloseOnReturn() || conn.markedToReplace();
    private static final long MAKE_ROOM_POSTPONEMENT = 120L;
    private volatile long notAvailTS = Clock.clock();
    private volatile long latestMakeRoomTimeStamp = 0L;
    private static final long INITIALIZE_TIMEOUT = 1000L;
    private volatile boolean makeRoomInProgress = false;
    private volatile boolean makeRoomAsyncInProgress = false;
    private volatile boolean initializeInProgress = false;
    private volatile boolean closeNonReusableByTimeInProgress = false;
    private volatile boolean closeNonReusableByCountInProgress = false;
    private volatile boolean closeInactiveInProgress = false;
    private volatile boolean replaceAvailableInProgress = false;
    private volatile boolean replaceBadConnectionsInProgress = false;
    private volatile boolean handleAbandonedTimeoutHandlerInProgress = false;
    private volatile boolean handleTimeToLiveTimeoutHandlerInProgress = false;
    private volatile boolean adjusterSuspended = false;
    private final AtomicBoolean adjusterBusy = new AtomicBoolean(false);
    private static final int HARVESTING_ATTEMPTS = 5;
    final AtomicBoolean keepOverMinimum = new AtomicBoolean(false);
    final LongAccumulator peakConnectionsCount = new LongAccumulator(Math::max, 0L);
    final LongAccumulator peakBorrowedConnectionsCount = new LongAccumulator(Math::max, 0L);
    public static final int ADJUST_MIN_AND_MIN_IDLE_LIMIT_ATTEMPTS = 10;
    public static final int BEST_INSTANCE_CREATION_ATTEMPTS = 3;
    public static final long ADJUST_MIN_AND_MIN_IDLE_LIMIT_DELAY = 2000L;
    private final AtomicBoolean maxLimitAdjuster = new AtomicBoolean(false);
    private static final long CLOSE_ALL_TIMEOUT = 5000L;
    private static final Set<Core> coreInstances = Collections.synchronizedSet(new HashSet());

    Core(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
        coreInstances.add(this);
        this.trace(Level.FINEST, CLASS_NAME, "Core", "{0} core object to watch pending grows added", null, null, this.toString());
    }

    private void put(CoreConnection conn) {
        this.waitFreePool.put(conn);
        conn.serviceMember().serviceRef.buildDistributionTable();
        conn.onInsert();
        int totalCount = this.totalCount().get();
        this.peakConnectionsCount.accumulate(totalCount);
        if (totalCount + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() >= this.limits().getMin()) {
            this.keepOverMinimum.set(true);
        }
    }

    void forEach(Consumer<CoreConnection> consumer) {
        this.forSome(p -> true, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreConnection> split(Predicate<CoreConnection> selector) {
        ArrayList<CoreConnection> connections = new ArrayList<CoreConnection>();
        PoolIterator<CoreConnection> it = this.waitFreePool.poolIterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection connection = (CoreConnection)it.next();
                if (!selector.test(connection)) continue;
                it.remove();
                connection.serviceMember().serviceRef.buildDistributionTable();
                connections.add(connection);
                connection.onRetrieve();
            }
        }
        finally {
            it.release();
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forSome(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?>[] suppliers) {
        boolean i = false;
        for (Supplier<?> supplier : suppliers) {
            Object oit = supplier.get();
            assert (oit instanceof PoolIterator) : "should be PoolIterator";
            PoolIterator it = (PoolIterator)oit;
            try {
                while (it.hasNext()) {
                    Object oconn = it.next();
                    assert (oconn instanceof CoreConnection) : "should be CoreConnection";
                    CoreConnection conn = (CoreConnection)oconn;
                    if (!selector.test(conn)) continue;
                    consumer.accept(conn);
                }
            }
            finally {
                it.release();
            }
        }
    }

    private void forSome(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?> supplier) {
        this.forSome(selector, consumer, new Supplier[]{supplier});
    }

    private void forSome(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer) {
        this.forSome(selector, consumer, () -> this.waitFreePool.poolIterator(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forFirst(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?>[] suppliers) {
        boolean i = false;
        for (Supplier<?> supplier : suppliers) {
            Object oit = supplier.get();
            assert (oit instanceof PoolIterator) : "must be PoolIterator";
            PoolIterator it = (PoolIterator)oit;
            try {
                while (it.hasNext()) {
                    Object oconn = it.next();
                    assert (oconn instanceof CoreConnection) : "must be CoreConnection";
                    CoreConnection conn = (CoreConnection)oconn;
                    if (!selector.test(conn)) continue;
                    consumer.accept(conn);
                    return;
                }
            }
            finally {
                it.release();
            }
        }
    }

    private void forFirst(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?> supplier) {
        this.forFirst(selector, consumer, new Supplier[]{supplier});
    }

    private void forFirst(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer) {
        this.forFirst(selector, consumer, () -> this.waitFreePool.poolIterator(true));
    }

    private CoreConnection retrieveFirst(Predicate<CoreConnection> selector) {
        return this.retrieveFirst(selector, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection retrieveFirst(Predicate<CoreConnection> selector, boolean revisit) {
        CoreConnection found = null;
        PoolIterator<CoreConnection> it = this.waitFreePool.poolIterator(revisit);
        try {
            while (it.hasNext()) {
                CoreConnection conn = (CoreConnection)it.next();
                if (!selector.test(conn)) continue;
                it.remove();
                conn.serviceMember().serviceRef.buildDistributionTable();
                found = conn;
                conn.onRetrieve();
                break;
            }
        }
        finally {
            it.release();
        }
        return found;
    }

    private void registerService(String serviceName) {
        this.knownServices.add(serviceName);
        ConnectionSource.FailoverCallback failoverCallback = this.prepareFailoverHandler(serviceName);
        ConnectionSource.RebalanceCallback rebalanceCallback = this.prepareRebalanceHandler(serviceName);
        this.connectionSource().registerService(serviceName, failoverCallback, rebalanceCallback);
    }

    final void plugConnectionSource(ConnectionSource connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("null connectionSource");
        }
        this.connectionSource.set(connectionSource);
    }

    public ConnectionSource connectionSource() {
        return this.connectionSource.get();
    }

    final void plugLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("null limits");
        }
        this.limits.set(limits);
    }

    private Limits limits() {
        return this.limits.get();
    }

    final void plugPolicies(Policies policies) {
        if (policies == null) {
            throw new IllegalArgumentException("null policies");
        }
        this.policies.set(policies);
    }

    private Policies policies() {
        return this.policies.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoreConnection borrow(ConnectionRetrievalInfo cri, long timeout) throws UniversalConnectionPoolException {
        CoreConnection conn = null;
        try {
            conn = this.helpBorrow(cri, timeout);
        }
        finally {
            this.peakBorrowedConnectionsCount.accumulate(this.borrowedCount());
            if (conn != null) {
                try {
                    conn.onBorrow(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "borrow", "", null, e, new Object[0]);
                    conn.makeAvailable();
                    this.put(conn);
                    conn = null;
                    throw e;
                }
            }
        }
        return conn;
    }

    private Predicate<CoreConnection> serviceSelector(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        assert (null != cs) : "connection source should be defined at this point";
        String serviceName = cs.serviceName(cri);
        return cs.serviceSelector(serviceName);
    }

    private Predicate<CoreConnection> keyBasedSelector(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        assert (null != cs) : "connection source should be defined at this point";
        if (cs.isShardedDatabase()) {
            Predicate<CoreConnection> prioritizedKeyBasedSelector = cs.routingKeyBasedBorrowSelector(cri, true);
            Predicate<CoreConnection> regularKeyBasedSelector = cs.routingKeyBasedBorrowSelector(cri, false);
            return prioritizedKeyBasedSelector.or(regularKeyBasedSelector);
        }
        if (cs.isRacDataAffinityEnabled()) {
            return cs.routingKeyBasedBorrowSelector(cri, false);
        }
        return p -> true;
    }

    private Predicate<CoreConnection> lbSelector(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        assert (null != cs) : "connection source should be defined at this point";
        return cs.loadBalancedBorrowSelector(cri);
    }

    private Predicate<CoreConnection> baseSelector(ConnectionRetrievalInfo cri) {
        return conn -> cri.criMatchSelector().test((CoreConnection)conn) && WLSJTAPlugin.xaAffSelector().test((CoreConnection)conn);
    }

    private Predicate<CoreConnection> basicCommonSelector(ConnectionRetrievalInfo cri, boolean lbBased, boolean keyBased) {
        if (lbBased) {
            if (keyBased) {
                return p -> SelectorsUtil.availableSelector.test((CoreConnection)p) && this.baseSelector(cri).test((CoreConnection)p) && this.lbSelector(cri).test((CoreConnection)p) && this.keyBasedSelector(cri).test((CoreConnection)p);
            }
            return p -> SelectorsUtil.availableSelector.test((CoreConnection)p) && this.baseSelector(cri).test((CoreConnection)p) && this.lbSelector(cri).test((CoreConnection)p);
        }
        if (keyBased) {
            return p -> SelectorsUtil.availableSelector.test((CoreConnection)p) && this.baseSelector(cri).test((CoreConnection)p) && this.keyBasedSelector(cri).test((CoreConnection)p);
        }
        return p -> SelectorsUtil.availableSelector.test((CoreConnection)p) && this.baseSelector(cri).test((CoreConnection)p);
    }

    private CoreConnection findFirst(ConnectionRetrievalInfo cri, Predicate<CoreConnection> selector) {
        Properties reqLabels = cri.getLabels();
        return null != reqLabels ? this.findFirstLabeled(selector, reqLabels, new HashMap<CoreConnection, Integer>()) : this.findFirstUnlabeled(selector);
    }

    private CoreConnection findFirstUnlabeled(Predicate<CoreConnection> selector) {
        CoreConnection conn = null;
        try {
            conn = this.waitFreePool.findFirst(selector, (T p) -> p.makeUnavailable());
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "findFirst", "", null, e, new Object[0]);
            if (null != conn) {
                conn.makeAvailable();
                conn = null;
            }
            throw e;
        }
        return conn;
    }

    private CoreConnection findFirstLabeled(Predicate<CoreConnection> selector, Properties reqLabels, Map<CoreConnection, Integer> costCache) {
        assert (null != reqLabels);
        int[] reservedCost = new int[]{Integer.MAX_VALUE};
        CoreConnection[] reservedConn = new CoreConnection[]{null};
        try {
            this.waitFreePool.findFirst((T conn) -> {
                if (!selector.test((CoreConnection)conn)) {
                    return false;
                }
                int cost = costCache.computeIfAbsent((CoreConnection)conn, p -> p.labelingCost(reqLabels));
                if (Integer.MAX_VALUE == cost) {
                    return false;
                }
                if (null != reservedConn[0]) {
                    if (cost < reservedCost[0]) {
                        reservedCost[0] = cost;
                        reservedConn[0].makeAvailable();
                        reservedConn[0] = conn;
                        reservedConn[0].makeUnavailable();
                        return false;
                    }
                    return false;
                }
                reservedCost[0] = cost;
                reservedConn[0] = conn;
                reservedConn[0].makeUnavailable();
                return 0 == cost;
            }, (T conn) -> {});
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "findFirst", "", null, e, new Object[0]);
            if (null != reservedConn[0]) {
                reservedConn[0].makeAvailable();
                reservedConn[0] = null;
            }
            throw e;
        }
        return reservedConn[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection findFirst(ConnectionRetrievalInfo cri, Predicate<CoreConnection> selector, long giveUpTimeStamp) {
        CoreConnection conn;
        block7: {
            int ATTEMPTS = 5;
            CriStats criMetadata = this.connectionSource().getCriMetadata(cri);
            conn = null;
            try {
                CriStats.BorrowSemaphore borrowSemaphore;
                boolean acquired;
                for (int i = 0; i < 5 && criMetadata.totalConnCount().get() - criMetadata.borrowedConnCount().get() > 0; ++i) {
                    conn = this.findFirst(cri, selector);
                    if (null == conn) continue;
                    return conn;
                }
                long remainingTimeToWait = Core.computeRemainingTimeToWait(giveUpTimeStamp);
                if (remainingTimeToWait <= 0L || !(acquired = ((Semaphore)(borrowSemaphore = criMetadata.getBorrowSemaphore())).tryAcquire(remainingTimeToWait, TimeUnit.MILLISECONDS))) break block7;
                try {
                    conn = this.findFirst(cri, selector);
                }
                finally {
                    borrowSemaphore.release();
                }
            }
            catch (InterruptedException e) {
                this.handleUncheckedException(e, conn);
                conn = null;
            }
            catch (Throwable e) {
                this.handleUncheckedException(e, conn);
                conn = null;
                throw e;
            }
        }
        return conn;
    }

    private static long computeRemainingTimeToWait(long giveUpTimeStamp) {
        return Math.max(0L, giveUpTimeStamp - Clock.clock());
    }

    private CoreConnection helpBorrow(ConnectionRetrievalInfo cri, long timeout) {
        ConnectionSource cs = this.connectionSource();
        long giveUpTimeStamp = Clock.clock() + timeout;
        CoreConnection conn = null;
        try {
            boolean dbAffinity;
            ConnectionAffinityCallback callback = cri.getConnectionAffinityCallback();
            boolean bl = dbAffinity = null != callback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == callback.getAffinityPolicy();
            if ((cs.failoverEnabled() || dbAffinity) && !cs.isColocation()) {
                Predicate<CoreConnection> balancedKeyBasedSelector = cs.isRacDataAffinityEnabled() ? this.basicCommonSelector(cri, false, true) : this.basicCommonSelector(cri, true, true);
                conn = this.findFirst(cri, balancedKeyBasedSelector, giveUpTimeStamp);
                if (null == conn) {
                    if (cs.isRacDataAffinityEnabled()) {
                        Predicate<CoreConnection> balancedNonKeyBasedSelector;
                        if (!isAffinityStrict && (conn = this.findFirst(cri, balancedNonKeyBasedSelector = this.basicCommonSelector(cri, true, false), giveUpTimeStamp)) == null) {
                            Predicate<CoreConnection> unBalancedNonKeyBasedSelector = this.basicCommonSelector(cri, false, false);
                            conn = this.findFirst(cri, unBalancedNonKeyBasedSelector, giveUpTimeStamp);
                        }
                    } else if (cs.isShardedDatabase()) {
                        Predicate<CoreConnection> unBalancedKeyBasedSelector = this.basicCommonSelector(cri, false, true);
                        conn = this.findFirst(cri, unBalancedKeyBasedSelector, giveUpTimeStamp);
                    } else if (!dbAffinity || !isAffinityStrict) {
                        Predicate<CoreConnection> unBalancedKeyBasedSelector = this.basicCommonSelector(cri, false, true);
                        conn = this.findFirst(cri, unBalancedKeyBasedSelector, giveUpTimeStamp);
                    }
                } else if (null != callback) {
                    ConnectionAffinityCallback.AffinityPolicy policy = callback.getAffinityPolicy();
                    if (callback.getConnectionAffinityContext() == null) {
                        ServiceMember chosenConnInstance = conn.serviceMember();
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == policy && chosenConnInstance.affined() || ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == policy) {
                            this.trace(Level.FINEST, CLASS_NAME, "helpBorrow", "Updating affinity context with instance {0}", null, null, chosenConnInstance.name());
                            callback.setConnectionAffinityContext(new AffinityContext(chosenConnInstance.service(), chosenConnInstance.database(), chosenConnInstance.name(), policy));
                        }
                    }
                }
            } else {
                Predicate<CoreConnection> unBalancedKeyBasedSelector = this.basicCommonSelector(cri, false, true);
                conn = this.findFirst(cri, unBalancedKeyBasedSelector, giveUpTimeStamp);
                if (conn == null && cs.isRacDataAffinityEnabled() && !isAffinityStrict) {
                    Predicate<CoreConnection> unBalancedNonKeyBasedSelector = this.basicCommonSelector(cri, false, false);
                    conn = this.findFirst(cri, unBalancedNonKeyBasedSelector, giveUpTimeStamp);
                }
            }
            if (null != conn) {
                if (cs.failoverEnabled() && !cs.isColocation()) {
                    this.updateRLBStats(conn.serviceMember());
                }
                try {
                    WLSJTAPlugin.checkXAAffinity(conn.serviceMember());
                }
                catch (UniversalConnectionPoolException exc) {
                    this.trace(Level.WARNING, CLASS_NAME, "helpBorrow", "##### WLSJTAPlugin.checkXAAffinity() threw exception: ", null, exc, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            this.handleUncheckedException(e, conn);
            conn = null;
            throw e;
        }
        return conn;
    }

    private void handleUncheckedException(Throwable e, CoreConnection ... connsToInvalidate) {
        this.trace(Level.WARNING, CLASS_NAME, "handleUncheckedException", "got unchecked exception from user-defined connection labeling callback", null, e, new Object[0]);
        for (CoreConnection conn : connsToInvalidate) {
            if (null == conn) continue;
            conn.markBad();
            conn.makeAvailable();
        }
    }

    private void updateRLBStats(ServiceMember serviceMember) {
        if (serviceMember.violatingRLBAdvisory()) {
            serviceMember.lbStats.onFailedLbBorrowed();
            serviceMember.serviceRef.lbStats.onFailedLbBorrowed();
        } else {
            serviceMember.lbStats.onSuccessfulLbBorrowed();
            serviceMember.serviceRef.lbStats.onSuccessfulLbBorrowed();
        }
    }

    void waitForPoolUpdate(ConnectionRetrievalInfo cri, long timeout) {
        CriStats criMetadata = this.connectionSource().getCriMetadata(cri);
        assert (Objects.nonNull(criMetadata));
        criMetadata.waitForPoolUpdate(timeout);
    }

    private boolean atOrBelowMinIdle() {
        int minIdle = this.limits().getMinIdle();
        return this.availableCount() + this.pendingAvailableGrows() <= minIdle;
    }

    private boolean atOrBelowMin() {
        int minPoolSize = this.limits().getMin();
        return this.totalCount().get() + this.pendingGrowsCount() <= minPoolSize;
    }

    private boolean belowMinIdle() {
        int minIdle = this.limits().getMinIdle();
        return this.availableCount() + this.pendingAvailableGrows() < minIdle;
    }

    private boolean belowMin() {
        int minPoolSize = this.limits().getMin();
        return this.totalCount().get() + this.pendingGrowsCount() < minPoolSize;
    }

    private boolean atOrBelowMinimums() {
        return this.atOrBelowMin() || this.atOrBelowMinIdle();
    }

    private boolean belowMinimums() {
        return this.belowMin() || this.belowMinIdle();
    }

    final void reclaim(CoreConnection conn) {
        if (conn.available()) {
            return;
        }
        if (conn.normal()) {
            if (conn.reusableByCount()) {
                try {
                    conn.onReturn();
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "reclaim", "", null, e, new Object[0]);
                }
                conn.makeAvailable();
                return;
            }
            conn.markCloseOnReturn();
        }
        this.retrieve(conn);
        UniversalConnectionPoolManagerBase.getShrinkingExecutor().execute(() -> {
            this.closeNonReusableByCountInProgress = true;
            try {
                conn.abort();
                conn.close();
                if (conn.markedToReplace()) {
                    try {
                        this.growAvailable(conn.cri());
                    }
                    catch (UniversalConnectionPoolException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "reclaim", "unable to grow a connection", null, e, new Object[0]);
                    }
                }
            }
            finally {
                this.closeNonReusableByCountInProgress = false;
                this.kickAdjuster();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CoreConnection growForBorrow(final ConnectionRetrievalInfo cri, final long timeToRetry, boolean[] growPending) throws UniversalConnectionPoolException {
        CoreConnection connection;
        ConnectionSource cs;
        block12: {
            String serviceName;
            boolean makeRoomNeeded;
            boolean repurposeNeeded;
            block11: {
                assert (growPending.length == 1) : "grow context is one-slot boolean array";
                if (growPending[0]) {
                    return null;
                }
                cs = this.connectionSource();
                int total = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
                int borrowed = this.borrowedCount();
                boolean shareable = cs.isShareable();
                boolean multitenantDatabase = cs.isMultitenantDatabase();
                int min = this.limits().getMin();
                int max = this.limits().getMax();
                int repurposeThreshold = this.limits().getRepurposeThreshold();
                repurposeNeeded = shareable && multitenantDatabase && total > min && total > repurposeThreshold && total > borrowed;
                makeRoomNeeded = total > max && total > borrowed;
                this.trace(Level.FINEST, CLASS_NAME, "growBorrowed", "repurposeNeeded={0}, makeRoomNeeded={1}, shareable={2}, multitenantDatabase={3}, total={4}, borrowed={5}, min={6}, max={7}, repurposeThreshold={8}", null, null, repurposeNeeded, makeRoomNeeded, shareable, multitenantDatabase, total, borrowed, min, max, repurposeThreshold);
                connection = null;
                serviceName = cs.serviceName(cri);
                if (!this.noMoreGrows) break block11;
                CoreConnection coreConnection = null;
                this.postGrowForBorrow(cri, connection, cs.isCreateConnectionInBorrowThread() || !growPending[0]);
                return coreConnection;
            }
            try {
                boolean madeRoom;
                if (repurposeNeeded && Objects.nonNull(connection = this.tryRepurpose(cri))) {
                    this.repurposeCount.getAndIncrement();
                    break block12;
                }
                if (!cs.isServiceRegistered(serviceName)) {
                    this.registerService(serviceName);
                }
                boolean bl = madeRoom = makeRoomNeeded ? this.makeRoom(cri) : false;
                if (makeRoomNeeded && !madeRoom) break block12;
                final EnumSet<ConnectionSource.CreateMode> createMode = EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE);
                UCPTaskBase createTask = cs.isCreateConnectionInBorrowThread() ? null : new UCPTaskBase(){

                    @Override
                    public void run() {
                        CoreConnection conn = null;
                        try {
                            conn = cs.create(cri, createMode, timeToRetry);
                            Core.this.connectionCreationError[0] = null;
                            Core.this.connectionCreationErrorTimestamp[0] = 0L;
                            Core.this.postAsyncGrowForBorrow(cri, conn);
                        }
                        catch (Throwable e) {
                            try {
                                Core.this.connectionCreationError[0] = Core.unwrapDriverCause(e);
                                Core.this.connectionCreationErrorTimestamp[0] = Clock.clock();
                                Core.this.trace(Level.WARNING, CLASS_NAME, "growForBorrow", "", null, e, new Object[0]);
                                Core.this.postAsyncGrowForBorrow(cri, conn);
                            }
                            catch (Throwable throwable) {
                                Core.this.postAsyncGrowForBorrow(cri, conn);
                                throw throwable;
                            }
                        }
                    }
                };
                TaskManager taskManager = Objects.requireNonNull(UniversalConnectionPoolManagerBase.getTaskManager());
                if (Objects.nonNull(createTask)) {
                    int pendingGrows = this.pendingBorrowedGrows.get() - 1;
                    if (this.pendingRequestsCount() >= pendingGrows) {
                        growPending[0] = true;
                        taskManager.submitTask(createTask);
                    }
                    break block12;
                }
                connection = cs.create(cri, createMode, timeToRetry);
            }
            catch (Throwable e) {
                try {
                    this.trace(Level.WARNING, CLASS_NAME, "growForBorrow", "", null, e, new Object[0]);
                    UCPErrorHandler.throwUniversalConnectionPoolException(e);
                }
                catch (Throwable throwable) {
                    this.postGrowForBorrow(cri, connection, cs.isCreateConnectionInBorrowThread() || !growPending[0]);
                    throw throwable;
                }
                this.postGrowForBorrow(cri, connection, cs.isCreateConnectionInBorrowThread() || !growPending[0]);
            }
        }
        this.postGrowForBorrow(cri, connection, cs.isCreateConnectionInBorrowThread() || !growPending[0]);
        return connection;
    }

    private long getThrowableExpiryTimeout(long connectionWaitTimeout) {
        ConnectionSource cs = this.connectionSource();
        return Math.max(cs.getOutboundConnectTimeout(), Math.max(cs.getLoginTimeout(), connectionWaitTimeout));
    }

    private static Throwable unwrapDriverCause(Throwable throwable) {
        for (Throwable e = throwable; null != e; e = e.getCause()) {
            if (e instanceof UniversalConnectionPoolException) continue;
            return e;
        }
        return null;
    }

    Throwable getConnectionCreationCause(long connectionWaitTimeout) {
        long now;
        long stillValidTs;
        long ts;
        if (this.connectionSource().isCreateConnectionInBorrowThread()) {
            return null;
        }
        Throwable error = this.connectionCreationError[0];
        if (null != error && (ts = this.connectionCreationErrorTimestamp[0]) <= (stillValidTs = (now = Clock.clock()) + this.getThrowableExpiryTimeout(connectionWaitTimeout))) {
            return error;
        }
        return null;
    }

    CompletionStage<CoreConnection> growBorrowedAsync(ConnectionRetrievalInfo cri, long timeToRetry, boolean[] growContext, Executor executor) {
        CompletableFuture<CoreConnection> cf = new CompletableFuture<CoreConnection>();
        this.growBorrowedHelperAsync(cri, timeToRetry, growContext, executor).whenCompleteAsync((conn, e) -> {
            if (null != e) {
                this.pendingBorrowedGrows.getAndDecrement();
                cf.completeExceptionally((Throwable)e);
            } else {
                try {
                    this.postGrowForBorrow(cri, (CoreConnection)conn, true);
                    cf.complete((CoreConnection)conn);
                }
                catch (UniversalConnectionPoolException e2) {
                    cf.completeExceptionally(e2);
                }
            }
        }, executor);
        return cf;
    }

    private CompletionStage<CoreConnection> growBorrowedHelperAsync(ConnectionRetrievalInfo cri, long timeToRetry, boolean[] growContext, Executor executor) {
        int total = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
        if (this.noMoreGrows) {
            return CompletableFuture.completedFuture(null);
        }
        ConnectionSource cs = this.connectionSource();
        int borrowed = this.borrowedCount();
        boolean shareable = cs.isShareable();
        boolean multitenantDatabase = cs.isMultitenantDatabase();
        int min = this.limits().getMin();
        int max = this.limits().getMax();
        int repurposeThreshold = this.limits().getRepurposeThreshold();
        boolean repurposeAllowed = shareable && multitenantDatabase && total > min && total > repurposeThreshold && total > borrowed;
        boolean makeRoomAllowed = total > max && total > borrowed;
        this.trace(Level.FINEST, CLASS_NAME, "growBorrowed", "repurposeAllowed={0}, makeRoomAllowed={1}, shareable={2}, multitenantDatabase={3}, total={4}, borrowed={5}, min={6}, max={7}, repurposeThreshold={8}", null, null, repurposeAllowed, makeRoomAllowed, shareable, multitenantDatabase, total, borrowed, min, max, repurposeThreshold);
        String serviceName = this.connectionSource().serviceName(cri);
        if (repurposeAllowed) {
            return this.tryRepurposeAsync(cri, executor).thenApplyAsync(conn -> {
                if (Objects.nonNull(conn)) {
                    this.repurposeCount.getAndIncrement();
                }
                return conn;
            }, executor);
        }
        if (!cs.isServiceRegistered(serviceName)) {
            this.registerService(serviceName);
        }
        if (makeRoomAllowed) {
            return this.makeRoomAsync(cri, executor).thenComposeAsync(madeRoom -> {
                if (madeRoom.booleanValue()) {
                    growContext[0] = true;
                    return cs.createAsync(cri, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry, executor);
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        growContext[0] = true;
        return cs.createAsync(cri, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postGrowForBorrow(ConnectionRetrievalInfo cri, CoreConnection conn, boolean decrementBorrowedGrows) throws UniversalConnectionPoolException {
        block17: {
            try {
                if (Objects.nonNull(conn)) {
                    if (!this.connectionSource().isServiceRegistered(conn.serviceName())) {
                        this.registerService(conn.serviceName());
                    }
                    try {
                        conn.onBorrow(cri);
                    }
                    catch (UniversalConnectionPoolException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "postGrowBorrowed", "", null, e, new Object[0]);
                        conn.makeAvailable();
                        this.put(conn);
                        conn = null;
                        throw e;
                    }
                    conn.makeUnavailable();
                    this.put(conn);
                    this.peakBorrowedConnectionsCount.accumulate(this.borrowedCount());
                }
                if (!decrementBorrowedGrows) break block17;
                this.pendingBorrowedGrows.getAndDecrement();
            }
            catch (Throwable throwable) {
                if (decrementBorrowedGrows) {
                    this.pendingBorrowedGrows.getAndDecrement();
                }
                if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                    try {
                        this.stoppingLock.lock();
                        this.stoppingCondition.signal();
                    }
                    finally {
                        this.stoppingLock.unlock();
                    }
                }
                if (null != conn) {
                    this.trace(Level.FINEST, CLASS_NAME, "postGrowBorrowed", "conn={0}", null, null, conn);
                }
                throw throwable;
            }
        }
        if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.signal();
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
        if (null != conn) {
            this.trace(Level.FINEST, CLASS_NAME, "postGrowBorrowed", "conn={0}", null, null, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postAsyncGrowForBorrow(ConnectionRetrievalInfo cri, CoreConnection conn) {
        try {
            if (Objects.nonNull(conn)) {
                if (!this.connectionSource().isServiceRegistered(conn.serviceName())) {
                    this.registerService(conn.serviceName());
                }
                conn.makeAvailable();
                this.put(conn);
            }
            this.pendingBorrowedGrows.getAndDecrement();
        }
        catch (Throwable throwable) {
            this.pendingBorrowedGrows.getAndDecrement();
            if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
            if (null != conn) {
                this.trace(Level.FINEST, CLASS_NAME, "postAsyncGrowForBorrow", "conn={0}", null, null, conn);
            }
            throw throwable;
        }
        if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.signal();
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
        if (null != conn) {
            this.trace(Level.FINEST, CLASS_NAME, "postAsyncGrowForBorrow", "conn={0}", null, null, conn);
        }
    }

    final CompletionStage<CoreConnection> waitForAvailableAsync(ConnectionRetrievalInfo cri, long timeToWait) {
        CriStats criMetadata = this.connectionSource().getCriMetadata(cri);
        Executor waitExecutor = criMetadata.getWaitExecutor();
        CompletableFuture<CoreConnection> cf = new CompletableFuture<CoreConnection>();
        Supplier<CoreConnection> borrowSupplier = () -> {
            long remainingTime;
            long giveUpTimestamp = Clock.clock() + timeToWait;
            while ((remainingTime = giveUpTimestamp - Clock.clock()) > 0L) {
                CoreConnection conn;
                try {
                    conn = this.borrow(cri, remainingTime);
                }
                catch (UniversalConnectionPoolException e) {
                    cf.completeExceptionally(e);
                    break;
                }
                if (null == conn) continue;
                return conn;
            }
            return null;
        };
        CompletableFuture.supplyAsync(borrowSupplier, waitExecutor).orTimeout(timeToWait, TimeUnit.MILLISECONDS).whenComplete((conn, e) -> {
            if (cf.isCompletedExceptionally()) {
                return;
            }
            if (null != e) {
                if (null != conn) {
                    conn.makeAvailable();
                }
                cf.complete(null);
            } else {
                cf.complete((CoreConnection)conn);
            }
        });
        return cf;
    }

    private ConnectionSource.FailoverCallback prepareFailoverHandler(final String serviceName) {
        return new ConnectionSource.FailoverCallback(){

            @Override
            public ConnectionSource.FailoverCallback.Result handle(Predicate<CoreConnection> cleanupSelector, Predicate<CoreConnection> markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                Core.this.handlersLock.lock();
                try {
                    ConnectionSource.FailoverCallback.Result result = this.handleHelper(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup);
                    return result;
                }
                catch (Throwable e) {
                    Core.this.trace(Level.WARNING, CLASS_NAME, "prepareFailoverHandler", "", null, e, new Object[0]);
                    throw e;
                }
                finally {
                    Core.this.handlersLock.unlock();
                }
            }

            private ConnectionSource.FailoverCallback.Result handleHelper(Predicate<CoreConnection> cleanupSelector, Predicate<CoreConnection> markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                CoreConnection conn2;
                int[] count = new int[]{0};
                ConnectionSource.FailoverCallback.Result.ResultType resultType = ConnectionSource.FailoverCallback.Result.ResultType.FAILURE;
                int avail = Core.this.availableCount();
                int borrowed = Core.this.borrowedCount();
                int availMarkedDown = 0;
                int borrowedMarkedDown = 0;
                int[] availClosed = new int[]{0};
                int[] borrowedClosed = new int[]{0};
                int[] opened = new int[]{0};
                ConnectionSource cs = Core.this.connectionSource();
                Predicate<CoreConnection> serviceSelector = cs.serviceSelector(serviceName);
                Predicate<CoreConnection> availCleanupSelector = SelectorsUtil.availableSelector.and(serviceSelector).and(cleanupSelector);
                Predicate<CoreConnection> notAvailCleanupSelector = SelectorsUtil.notAvailableSelector.and(serviceSelector).and(cleanupSelector);
                Predicate<CoreConnection> anyCleanupSelector = serviceSelector.and(cleanupSelector);
                Predicate<CoreConnection> anyMerkupSelector = markedAlready.negate().and(serviceSelector).and(markupSelector);
                if (cs.isReplayable()) {
                    while (true) {
                        conn2 = Core.this.retrieveFirst(availCleanupSelector);
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "replayable: about to close conn={0}", null, null, conn2);
                        if (null == conn2) break;
                        conn2.close();
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "closed conn={0}", null, null, conn2);
                        if (restoreAfterCleanup) {
                            try {
                                Core.this.growAvailable(conn2.cri());
                                opened[0] = opened[0] + 1;
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareFailoverHandler", "", null, e, new Object[0]);
                            }
                        }
                        availClosed[0] = availClosed[0] + 1;
                        count[0] = count[0] + 1;
                    }
                    if (count[0] > 0) {
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: cleaned up {0} connections", null, null, count[0]);
                    }
                    count[0] = 0;
                    Core.this.forSome(notAvailCleanupSelector, conn -> {
                        conn.markReconnecting();
                        count[0] = count[0] + 1;
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "markreconnecting() done and put back conn={0}", null, null, conn);
                    });
                    if (count[0] > 0) {
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: marked for reconnecting {0} connections", null, null, count[0]);
                    }
                } else {
                    while (true) {
                        conn2 = Core.this.retrieveFirst(anyCleanupSelector);
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "about to close conn={0}", null, null, conn2);
                        if (null == conn2) break;
                        conn2.abort();
                        conn2.close();
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "closed conn={0}", null, null, conn2);
                        if (restoreAfterCleanup) {
                            try {
                                Core.this.growAvailable(conn2.cri());
                                opened[0] = opened[0] + 1;
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareFailoverHandler", "growAvailable hit exception:", null, e, new Object[0]);
                            }
                        }
                        if (conn2.available()) {
                            availClosed[0] = availClosed[0] + 1;
                        } else {
                            borrowedClosed[0] = borrowedClosed[0] + 1;
                        }
                        count[0] = count[0] + 1;
                    }
                }
                if (count[0] > 0) {
                    Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: cleaned up {0} connections", null, null, count[0]);
                }
                count[0] = 0;
                while (true) {
                    boolean[] marked = new boolean[]{false};
                    boolean[] av = new boolean[]{false};
                    Core.this.forFirst(anyMerkupSelector, conn -> {
                        if (isGracefulDraining) {
                            conn.markCloseOnReturn();
                        } else {
                            conn.markToReplace();
                        }
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: marked {0} connections", null, null, count[0]);
                        marked[0] = true;
                        av[0] = conn.available();
                    });
                    if (!marked[0]) break;
                    count[0] = count[0] + 1;
                    if (av[0]) {
                        ++availMarkedDown;
                        continue;
                    }
                    ++borrowedMarkedDown;
                    borrowedClosed[0] = borrowedClosed[0] + 1;
                }
                if (count[0] > 0) {
                    Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: marked to replace {0} connections", null, null, count[0]);
                }
                int beforeAvail = Core.this.availableCount();
                int beforeBorrowed = Core.this.borrowedCount();
                ConnectionSource.FailoverCallback.Result result = new ConnectionSource.FailoverCallback.Result();
                result.type = ConnectionSource.FailoverCallback.Result.ResultType.SUCCESS;
                result.availConns = Core.this.availableCount();
                result.borrowedConns = Core.this.borrowedCount();
                result.availOpened = opened[0] + Core.this.availableCount() > beforeAvail ? Core.this.availableCount() - beforeAvail : 0;
                result.availClosed = availClosed[0] + (beforeAvail > Core.this.availableCount() ? beforeAvail - Core.this.availableCount() : 0);
                result.borrowedClosed = borrowedClosed[0] + (beforeBorrowed > Core.this.borrowedCount() ? beforeBorrowed - Core.this.borrowedCount() : 0);
                Core.this.kickAdjuster();
                return result;
            }
        };
    }

    private ConnectionSource.RebalanceCallback prepareRebalanceHandler(final String serviceName) {
        return new ConnectionSource.RebalanceCallback(){

            @Override
            public ConnectionSource.RebalanceCallback.Result handle(final Predicate<CoreConnection> cleanupSelector, final Predicate<CoreConnection> markupSelector) {
                final ConnectionSource.RebalanceCallback.Result res = new ConnectionSource.RebalanceCallback.Result();
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private final Predicate<CoreConnection> serviceSelector;
                    private final Predicate<CoreConnection> gravitatorCleanupSelector;
                    private final Predicate<CoreConnection> gravitatorMarkupSelector;
                    {
                        this.serviceSelector = Core.this.connectionSource().serviceSelector(serviceName);
                        this.gravitatorCleanupSelector = this.serviceSelector.and(this.gravitatorSelector(cleanupSelector));
                        this.gravitatorMarkupSelector = this.serviceSelector.and(this.gravitatorSelector(markupSelector));
                    }

                    @Override
                    public void run() {
                        if (!Core.this.handlersLock.tryLock()) {
                            return;
                        }
                        try {
                            this.runHelper();
                        }
                        finally {
                            Core.this.handlersLock.unlock();
                        }
                    }

                    private Predicate<CoreConnection> gravitatorSelector(Predicate<CoreConnection> eitherCleanupOrMarkupSelector) {
                        return c -> {
                            boolean gravitate;
                            block1: {
                                gravitate = false;
                                if (!eitherCleanupOrMarkupSelector.test((CoreConnection)c)) break block1;
                                ServiceMember inst = c.serviceMember();
                                int delta = inst.connsToRebalance.get();
                                if (delta < 0 && inst.connsToRebalance.compareAndSet(delta, delta + 1)) {
                                    gravitate = true;
                                }
                            }
                            return gravitate;
                        };
                    }

                    private void runHelper() {
                        int maxLimit = Math.max(1, (Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get()) * 15 / 100);
                        int[] count = new int[]{0};
                        while (count[0] < maxLimit) {
                            if (res.terminate.get()) {
                                return;
                            }
                            CoreConnection conn2 = Core.this.retrieveFirst(this.gravitatorCleanupSelector);
                            if (null == conn2) break;
                            conn2.close();
                            try {
                                Core.this.growAvailable(conn2.cri());
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareRebalanceHandler", "", null, e, new Object[0]);
                            }
                            count[0] = count[0] + 1;
                        }
                        Core.this.forSome(this.gravitatorMarkupSelector, conn -> {
                            conn.markToReplace();
                            count[0] = count[0] + 1;
                        });
                        if (count[0] > 0) {
                            Core.this.trace(Level.FINE, CLASS_NAME, "prepareRebalanceHandler", "rebalanced {0} connection(s)", null, null, count[0]);
                        }
                        for (int j = Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get(); j < Core.this.getEffectiveMinPoolSize(); ++j) {
                            if (res.terminate.get()) {
                                return;
                            }
                            try {
                                Core.this.growAvailable(Core.this.policies().getMostPopularCri(), true);
                                Core.this.trace(Level.FINEST, CLASS_NAME, "prepareRebalanceHandler", "grew up one connection to reach the minimum", null, null, new Object[0]);
                                continue;
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareRebalanceHandler", "", null, e, new Object[0]);
                                break;
                            }
                        }
                        if (res.terminate.get()) {
                            return;
                        }
                        Core.this.adjustMaxLimit();
                    }
                });
                return res;
            }
        };
    }

    private CoreConnection findConnectionToRepurpose(ConnectionRetrievalInfo cri) {
        String serviceName;
        ConnectionSource cs = this.connectionSource();
        if (!cs.isServiceRegistered(serviceName = cs.serviceName(cri))) {
            return null;
        }
        if (0 == this.knownServices.size()) {
            return null;
        }
        Predicate<CoreConnection> retrievalSelector = SelectorsUtil.availableSelector.and(cs.serviceSelector(serviceName).negate());
        for (boolean balanced : new boolean[]{true, false}) {
            CoreConnection toRepurpose = this.retrieveFirst(retrievalSelector.and(cs.serviceBasedRepurposeSelector(cri, balanced)));
            if (Objects.nonNull(toRepurpose)) {
                this.trace(Level.FINEST, CLASS_NAME, "findConnectionToRepurpose", "successful rerurpose, conn={0}", null, null, toRepurpose);
                return toRepurpose;
            }
            this.trace(Level.FINEST, CLASS_NAME, "findConnectionToRepurpose", "unable to rerurpose", null, null, new Object[0]);
        }
        return null;
    }

    private CoreConnection tryRepurpose(ConnectionRetrievalInfo cri) {
        CoreConnection toRepurpose = this.findConnectionToRepurpose(cri);
        if (Objects.nonNull(toRepurpose)) {
            if (toRepurpose.repurpose(cri)) {
                return toRepurpose;
            }
            toRepurpose.close();
            return null;
        }
        return null;
    }

    private CompletionStage<CoreConnection> tryRepurposeAsync(ConnectionRetrievalInfo cri, Executor executor) {
        CoreConnection toRepurpose = this.findConnectionToRepurpose(cri);
        if (Objects.nonNull(toRepurpose)) {
            return toRepurpose.repurposeAsync(cri, executor).thenComposeAsync(wasRepurposed -> {
                if (wasRepurposed.booleanValue()) {
                    this.trace(Level.FINEST, CLASS_NAME, "tryRepurposeAsync", "was repurposed", null, null, new Object[0]);
                    return CompletableFuture.completedFuture(toRepurpose);
                }
                return toRepurpose.closeAsync(executor).thenApplyAsync(nil -> {
                    this.trace(Level.FINEST, CLASS_NAME, "tryRepurposeAsync", "was not repurposed and closed", null, null, new Object[0]);
                    return null;
                });
            }, executor);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean holdOverMakingRoom() {
        if (this.availableCount() == 0) {
            this.notAvailTS = Clock.clock();
            return true;
        }
        return Clock.clock() - this.notAvailTS < 120L;
    }

    private CoreConnection findConnectionToCloseToMakeRoom(ConnectionRetrievalInfo cri) {
        if (this.holdOverMakingRoom()) {
            return null;
        }
        this.trace(Level.FINEST, CLASS_NAME, "findConnectionToCloseToMakeRoom", "about to make room traversal", null, null, new Object[0]);
        ConnectionSource cs = this.connectionSource();
        try {
            Predicate<CoreConnection> optionsToGetRidSelector = SelectorsUtil.badSelector.or(SelectorsUtil.criUnmatchSelector(cri)).or(cs.routingKeyBasedBorrowSelector(cri, false).negate()).or(SelectorsUtil.wrongCostSelector(cri.getLabels()));
            Predicate<CoreConnection> retrievalSelector = SelectorsUtil.availableSelector.and(optionsToGetRidSelector);
            return this.retrieveFirst(retrievalSelector, false);
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "findConnectionToCloseToMakeRoom", "", null, e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeRoom(ConnectionRetrievalInfo cri) {
        this.makeRoomInProgress = true;
        try {
            CoreConnection toClose = this.findConnectionToCloseToMakeRoom(cri);
            if (Objects.nonNull(toClose)) {
                toClose.close();
                this.trace(Level.FINEST, CLASS_NAME, "makeRoom", "connection closed", null, null, new Object[0]);
                boolean bl = true;
                return bl;
            }
            this.trace(Level.FINEST, CLASS_NAME, "makeRoom", "makeRoom() was not able to find a connection to close", null, null, new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.makeRoomInProgress = false;
            this.kickAdjusterIfSuspended();
        }
    }

    private CompletionStage<Boolean> makeRoomAsync(ConnectionRetrievalInfo cri, Executor executor) {
        this.makeRoomAsyncInProgress = true;
        return this.makeRoomHelperAsync(cri, executor).whenCompleteAsync((res, e) -> {
            this.makeRoomAsyncInProgress = false;
            this.kickAdjusterIfSuspended();
        }, executor);
    }

    private CompletionStage<Boolean> makeRoomHelperAsync(ConnectionRetrievalInfo cri, Executor executor) {
        CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
        CoreConnection toClose = this.findConnectionToCloseToMakeRoom(cri);
        if (Objects.nonNull(toClose)) {
            return toClose.closeAsync(executor).thenApplyAsync(nil -> {
                this.trace(Level.FINEST, CLASS_NAME, "makeRoomHelperAsync", "connection closed", null, null, new Object[0]);
                return true;
            }, executor);
        }
        this.trace(Level.FINEST, CLASS_NAME, "makeRoomHelperAsync", "makeRoom() was not able to find a connection to close", null, null, new Object[0]);
        cf.complete(false);
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growAvailable(ConnectionRetrievalInfo cri, boolean useBestInstance) throws UniversalConnectionPoolException {
        CoreConnection conn = null;
        int total = this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.incrementAndGet();
        try {
            if (total > this.limits().getMax()) {
                return;
            }
            if (this.noMoreGrows) {
                return;
            }
            conn = this.connectionSource().create(cri.getCopyWithUpdatedPassword(), useBestInstance ? EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE) : EnumSet.noneOf(ConnectionSource.CreateMode.class), 0L);
            if (conn == null) {
                return;
            }
            if (!this.connectionSource().isServiceRegistered(conn.serviceName())) {
                this.registerService(conn.serviceName());
            }
            conn.makeAvailable();
            this.trace(Level.FINEST, CLASS_NAME, "growAvailable", "conn={0}", null, null, conn);
            this.put(conn);
            this.connectionCreationError[0] = null;
            this.connectionCreationErrorTimestamp[0] = 0L;
        }
        catch (UniversalConnectionPoolException e) {
            this.connectionCreationError[0] = e;
            this.connectionCreationErrorTimestamp[0] = Clock.clock();
            throw e;
        }
        finally {
            this.pendingAvailableGrows.getAndDecrement();
            if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
        }
    }

    private void growAvailable(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        this.growAvailable(cri, true);
    }

    final void growAvailableAsynch(final ConnectionRetrievalInfo cri) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

            @Override
            public void run() {
                try {
                    Core.this.growAvailable(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    Core.this.trace(Level.WARNING, CLASS_NAME, "growAvailableAsynch", "", null, e, new Object[0]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initialize() throws UniversalConnectionPoolException {
        this.initializeInProgress = true;
        final boolean[] succeeded = new boolean[]{true};
        final Throwable[] cause = new Throwable[]{null};
        try {
            int initPoolSize = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService()) - this.totalCount().get();
            final AtomicInteger connsToCreate = new AtomicInteger();
            UCPTaskBase<Boolean> task = new UCPTaskBase<Boolean>(){

                @Override
                public Boolean call() {
                    Core.this.trace(Level.FINEST, CLASS_NAME, "initialize", "launching init thread", null, null, new Object[0]);
                    while (connsToCreate.getAndDecrement() > 0 && Core.this.totalCount().get() < Core.this.limits().getInitial()) {
                        try {
                            CoreConnection conn;
                            ConnectionRetrievalInfo defaultCri = Core.this.connectionSource().defaultCriAndService();
                            String defaultSvcName = Core.this.connectionSource().serviceName(defaultCri);
                            if (!Core.this.connectionSource().isServiceRegistered(defaultSvcName)) {
                                Core.this.registerService(defaultSvcName);
                            }
                            if (null != (conn = Core.this.connectionSource().create(Core.this.policies().getMostPopularCri(), EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), 1000L))) {
                                conn.makeAvailable();
                                Core.this.put(conn);
                                Core.this.trace(Level.FINEST, CLASS_NAME, "initialize", "connection {0} successfully created", null, null, conn);
                                continue;
                            }
                            Core.this.trace(Level.WARNING, CLASS_NAME, "initialize", "connection not created", null, null, new Object[0]);
                        }
                        catch (UniversalConnectionPoolException e) {
                            Throwable c = e.getCause();
                            Core.this.connectionCreationError[0] = e;
                            Core.this.connectionCreationErrorTimestamp[0] = Clock.clock();
                            Core.this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                            if (c instanceof SQLRecoverableException) continue;
                            Core.this.trace(Level.FINEST, CLASS_NAME, "initialize", "failure", null, null, new Object[0]);
                            succeeded[0] = false;
                            cause[0] = e;
                            break;
                        }
                    }
                    return succeeded[0];
                }
            };
            try {
                connsToCreate.set(initPoolSize > 0 ? 1 : 0);
                if (!((Boolean)task.call()).booleanValue()) {
                    this.trace(Level.WARNING, CLASS_NAME, "initialize", "unable to start connection creation task", null, cause[0], new Object[0]);
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, cause[0]);
                }
                int maxInitThreads = Util.getMaxInitThreads();
                int initThreads = Math.min(Math.max(0, maxInitThreads), Math.max(0, initPoolSize));
                this.trace(Level.FINEST, CLASS_NAME, "initialize", "initPoolSize={0}, maxInitThreads={1}, initThreads={2}", null, null, initPoolSize, maxInitThreads, initThreads);
                connsToCreate.set(initPoolSize - 1);
                TaskHandle[] handles = new TaskHandle[initThreads];
                TaskManager tm = UniversalConnectionPoolManagerBase.getTaskManager();
                if (null == tm) {
                    this.trace(Level.WARNING, CLASS_NAME, "initialize", "task manager is not set", null, null, new Object[0]);
                }
                for (int i = 0; i < handles.length; ++i) {
                    TaskHandle taskHandle = handles[i] = null == tm ? null : tm.submitTask(task);
                    if (null != handles[i]) continue;
                    this.trace(Level.WARNING, CLASS_NAME, "initialize", "task manager is not running, so init pool size connections are being started in this thread", null, null, new Object[0]);
                    if (((Boolean)task.call()).booleanValue()) continue;
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, new IllegalStateException("unable to initialize connection", cause[0]));
                }
                for (TaskHandle handle : handles) {
                    if (null == handle) continue;
                    succeeded[0] = succeeded[0] && (Boolean)handle.get(0L) != false;
                }
            }
            catch (Exception e) {
                this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                UCPErrorHandler.throwUniversalConnectionPoolException(66, e);
            }
        }
        finally {
            this.initializeInProgress = false;
            this.kickAdjusterIfSuspended();
        }
        if (succeeded[0]) {
            return;
        }
        UCPErrorHandler.throwUniversalConnectionPoolException(66, cause[0].getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeAvailableInactive(long inactivityTimeout) {
        if (inactivityTimeout == 0L) {
            return;
        }
        boolean timersAffectAllConnections = Util.timersAffectAllConnections();
        this.closeInactiveInProgress = true;
        try {
            while (timersAffectAllConnections || !this.atOrBelowMinimums()) {
                CoreConnection conn = this.retrieveFirst(SelectorsUtil.inactiveSelector(inactivityTimeout));
                if (null == conn) {
                    break;
                }
                conn.close();
            }
        }
        finally {
            this.closeInactiveInProgress = false;
            this.kickAdjuster();
        }
    }

    final void reduce(ConnectionRetrievalInfo cri) {
        int htc = this.limits().getHarvestTriggerCount();
        int hmc = this.limits().getHarvestMaxCount();
        Predicate<CoreConnection> limitSelector = htc < Integer.MAX_VALUE ? p -> p.available() && this.totalCount().get() > this.getEffectiveMinPoolSize() && this.availableCount() > htc + hmc : p -> p.available() && this.totalCount().get() > this.getEffectiveMinPoolSize();
        CoreConnection conn = this.retrieveFirst(cri.criMatchSelector().and(limitSelector));
        if (null != conn) {
            conn.close();
        }
        this.kickAdjuster();
    }

    private boolean idle() {
        if (this.borrowedCount() != 0) {
            return false;
        }
        if (this.adjusterBusy.get()) {
            return true;
        }
        return this.pendingGrowsCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeNonReusable() {
        this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "timer triggered", null, null, new Object[0]);
        if (this.closeNonReusableByTimeInProgress) {
            return;
        }
        boolean timersAffectAllConnections = Util.timersAffectAllConnections();
        this.closeNonReusableByTimeInProgress = true;
        this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "processing started", null, null, new Object[0]);
        try {
            Predicate<CoreConnection> connToCloseSelector = conn -> conn.available() && !conn.reusable();
            if (!timersAffectAllConnections && this.atOrBelowMinimums()) {
                return;
            }
            CoreConnection conn2 = this.retrieveFirst(connToCloseSelector);
            if (null != conn2) {
                this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "about to close conn={0}", null, null, conn2);
                conn2.close();
                this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "closed conn={0}", null, null, conn2);
                if (this.belowMinimums()) {
                    try {
                        this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "about to grow", null, null, new Object[0]);
                        this.growAvailable(conn2.cri());
                        this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "grown one conn", null, null, new Object[0]);
                    }
                    catch (UniversalConnectionPoolException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "closeNonReusable", "growth failed", null, e, new Object[0]);
                    }
                }
            }
        }
        finally {
            this.trace(Level.FINEST, CLASS_NAME, "closeNonReusable", "ended", null, null, new Object[0]);
            this.closeNonReusableByTimeInProgress = false;
            this.kickAdjuster();
        }
    }

    final void replaceAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(false);
    }

    final void replaceInvalidAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvailable(boolean invalidOnly) throws UniversalConnectionPoolException {
        UniversalPooledConnection.ValidationType vtNetwork = UniversalPooledConnection.ValidationType.NETWORK;
        this.replaceAvailableInProgress = true;
        try {
            List<CoreConnection> closedConns = this.split(conn -> {
                if (!conn.available()) {
                    if (!invalidOnly) {
                        conn.markToReplace();
                    }
                    return false;
                }
                if (invalidOnly && ((UniversalPooledConnection)conn.getDelegate()).isValid(vtNetwork)) {
                    return false;
                }
                conn.close();
                return true;
            });
            for (CoreConnection connection : closedConns) {
                this.growAvailable(connection.cri());
            }
        }
        finally {
            this.replaceAvailableInProgress = false;
            this.kickAdjusterIfSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replaceBadConnections() throws UniversalConnectionPoolException {
        this.replaceBadConnectionsInProgress = true;
        try {
            List<CoreConnection> closedConns = this.split(conn -> {
                if (!conn.available()) {
                    return false;
                }
                if (conn.normal()) {
                    return false;
                }
                conn.close();
                return true;
            });
            for (CoreConnection connection : closedConns) {
                this.growAvailable(connection.cri());
            }
        }
        finally {
            this.replaceBadConnectionsInProgress = false;
        }
        this.kickAdjuster();
    }

    private boolean isGoodTimeForAdjuster() {
        return !this.makeRoomInProgress && !this.makeRoomAsyncInProgress && !this.initializeInProgress && !this.closeNonReusableByTimeInProgress && !this.closeNonReusableByCountInProgress && !this.closeInactiveInProgress && !this.replaceAvailableInProgress && !this.replaceBadConnectionsInProgress && !this.handleAbandonedTimeoutHandlerInProgress && !this.handleTimeToLiveTimeoutHandlerInProgress;
    }

    private void kickAdjusterIfSuspended() {
        if (this.adjusterSuspended) {
            try {
                this.kickAdjuster();
            }
            finally {
                this.adjusterSuspended = false;
            }
        }
    }

    void kickAdjuster() {
        if (!this.isGoodTimeForAdjuster()) {
            this.adjusterSuspended = true;
            return;
        }
        if (this.adjusterBusy.compareAndSet(false, true)) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    try {
                        Core.this.adjustLimits();
                    }
                    finally {
                        Core.this.adjusterBusy.set(false);
                    }
                }
            });
        }
    }

    int pendingAvailableGrows() {
        return this.pendingAvailableGrows.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleAbandonedTimeout(long timeout) {
        this.handleAbandonedTimeoutHandlerInProgress = true;
        try {
            for (CoreConnection conn : this.split(SelectorsUtil.abandonedSelector(timeout))) {
                conn.abort();
                conn.close();
                conn.setAbandonedConnectionTimeoutStatus(true);
            }
        }
        finally {
            this.handleAbandonedTimeoutHandlerInProgress = false;
            this.kickAdjuster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleTimeToLiveTimeout(long timeout) {
        this.handleTimeToLiveTimeoutHandlerInProgress = true;
        try {
            for (CoreConnection conn : this.split(SelectorsUtil.ttlSelector(timeout))) {
                conn.abort();
                conn.close();
                conn.setTimeToLiveConnectionTimeoutStatus(true);
            }
        }
        finally {
            this.handleTimeToLiveTimeoutHandlerInProgress = false;
            this.kickAdjuster();
        }
    }

    final void harvest(int triggerCount, int maxCount) {
        if (triggerCount >= 0 && triggerCount < Integer.MAX_VALUE && this.availableCount() <= triggerCount) {
            final int[] requestedConns = new int[]{maxCount};
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    for (int i = 0; i < 5 * requestedConns[0] && requestedConns[0] > 0; ++i) {
                        long[] oldestLastAccessedTime = new long[]{Clock.clock()};
                        boolean[] exhausted = new boolean[]{true};
                        Predicate<CoreConnection> notAvailableHarvestableSelector = SelectorsUtil.notAvailableSelector.and(SelectorsUtil.harvestableSelector());
                        Consumer<CoreConnection> consumer = conn -> {
                            long lastAccessedTime = conn.lastAccessedTime();
                            if (lastAccessedTime < oldestLastAccessedTime[0]) {
                                oldestLastAccessedTime[0] = lastAccessedTime;
                                exhausted[0] = false;
                            }
                        };
                        Core.this.forSome(notAvailableHarvestableSelector, consumer);
                        if (exhausted[0] || requestedConns[0] <= 0) break;
                        Predicate<CoreConnection> selector = notAvailableHarvestableSelector.and(c -> requestedConns[0] > 0);
                        Consumer<CoreConnection> consumer2 = conn -> {
                            long lacct = conn.lastAccessedTime();
                            if (lacct <= oldestLastAccessedTime[0]) {
                                conn.cleanupToHarvest();
                                conn.makeAvailable();
                                requestedConns2[0] = requestedConns[0] - 1;
                            }
                        };
                        Core.this.forSome(selector, consumer2);
                    }
                }
            });
        }
    }

    final boolean retrieve(CoreConnection conn) {
        Predicate<CoreConnection> retrievalSelector = this.connectionSource().serviceSelector(conn.serviceName()).and(SelectorsUtil.notAvailableSelector).and(c -> conn == c);
        return null != this.retrieveFirst(retrievalSelector);
    }

    final CoreConnection findSpecificConnection(Object physicalConn) {
        CoreConnection[] selectedConn = new CoreConnection[]{null};
        Predicate<CoreConnection> selector = SelectorsUtil.notAvailableSelector.and(SelectorsUtil.physicalSelector(physicalConn));
        this.forFirst(selector, conn -> {
            selectedConn[0] = conn;
        });
        return selectedConn[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPendingGrowsToFinish() {
        this.noMoreGrows = true;
        int GROWTH_CHECK_ATTEMPTS = 10;
        boolean pendingGrowsFinished = false;
        for (int attempts = 10; attempts > 0; --attempts) {
            if (0 == this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.get()) {
                pendingGrowsFinished = true;
                break;
            }
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.await(1L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "waitForPendingGrowsToFinish", "interrupted while waiting for pending connection creations to finish", null, e, new Object[0]);
                break;
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
        if (!pendingGrowsFinished) {
            this.trace(Level.INFO, CLASS_NAME, "waitForPendingGrowsToFinish", "waiting for 10 seconds for recent connection creation operations to be finished, these operations will be aborted", null, null, new Object[0]);
        }
    }

    private void enablePendingGrows() {
        this.noMoreGrows = false;
    }

    final void closeAll() {
        this.closeAll(0L);
    }

    final void closeAll(long timeout) {
        this.closeSome(Predicates.EVERY, timeout);
    }

    final void closeSome(Predicate<CoreConnection> connectionsToCloseSelector, long timeout) {
        Objects.requireNonNull(connectionsToCloseSelector);
        if (connectionsToCloseSelector.equals(Predicates.EVERY)) {
            this.peakConnectionsCount.reset();
            this.peakBorrowedConnectionsCount.reset();
            this.keepOverMinimum.set(false);
        }
        long giveUp = Clock.clock() + timeout;
        while (true) {
            boolean[] allClosed = new boolean[]{true};
            boolean over = Clock.clock() >= giveUp;
            Predicate<CoreConnection> cleanupSelector = conn -> {
                if (0L == timeout || conn.available() || over) {
                    if (!conn.available()) {
                        conn.abort();
                    }
                    conn.close();
                    return true;
                }
                allClosed[0] = false;
                return false;
            };
            this.split(connectionsToCloseSelector.and(cleanupSelector));
            if (allClosed[0] || over) break;
            this.trace(Level.WARNING, CLASS_NAME, "closeSome", "Attempted to close borrowed connections, waiting for {0} milliseconds", null, null, timeout);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void adjustLimits() {
        this.adjustMinAndMinIdleLimit(10);
        this.adjustMaxLimit();
    }

    private int getEffectiveMinPoolSize() {
        return this.keepOverMinimum.get() ? this.limits().getMin() : this.peakConnectionsCount.intValue();
    }

    private boolean isStillToAdjustMinAndMinIdleLimit() {
        int totalCount = this.totalCount().get();
        int availableCount = this.availableCount();
        int effectiveMinPoolSize = this.getEffectiveMinPoolSize();
        int pbg = this.pendingBorrowedGrows.get();
        int pag = this.pendingAvailableGrows.get();
        int minIdle = this.limits().getMinIdle();
        int maxPoolSize = this.limits().getMax();
        int dynamicTotal = totalCount + pbg + pag;
        int dynamicAvailable = availableCount + pag;
        return dynamicTotal < effectiveMinPoolSize || dynamicAvailable < minIdle && dynamicTotal < maxPoolSize;
    }

    void adjustMinAndMinIdleLimit(final int attempts) {
        Policies policies = this.policies();
        while (this.isStillToAdjustMinAndMinIdleLimit()) {
            if (!this.isGoodTimeForAdjuster()) {
                this.adjusterSuspended = true;
                break;
            }
            try {
                this.trace(Level.FINE, CLASS_NAME, "adjustMinAndMinIdleLimit", "growing...", null, null, new Object[0]);
                this.growAvailable(policies.getMostPopularCri(), attempts < 3);
                this.trace(Level.FINE, CLASS_NAME, "adjustMinAndMinIdleLimit", "grew up 1 connection to reach the minimum", null, null, new Object[0]);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "adjustMinAndMinIdleLimit", "", null, e, new Object[0]);
                break;
            }
        }
        if (this.isStillToAdjustMinAndMinIdleLimit() && attempts > 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "adjustMinAndMinIdleLimit", "", null, e, new Object[0]);
            }
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    Core.this.adjustMinAndMinIdleLimit(attempts - 1);
                }
            });
        }
    }

    void adjustMaxLimit() {
        if (this.maxLimitAdjuster.compareAndSet(false, true)) {
            try {
                int maxPoolSize = this.limits().getMax();
                while (this.totalCount().get() > maxPoolSize) {
                    CoreConnection conn = this.retrieveFirst(SelectorsUtil.availableSelector);
                    if (null == conn) {
                        break;
                    }
                    conn.close();
                    this.trace(Level.FINE, CLASS_NAME, "adjustMaxLimit", "closed one connection to stay under max limit", null, null, new Object[0]);
                }
            }
            finally {
                this.maxLimitAdjuster.set(false);
            }
        }
    }

    private Counter totalCount() {
        return this.connectionSource().totalCount();
    }

    private int borrowedCount() {
        return this.connectionSource().borrowedCount().get();
    }

    int availableCount() {
        return this.totalCount().get() - this.borrowedCount();
    }

    public long repurposeCount() {
        return this.repurposeCount.get();
    }

    private int pendingRequestsCount() {
        return this.connectionSource().pendingRequestsCount();
    }

    void start(ConnectionRetrievalInfo cri, boolean keepMetadataConn) throws UniversalConnectionPoolException {
        this.enablePendingGrows();
        final ConnectionSource cs = this.connectionSource();
        int initPoolSize = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService());
        Consumer<String> serviceRegistrator = serviceName -> {
            if (!cs.isServiceRegistered((String)serviceName)) {
                this.registerService((String)serviceName);
            }
        };
        Consumer<CoreConnection> coreConnectionConsumer = conn -> {
            conn.makeAvailable();
            this.trace(Level.FINEST, CLASS_NAME, "start", "conn={0}", null, null, conn);
            this.put((CoreConnection)conn);
        };
        cs.start(cri, serviceRegistrator, initPoolSize > 0 || keepMetadataConn ? coreConnectionConsumer : null);
        this.plugPolicies(new Policies(){

            @Override
            public ConnectionRetrievalInfo getMostPopularCri() {
                return cs.defaultCriAndService();
            }

            @Override
            public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
                return !cs.defaultCriAndService().equalsIncludingPassword(cri);
            }
        });
    }

    public static void stopAllRunningCores() {
        coreInstances.forEach((? super T p) -> {
            p.waitForPendingGrowsToFinish();
            p.closeAll(5000L);
            p.trace(Level.FINEST, CLASS_NAME, "shutdownHook", "{0}: pending grows finished gracefully", null, null, p.toString());
        });
    }

    void stop() {
        this.waitForPendingGrowsToFinish();
        this.closeAll(5000L);
        this.connectionSource().stop();
        this.knownServices.clear();
        coreInstances.remove(this);
    }

    int pendingGrowsCount() {
        return this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get();
    }

    boolean noMoreGrows() {
        return this.noMoreGrows;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

