/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionCreationInformation;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.OracleShardingKeyBuilderFactory;
import oracle.ucp.jdbc.UCPConnectionBuilder;

public interface PoolDataSource
extends DataSource,
Diagnosable {
    public static final String SYSTEM_PROPERTY_AFFINITY_STRICT = "oracle.ucp.jdbc.oracle.affinity.strict";
    public static final String SYSTEM_PROPERTY_MAX_INIT_THREADS = "oracle.ucp.MaxInitThreads";
    public static final String SYSTEM_PROPERTY_PRE_WLS1212_COMPATIBLE = "oracle.ucp.PreWLS1212Compatible";
    public static final String SYSTEM_PROPERTY_CONNECTION_CREATION_RETRY_DELAY = "oracle.ucp.ConnectionCreationRetryDelay";
    public static final String SYSTEM_PROPERTY_FAN_ENABLED = "oracle.jdbc.fanEnabled";
    public static final String SYSTEM_PROPERTY_BEGIN_REQUEST_AT_CONNECTION_CREATION = "oracle.jdbc.beginRequestAtConnectionCreation";
    public static final String SYSTEM_PROPERTY_XML_CONFIG_FILE = "oracle.ucp.jdbc.xmlConfigFile";
    public static final String SYSTEM_PROPERTY_DESTROY_ON_RELOAD = "oracle.ucp.destroyOnReload";
    public static final String SYSTEM_PROPERTY_IMITATE_ASYNC_BORROW = "oracle.ucp.imitateAsyncBorrow";
    public static final String SYSTEM_PROPERTY_SELFTUNING = "oracle.ucp.selftuning";
    public static final String SYSTEM_PROPERTY_WLS_JTA = "oracle.ucp.wls.jta";
    public static final String SYSTEM_PROPERTY_TIMERS_AFFECT_ALL_CONNECTIONS = "oracle.ucp.timersAffectAllConnections";
    public static final String SYSTEM_PROPERTY_DIAGNOSTIC_ENABLE_TRACE = "oracle.ucp.diagnostic.enableTrace";
    public static final String SYSTEM_PROPERTY_DIAGNOSTIC_ENABLE_LOGGING = "oracle.ucp.diagnostic.enableLogging";
    public static final String SYSTEM_PROPERTY_DIAGNOSTIC_BUFFER_SIZE = "oracle.ucp.diagnostic.bufferSize";
    public static final String SYSTEM_PROPERTY_DIAGNOSTIC_LOGGING_LEVEL = "oracle.ucp.diagnostic.loggingLevel";
    public static final String SYSTEM_PROPERTY_DIAGNOSTIC_ERROR_CODES_TO_WATCH_LIST = "oracle.ucp.diagnostic.errorCodesToWatchList";
    public static final String SYSTEM_PROPERTY_ENABLE_SHUTDOWN_HOOK = "oracle.ucp.enableShutdownHook";
    public static final String SYSTEM_PROPERTY_RLB_INOPERABILITY_TIMEOUT = "oracle.ucp.RLBInoperabilityTimeout";
    public static final String SYSTEM_PROPERTY_CREATE_CONNECTION_IN_BORROW_THREAD = "oracle.ucp.createConnectionInBorrowThread";
    public static final String UCP_USER = "user";
    public static final String UCP_URL = "url";
    public static final String UCP_PASSWORD = "password";
    public static final String UCP_SERVER_NAME = "serverName";
    public static final String UCP_PORT_NUMBER = "portNumber";
    public static final String UCP_DATABASE_NAME = "databaseName";
    public static final String UCP_DATA_SOURCE_NAME = "dataSourceName";
    public static final String UCP_DESCRIPTION = "description";
    public static final String UCP_NETWORK_PROTOCOL = "networkProtocol";
    public static final String UCP_ROLE_NAME = "roleName";
    public static final String UCP_CONNECTION_FACTORY_CLASS_NAME = "connectionFactoryClassName";
    public static final String UCP_CONNECTION_PROPERTIES = "connectionProperties";
    public static final String UCP_CONNECTION_FACTORY_PROPERTIES = "connectionFactoryProperties";
    public static final String UCP_VALIDATE_CONNECTION_ON_BORROW = "validateConnectionOnBorrow";
    public static final String UCP_SQL_FOR_VALIDATE_CONNECTION = "sqlForValidateConnection";
    public static final String UCP_CONNECTION_POOL_NAME = "connectionPoolName";
    public static final String UCP_INITIAL_POOL_SIZE = "initialPoolSize";
    public static final String UCP_MIN_POOL_SIZE = "minPoolSize";
    public static final String UCP_MIN_IDLE = "minIdle";
    public static final String UCP_MAX_POOL_SIZE = "maxPoolSize";
    public static final String UCP_NTH_RETURNED_CONNECTION_TO_VALIDATE = "nthReturnedConnectionToValidate";
    public static final String UCP_ABANDONED_CONNECTION_TIMEOUT = "abandonedConnectionTimeout";
    public static final String UCP_TIME_TO_LIVE_CONNECTION_TIMEOUT = "timeToLiveConnectionTimeout";
    public static final String UCP_INACTIVE_CONNECTION_TIMEOUT = "inactiveConnectionTimeout";
    public static final String UCP_MAX_IDLE_TIME = "maxIdleTime";
    public static final String UCP_TIMEOUT_CHECK_INTERVAL = "timeoutCheckInterval";
    public static final String UCP_PROPERTY_CYCLE = "propertyCycle";
    public static final String UCP_MAX_STATEMENTS = "maxStatements";
    public static final String UCP_CONNECTION_WAIT_TIMEOUT = "connectionWaitTimeout";
    public static final String UCP_CONNECTION_WAIT_TIMEOUT_WHILE_SERVICE_DOWN = "connectionWaitTimeoutWhileServiceDown";
    public static final String UCP_CONNECTION_WAIT_DURATION = "connectionWaitDuration";
    public static final String UCP_MAX_CONNECTION_REUSE_TIME = "maxConnectionReuseTime";
    public static final String UCP_MAX_CONNECTION_REUSE_COUNT = "maxConnectionReuseCount";
    public static final String UCP_CONNECTION_HARVEST_TRIGGER_COUNT = "connectionHarvestTriggerCount";
    public static final String UCP_CONNECTION_HARVEST_MAX_COUNT = "connectionHarvestMaxCount";
    public static final String UCP_FAST_CONNECTION_FAILOVER_ENABLED = "fastConnectionFailoverEnabled";
    public static final String UCP_ONS_CONFIGURATION = "onsConfiguration";
    public static final String UCP_SECONDS_TO_TRUST_IDLE_CONNECTION = "secondsToTrustIdleConnection";
    public static final String UCP_MAX_CONNECTIONS_PER_SERVICE = "maxConnectionsPerService";
    public static final String UCP_LOGIN_TIMEOUT = "loginTimeout";
    public static final String UCP_SERVICE_NAME = "serviceName";
    public static final String UCP_PDB_ROLES = "pdbRoles";
    public static final String UCP_CONNECTION_AFFINITY_CALLBACK = "connectionAffinityCallback";
    public static final String UCP_CONNECTION_INITIALIZATION_CALLBACK = "connectionInitializationCallback";
    public static final String UCP_CONNECTION_CREATION_CONSUMER = "connectionCreationConsumer";
    public static final String UCP_CONNECTION_LABELING_CALLBACK = "connectionLabelingCallback";
    public static final String UCP_CONNECTION_LABELING_HIGH_COST = "connectionLabelingHighCost";
    public static final String UCP_CONNECTION_REPURPOSE_THRESHOLD = "connectionRepurposeThreshold";
    public static final String UCP_HIGH_COST_CONNECTION_REUSE_THRESHOLD = "highCostConnectionReuseThreshold";
    public static final String UCP_DATA_SOURCE_FROM_CONFIGURATION = "dataSourceFromConfiguration";
    public static final String UCP_MAX_CONNECTIONS_PER_SHARD = "maxConnectionsPerShard";
    public static final String UCP_SHARDING_MODE = "shardingMode";
    public static final String UCP_CONNECTION_VALIDATION_TIMEOUT = "connectionValidationTimeout";
    public static final String UCP_READONLY_INSTANCE_ALLOWED = "readOnlyInstanceAllowed";
    public static final String UCP_CREATE_CONNECTION_IN_BORROW_THREAD = "createConnectionInBorrowThread";
    public static final String UCP_COMMIT_ON_CONNECTION_RETURN = "commitOnConnectionReturn";
    public static final String UCP_EVENT_LISTENER_PROVIDER = "ucpEventListenerProvider";
    public static final String UCP_FAIL_FAST_ON_CHUNK_UNAVAILABLE = "failFastOnChunkUnavailable";

    public int getInitialPoolSize();

    public void setInitialPoolSize(int var1) throws SQLException;

    public int getMinPoolSize();

    public void setMinPoolSize(int var1) throws SQLException;

    public int getMinIdle();

    public void setMinIdle(int var1) throws SQLException;

    public int getMaxPoolSize();

    public void setMaxPoolSize(int var1) throws SQLException;

    public int getInactiveConnectionTimeout();

    public void setInactiveConnectionTimeout(int var1) throws SQLException;

    public int getAbandonedConnectionTimeout();

    public void setAbandonedConnectionTimeout(int var1) throws SQLException;

    @Deprecated
    public int getConnectionWaitTimeout();

    public Duration getConnectionWaitDuration();

    @Deprecated
    public void setConnectionWaitTimeout(int var1) throws SQLException;

    public void setConnectionWaitDuration(Duration var1) throws SQLException;

    public long getConnectionWaitTimeoutWhileServiceDown();

    public void setConnectionWaitTimeoutWhileServiceDown(long var1) throws SQLException;

    public boolean getFailFastOnChunkUnavailable();

    public void setFailFastOnChunkUnavailable(boolean var1) throws SQLException;

    public int getTimeToLiveConnectionTimeout();

    public void setTimeToLiveConnectionTimeout(int var1) throws SQLException;

    public void setTimeoutCheckInterval(int var1) throws SQLException;

    public int getTimeoutCheckInterval();

    public void setFastConnectionFailoverEnabled(boolean var1) throws SQLException;

    public boolean getFastConnectionFailoverEnabled();

    public String getConnectionFactoryClassName();

    public void setConnectionFactoryClassName(String var1) throws SQLException;

    public void setMaxStatements(int var1) throws SQLException;

    public int getMaxStatements();

    public void setMaxIdleTime(int var1) throws SQLException;

    public int getMaxIdleTime();

    public String getUCPEventListenerProvider();

    public void setUCPEventListenerProvider(String var1) throws SQLException;

    public void setPropertyCycle(int var1) throws SQLException;

    public int getPropertyCycle();

    public void setConnectionPoolName(String var1) throws SQLException;

    public String getConnectionPoolName();

    public void setURL(String var1) throws SQLException;

    public String getURL();

    public void setUser(String var1) throws SQLException;

    public String getUser();

    public void setPassword(String var1) throws SQLException;

    @Deprecated
    default public String getPassword() {
        throw new NoSuchMethodError("this method is deprecated");
    }

    public void setServerName(String var1) throws SQLException;

    public String getServerName();

    public void setPortNumber(int var1) throws SQLException;

    public int getPortNumber();

    public void setDatabaseName(String var1) throws SQLException;

    public String getDatabaseName();

    public void setDataSourceName(String var1) throws SQLException;

    public String getDataSourceName();

    public void setDescription(String var1) throws SQLException;

    public String getDescription();

    public void setNetworkProtocol(String var1) throws SQLException;

    public String getNetworkProtocol();

    public void setRoleName(String var1) throws SQLException;

    public String getRoleName();

    public void setValidateConnectionOnBorrow(boolean var1) throws SQLException;

    public boolean getValidateConnectionOnBorrow();

    public void setSQLForValidateConnection(String var1) throws SQLException;

    public String getSQLForValidateConnection();

    public int getConnectionHarvestTriggerCount();

    public void setConnectionHarvestTriggerCount(int var1) throws SQLException;

    public int getConnectionHarvestMaxCount();

    public void setConnectionHarvestMaxCount(int var1) throws SQLException;

    public int getAvailableConnectionsCount() throws SQLException;

    public int getBorrowedConnectionsCount() throws SQLException;

    public String getONSConfiguration() throws SQLException;

    public void setONSConfiguration(String var1) throws SQLException;

    public Connection getConnection(Properties var1) throws SQLException;

    public Connection getConnection(String var1, String var2, Properties var3) throws SQLException;

    public void registerConnectionLabelingCallback(ConnectionLabelingCallback var1) throws SQLException;

    public void removeConnectionLabelingCallback() throws SQLException;

    public void registerConnectionAffinityCallback(ConnectionAffinityCallback var1) throws SQLException;

    public void removeConnectionAffinityCallback() throws SQLException;

    public Properties getConnectionProperties();

    public String getConnectionProperty(String var1);

    public void setConnectionProperty(String var1, String var2) throws SQLException;

    public void setConnectionProperties(Properties var1) throws SQLException;

    public Properties getConnectionFactoryProperties();

    public String getConnectionFactoryProperty(String var1);

    public void setConnectionFactoryProperty(String var1, String var2) throws SQLException;

    public void setConnectionFactoryProperties(Properties var1) throws SQLException;

    public long getMaxConnectionReuseTime();

    public void setMaxConnectionReuseTime(long var1) throws SQLException;

    public int getMaxConnectionReuseCount();

    public void setMaxConnectionReuseCount(int var1) throws SQLException;

    public JDBCConnectionPoolStatistics getStatistics();

    public void registerConnectionInitializationCallback(ConnectionInitializationCallback var1) throws SQLException;

    public void unregisterConnectionInitializationCallback() throws SQLException;

    public ConnectionInitializationCallback getConnectionInitializationCallback();

    default public void registerConnectionCreationConsumer(Consumer<ConnectionCreationInformation> consumer) {
        throw new NoSuchMethodError("Method not defined");
    }

    default public void unregisterConnectionCreationConsumer() {
        throw new NoSuchMethodError("Method not defined");
    }

    default public Consumer<ConnectionCreationInformation> getConnectionCreationConsumer() {
        throw new NoSuchMethodError("Method is not defined");
    }

    public int getConnectionLabelingHighCost();

    public void setConnectionLabelingHighCost(int var1) throws SQLException;

    public int getHighCostConnectionReuseThreshold();

    public void setHighCostConnectionReuseThreshold(int var1) throws SQLException;

    public UCPConnectionBuilder createConnectionBuilder();

    default public OracleShardingKeyBuilder createShardingKeyBuilder() {
        return OracleShardingKeyBuilderFactory.create();
    }

    public int getConnectionRepurposeThreshold();

    public void setConnectionRepurposeThreshold(int var1) throws SQLException;

    public Properties getPdbRoles();

    public String getServiceName();

    public int getSecondsToTrustIdleConnection();

    public void setSecondsToTrustIdleConnection(int var1) throws SQLException;

    public void reconfigureDataSource(Properties var1) throws SQLException;

    public int getMaxConnectionsPerService();

    public int getQueryTimeout();

    public void setQueryTimeout(int var1) throws SQLException;

    public int getMaxConnectionsPerShard();

    public void setMaxConnectionsPerShard(int var1) throws SQLException;

    public void setShardingMode(boolean var1) throws SQLException;

    public boolean getShardingMode();

    public void setConnectionValidationTimeout(int var1) throws SQLException;

    public int getConnectionValidationTimeout();

    public void setSSLContext(SSLContext var1);

    public void setHostnameResolver(HostnameResolver var1);

    public boolean isReadOnlyInstanceAllowed();

    public void setReadOnlyInstanceAllowed(boolean var1) throws SQLException;

    public void setTokenSupplier(Supplier<? extends AccessToken> var1) throws SQLException;

    public boolean isCreateConnectionInBorrowThread();

    public void setCreateConnectionInBorrowThread(boolean var1) throws SQLException;

    public boolean isCommitOnConnectionReturn();

    public void setCommitOnConnectionReturn(boolean var1) throws SQLException;

    @FunctionalInterface
    public static interface HostnameResolver {
        public InetAddress[] getAllByName(String var1) throws UnknownHostException;
    }
}

