/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.dms.console.DMSConsole;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.State;
import oracle.dms.instrument.StateIntf;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.actors.InterruptableActor;
import oracle.ucp.actors.RestartableExecutor;
import oracle.ucp.admin.MetricsUpdateTimerTask;
import oracle.ucp.admin.PoolMBeans;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.common.Clock;
import oracle.ucp.common.Core;
import oracle.ucp.common.DiagnosticsSummary;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollector;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.events.api.UCPEventListenerSelector;
import oracle.ucp.events.core.DefaultUCPEventContext;
import oracle.ucp.events.core.UCPEventContext;
import oracle.ucp.events.core.UCPEventListener;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.util.Strings;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskManagerImpl;
import oracle.ucp.util.UCPTimerManagerImpl;
import oracle.ucp.util.UniqueIdentifier;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

public abstract class UniversalConnectionPoolManagerBase
implements UniversalConnectionPoolManager,
Diagnosable {
    static final String CLASS_NAME = UniversalConnectionPoolManagerBase.class.getName();
    private static final boolean DEFAULT_IS_JMX_ENABLED = true;
    private static final boolean DEFAULT_LOCAL_METRIC_CONSOLE = true;
    private static final int DEFAULT_METRIC_UPDATE_INTERVAL = 60;
    private volatile boolean jmxFlag = true;
    private boolean m_localMetricConsole = true;
    private int m_metricInterval = 60;
    private static final String UCP_METRIC_NAME = "/UCP_METRIC";
    private static final String MGR_PREFIX = "UniversalConnectionPoolManager(" + UniversalConnectionPoolManagerBase.class.hashCode() + ")-";
    private DMSConsole m_metricConsole = null;
    private TimerHandle m_updateMetricTimer = null;
    private boolean m_metricsPostingThread = false;
    private UCPEventListener listener;
    private final PoolRegistry poolRegistry = new PoolRegistry();
    private static final Map<UCPMetric, String> m_ucpMetrics = Collections.synchronizedMap(new HashMap());
    private final Hashtable<String, NounIntf> m_parentNouns = new Hashtable();
    private final ArrayList<String> m_metricPools = new ArrayList();
    static final String TOTAL_CONN_NAME = "TotalConnectionsCount";
    static final String TOTAL_CONN_UNITS = "ConnectionsCount";
    static final String TOTAL_CONN_DESC = "Total number of connections in the pool";
    static final String AVAILABLE_CONN_NAME = "AvailableConnectionsCount";
    static final String AVAILABLE_CONN_UNITS = "ConnectionsCount";
    static final String AVAILABLE_CONN_DESC = "Total number of available connections in the pool";
    static final String BORROWED_CONN_NAME = "BorrowedConnectionsCount";
    static final String BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String BORROWED_CONN_DESC = "Total number of borrowed connections in the pool";
    static final String AVERAGE_BORROWED_CONN_NAME = "AverageBorrowedConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_DESC = "Average count for borrowed connections in the pool";
    static final String PEAK_CONN_NAME = "PeakConnectionsCount";
    static final String PEAK_CONN_UNITS = "ConnectionsCount";
    static final String PEAK_CONN_DESC = "Peak connections count in the pool";
    static final String REMAINING_CONN_NAME = "RemainingPoolCapacityCount";
    static final String REMAINING_CONN_UNITS = "ConnectionsCount";
    static final String REMAINING_CONN_DESC = "Remaining pool capacity count for the pool";
    static final String LABELED_CONN_NAME = "LabeledConnectionsCount";
    static final String LABELED_CONN_UNITS = "ConnectionsCount";
    static final String LABELED_CONN_DESC = "Total number of labeled connections in the pool";
    static final String CREATED_CONN_NAME = "ConnectionsCreatedCount";
    static final String CREATED_CONN_UNITS = "ConnectionsCount";
    static final String CREATED_CONN_DESC = "Total number of connections created in the pool";
    static final String CLOSED_CONN_NAME = "ConnectionsClosedCount";
    static final String CLOSED_CONN_UNITS = "ConnectionsCount";
    static final String CLOSED_CONN_DESC = "Total number of closed connections in the pool";
    static final String AVG_CONN_WAIT_NAME = "AverageConnectionWaitTime";
    static final String AVG_CONN_WAIT_UNITS = "Seconds";
    static final String AVG_CONN_WAIT_DESC = "Average connection wait time in the pool";
    static final String PEAK_CONN_WAIT_NAME = "PeakConnectionWaitTime";
    static final String PEAK_CONN_WAIT_UNITS = "Seconds";
    static final String PEAK_CONN_WAIT_DESC = "Peak Connection wait time in the pool";
    static final String ABANDONED_CONN_NAME = "AbandonedConnectionsCount";
    static final String ABANDONED_CONN_UNITS = "ConnectionsCount";
    static final String ABANDONED_CONN_DESC = "Total number of abandoned connections in the pool";
    static final String PENDING_REQUEST_NAME = "PendingRequestsCount";
    static final String PENDING_REQUEST_UNITS = "ConnectionsCount";
    static final String PENDING_REQUEST_DESC = "Total number of pending requests count in the pool";
    static final String CUMULATIVE_CONN_WAIT_NAME = "CumulativeConnectionWaitTime";
    static final String CUMULATIVE_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_WAIT_DESC = "Cumulative connection wait time for the pool";
    static final String CUMULATIVE_CONN_BORROWED_NAME = "CumulativeConnectionBorrowedCount";
    static final String CUMULATIVE_CONN_BORROWED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_BORROWED_DESC = "Cumulative connection borrowed count for the pool";
    static final String CUMULATIVE_CONN_USE_NAME = "CumulativeConnectionUseTime";
    static final String CUMULATIVE_CONN_USE_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_USE_DESC = "Cumulative connection use time for the pool";
    static final String CUMULATIVE_CONN_RETURNED_NAME = "CumulativeConnectionReturnedCount";
    static final String CUMULATIVE_CONN_RETURNED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_RETURNED_DESC = "Cumulative connection returned count in the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_NAME = "CumulativeSuccessfulConnectionWaitTime";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_DESC = "Cumulative successful connection wait time for the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME = "CumulativeSuccessfulConnectionWaitCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC = "Cumulative successful connection wait count for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_NAME = "CumulativeFailedConnectionWaitTime";
    static final String CUMULATIVE_FAILED_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_FAILED_CONN_WAIT_DESC = "Cumulative failed connection wait time for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME = "CumulativeFailedConnectionWaitCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC = "Cumulative failed connection wait count for the pool";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME = "SuccessfulAffinityBasedBorrowCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded with matching affinity contexts.";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_NAME = "FailedAffinityBasedBorrowCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests that returned connections not matching the affinity contexts.";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME = "SuccessfulRCLBBasedBorrowCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded using Runtime Connection Load-Balancing (RCLB) algorithms.";
    static final String FAILED_RCLBBASED_BORROW_COUNT_NAME = "FailedRCLBBasedBorrowCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests failed using Runtime Connection Load-Balancing (RCLB) algorithms.";
    private static volatile TimerManager timerManager = new UCPTimerManagerImpl();
    private final ReentrantLock poolLock = new ReentrantLock();
    private static volatile TaskManager taskManager = new UCPTaskManagerImpl();
    private static final RestartableExecutor shrinkingExecutor = new RestartableExecutor();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private static final Lock startStopExecutionEnvironmentLock;
    private static boolean executionEnvironmentStarted;

    public UniversalConnectionPoolManagerBase(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    private static UCPEventContext createEventContextFromPoolState(UniversalConnectionPoolBase pool) {
        Objects.requireNonNull(pool, "Pool cannot be null");
        return DefaultUCPEventContext.fromPool(pool);
    }

    private void fireUCPEventToListeners(UCPEventListener.EventType eventType, UCPEventContext ctx) {
        if (this.listener != null && this.listener.isDesiredEvent(eventType)) {
            this.listener.onUCPEvent(eventType, ctx);
        }
    }

    @Override
    public void startConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (pool != null) {
            pool.start();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void stopConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (pool != null) {
            pool.stop();
            if (this.m_metricPools.contains(this.poolRegistry.getIdByName(poolName))) {
                this.stopMetricsCollection(poolName);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void refreshConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (pool != null) {
            pool.refresh();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void recycleConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (pool != null) {
            pool.recycle();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void purgeConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (pool != null) {
            pool.purge();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void destroyConnectionPool(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        try {
            this.stopConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException ucpe) {
            this.trace(Level.WARNING, CLASS_NAME, "destroyConnectionPool", "", null, ucpe, new Object[0]);
        }
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (Objects.isNull(pool)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        } else {
            DiagnosticsCollector collector = (DiagnosticsCollector)pool.getDiagnosable();
            Objects.requireNonNull(collector).destroy();
        }
        PoolMBeans.destroyBean(poolName);
        this.poolRegistry.removeByName(poolName);
        this.listener = UCPEventListenerSelector.loadUcpEventListenerFromConfiguredProvider(pool.getUCPEventListenerProvider());
        UCPEventContext ctx = UniversalConnectionPoolManagerBase.createEventContextFromPoolState((UniversalConnectionPoolBase)pool);
        this.fireUCPEventToListeners(UCPEventListener.EventType.POOL_DESTROYED, ctx);
        if (this.poolRegistry.isEmpty()) {
            UniversalConnectionPoolManagerBase.stopExecutionEnvironment();
        }
    }

    @Override
    public void reconfigureConnectionPool(String poolName, Properties configuration) throws UniversalConnectionPoolException {
        String uniquePoolID = this.poolRegistry.getIdByName(poolName);
        try {
            this.applyConfiguration(uniquePoolID, configuration);
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(388, e);
        }
    }

    private void applyConfiguration(String uniquePoolID, Properties poolProperties) throws Exception {
        UniversalConnectionPoolBase pool;
        UniversalConnectionPoolBase universalConnectionPoolBase = pool = uniquePoolID != null ? (UniversalConnectionPoolBase)this.poolRegistry.getPoolByID(uniquePoolID) : null;
        if (pool != null) {
            String property = null;
            try {
                block83: for (Map.Entry<Object, Object> poolProperty : poolProperties.entrySet()) {
                    switch (property = (String)poolProperty.getKey()) {
                        case "user": 
                        case "password": 
                        case "url": 
                        case "connectionFactoryClassName": 
                        case "connectionFactoryProperties": 
                        case "connectionProperties": {
                            break;
                        }
                        case "initialPoolSize": {
                            pool.setInitialPoolSize(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "minPoolSize": {
                            pool.setMinPoolSize(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "minIdle": {
                            pool.setMinIdle(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxPoolSize": {
                            pool.setMaxPoolSize(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionReuseCount": {
                            pool.setMaxConnectionReuseCount(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionReuseTime": {
                            pool.setMaxConnectionReuseTime(Long.parseLong((String)poolProperty.getValue()));
                            break;
                        }
                        case "fastConnectionFailoverEnabled": {
                            pool.setFailoverEnabled(Boolean.parseBoolean((String)poolProperty.getValue()));
                            break;
                        }
                        case "abandonedConnectionTimeout": {
                            pool.setAbandonedConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionHarvestMaxCount": {
                            pool.setConnectionHarvestMaxCount(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionHarvestTriggerCount": {
                            pool.setConnectionHarvestTriggerCount(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "inactiveConnectionTimeout": {
                            pool.setInactiveConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionWaitTimeout": {
                            pool.setConnectionWaitTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionWaitTimeoutWhileServiceDown": {
                            pool.setConnectionWaitTimeoutWhileServiceDown(Long.parseLong((String)poolProperty.getValue()));
                        }
                        case "failFastOnChunkUnavailable": {
                            pool.setFailFastOnChunkUnavailable(Boolean.parseBoolean((String)poolProperty.getValue()));
                            break;
                        }
                        case "validateConnectionOnBorrow": {
                            pool.setValidateConnectionOnBorrow(Boolean.parseBoolean((String)poolProperty.getValue()));
                            break;
                        }
                        case "timeoutCheckInterval": {
                            pool.setTimeoutCheckInterval(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "propertyCycle": {
                            pool.setTimeoutCheckInterval(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "timeToLiveConnectionTimeout": {
                            pool.setTimeToLiveConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "highCostConnectionReuseThreshold": {
                            pool.setHighCostConnectionReuseThreshold(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionLabelingHighCost": {
                            pool.setConnectionLabelingHighCost(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "onsConfiguration": {
                            pool.setONSConfiguration((String)poolProperty.getValue());
                            break;
                        }
                        case "maxIdleTime": {
                            pool.setInactiveConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxStatements": {
                            if (!(pool instanceof JDBCConnectionPool)) continue block83;
                            ((JDBCConnectionPool)pool).setMaxStatements(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "sqlForValidateConnection": {
                            if (!(pool instanceof JDBCConnectionPool)) continue block83;
                            ((JDBCConnectionPool)pool).setSQLForValidateConnection((String)poolProperty.getValue());
                            break;
                        }
                        case "connectionInitializationCallback": {
                            if (!(pool instanceof JDBCConnectionPool)) continue block83;
                            try {
                                ((JDBCConnectionPool)pool).unregisterConnectionInitializationCallback();
                                String initializationClassName = (String)poolProperty.getValue();
                                if (initializationClassName == null || "".equals(initializationClassName)) continue block83;
                                Class<?> initializationClass = Class.forName(initializationClassName);
                                ConnectionInitializationCallback initializationObject = (ConnectionInitializationCallback)initializationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                ((JDBCConnectionPool)pool).registerConnectionInitializationCallback(initializationObject);
                                break;
                            }
                            catch (Exception e1) {
                                throw new IllegalArgumentException("Invalid property value " + property);
                            }
                        }
                        case "connectionLabelingCallback": {
                            try {
                                Class<?> c;
                                pool.removeConnectionLabelingCallback();
                                String labelingClassName = (String)poolProperty.getValue();
                                if (labelingClassName == null || "".equals(labelingClassName)) continue block83;
                                Class<?> labelingClass = c = Class.forName(labelingClassName);
                                ConnectionLabelingCallback labelingObject = (ConnectionLabelingCallback)labelingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                pool.registerConnectionLabelingCallback(labelingObject);
                                break;
                            }
                            catch (Exception e1) {
                                throw new IllegalArgumentException("Invalid property value " + property);
                            }
                        }
                        case "connectionAffinityCallback": {
                            try {
                                Class<?> c;
                                pool.removeConnectionAffinityCallback();
                                String affinityClassName = (String)poolProperty.getValue();
                                if (affinityClassName == null || "".equals(affinityClassName)) continue block83;
                                Class<?> affinityClass = c = Class.forName(affinityClassName);
                                ConnectionAffinityCallback affinityObject = (ConnectionAffinityCallback)affinityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                pool.registerConnectionAffinityCallback(affinityObject);
                                break;
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Invalid property value " + property);
                            }
                        }
                        case "loginTimeout": {
                            pool.setLoginTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "secondsToTrustIdleConnection": {
                            break;
                        }
                        case "connectionRepurposeThreshold": {
                            pool.setConnectionRepurposeThreshold(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionsPerService": {
                            pool.setMaxConnectionsPerService(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionsPerShard": {
                            pool.setMaxConnectionsPerShard(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid property name " + property);
                        }
                    }
                }
                if (poolProperties.containsKey("secondsToTrustIdleConnection")) {
                    pool.setSecondsToTrustIdleConnection(Integer.parseInt((String)poolProperties.get("secondsToTrustIdleConnection")));
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("invalid type set");
            }
        }
    }

    @Override
    public void createConnectionPool(UniversalConnectionPoolAdapter ucpAdapter) throws UniversalConnectionPoolException {
        if (ucpAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(383);
        }
        try {
            UniversalConnectionPool pool = ucpAdapter.createUniversalConnectionPool();
            Objects.requireNonNull(pool);
            if (!this.isJmxEnabled()) {
                this.setConnectionPool(pool);
            } else {
                PoolMBeans.getOrCreateBean(pool);
            }
        }
        catch (Exception exc) {
            UCPErrorHandler.throwUniversalConnectionPoolException(385, exc);
        }
    }

    @Override
    public void setConnectionPool(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        if (Objects.isNull(connectionPool)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        String poolName = connectionPool.getName();
        assert (!Strings.isNullOrEmpty(poolName));
        boolean isDestroyOnReloadEnabled = Util.isDestroyOnReloadEnabled();
        Consumer<UniversalConnectionPool> formerPoolConsumer = isDestroyOnReloadEnabled ? pool -> {
            try {
                Objects.requireNonNull(pool).stop();
                if (this.m_metricPools.contains(this.poolRegistry.getIdByName(poolName))) {
                    this.stopMetricsCollection(poolName);
                }
                DiagnosticsCollector collector = (DiagnosticsCollector)pool.getDiagnosable();
                Objects.requireNonNull(collector).destroy();
                PoolMBeans.destroyBean(poolName);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "setConnectionPool", "", null, e, new Object[0]);
            }
        } : null;
        boolean alreadyExisted = this.poolRegistry.put(connectionPool, poolName, formerPoolConsumer);
        if (!isDestroyOnReloadEnabled && alreadyExisted) {
            UCPErrorHandler.throwUniversalConnectionPoolException(350);
        }
    }

    @Override
    public UniversalConnectionPool getConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool = this.poolRegistry.getPoolByName(poolName);
        if (null == pool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        return pool;
    }

    @Override
    public String[] getConnectionPoolNames() {
        return this.poolRegistry.getNames();
    }

    protected void setManagerPoolID(String poolName, String newPoolName) throws UniversalConnectionPoolException {
        Objects.requireNonNull(poolName);
        Objects.requireNonNull(newPoolName);
        boolean oldPoolwasSet = this.poolRegistry.rename(poolName, newPoolName);
        if (!oldPoolwasSet) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        this.trace(Level.FINEST, CLASS_NAME, "setManagerPoolID", newPoolName, null, null, new Object[0]);
    }

    protected String getManagerPoolID(String poolName) throws UniversalConnectionPoolException {
        Objects.requireNonNull(poolName);
        String uniquePoolID = this.poolRegistry.getIdByName(poolName);
        if (null == uniquePoolID) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        return uniquePoolID;
    }

    private String[] getMetricPoolNames() throws UniversalConnectionPoolException {
        String[] sArray = this.m_metricPools.toArray(new String[this.m_metricPools.size()]);
        return sArray;
    }

    @Override
    public void startMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        block7: {
            this.poolLock.lock();
            try {
                if (poolName == null) {
                    throw UCPErrorHandler.newUniversalConnectionPoolException(54);
                }
                if (!this.isMetricConsoleAvailable()) break block7;
                try {
                    UniversalConnectionPool pool = this.getConnectionPool(poolName);
                    this.createMetricSensors(pool);
                    if (!this.m_metricsPostingThread) {
                        this.initupdateMetricTimer();
                    }
                }
                catch (UniversalConnectionPoolException ce) {
                    this.trace(Level.WARNING, CLASS_NAME, "startMetricsCollection", "", null, ce, new Object[0]);
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
    }

    private void createMetricSensors(UniversalConnectionPool pool) throws UniversalConnectionPoolException {
        if (null == pool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        NounIntf metricParentNoun = null;
        String poolName = pool.getName();
        String uniquePoolID = this.poolRegistry.getIdByName(poolName);
        Objects.requireNonNull(uniquePoolID);
        metricParentNoun = !this.m_localMetricConsole ? (poolName != null ? this.m_parentNouns.get(poolName) : null) : this.m_metricConsole.getNounFactory().create("/UCP_METRIC/" + poolName);
        if (!this.m_metricPools.contains(uniquePoolID)) {
            this.m_metricPools.add(uniquePoolID);
        }
        UniversalConnectionPoolStatistics stats = pool.getStatistics();
        StateIntf totalConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, TOTAL_CONN_NAME, (byte)3, "ConnectionsCount", TOTAL_CONN_DESC);
        totalConnectionsCount.deriveMetric(511);
        totalConnectionsCount.update(stats.getTotalConnectionsCount());
        StateIntf availableConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVAILABLE_CONN_NAME, (byte)3, "ConnectionsCount", AVAILABLE_CONN_DESC);
        availableConnectionsCount.deriveMetric(511);
        totalConnectionsCount.update(stats.getAvailableConnectionsCount());
        StateIntf borrowedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", BORROWED_CONN_DESC);
        borrowedConnectionsCount.deriveMetric(8);
        borrowedConnectionsCount.update(stats.getBorrowedConnectionsCount());
        StateIntf averageBorrowedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVERAGE_BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", AVERAGE_BORROWED_CONN_DESC);
        averageBorrowedConnectionsCount.update(stats.getAverageBorrowedConnectionsCount());
        StateIntf peakConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, PEAK_CONN_NAME, (byte)3, "ConnectionsCount", PEAK_CONN_DESC);
        peakConnectionsCount.update(stats.getPeakConnectionsCount());
        StateIntf remainingPoolCapacityCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, REMAINING_CONN_NAME, (byte)3, "ConnectionsCount", REMAINING_CONN_DESC);
        remainingPoolCapacityCount.deriveMetric(511);
        remainingPoolCapacityCount.update(stats.getRemainingPoolCapacityCount());
        StateIntf labeledConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, LABELED_CONN_NAME, (byte)3, "ConnectionsCount", LABELED_CONN_DESC);
        labeledConnectionsCount.deriveMetric(511);
        labeledConnectionsCount.update(stats.getLabeledConnectionsCount());
        StateIntf connectionsCreatedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CREATED_CONN_NAME, (byte)3, "ConnectionsCount", CREATED_CONN_DESC);
        connectionsCreatedCount.deriveMetric(511);
        connectionsCreatedCount.update(stats.getConnectionsCreatedCount());
        StateIntf connectionsClosedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CLOSED_CONN_NAME, (byte)3, "ConnectionsCount", CLOSED_CONN_DESC);
        connectionsClosedCount.deriveMetric(511);
        connectionsClosedCount.update(stats.getConnectionsClosedCount());
        StateIntf averageConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVG_CONN_WAIT_NAME, (byte)2, "Seconds", AVG_CONN_WAIT_DESC);
        averageConnectionWaitTime.update(stats.getAverageConnectionWaitTime());
        StateIntf peakConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, PEAK_CONN_WAIT_NAME, (byte)2, "Seconds", PEAK_CONN_WAIT_DESC);
        peakConnectionWaitTime.update(stats.getPeakConnectionWaitTime());
        StateIntf abandonedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, ABANDONED_CONN_NAME, (byte)3, "ConnectionsCount", ABANDONED_CONN_DESC);
        abandonedConnectionsCount.deriveMetric(511);
        abandonedConnectionsCount.update(stats.getAbandonedConnectionsCount());
        StateIntf pendingRequestsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, PENDING_REQUEST_NAME, (byte)3, "ConnectionsCount", PENDING_REQUEST_DESC);
        pendingRequestsCount.deriveMetric(511);
        pendingRequestsCount.update(stats.getPendingRequestsCount());
        StateIntf cumulativeConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_WAIT_DESC);
        cumulativeConnectionWaitTime.deriveMetric(511);
        cumulativeConnectionWaitTime.update(stats.getCumulativeConnectionWaitTime());
        StateIntf cumulativeConnectionBorrowedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_BORROWED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_BORROWED_DESC);
        cumulativeConnectionBorrowedCount.deriveMetric(511);
        cumulativeConnectionBorrowedCount.update(stats.getCumulativeConnectionBorrowedCount());
        StateIntf cumulativeConnectionUseTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_USE_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_USE_DESC);
        cumulativeConnectionUseTime.deriveMetric(511);
        cumulativeConnectionUseTime.update(stats.getCumulativeConnectionUseTime());
        StateIntf cumulativeConnectionReturnedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_RETURNED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_RETURNED_DESC);
        cumulativeConnectionReturnedCount.deriveMetric(511);
        cumulativeConnectionReturnedCount.update(stats.getCumulativeConnectionReturnedCount());
        StateIntf cumulativeSuccessfulConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_SUCCESS_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_SUCCESS_CONN_WAIT_DESC);
        cumulativeSuccessfulConnectionWaitTime.deriveMetric(511);
        cumulativeSuccessfulConnectionWaitTime.update(stats.getCumulativeSuccessfulConnectionWaitTime());
        StateIntf cumulativeSuccessfulConnectionWaitCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC);
        cumulativeSuccessfulConnectionWaitCount.deriveMetric(511);
        cumulativeSuccessfulConnectionWaitCount.update(stats.getCumulativeSuccessfulConnectionWaitCount());
        StateIntf cumulativeFailedConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_FAILED_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_FAILED_CONN_WAIT_DESC);
        cumulativeFailedConnectionWaitTime.deriveMetric(511);
        cumulativeFailedConnectionWaitTime.update(stats.getCumulativeFailedConnectionWaitTime());
        StateIntf cumulativeFailedConnectionWaitCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC);
        cumulativeFailedConnectionWaitCount.deriveMetric(511);
        cumulativeFailedConnectionWaitCount.update(stats.getCumulativeFailedConnectionWaitCount());
        if (pool instanceof OracleJDBCConnectionPool) {
            OracleJDBCConnectionPoolStatistics oracleStats = (OracleJDBCConnectionPoolStatistics)stats;
            StateIntf successfulAffinityBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC);
            successfulAffinityBasedBorrowCount.deriveMetric(511);
            successfulAffinityBasedBorrowCount.update(oracleStats.getSuccessfulAffinityBasedBorrowCount());
            StateIntf failedAffinityBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, FAILED_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_AFFINITYBASED_BORROW_COUNT_DESC);
            failedAffinityBasedBorrowCount.deriveMetric(511);
            failedAffinityBasedBorrowCount.update(oracleStats.getFailedAffinityBasedBorrowCount());
            StateIntf successfulRCLBBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC);
            successfulRCLBBasedBorrowCount.deriveMetric(511);
            successfulRCLBBasedBorrowCount.update(oracleStats.getSuccessfulRCLBBasedBorrowCount());
            StateIntf failedRCLBBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, FAILED_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_RCLBBASED_BORROW_COUNT_DESC);
            failedRCLBBasedBorrowCount.deriveMetric(511);
            failedRCLBBasedBorrowCount.update(oracleStats.getFailedRCLBBasedBorrowCount());
        }
    }

    void updateMetricSensors() throws UniversalConnectionPoolException {
        if (this.isMetricConsoleAvailable()) {
            try {
                String[] uniquePoolIDs = this.getMetricPoolNames();
                for (int i = 0; i < uniquePoolIDs.length; ++i) {
                    UniversalConnectionPool connectionPool = uniquePoolIDs[i] != null ? this.poolRegistry.getPoolByID(uniquePoolIDs[i]) : null;
                    this.updateMetricSensors(connectionPool);
                }
            }
            catch (UniversalConnectionPoolException e) {
                UCPErrorHandler.throwUniversalConnectionPoolException(377, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetricSensors(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        this.poolLock.lock();
        try {
            NounFactoryIntf nfi;
            if (connectionPool == null) {
                UCPErrorHandler.throwUniversalConnectionPoolException(351);
            }
            String poolName = connectionPool.getName();
            NounIntf metricParentNoun = null;
            if (!this.m_localMetricConsole) {
                metricParentNoun = poolName != null ? this.m_parentNouns.get(poolName) : null;
            } else if (null != this.m_metricConsole && null != (nfi = this.m_metricConsole.getNounFactory())) {
                metricParentNoun = nfi.get("/UCP_METRIC/" + poolName);
            }
            if (null != metricParentNoun) {
                UniversalConnectionPoolStatistics stats = connectionPool.getStatistics();
                assert (stats != null);
                ((State)metricParentNoun.getSensor(TOTAL_CONN_NAME)).update(stats.getTotalConnectionsCount());
                ((State)metricParentNoun.getSensor(AVAILABLE_CONN_NAME)).update(stats.getAvailableConnectionsCount());
                ((State)metricParentNoun.getSensor(BORROWED_CONN_NAME)).update(stats.getBorrowedConnectionsCount());
                ((State)metricParentNoun.getSensor(AVERAGE_BORROWED_CONN_NAME)).update(stats.getAverageBorrowedConnectionsCount());
                ((State)metricParentNoun.getSensor(PEAK_CONN_NAME)).update(stats.getPeakConnectionsCount());
                ((State)metricParentNoun.getSensor(REMAINING_CONN_NAME)).update(stats.getRemainingPoolCapacityCount());
                ((State)metricParentNoun.getSensor(LABELED_CONN_NAME)).update(stats.getLabeledConnectionsCount());
                ((State)metricParentNoun.getSensor(CREATED_CONN_NAME)).update(stats.getConnectionsCreatedCount());
                ((State)metricParentNoun.getSensor(CLOSED_CONN_NAME)).update(stats.getConnectionsClosedCount());
                ((State)metricParentNoun.getSensor(AVG_CONN_WAIT_NAME)).update(stats.getAverageConnectionWaitTime());
                ((State)metricParentNoun.getSensor(PEAK_CONN_WAIT_NAME)).update(stats.getPeakConnectionWaitTime());
                ((State)metricParentNoun.getSensor(ABANDONED_CONN_NAME)).update(stats.getAbandonedConnectionsCount());
                ((State)metricParentNoun.getSensor(PENDING_REQUEST_NAME)).update(stats.getPendingRequestsCount());
                ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_WAIT_NAME)).update(stats.getCumulativeConnectionWaitTime());
                ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_BORROWED_NAME)).update(stats.getCumulativeConnectionBorrowedCount());
                ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_USE_NAME)).update(stats.getCumulativeConnectionUseTime());
                ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_RETURNED_NAME)).update(stats.getCumulativeConnectionReturnedCount());
                ((State)metricParentNoun.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_NAME)).update(stats.getCumulativeSuccessfulConnectionWaitTime());
                ((State)metricParentNoun.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME)).update(stats.getCumulativeSuccessfulConnectionWaitCount());
                ((State)metricParentNoun.getSensor(CUMULATIVE_FAILED_CONN_WAIT_NAME)).update(stats.getCumulativeFailedConnectionWaitTime());
                ((State)metricParentNoun.getSensor(CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME)).update(stats.getCumulativeFailedConnectionWaitCount());
                if (connectionPool instanceof OracleJDBCConnectionPool) {
                    OracleJDBCConnectionPoolStatistics oracleStats = (OracleJDBCConnectionPoolStatistics)stats;
                    ((State)metricParentNoun.getSensor(SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleStats.getSuccessfulAffinityBasedBorrowCount());
                    ((State)metricParentNoun.getSensor(FAILED_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleStats.getFailedAffinityBasedBorrowCount());
                    ((State)metricParentNoun.getSensor(SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME)).update(oracleStats.getSuccessfulRCLBBasedBorrowCount());
                    ((State)metricParentNoun.getSensor(FAILED_RCLBBASED_BORROW_COUNT_NAME)).update(oracleStats.getFailedRCLBBasedBorrowCount());
                }
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private boolean isMetricConsoleAvailable() {
        boolean metricConsoleExists = false;
        if (this.m_metricConsole != null) {
            metricConsoleExists = true;
        } else {
            try {
                Util.getClassForName("oracle.dms.instrument.DMSConsole", true, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader());
                this.m_metricConsole = DMSConsole.getConsole();
                this.m_metricConsole.init(UCP_METRIC_NAME);
                metricConsoleExists = true;
            }
            catch (ClassNotFoundException cnf) {
                this.trace(Level.WARNING, CLASS_NAME, "isMetricConsoleAvailable", "", null, cnf, new Object[0]);
            }
            catch (SecurityException e) {
                this.trace(Level.WARNING, CLASS_NAME, "isMetricConsoleAvailable", "", null, e, new Object[0]);
            }
            catch (RuntimeException re) {
                this.trace(Level.WARNING, CLASS_NAME, "isMetricConsoleAvailable", "", null, re, new Object[0]);
            }
            catch (Exception e) {
                this.trace(Level.WARNING, CLASS_NAME, "isMetricConsoleAvailable", "", null, e, new Object[0]);
            }
        }
        return metricConsoleExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        block12: {
            this.poolLock.lock();
            try {
                if (poolName == null) {
                    throw UCPErrorHandler.newUniversalConnectionPoolException(54);
                }
                if (!this.isMetricConsoleAvailable()) break block12;
                try {
                    if (this.isMetricConsoleAvailable()) {
                        NounIntf metricParentNoun = null;
                        metricParentNoun = !this.m_localMetricConsole ? (poolName != null ? this.m_parentNouns.get(poolName) : null) : this.m_metricConsole.getNounFactory().get("/UCP_METRIC/" + poolName);
                        if (metricParentNoun != null) {
                            metricParentNoun.destroy();
                        }
                        String uniquePoolID = this.poolRegistry.getIdByName(poolName);
                        Objects.requireNonNull(uniquePoolID);
                        if (this.m_metricPools.contains(uniquePoolID)) {
                            this.m_metricPools.remove(uniquePoolID);
                        }
                        if (this.m_parentNouns.contains(poolName)) {
                            this.m_parentNouns.remove(poolName);
                        }
                        if (this.m_metricPools.size() == 0) {
                            this.disableupdateMetricTimer();
                            if (this.m_localMetricConsole) {
                                this.m_metricConsole.exit();
                            }
                            this.m_metricConsole = null;
                            this.m_localMetricConsole = true;
                        }
                    }
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(375, e);
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
    }

    @Override
    public void setMetricUpdateInterval(int metricInterval) throws UniversalConnectionPoolException {
        this.poolLock.lock();
        try {
            if (metricInterval < 0) {
                UCPErrorHandler.throwUniversalConnectionPoolException(6);
            }
            if (this.m_metricInterval != metricInterval) {
                this.disableupdateMetricTimer();
                this.m_metricInterval = metricInterval;
                if (this.m_metricConsole != null && this.m_metricInterval > 0) {
                    this.initupdateMetricTimer();
                }
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public int getMetricUpdateInterval() {
        return this.m_metricInterval;
    }

    @Override
    public void setJmxEnabled(boolean jmxFlag) {
        this.jmxFlag = jmxFlag;
    }

    @Override
    public boolean isJmxEnabled() {
        return this.jmxFlag;
    }

    private void initupdateMetricTimer() throws UniversalConnectionPoolException {
        if (this.m_metricInterval > 0) {
            try {
                this.m_updateMetricTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new MetricsUpdateTimerTask(this.diagnosticsCollector), 0L, this.m_metricInterval * 1000);
                this.m_metricsPostingThread = true;
            }
            catch (Exception exc) {
                UCPErrorHandler.throwUniversalConnectionPoolException(376, exc);
            }
        } else {
            this.m_updateMetricTimer = null;
        }
    }

    private void disableupdateMetricTimer() throws UniversalConnectionPoolException {
        if (this.m_updateMetricTimer != null) {
            this.m_updateMetricTimer.cancel();
            this.m_metricsPostingThread = false;
            this.m_updateMetricTimer = null;
        }
    }

    @Override
    public void setLogLevel(Level newLogLevel) {
        UCPLoggerFactory.setLogLevel(newLogLevel);
    }

    @Override
    public Level getLogLevel() {
        return UCPLoggerFactory.getLogLevel();
    }

    protected void setMetricConsole(DMSConsole metricConsole) {
        this.m_metricConsole = metricConsole;
        this.m_localMetricConsole = false;
    }

    protected void setMetricParentNoun(String poolName, NounIntf metricParentNoun) {
        this.m_parentNouns.put(poolName, metricParentNoun);
    }

    protected StateIntf getStateMetric(String poolName, UCPMetric ucpMetric) {
        NounIntf metricParentNoun;
        StateIntf stateMetric = null;
        NounIntf nounIntf = metricParentNoun = poolName != null ? this.m_parentNouns.get(poolName) : null;
        if (metricParentNoun != null) {
            stateMetric = (StateIntf)metricParentNoun.getSensor(m_ucpMetrics.get((Object)ucpMetric));
        }
        return stateMetric;
    }

    public static TimerManager getTimerManager() {
        return Objects.requireNonNull(timerManager);
    }

    public static boolean setTimerManager(TimerManager newTimerManager) {
        TimerManager oldTm = Objects.requireNonNull(timerManager);
        if (oldTm.isRunning()) {
            return false;
        }
        timerManager = Objects.requireNonNull(newTimerManager);
        return true;
    }

    public static TaskManager getTaskManager() {
        return Objects.requireNonNull(taskManager);
    }

    public static Executor getShrinkingExecutor() {
        return shrinkingExecutor;
    }

    public static boolean setTaskManager(TaskManager newTaskManager) {
        TaskManager oldTm = Objects.requireNonNull(taskManager);
        if (oldTm.isRunning()) {
            return false;
        }
        taskManager = Objects.requireNonNull(newTaskManager);
        return true;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public static void startExecutionEnvironment() {
        try {
            startStopExecutionEnvironmentLock.lock();
            if (!executionEnvironmentStarted) {
                InterruptableActor.start();
                Clock.start();
                shrinkingExecutor.start();
                UniversalConnectionPoolManagerBase.getTaskManager().start();
                UniversalConnectionPoolManagerBase.getTimerManager().start();
                executionEnvironmentStarted = true;
            }
        }
        finally {
            startStopExecutionEnvironmentLock.unlock();
        }
    }

    public static void stopExecutionEnvironment() {
        try {
            startStopExecutionEnvironmentLock.lock();
            if (executionEnvironmentStarted) {
                UniversalConnectionPoolManagerBase.getTimerManager().stop();
                shrinkingExecutor.stop();
                UniversalConnectionPoolManagerBase.getTaskManager().stop();
                Clock.stop();
                InterruptableActor.stop();
                executionEnvironmentStarted = false;
            }
        }
        finally {
            startStopExecutionEnvironmentLock.unlock();
        }
    }

    static {
        m_ucpMetrics.put(UCPMetric.TOTALCONNECTIONSCOUNT, TOTAL_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVAILABLECONNECTIONSCOUNT, AVAILABLE_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.BORROWEDCONNECTIONSCOUNT, BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGEBORROWEDCONNECTIONSCOUNT, AVERAGE_BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONSCOUNT, PEAK_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.REMAININGPOOLCAPACITYCOUNT, REMAINING_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.LABELEDCONNECTIONSCOUNT, LABELED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCREATEDCOUNT, CREATED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCLOSEDCOUNT, CLOSED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGECONNECTIONWAITTIME, AVG_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONWAITTIME, PEAK_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.ABANDONEDCONNECTIONSCOUNT, ABANDONED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PENDINGREQUESTSCOUNT, PENDING_REQUEST_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONWAITTIME, CUMULATIVE_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONBORROWEDCOUNT, CUMULATIVE_CONN_BORROWED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONUSETIME, CUMULATIVE_CONN_USE_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONRETURNEDCOUNT, CUMULATIVE_CONN_RETURNED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITTIME, CUMULATIVE_SUCCESS_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITTIME, CUMULATIVE_FAILED_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITCOUNT, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULAFFINITYBASEDBORROWCOUNT, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDAFFINITYBASEDBORROWCOUNT, FAILED_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULRCLBBASEDBORROWCOUNT, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDRCLBBASEDBORROWCOUNT, FAILED_RCLBBASED_BORROW_COUNT_NAME);
        if (Util.isShutdownHookEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                UniversalConnectionPoolManagerBase.startExecutionEnvironment();
                Core.stopAllRunningCores();
                String diagnosticsSummary = "<empty>";
                try {
                    diagnosticsSummary = DiagnosticsSummary.collect();
                }
                catch (UniversalConnectionPoolException e) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "addShutdownHook", "failed to collect diagnostics summary", null, null, e);
                }
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "addShutdownHook", diagnosticsSummary, null, null, new Object[0]);
                UniversalConnectionPoolManagerBase.stopExecutionEnvironment();
            }, "shutdown hook"));
        } else {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "shutdownHook", "The smooth shutdown was explicitly disabled and it is customer's \nresponsibility to explicitly roll back ongoing transactions on shutdown", null, null, null);
        }
        startStopExecutionEnvironmentLock = new ReentrantLock();
        executionEnvironmentStarted = false;
    }

    private static class PoolRegistry {
        private final Map<String, String> nameToIdMap = new HashMap<String, String>();
        private final Map<String, UniversalConnectionPool> idToPoolMap = new HashMap<String, UniversalConnectionPool>();
        private static final ReentrantLock lock = new ReentrantLock(false);

        private PoolRegistry() {
        }

        UniversalConnectionPool getPoolByName(String poolName) {
            if (Strings.isNullOrEmpty(poolName)) {
                throw new IllegalArgumentException();
            }
            lock.lock();
            try {
                UniversalConnectionPool universalConnectionPool = this.idToPoolMap.get(this.nameToIdMap.get(poolName));
                return universalConnectionPool;
            }
            finally {
                lock.unlock();
            }
        }

        UniversalConnectionPool getPoolByID(String poolID) {
            if (Strings.isNullOrEmpty(poolID)) {
                throw new IllegalArgumentException();
            }
            lock.lock();
            try {
                UniversalConnectionPool universalConnectionPool = this.idToPoolMap.get(poolID);
                return universalConnectionPool;
            }
            finally {
                lock.unlock();
            }
        }

        String getIdByName(String poolName) {
            if (Strings.isNullOrEmpty(poolName)) {
                throw new IllegalArgumentException();
            }
            lock.lock();
            try {
                String string = this.nameToIdMap.get(poolName);
                return string;
            }
            finally {
                lock.unlock();
            }
        }

        void removeByName(String poolName) {
            if (Strings.isNullOrEmpty(poolName)) {
                throw new IllegalArgumentException();
            }
            lock.lock();
            try {
                String poolID = this.nameToIdMap.remove(poolName);
                this.idToPoolMap.remove(poolID);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean put(UniversalConnectionPool pool, String poolName, Consumer<UniversalConnectionPool> matchingEntryConsumer) {
            UniversalConnectionPool formerPool;
            Objects.requireNonNull(pool);
            if (Strings.isNullOrEmpty(poolName)) {
                throw new IllegalArgumentException();
            }
            lock.lock();
            try {
                String formerID;
                if (Objects.isNull(matchingEntryConsumer)) {
                    formerID = null;
                    formerPool = null;
                    if (this.nameToIdMap.containsKey(poolName)) {
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    formerID = this.nameToIdMap.remove(poolName);
                    formerPool = Objects.isNull(formerID) ? null : this.idToPoolMap.remove(formerID);
                }
                String poolID = Objects.isNull(formerID) ? new UniqueIdentifier(MGR_PREFIX).toString() : formerID;
                this.nameToIdMap.put(poolName, poolID);
                this.idToPoolMap.put(poolID, pool);
            }
            finally {
                lock.unlock();
            }
            boolean alreadyExisted = Objects.nonNull(formerPool);
            if (alreadyExisted) {
                Objects.requireNonNull(matchingEntryConsumer).accept(formerPool);
            }
            return alreadyExisted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean rename(String oldPoolName, String newPoolName) {
            lock.lock();
            try {
                String poolId = this.nameToIdMap.remove(oldPoolName);
                UniversalConnectionPool pool = this.idToPoolMap.remove(poolId);
                if (Strings.isNullOrEmpty(poolId)) {
                    boolean bl = false;
                    return bl;
                }
                this.nameToIdMap.put(newPoolName, poolId);
                this.idToPoolMap.put(poolId, pool);
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        String[] getNames() {
            String[] names;
            lock.lock();
            try {
                names = this.nameToIdMap.keySet().toArray(new String[this.nameToIdMap.size()]);
            }
            finally {
                lock.unlock();
            }
            return names;
        }

        boolean isEmpty() {
            boolean empty;
            lock.lock();
            try {
                empty = this.nameToIdMap.isEmpty();
            }
            finally {
                lock.unlock();
            }
            return empty;
        }
    }

    public static enum UCPMetric {
        TOTALCONNECTIONSCOUNT,
        AVAILABLECONNECTIONSCOUNT,
        BORROWEDCONNECTIONSCOUNT,
        AVERAGEBORROWEDCONNECTIONSCOUNT,
        PEAKCONNECTIONSCOUNT,
        REMAININGPOOLCAPACITYCOUNT,
        LABELEDCONNECTIONSCOUNT,
        CONNECTIONSCREATEDCOUNT,
        CONNECTIONSCLOSEDCOUNT,
        AVERAGECONNECTIONWAITTIME,
        PEAKCONNECTIONWAITTIME,
        ABANDONEDCONNECTIONSCOUNT,
        PENDINGREQUESTSCOUNT,
        CUMULATIVECONNECTIONWAITTIME,
        CUMULATIVECONNECTIONBORROWEDCOUNT,
        CUMULATIVECONNECTIONUSETIME,
        CUMULATIVECONNECTIONRETURNEDCOUNT,
        CUMULATIVESUCCESSFULCONNECTIONWAITTIME,
        CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT,
        CUMULATIVEFAILEDCONNECTIONWAITTIME,
        CUMULATIVEFAILEDCONNECTIONWAITCOUNT,
        SUCCESSFULAFFINITYBASEDBORROWCOUNT,
        FAILEDAFFINITYBASEDBORROWCOUNT,
        SUCCESSFULRCLBBASEDBORROWCOUNT,
        FAILEDRCLBBASEDBORROWCOUNT,
        FCFDOWNEVENTPROCESSINGINFO;

    }
}

