/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.events.core;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.events.core.UCPEventContext;

public final class DefaultUCPEventContext
implements UCPEventContext {
    private static final long serialVersionUID = 1L;
    private final String poolName;
    private final long timestamp;
    private final int maxPoolSize;
    private final int minPoolSize;
    private final int borrowedConnectionsCount;
    private final int availableConnectionsCount;
    private final int totalConnections;
    private final int closedConnections;
    private final int createdConnections;
    private final long averageConnectionWaitTime;

    public DefaultUCPEventContext(String poolName, long timestamp, int maxPoolSize, int minPoolSize, int borrowedConnectionsCount, int availableConnectionsCount, int totalConnections, int closedConnections, int createdConnections, long averageConnectionWaitTime) {
        this.poolName = poolName;
        this.timestamp = timestamp;
        this.maxPoolSize = maxPoolSize;
        this.minPoolSize = minPoolSize;
        this.borrowedConnectionsCount = borrowedConnectionsCount;
        this.availableConnectionsCount = availableConnectionsCount;
        this.totalConnections = totalConnections;
        this.closedConnections = closedConnections;
        this.createdConnections = createdConnections;
        this.averageConnectionWaitTime = averageConnectionWaitTime;
    }

    public static UCPEventContext fromPool(UniversalConnectionPoolBase pool) {
        Objects.requireNonNull(pool, "Pool cannot be null");
        int closedCount = 0;
        int createdCount = 0;
        long avgWaitTime = 0L;
        if (pool.getStatistics() != null) {
            closedCount = pool.getStatistics().getConnectionsClosedCount();
            createdCount = pool.getStatistics().getConnectionsCreatedCount();
            avgWaitTime = pool.getStatistics().getAverageConnectionWaitTime();
        }
        return new DefaultUCPEventContext(pool.getName(), System.currentTimeMillis(), pool.getMaxPoolSize(), pool.getMinPoolSize(), pool.getBorrowedConnectionsCount(), pool.getAvailableConnectionsCount(), pool.getTotalConnectionsCount(), closedCount, createdCount, avgWaitTime);
    }

    @Override
    public String poolName() {
        return this.poolName;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int minPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public int borrowedConnectionsCount() {
        return this.borrowedConnectionsCount;
    }

    @Override
    public int availableConnectionsCount() {
        return this.availableConnectionsCount;
    }

    @Override
    public long getAverageConnectionWaitTime() {
        return this.averageConnectionWaitTime;
    }

    @Override
    public int totalConnections() {
        return this.totalConnections;
    }

    @Override
    public int closedConnections() {
        return this.closedConnections;
    }

    @Override
    public int createdConnections() {
        return this.createdConnections;
    }

    @Override
    public String formattedTimestamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy HH:mm:ss.SSS z").withLocale(Locale.ENGLISH).withZone(ZoneId.of("UTC"));
        return formatter.format(Instant.ofEpochMilli(this.timestamp));
    }

    public String toString() {
        return "DefaultUCPEventContext{poolName='" + this.poolName + "', timestamp=" + this.formattedTimestamp() + ", maxPoolSize=" + this.maxPoolSize + ", minPoolSize=" + this.minPoolSize + ", borrowedConnectionsCount=" + this.borrowedConnectionsCount + ", availableConnectionsCount=" + this.availableConnectionsCount + ", totalConnections=" + this.totalConnections + ", closedConnections=" + this.closedConnections + ", createdConnections=" + this.createdConnections + "}";
    }
}

