/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.SelectorsUtil;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.RingBuffer;
import oracle.ucp.util.Strings;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.Util;

public abstract class FailoverDriver
implements Diagnosable {
    static final String CLASS_NAME = FailoverDriver.class.getName();
    private final TaskManager taskManager;
    private AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final LinkedList<Event> recentHAEvents = new LinkedList();
    private static final long EVENT_AGE_OUT_PERIOD = 120000L;
    private UCPTimerTaskImpl delayedPlannedDownTimerTask = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private static final String FAN_STATUS_FIELD = "status";
    private static final Pattern ff_pg1 = Pattern.compile("(version|event_type|service|instance|database|db_domain|host|status|reason|card|drain_timeout)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
    private static final Pattern ff_pg2 = Pattern.compile("(timestamp)=\\s*(\\S+\\s\\S+)");
    private static final Pattern ff_pg3 = Pattern.compile("(timezone)=(.*)");
    private static final Pattern ff_pg4 = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2}");
    private static final Pattern ff_pg5 = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");

    FailoverDriver(Diagnosable diagnosticsCollector) {
        this(UniversalConnectionPoolManagerBase.getTaskManager(), diagnosticsCollector);
    }

    FailoverDriver() {
        this(UniversalConnectionPoolManagerBase.getTaskManager(), DiagnosticsCollectorImpl.getCommon());
    }

    FailoverDriver(TaskManager taskManager, Diagnosable diagnosticsCollector) {
        this.taskManager = taskManager;
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    FailoverDriver(TaskManager taskManager) {
        this(taskManager, DiagnosticsCollectorImpl.getCommon());
    }

    protected abstract ConnectionSource.FailoverCallback.Result onEvent(Event var1, Predicate<CoreConnection> var2, Predicate<CoreConnection> var3, boolean var4, boolean var5);

    protected abstract Service service();

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private Task<Object> prepareTask(ONSDriver oNSDriver) {
        try {
            void onsDriver;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "prepareTask", "entering args ({0})", null, null, oNSDriver);
            UCPTaskBase<Object> uCPTaskBase = new UCPTaskBase<Object>((ONSDriver)onsDriver){
                Subscriber subscriber = null;
                final /* synthetic */ ONSDriver val$onsDriver;
                {
                    this.val$onsDriver = oNSDriver;
                }

                @Override
                public boolean isCritical() {
                    return true;
                }

                @Override
                public void run() {
                    try {
                        this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){

                            @Override
                            public Subscriber run() throws UniversalConnectionPoolException {
                                try {
                                    return val$onsDriver.createSubscriber("((%\"eventType=database/event/service\")&($%'service=" + FailoverDriver.this.service().getFullServiceName() + "'))|(%\"eventType=database/event/host\")");
                                }
                                catch (Exception e) {
                                    FailoverDriver.this.trace(Level.WARNING, CLASS_NAME, "run", "ONS subscription hit exception:", null, e, new Object[0]);
                                    throw new UniversalConnectionPoolException(e);
                                }
                            }
                        });
                        if (null == this.subscriber) {
                            return;
                        }
                        this.handleNotifications();
                    }
                    catch (PrivilegedActionException e) {
                        FailoverDriver.this.trace(Level.WARNING, CLASS_NAME, "run", "", null, e, new Object[0]);
                    }
                    finally {
                        if (null != this.subscriber) {
                            this.subscriber.close();
                            this.subscriber = null;
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                private void handleNotifications() {
                    FailoverDriver.this.terminate.set(false);
                    while (true) {
                        block24: {
                            block23: {
                                block22: {
                                    block25: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        if (Thread.currentThread().isInterrupted() || FailoverDriver.this.terminate.get()) {
                                                            FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "terminated", null, null, new Object[0]);
                                                            return;
                                                        }
                                                        notification = this.subscriber.receive(true);
                                                        FailoverDriver.this.service().fdStats.currentEvent.set(null);
                                                        if (notification != null) break block18;
                                                        FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "empty notification", null, null, new Object[0]);
                                                        FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                                        continue;
                                                    }
                                                    nType = notification.type();
                                                    FailoverDriver.this.trace(Level.INFO, FailoverDriver.CLASS_NAME, "handleNotifications", "nType={0}", null, null, new Object[]{nType});
                                                    nBody = new String(notification.body());
                                                    FailoverDriver.this.trace(Level.INFO, FailoverDriver.CLASS_NAME, "handleNotifications", "nBody={0}", null, null, new Object[]{nBody});
                                                    event = notification.get("status") != null ? FailoverDriver.this.createEvent(notification) : FailoverDriver.this.parseNotification(nType.toLowerCase(), nBody.toLowerCase());
                                                    service = event.serviceName();
                                                    database = event.database();
                                                    hostname = event.host();
                                                    eventType = event.event_type();
                                                    FailoverDriver.this.service().fdStats.currentEvent.set(event);
                                                    if (!eventType.isOneOf(new Event.EventType[]{Event.EventType.INSTANCE, Event.EventType.SERVICEMEMBER, Event.EventType.SERVICE}) || !Strings.isNullOrEmpty(service) && !Strings.isNullOrEmpty(database)) break block19;
                                                    FailoverDriver.this.trace(Level.WARNING, FailoverDriver.CLASS_NAME, "handleNotifications", "invalid service event: not processed", null, null, new Object[0]);
                                                    FailoverDriver.this.service().fdStats.update(Stats.INVALID_EVENT_PROC_RESULT);
                                                    FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                                    continue;
                                                }
                                                if (!eventType.isOneOf(new Event.EventType[]{Event.EventType.NODE}) || !Strings.isNullOrEmpty(hostname)) break block20;
                                                FailoverDriver.this.trace(Level.WARNING, FailoverDriver.CLASS_NAME, "handleNotifications", "invalid host down event: not processed", null, null, new Object[0]);
                                                FailoverDriver.this.service().fdStats.update(Stats.INVALID_EVENT_PROC_RESULT);
                                                FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                                continue;
                                            }
                                            if (!FailoverDriver.this.filtered(event)) break block21;
                                            FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                            continue;
                                        }
                                        FailoverDriver.this.recentEvent = event;
                                        FailoverDriver.this.service().markup(event);
                                        FailoverDriver.this.trace(Level.FINEST, FailoverDriver.CLASS_NAME, "handleNotifications", event.toString(), null, null, new Object[0]);
                                        status = event.status();
                                        planned = event.isPlanned();
                                        instname = event.instance();
                                        failoverableSelector = (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$0(oracle.ucp.common.FailoverDriver$Event$EventType java.lang.String java.lang.String java.lang.String java.lang.String oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)((Event.EventType)eventType, (String)instname, (String)service, (String)hostname, (String)database);
                                        notFailoverableSelector = failoverableSelector.negate();
                                        plannedSelector = (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$1(boolean oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)((boolean)planned);
                                        notPlannedSelector = plannedSelector.negate();
                                        v0 = inst = eventType.isOneOf(new Event.EventType[]{Event.EventType.SERVICEMEMBER, Event.EventType.INSTANCE}) != false ? FailoverDriver.this.service().getMember(instname, event.database(), event.host(), event.serviceName()) : null;
                                        if (!status.isOneOf(new Event.Status[]{Event.Status.DOWN, Event.Status.NOT_RESTARTING, Event.Status.RESTART_FAILED})) break block25;
                                        drainingPeriod = event.drain_timeout() > 0 ? event.drain_timeout() : 0;
                                        FailoverDriver.this.service().setLastDrainTimeout(drainingPeriod);
                                        noOtherInstanceUp = FailoverDriver.this.service().activeMembersCount() == 0;
                                        timerMngr = UniversalConnectionPoolManagerBase.getTimerManager();
                                        v1 = noOtherInstanceUp != false ? FailoverDriver.this.service().activeCount() : (drainTotal = null == inst ? 0 : inst.activeCount.get());
                                        if (planned && drainingPeriod > 0 && timerMngr.isRunning()) {
                                            drainingTimerTask = new UCPTimerTaskImpl(){
                                                final int drainIntervals;
                                                final int countToDrainPerInterval;
                                                int countDrainedThisInterval;
                                                {
                                                    this.drainIntervals = (drainingPeriod + Util.PLANNED_DRAINING_INTERVAL - 1) / Util.PLANNED_DRAINING_INTERVAL;
                                                    this.countToDrainPerInterval = (drainTotal + this.drainIntervals - 1) / this.drainIntervals;
                                                    this.countDrainedThisInterval = 0;
                                                }

                                                @Override
                                                public void run() {
                                                    this.countDrainedThisInterval = 0;
                                                    Predicate<CoreConnection> p = conn -> this.countDrainedThisInterval < this.countToDrainPerInterval;
                                                    Predicate<CoreConnection> q = conn -> {
                                                        ++this.countDrainedThisInterval;
                                                        return true;
                                                    };
                                                    Predicate<CoreConnection> cleanupSelector = SelectorsUtil.availableSelector.and(p).and(failoverableSelector).and(q);
                                                    Predicate<CoreConnection> markupSelector = SelectorsUtil.notAvailableSelector.and(p).and(SelectorsUtil.normalSelector).and(failoverableSelector).and(q);
                                                    FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, cleanupSelector, markupSelector, true, false));
                                                }
                                            };
                                            if (noOtherInstanceUp) {
                                                FailoverDriver.this.delayedPlannedDownTimerTask = drainingTimerTask;
                                            } else {
                                                drainingTimerHandle = UniversalConnectionPoolManagerBase.getTimerManager().schedule(drainingTimerTask, 0L, (long)Util.PLANNED_DRAINING_INTERVAL * 1000L);
                                                UniversalConnectionPoolManagerBase.getTimerManager().schedule(new UCPTimerTaskImpl(){

                                                    @Override
                                                    public void run() {
                                                        drainingTimerHandle.cancel();
                                                        if (FailoverDriver.this.isGDS()) {
                                                            FailoverDriver.this.agingOutEvents();
                                                        }
                                                    }
                                                }, drainingPeriod * 1000 + 100, 0L);
                                            }
                                        } else {
                                            p = plannedSelector.and(SelectorsUtil.notAvailableSelector);
                                            q = notPlannedSelector.and(SelectorsUtil.reconnectingSelector);
                                            cleanupSelector = p.negate().and(q.negate()).and(failoverableSelector);
                                            r = notPlannedSelector.or(SelectorsUtil.availableSelector);
                                            markupSelector = r.negate().and(SelectorsUtil.normalSelector).and(failoverableSelector);
                                            FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, cleanupSelector, markupSelector, false, false));
                                        }
                                        ** GOTO lbl130
                                    }
                                    if (!status.isOneOf(new Event.Status[]{Event.Status.UP})) ** GOTO lbl121
                                    FailoverDriver.this.service().markConnCreationBrokerOperable();
                                    if (0 != FailoverDriver.this.service().activeMembersCount()) break block22;
                                    FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$2(oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)(), (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$3(oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)(), false, false));
                                    FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                    continue;
                                }
                                drainingPeriod = FailoverDriver.this.service().getLastDrainTimeout();
                                if (FailoverDriver.this.delayedPlannedDownTimerTask == null) break block23;
                                delayedPlannedDownTimerHandle = UniversalConnectionPoolManagerBase.getTimerManager().schedule(FailoverDriver.this.delayedPlannedDownTimerTask, 0L, (long)Util.PLANNED_DRAINING_INTERVAL * 1000L);
                                UniversalConnectionPoolManagerBase.getTimerManager().schedule(new UCPTimerTaskImpl(){

                                    @Override
                                    public void run() {
                                        delayedPlannedDownTimerHandle.cancel();
                                        if (FailoverDriver.this.isGDS()) {
                                            FailoverDriver.this.agingOutEvents();
                                        }
                                    }
                                }, drainingPeriod * 1000 + 100, 0L);
                                FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$4(oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)(), (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$5(oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)(), false, false));
                                FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                continue;
                            }
                            try {
                                block26: {
                                    total = FailoverDriver.this.service().connectionSource().totalCount().get();
                                    members = FailoverDriver.this.service().activeMembersCount();
                                    averageCount = total / members;
                                    count = new int[]{total - (members - 1) * averageCount};
                                    FailoverDriver.this.trace(Level.FINEST, FailoverDriver.CLASS_NAME, "handleNotifications", "total={0}, members={1}, averageCount={2}, count={3}", null, null, new Object[]{total, members, averageCount, count[0]});
                                    p = (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$6(int oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)((int)averageCount);
                                    q = (Predicate<CoreConnection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleNotifications$7(int[] oracle.ucp.common.CoreConnection ), (Loracle/ucp/common/CoreConnection;)Z)((int[])count);
                                    cleanupSelector = SelectorsUtil.availableSelector.and(notFailoverableSelector).and(p).and(q);
                                    markupSelector = SelectorsUtil.notAvailableSelector.and(notFailoverableSelector).and(p).and(q);
                                    FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, cleanupSelector, markupSelector, false, true));
                                    break block26;
lbl121:
                                    // 1 sources

                                    if (status.isOneOf(new Event.Status[]{Event.Status.NODEDOWN})) {
                                        p = plannedSelector.and(SelectorsUtil.notAvailableSelector);
                                        q = notPlannedSelector.and(SelectorsUtil.reconnectingSelector);
                                        cleanupSelector = p.negate().and(q.negate()).and(failoverableSelector);
                                        markupSelector = p.and(SelectorsUtil.normalSelector).and(failoverableSelector);
                                        FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, cleanupSelector, markupSelector, false, false));
                                    } else {
                                        FailoverDriver.this.trace(Level.FINEST, FailoverDriver.CLASS_NAME, "handleNotifications", "invalid event", null, null, new Object[0]);
                                    }
                                }
                                if (!FailoverDriver.this.isGDS()) break block24;
                                FailoverDriver.this.agingOutEvents();
                            }
                            catch (Throwable e) {
                                try {
                                    FailoverDriver.this.trace(Level.WARNING, FailoverDriver.CLASS_NAME, "handleNotifications", "", null, e, new Object[0]);
                                }
                                catch (Throwable var26_34) {
                                    FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                    throw var26_34;
                                }
                                FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                                continue;
                            }
                        }
                        FailoverDriver.this.trace(Level.FINE, FailoverDriver.CLASS_NAME, "handleNotifications", "event processed, snapshot: {0}", null, null, new Object[]{FailoverDriver.this.service().getAllMembers().toString()});
                        continue;
                        break;
                    }
                }

                private static /* synthetic */ boolean lambda$handleNotifications$7(int[] count, CoreConnection conn) {
                    int n = count[0];
                    count[0] = n - 1;
                    return n > 0;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$6(int averageCount, CoreConnection conn) {
                    return conn.serviceMember().activeCount.get() > averageCount;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$5(CoreConnection p) {
                    return false;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$4(CoreConnection p) {
                    return false;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$3(CoreConnection p) {
                    return false;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$2(CoreConnection p) {
                    return false;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$1(boolean planned, CoreConnection conn) {
                    return planned;
                }

                private static /* synthetic */ boolean lambda$handleNotifications$0(Event.EventType eventType, String instname, String service, String hostname, String database, CoreConnection conn) {
                    ServiceMember inst = conn.serviceMember();
                    if (null == inst) {
                        return false;
                    }
                    if (eventType.isOneOf(Event.EventType.INSTANCE, Event.EventType.SERVICEMEMBER)) {
                        return inst.name().equals(instname) && inst.service().equals(service) && inst.host().equals(hostname) && inst.database().equals(database);
                    }
                    if (eventType.isOneOf(Event.EventType.SERVICE)) {
                        return inst.service().equals(service) && inst.database().equals(database);
                    }
                    if (eventType.isOneOf(Event.EventType.NODE)) {
                        return inst.host().equals(hostname);
                    }
                    return false;
                }
            };
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "prepareTask", "returning {0}", null, null, uCPTaskBase);
            return uCPTaskBase;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "prepareTask", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private ConnectionSource.FailoverCallback.Result onEventX(Event event, Predicate<CoreConnection> cleanupSelector, Predicate<CoreConnection> markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
        this.service().pendingRebalance.getAndSet(new ConnectionSource.RebalanceCallback.Result()).terminate();
        return this.onEvent(event, cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup);
    }

    private Event createEvent(Notification n) {
        return new EventImpl(n);
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    Event parseNotification(String string, String string2) {
        try {
            void nTypeLowerCase;
            Matcher mg3;
            void nBodyLowerCase;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "parseNotification", "entering args ({0}, {1})", null, null, string, string2);
            Properties props = new Properties();
            Matcher mg1 = ff_pg1.matcher((CharSequence)nBodyLowerCase);
            while (mg1.find()) {
                props.setProperty(mg1.group(1), mg1.group(2));
            }
            Matcher mg2 = ff_pg2.matcher((CharSequence)nBodyLowerCase);
            if (mg2.find()) {
                if (ff_pg4.matcher(mg2.group(2)).find()) {
                    props.setProperty(mg2.group(1), mg2.group(2));
                } else {
                    throw new IllegalStateException("unaccepted timezone format: " + mg2.group(2));
                }
            }
            if ((mg3 = ff_pg3.matcher((CharSequence)nBodyLowerCase)).find()) {
                if (ff_pg5.matcher(mg3.group(2)).find()) {
                    props.setProperty(mg3.group(1), mg3.group(2));
                } else {
                    throw new IllegalStateException("unaccepted timezone format: " + mg3.group(2));
                }
            }
            EventImpl eventImpl = new EventImpl(props, (String)nTypeLowerCase);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "parseNotification", "returning {0}", null, null, eventImpl);
            return eventImpl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "parseNotification", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    ServiceMember underloadedInstance(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "underloadedInstance", "entering args ({0})", null, null, connectionRetrievalInfo);
            Event event = this.recentEvent;
            if (null == event) {
                ServiceMember serviceMember = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "underloadedInstance", "returning {0}", null, null, serviceMember);
                return serviceMember;
            }
            ServiceMember underloadedInstance = null;
            int maxdiff = 0;
            for (ServiceMember instance : this.service().getAllMembers((ConnectionRetrievalInfo)cri, true)) {
                int diff;
                int activeMembersCount;
                int desiredCount;
                if (!instance.active()) continue;
                int actualCount = instance.activeCount.get();
                if (actualCount >= (desiredCount = 0 == (activeMembersCount = this.service().activeMembersCount()) ? 0 : this.service().activeCount() / activeMembersCount) || (diff = desiredCount - actualCount) <= maxdiff) continue;
                maxdiff = diff;
                underloadedInstance = instance;
            }
            ServiceMember serviceMember = underloadedInstance;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "underloadedInstance", "returning {0}", null, null, serviceMember);
            return serviceMember;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "underloadedInstance", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean start(ONSDriver oNSDriver) {
        try {
            void onsDriver;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "start", "entering args ({0})", null, null, oNSDriver);
            if (this.task.compareAndSet(null, this.prepareTask((ONSDriver)onsDriver))) {
                this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
                this.trace(Level.FINEST, CLASS_NAME, "start", "FailoverDriver started", null, null, new Object[0]);
            }
            boolean bl = true;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "start", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    public void stop() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "stop", "entering args ()", null, null, new Object[0]);
            Task t = this.task.getAndSet(null);
            if (null != t) {
                block6: {
                    t.release();
                    this.terminate.set(true);
                    try {
                        TaskHandle th = this.taskHandle.getAndSet(null);
                        if (null != th) {
                            th.get(100000L);
                        }
                    }
                    catch (TaskManagerException e) {
                        if (e.getCause() instanceof CancellationException) break block6;
                        this.trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
                    }
                }
                this.trace(Level.FINEST, CLASS_NAME, "stop", "stopped", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "stop", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.FailoverDriver", "stop", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private boolean filtered(Event newEvent) {
        if (this.recentEvent != null && newEvent.timestamp().before(this.recentEvent.timestamp())) {
            this.trace(Level.WARNING, CLASS_NAME, "filtered", "Out-of-order HA event received and ignored", null, null, new Object[0]);
            this.service().fdStats.update(Stats.OUTOFORDER_EVENT_PROC_RESULT);
            return true;
        }
        Event.EventType type = newEvent.event_type();
        if (!type.isOneOf(Event.EventType.NODE, Event.EventType.UNKNOWN) && !newEvent.serviceName().equals(this.service().getFullServiceName())) {
            this.trace(Level.WARNING, CLASS_NAME, "filtered", "Non-Applicable HA event received and ignored: different service name", null, null, new Object[0]);
            return true;
        }
        if (!this.isGDS()) {
            return false;
        }
        Iterator<Event> iterator = this.recentHAEvents.descendingIterator();
        boolean foundRedundant = false;
        Event.EventType newType = newEvent.event_type();
        String newSvc = newEvent.serviceName();
        String newInst = newEvent.instance();
        String newDb = newEvent.database();
        String newHost = newEvent.host();
        Event.Status newStat = newEvent.status();
        if (newType.isOneOf(Event.EventType.INSTANCE, Event.EventType.SERVICEMEMBER, Event.EventType.SERVICE)) {
            if (Objects.nonNull((Object)newStat) && Strings.isNoneOfThemNull(newSvc, newDb, newHost)) {
                while (iterator.hasNext()) {
                    Event nextEvent = iterator.next();
                    String nextInstName = nextEvent.instance();
                    if (!newStat.equals((Object)nextEvent.status()) || !newSvc.equals(nextEvent.serviceName()) || !newDb.equals(nextEvent.database()) || !newHost.equals(nextEvent.host())) continue;
                    if (Objects.isNull(newInst)) {
                        if (Objects.isNull(nextInstName)) {
                            foundRedundant = true;
                        } else {
                            int activeMembers = this.service().activeMembersCount();
                            if (newStat.isOneOf(Event.Status.DOWN) && activeMembers < 1) {
                                foundRedundant = true;
                            }
                            if (newStat.isOneOf(Event.Status.UP) && activeMembers <= 1) {
                                foundRedundant = true;
                            }
                        }
                    } else {
                        if (Objects.isNull(nextInstName)) {
                            foundRedundant = true;
                        }
                        if (newInst.equals(nextInstName)) {
                            foundRedundant = true;
                        }
                    }
                    if (!foundRedundant) continue;
                    break;
                }
            }
        } else if (newType.isOneOf(Event.EventType.NODE)) {
            while (iterator.hasNext()) {
                Event nextEvent = iterator.next();
                if (newHost == null || !newHost.equals(nextEvent.host())) continue;
                foundRedundant = true;
                this.trace(Level.FINEST, CLASS_NAME, "filtered", "Redundant HA host event received and ignored", null, null, new Object[0]);
                break;
            }
        }
        if (foundRedundant) {
            this.service().fdStats.update(Stats.REDUNDANT_EVENT_PROC_RESULT);
            this.trace(Level.WARNING, CLASS_NAME, "filtered", "Redundant HA service event received and ignored: the event with the same set of instance, database, host and service has already arrived in less than 120000 milliseconds", null, null, new Object[0]);
        } else {
            this.recentHAEvents.addLast(newEvent);
        }
        return foundRedundant;
    }

    private boolean isGDS() {
        Service service = this.service();
        if (null == service) {
            return false;
        }
        String serviceName = service.getFullServiceName();
        if (null == serviceName) {
            return false;
        }
        return serviceName.contains("%");
    }

    private void agingOutEvents() {
        if (this.recentEvent != null) {
            Event nextEvent;
            long recentMilli = this.recentEvent.timestamp().getTime();
            while ((nextEvent = this.recentHAEvents.peekFirst()) != null && recentMilli > nextEvent.timestamp().getTime() + 120000L) {
                this.recentHAEvents.removeFirst();
            }
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public static class Stats
    extends RingBuffer<StatsOne> {
        final AtomicReference<Event> currentEvent = new AtomicReference<Object>(null);
        static final ConnectionSource.FailoverCallback.Result INVALID_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.INVALID_NOT_PROCESSED);
        static final ConnectionSource.FailoverCallback.Result REDUNDANT_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.REDUNDANT_NOT_PROCESSED);
        static final ConnectionSource.FailoverCallback.Result OUTOFORDER_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.OUTOFORDER_NOT_PROCESSED);

        void update(ConnectionSource.FailoverCallback.Result newResult) {
            Event evt = this.currentEvent.get();
            if (evt != null && newResult != null) {
                this.addItem(new StatsOne(evt, newResult));
            }
        }

        public String toStringProcessedOnly() {
            StringBuilder sb = new StringBuilder();
            List<StatsOne> list = this.getAsList();
            list.forEach(p -> {
                ConnectionSource.FailoverCallback.Result r = p.getResult();
                if (ConnectionSource.FailoverCallback.Result.ResultType.INVALID_NOT_PROCESSED != r.type && ConnectionSource.FailoverCallback.Result.ResultType.REDUNDANT_NOT_PROCESSED != r.type && ConnectionSource.FailoverCallback.Result.ResultType.OUTOFORDER_NOT_PROCESSED != r.type) {
                    sb.append(p.toString());
                }
            });
            return sb.toString();
        }
    }

    static class StatsOne {
        final Event event;
        final ConnectionSource.FailoverCallback.Result result;

        StatsOne(Event event, ConnectionSource.FailoverCallback.Result result) {
            this.event = Objects.requireNonNull(event);
            this.result = Objects.requireNonNull(result);
        }

        private Event getEvent() {
            return this.event;
        }

        private ConnectionSource.FailoverCallback.Result getResult() {
            return this.result;
        }

        private String reason() {
            Event.EventType type;
            Event event = this.getEvent();
            assert (Objects.nonNull(event));
            Event.Status status = event.status();
            String reason = event.reason();
            if (!Strings.isNullOrEmpty(reason) && status.isOneOf(Event.Status.DOWN) && (type = event.event_type()).isOneOf(Event.EventType.SERVICE, Event.EventType.SERVICEMEMBER, Event.EventType.NODE, Event.EventType.INSTANCE)) {
                return " <Reason:" + reason + ">";
            }
            return "";
        }

        private String targets() {
            Event event = this.getEvent();
            assert (Objects.nonNull(event));
            Event.Status status = event.status();
            Event.EventType type = event.event_type();
            return type.isOneOf(Event.EventType.NODE) && status.isOneOf(Event.Status.NODEDOWN, Event.Status.NODEUP) ? " <Host:\"" + event.host() + "\">" : " <Service:\"" + event.serviceName() + "\">" + " <Instance:\"" + event.instance() + "\">" + " <Db:\"" + event.database() + "\">";
        }

        private String counts() {
            ConnectionSource.FailoverCallback.Result r = this.getResult();
            return " Connections:" + "(Available=" + r.availConns + " Opened=" + r.availOpened + " FailedToProcess=" + r.availFailedToProcess + " MarkedDown=" + r.availMarkedDown + " Closed=" + r.availClosed + ")" + "(Borrowed=" + r.borrowedConns + " FailedToProcess=" + r.borrowedFailedToProcess + " MarkedDown=" + r.borrowedMarkedDown + " Closed=" + r.borrowedClosed + ")";
        }

        private String type() {
            Event event = this.getEvent();
            Event.EventType type = event.event_type();
            Event.Status status = event.status();
            Object sType = type.isOneOf(Event.EventType.SERVICE, Event.EventType.SERVICEMEMBER) ? (status.isOneOf(Event.Status.DOWN) ? "SERVICE_DOWN" : "SERVICE_UP") : (type.isOneOf(Event.EventType.NODE) ? (status.isOneOf(Event.Status.NODEDOWN) ? "HOST_DOWN" : "HOST_UP") : (type.isOneOf(Event.EventType.INSTANCE) ? (status.isOneOf(Event.Status.DOWN) ? "INSTANCE_DOWN" : "INSTANCE_UP") : type.toString() + "_" + status.toString()));
            return " <Type:" + (String)sType + ">";
        }

        public String toString() {
            Event event = this.getEvent();
            ConnectionSource.FailoverCallback.Result r = this.getResult();
            switch (r.type) {
                case INVALID_NOT_PROCESSED: 
                case REDUNDANT_NOT_PROCESSED: 
                case OUTOFORDER_NOT_PROCESSED: {
                    return DateFormat.getDateTimeInstance(2, 3).format(event.timestamp()) + " " + (Object)((Object)r.type) + this.reason() + this.type() + this.targets();
                }
            }
            return "{" + DateFormat.getDateTimeInstance(2, 3).format(event.timestamp()) + " " + (Object)((Object)r.type) + this.reason() + this.type() + this.targets() + this.counts() + "}\n";
        }
    }

    private class EventImpl
    implements Event,
    Diagnosable {
        private final String version;
        private final String service;
        private Event.EventType event_type;
        private final String database;
        private final String instance;
        private final String host;
        private final String db_domain;
        private final String reason;
        private final Event.Status status;
        private final boolean isPlanned;
        private final boolean isTypeHost;
        private final boolean isTypeService;
        private final int cardinality;
        private final int drain_timeout;
        private Date timestamp;

        EventImpl(Notification n) {
            this.version = n.get("VERSION");
            this.service = Strings.toLowerCase(n.get("service"));
            String etype = Strings.toLowerCase(n.get("event_type"));
            this.event_type = Event.EventType.parse(etype == null ? "UNKNOWN" : etype);
            this.database = Strings.toLowerCase(n.get("database"));
            this.instance = Strings.toLowerCase(n.get("instance"));
            this.host = Strings.toLowerCase(n.get("host"));
            this.db_domain = Strings.toLowerCase(n.get("db_domain"));
            String r = Strings.toLowerCase(n.get("reason"));
            this.reason = r == null ? "" : r;
            String stat = Strings.toLowerCase(n.get(FailoverDriver.FAN_STATUS_FIELD));
            this.status = Event.Status.parse(stat == null ? "down" : stat);
            String nTypeLowerCase = Strings.toLowerCase(n.type());
            this.isPlanned = "user".equalsIgnoreCase(this.reason);
            this.isTypeHost = "database/event/host".equals(nTypeLowerCase);
            this.isTypeService = "database/event/service".equals(nTypeLowerCase);
            String card = n.get("card");
            this.cardinality = Integer.parseInt(card == null ? "0" : card);
            String timeout = n.get("drain_timeout");
            this.drain_timeout = Integer.parseInt(timeout == null ? "0" : timeout);
            this.checkEventType();
            String tsprop = n.get("timestamp");
            String ts = tsprop == null ? "" : tsprop;
            String tzprop = n.get("timezone");
            String tz = tzprop == null ? "" : tzprop;
            this.initializeTimestamp(ts, tz);
        }

        EventImpl(Properties props, String nTypeLowerCase) {
            this.version = props.getProperty("version");
            this.service = props.getProperty("service");
            this.event_type = Event.EventType.parse(props.getProperty("event_type", "UNKNOWN"));
            this.database = props.getProperty("database");
            this.instance = props.getProperty("instance");
            this.host = props.getProperty("host");
            this.db_domain = props.getProperty("db_domain");
            this.reason = props.getProperty("reason", "");
            this.status = Event.Status.parse(props.getProperty(FailoverDriver.FAN_STATUS_FIELD, "down"));
            this.isPlanned = "user".equals(this.reason);
            this.isTypeHost = "database/event/host".equals(nTypeLowerCase);
            this.isTypeService = "database/event/service".equals(nTypeLowerCase);
            this.cardinality = Integer.parseInt(props.getProperty("card", "0"));
            this.drain_timeout = Integer.parseInt(props.getProperty("drain_timeout", "0"));
            this.checkEventType();
            String ts = props.getProperty("timestamp", "");
            String tz = props.getProperty("timezone", "");
            this.initializeTimestamp(ts, tz);
        }

        private void checkEventType() {
            if (this.event_type.isOneOf(Event.EventType.UNKNOWN)) {
                if (this.isTypeHost) {
                    this.event_type = Event.EventType.NODE;
                } else if (this.isTypeService) {
                    this.event_type = null == this.instance ? Event.EventType.SERVICE : Event.EventType.SERVICEMEMBER;
                }
                this.trace(Level.FINEST, CLASS_NAME, "checkEventType", "derived event type is {0}", null, null, new Object[]{this.event_type});
            }
            if (this.event_type.isOneOf(Event.EventType.SERVICEMEMBER, Event.EventType.INSTANCE) && Strings.isAtLeastOneNull(this.version, this.service, this.host, this.database, this.instance)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
            if (this.event_type.isOneOf(Event.EventType.SERVICE) && Strings.isAtLeastOneNull(this.version, this.service, this.host, this.database)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
            if (this.event_type.isOneOf(Event.EventType.NODE) && Strings.isAtLeastOneNull(this.version, this.host)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
        }

        private void initializeTimestamp(String ts, String tz) {
            if ("".equals(ts) && !"".equals(tz)) {
                throw new IllegalStateException("single timezone (without timestamp) is not allowed");
            }
            if ("".equals(ts)) {
                this.timestamp = new Date();
            } else {
                try {
                    this.timestamp = "".equals(tz) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ts) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse(ts + " GMT" + tz);
                }
                catch (ParseException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        public String toString() {
            return "isTypeService=" + this.isTypeService + ", version=" + this.version() + ", service=" + this.serviceName() + ", event_type=" + (Object)((Object)this.event_type()) + ", db_domain=" + this.db_domain() + ", instance=" + this.instance() + ", host=" + this.host() + ", database=" + this.database() + ", status=" + (Object)((Object)this.status()) + ", isPlanned=" + this.isPlanned() + ", cardinality=" + this.cardinality() + ", drain_timeout=" + this.drain_timeout() + ", timestamp=" + this.timestamp();
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public String serviceName() {
            return this.service;
        }

        @Override
        public Event.EventType event_type() {
            return this.event_type;
        }

        @Override
        public String database() {
            return this.database;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public String db_domain() {
            return this.db_domain;
        }

        @Override
        public String reason() {
            return this.reason;
        }

        @Override
        public Event.Status status() {
            return this.status;
        }

        @Override
        public boolean isPlanned() {
            return this.isPlanned;
        }

        @Override
        public int cardinality() {
            return this.cardinality;
        }

        @Override
        public Date timestamp() {
            return this.timestamp;
        }

        @Override
        public int drain_timeout() {
            return this.drain_timeout;
        }

        @Override
        public Diagnosable getDiagnosable() {
            return FailoverDriver.this.diagnosticsCollector;
        }
    }

    public static interface Event {
        public static final String NTYPE_SERVICE = "database/event/service";
        public static final String NTYPE_HOST = "database/event/host";

        public String version();

        public String database();

        public String serviceName();

        public EventType event_type();

        public String instance();

        public String host();

        public String db_domain();

        public Status status();

        public boolean isPlanned();

        public String reason();

        public int cardinality();

        public Date timestamp();

        public int drain_timeout();

        public static enum Status {
            DOWN,
            NOT_RESTARTING,
            RESTART_FAILED,
            UP,
            NODEDOWN,
            NODEUP;


            static Status parse(String status) {
                for (Status s : Status.values()) {
                    if (!s.toString().toLowerCase().equals(status)) continue;
                    return s;
                }
                throw new IllegalStateException("unknown status " + status);
            }

            boolean isOneOf(Status ... statuses) {
                return Arrays.stream(statuses).anyMatch(p -> p == this);
            }
        }

        public static enum EventType {
            DATABASE,
            INSTANCE,
            SERVICE,
            SERVICEMEMBER,
            NODE,
            UNKNOWN;


            static EventType parse(String eventType) {
                for (EventType e : EventType.values()) {
                    if (!e.toString().toLowerCase().equals(eventType)) continue;
                    return e;
                }
                return UNKNOWN;
            }

            boolean isOneOf(EventType ... eventTypes) {
                return Arrays.stream(eventTypes).anyMatch(p -> p == this);
            }
        }
    }
}

