/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import oracle.ucp.common.ConnectionSource;
import oracle.ucp.diagnostics.Diagnosable;

public class ConnectionWaitTimeout
implements Diagnosable {
    static final String CLASS_NAME = ConnectionWaitTimeout.class.getName();
    private final Diagnosable diagnosticsCollector;
    private final boolean currentCreateConnectionInBorrowThread;
    private final long outboundConnectTimeout;
    private final long waitTimeoutWhileServiceDown;
    private final ConnectionSource connectionSource;
    private final boolean isServiceDownTimeoutEnabled;
    private volatile boolean isOutageDetected;

    ConnectionWaitTimeout(ConnectionSource connectionSource, Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = diagnosticsCollector;
        this.outboundConnectTimeout = connectionSource.getOutboundConnectTimeout();
        this.connectionSource = connectionSource;
        this.isOutageDetected = false;
        this.currentCreateConnectionInBorrowThread = connectionSource.isCreateConnectionInBorrowThread();
        this.waitTimeoutWhileServiceDown = connectionSource.getConnectionWaitTimeoutWhileServiceDown() * 1000L;
        this.isServiceDownTimeoutEnabled = this.waitTimeoutWhileServiceDown > 0L;
    }

    void markOutageDetected(boolean isOutage) {
        if (this.isServiceDownTimeoutEnabled) {
            this.isOutageDetected = isOutage;
        }
    }

    public boolean isOutageDetected() {
        return this.isOutageDetected;
    }

    public long updatedGiveUpTimestamp(long connectionWaitTimeout, long initialGiveUp) {
        if (this.isServiceDownTimeoutEnabled) {
            long adjustedInitialCwd = this.getAdjustedCwd(connectionWaitTimeout);
            return initialGiveUp + Math.max(0L, this.waitTimeoutWhileServiceDown - adjustedInitialCwd);
        }
        return initialGiveUp;
    }

    long getAdjustedCwd(long cwd) {
        return this.currentCreateConnectionInBorrowThread ? Math.max(cwd, this.outboundConnectTimeout) : cwd;
    }

    long getConnectionWaitTimeout() {
        return this.connectionSource.getConnectionWaitDurationInMillis();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

