/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.driver.utils.WalletLocation;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jndi.JndiAttrs;
import oracle.net.ns.NetException;
import oracle.net.resolver.EnvVariableResolver;

public class EZConnectResolver {
    private static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s%s%s)";
    private static final String ADDRESS_LIST_FORMAT = "(ADDRESS_LIST=(LOAD_BALANCE=ON)%s)";
    private static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s)%s)";
    private static final String HTTPS_PROXY_FORMAT = "(HTTPS_PROXY=%s)";
    private static final String HTTPS_PROXY_PORT_FORMAT = "(HTTPS_PROXY_PORT=%s)";
    private static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s%s%s%s%s)";
    private static final String SERVICE_NAME_FORMAT = "(SERVICE_NAME=%s)";
    private static final String SERVER_MODE_FORMAT = "(SERVER=%s)";
    private static final String INSTANCE_NAME_FORMAT = "(INSTANCE_NAME=%s)";
    private static final String SERVICE_TAG_FORMAT = "(SERVICE_TAG=%s)";
    private static final String POOL_CONNECTION_CLASS_FORMAT = "(POOL_CONNECTION_CLASS=%s)";
    private static final String POOL_PURITY_FORMAT = "(POOL_PURITY=%s)";
    private static final String CONNECTION_ID_PREFIX_FORMAT = "(CONNECTION_ID_PREFIX=%s)";
    private static final String SECURITY_FORMAT = "(SECURITY=%s)";
    private static final String SERVER_DN_MATCH_FORMAT = "(SSL_SERVER_DN_MATCH=%s)";
    private static final String SERVER_DN_FORMAT = "(SSL_SERVER_CERT_DN=%s)";
    private static final String MY_WALLET_DIR_FORMAT = "(MY_WALLET_DIRECTORY=%s)";
    private static final String ENCRYPTION_CLIENT_FORMAT = "(ENCRYPTION_CLIENT=%s)";
    private static final String ENCRYPTION_TYPES_CLIENT_FORMAT = "(ENCRYPTION_TYPES_CLIENT=%s)";
    private static final String CRYPTO_CHECKSUM_CLIENT_FORMAT = "(CRYPTO_CHECKSUM_CLIENT=%s)";
    private static final String CRYPTO_CHECKSUM_TYPES_CLIENT_FORMAT = "(CRYPTO_CHECKSUM_TYPES_CLIENT=%s)";
    private static final String EMPTY_STRING = "";
    private static final String KEY_VALUE_FORMAT = "(%s=%s)";
    private static final String CONNECTION_PROPERTY_THIN_LDAP_AUTH_BIND = "AUTHENTICATE_BIND";
    private static final String LDAP_BIND_TYPE_SIMPLE = "LDAPS_SIMPLE_AUTH";
    private static final String LDAP_BIND_TYPE_NONE = "NONE";
    private static final String CONNECTION_PROPERTY_THIN_LDAP_DIRECTORY_SERVER_TYPE = "DIRECTORY_SERVER_TYPE";
    private static final Pattern HOSTNAMES_PATTERN = Pattern.compile("(?<hostnames>(((\\[[A-z0-9:]+\\])|([A-z0-9][A-z0-9._-]+))[,]?)++)(:(?<port>\\d+))?");
    private static final Pattern EZ_URL_PATTERN = Pattern.compile("((?<protocol>tcp|tcps):)?(//)?(?<hostinfo>(" + HOSTNAMES_PATTERN.pattern() + "[;]?)+)(/(?<servicename>[A-z][A-z0-9,-.]+))?(:(?<servermode>dedicated|shared|pooled))?(/(?<instance>[A-z][A-z0-9]+))?", 2);
    private static final String EXT_TNS_ADMIN_KEYWORD = "TNS_ADMIN";
    private static final char EXT_DOUBLE_QT = '\"';
    private static final char EXT_KEY_VAL_SEP = '=';
    private static final char EXT_PARAM_SEP = '&';
    private static final char EXT_ESCAPE_CHAR = '\\';
    private static final Map<String, String> URL_PROPS_ALIAS = EZConnectResolver.initializeUrlAlias();
    private static final Map<String, String> CONNECTION_PROPS_ALIAS = EZConnectResolver.initializeConnectionPropertiesAlias();
    private static final List<String> DESCRIPTION_PARAMS = Collections.unmodifiableList(Arrays.asList("ENABLE", "FAILOVER", "LOAD_BALANCE", "RECV_BUF_SIZE", "SEND_BUF_SIZE", "SDU", "SOURCE_ROUTE", "RETRY_COUNT", "RETRY_DELAY", "CONNECT_TIMEOUT", "TRANSPORT_CONNECT_TIMEOUT"));
    private final String url;
    private String resolvedUrl;
    private final Properties connectionProps = new Properties();
    private final Properties urlProps = new Properties();
    private final String urlPrefix;
    private final Properties defaultProperties;
    private boolean useAddressList;
    private static final boolean DEBUG = false;

    private EZConnectResolver(String url, @Blind(value=PropertiesBlinder.class) Properties defaultProperties) throws NetException {
        this.defaultProperties = (Properties)defaultProperties.clone();
        int jdbcUrlPrefix = url.indexOf(64);
        if (jdbcUrlPrefix != -1) {
            this.url = url.substring(jdbcUrlPrefix + 1);
            this.urlPrefix = url.substring(0, jdbcUrlPrefix + 1);
        } else {
            this.url = url;
            this.urlPrefix = EMPTY_STRING;
        }
        this.parse();
    }

    public static EZConnectResolver newInstance(String url) throws NetException {
        return EZConnectResolver.newInstance(url, new Properties());
    }

    public static EZConnectResolver newInstance(String url, @Blind(value=PropertiesBlinder.class) Properties defaultProperties) throws NetException {
        return new EZConnectResolver(url, defaultProperties);
    }

    public String getResolvedUrl() {
        return this.resolvedUrl;
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getProperties() {
        return this.connectionProps;
    }

    private void parse() throws NetException {
        String parsedUrl = this.parseExtendedSettings(this.url);
        if (this.connectionProps.isEmpty() && this.urlProps.isEmpty()) {
            parsedUrl = this.url;
        }
        if (parsedUrl.startsWith("(")) {
            this.resolvedUrl = this.urlPrefix + parsedUrl;
        } else if (parsedUrl.startsWith("ldap://") || parsedUrl.startsWith("ldaps://")) {
            this.resolveLDAPProperties();
            this.resolvedUrl = this.urlPrefix + parsedUrl;
        } else {
            this.resolvedUrl = this.urlPrefix + this.resolveToLongURLFormat(parsedUrl);
        }
    }

    private void resolveLDAPProperties() throws NetException {
        String walletDir;
        String isAuthBindEnabled = this.connectionProps.getProperty(CONNECTION_PROPERTY_THIN_LDAP_AUTH_BIND);
        String authType = null;
        if (isAuthBindEnabled != null) {
            if (isAuthBindEnabled.equalsIgnoreCase("true")) {
                authType = this.getLdapAuthType();
            } else if (isAuthBindEnabled.equalsIgnoreCase("false")) {
                authType = LDAP_BIND_TYPE_NONE;
            } else {
                throw new NetException(17875, null, false, CONNECTION_PROPERTY_THIN_LDAP_AUTH_BIND, isAuthBindEnabled);
            }
            this.connectionProps.setProperty("oracle.net.ldap.security.authentication", authType);
        }
        if ((walletDir = this.urlProps.getProperty("MY_WALLET_DIRECTORY")) != null) {
            this.connectionProps.setProperty("oracle.net.ldap.ssl.walletLocation", walletDir);
            if (authType != null && authType.equalsIgnoreCase("simple")) {
                this.getLDAPAuthDetailsFromWallet(WalletLocation.parse(walletDir));
            }
        }
    }

    private String getLdapAuthType() throws NetException {
        String result;
        String authBindType = this.connectionProps.getProperty("oracle.net.ldap.security.authentication", LDAP_BIND_TYPE_SIMPLE);
        if (LDAP_BIND_TYPE_SIMPLE.equalsIgnoreCase(authBindType)) {
            result = "simple";
        } else if (LDAP_BIND_TYPE_NONE.equalsIgnoreCase(authBindType)) {
            result = "none";
        } else {
            throw new NetException(17875, null, false, "AUTHENTICATE_BIND_METHOD", authBindType);
        }
        return result;
    }

    private void getLDAPAuthDetailsFromWallet(WalletLocation walletLocation) throws NetException {
        OpaqueString walletPassword = OpaqueString.newOpaqueString(this.connectionProps.getProperty("oracle.net.ldap.ssl.walletPassword"));
        Object[] authParams = JndiAttrs.getAuthDetailsFromWallet(walletLocation, walletPassword);
        if (authParams != null) {
            if (authParams[0] != null) {
                this.connectionProps.setProperty("oracle.net.ldap.security.principal", (String)authParams[0]);
            }
            if (authParams[1] != null) {
                this.connectionProps.setProperty("oracle.net.ldap.security.credentials", ((OpaqueString)authParams[1]).get());
            }
        }
    }

    private String resolveToLongURLFormat(String url) {
        String proxyPort;
        String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
        Matcher matcher = EZ_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
        if (!matcher.matches()) {
            return url;
        }
        String protocol = matcher.group("protocol");
        String hostInfo = matcher.group("hostinfo");
        String serviceName = matcher.group("servicename");
        String serverMode = matcher.group("servermode");
        String instanceName = matcher.group("instance");
        if (hostInfo == null) {
            return url;
        }
        if (protocol == null && serviceName == null && serverMode == null && instanceName == null) {
            return url;
        }
        String proxyHost = this.urlProps.getProperty("HTTPS_PROXY");
        String addressInfo = this.buildAddressList(hostInfo, protocol, proxyHost, proxyPort = this.urlProps.getProperty("HTTPS_PROXY_PORT"));
        if (addressInfo == null) {
            return url;
        }
        if (!this.useAddressList && !this.urlProps.containsKey("LOAD_BALANCE")) {
            this.urlProps.setProperty("LOAD_BALANCE", "ON");
        }
        String connectionIdPrefix = this.urlProps.getProperty("CONNECTION_ID_PREFIX");
        return String.format(DESCRIPTION_FORMAT, this.buildDescriptionParams(), addressInfo, this.buildConnectData(serviceName, serverMode, instanceName, connectionIdPrefix), this.buildSecurityInfo(protocol));
    }

    private String buildConnectData(String serviceName, String serverMode, String instanceName, String connectionIdPrefix) {
        String poolConnectionClass = this.urlProps.getProperty("POOL_CONNECTION_CLASS");
        String poolPurity = this.urlProps.getProperty("POOL_PURITY");
        String serviceTag = this.urlProps.getProperty("SERVICE_TAG");
        return String.format(CONNECT_DATA_FORMAT, String.format(SERVICE_NAME_FORMAT, serviceName == null ? EMPTY_STRING : serviceName), serverMode == null ? EMPTY_STRING : String.format(SERVER_MODE_FORMAT, serverMode), instanceName == null ? EMPTY_STRING : String.format(INSTANCE_NAME_FORMAT, instanceName), poolConnectionClass == null ? EMPTY_STRING : String.format(POOL_CONNECTION_CLASS_FORMAT, poolConnectionClass), poolPurity == null ? EMPTY_STRING : String.format(POOL_PURITY_FORMAT, poolPurity), serviceTag == null ? EMPTY_STRING : String.format(SERVICE_TAG_FORMAT, serviceTag), connectionIdPrefix == null ? EMPTY_STRING : String.format(CONNECTION_ID_PREFIX_FORMAT, connectionIdPrefix));
    }

    private String buildAddressList(String hostInfo, String protocol, String proxyHost, String proxyPort) {
        StringBuilder builder = new StringBuilder();
        String proxyInfo = EMPTY_STRING;
        if (proxyHost != null && proxyPort != null) {
            proxyInfo = String.format(HTTPS_PROXY_FORMAT, proxyHost) + String.format(HTTPS_PROXY_PORT_FORMAT, proxyPort);
        }
        if (protocol == null) {
            protocol = "TCP";
        }
        String[] addressLists = hostInfo.split(";");
        this.useAddressList = hostInfo.indexOf(59) != -1;
        for (String addressList : addressLists) {
            int addressNodeCount = 0;
            StringBuilder addressListBuilder = new StringBuilder();
            Matcher matcher = HOSTNAMES_PATTERN.matcher(addressList);
            while (matcher.find()) {
                String[] hostNames = matcher.group("hostnames").split(",");
                String port = matcher.group("port");
                if (port == null) {
                    port = "1521";
                }
                for (String hostName : hostNames) {
                    addressListBuilder.append(this.getAddrStr(hostName, port, protocol, proxyInfo));
                    ++addressNodeCount;
                }
            }
            builder.append(this.useAddressList ? String.format(ADDRESS_LIST_FORMAT, addressListBuilder.toString()) : addressListBuilder.toString());
        }
        return builder.toString();
    }

    private String getAddrStr(String hostName, String port, String protocol, String proxyInfo) {
        String host = hostName.trim();
        if (host.startsWith("[") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }
        return String.format(ADDRESS_FORMAT, protocol, host, port, proxyInfo);
    }

    private String buildDescriptionParams() {
        if (this.urlProps.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        this.urlProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (DESCRIPTION_PARAMS.contains(k)) {
                builder.append(String.format(KEY_VALUE_FORMAT, k, v));
            }
        }));
        return builder.toString();
    }

    private String buildSecurityInfo(String protocol) {
        StringBuilder securityInfo = new StringBuilder();
        if (protocol != null && protocol.equalsIgnoreCase("tcps")) {
            String walletDir;
            String serverDNMatch = this.connectionProps.getProperty("oracle.net.ssl_server_dn_match");
            if (serverDNMatch == null) {
                serverDNMatch = this.defaultProperties.getProperty("oracle.net.ssl_server_dn_match", "TRUE");
                this.connectionProps.setProperty("oracle.net.ssl_server_dn_match", serverDNMatch);
            }
            securityInfo.append(String.format(SERVER_DN_MATCH_FORMAT, serverDNMatch));
            String serverCertDN = this.urlProps.getProperty("SSL_SERVER_CERT_DN");
            if (serverCertDN != null) {
                securityInfo.append(String.format(SERVER_DN_FORMAT, serverCertDN));
            }
            if ((walletDir = this.urlProps.getProperty("MY_WALLET_DIRECTORY")) != null) {
                securityInfo.append(String.format(MY_WALLET_DIR_FORMAT, walletDir));
            }
        } else {
            String encryptionClient = this.urlProps.getProperty("ENCRYPTION_CLIENT");
            String encryptionClientTypes = this.urlProps.getProperty("ENCRYPTION_TYPES_CLIENT");
            String checksumClient = this.urlProps.getProperty("CRYPTO_CHECKSUM_CLIENT");
            String checksumClientTypes = this.urlProps.getProperty("CRYPTO_CHECKSUM_TYPES_CLIENT");
            if (encryptionClient != null) {
                securityInfo.append(String.format(ENCRYPTION_CLIENT_FORMAT, encryptionClient));
            }
            if (encryptionClientTypes != null) {
                securityInfo.append(String.format(ENCRYPTION_TYPES_CLIENT_FORMAT, encryptionClientTypes));
            }
            if (checksumClient != null) {
                securityInfo.append(String.format(CRYPTO_CHECKSUM_CLIENT_FORMAT, checksumClient));
            }
            if (checksumClientTypes != null) {
                securityInfo.append(String.format(CRYPTO_CHECKSUM_TYPES_CLIENT_FORMAT, checksumClientTypes));
            }
        }
        return securityInfo.length() == 0 ? EMPTY_STRING : String.format(SECURITY_FORMAT, securityInfo.toString());
    }

    private String parseExtendedSettings(String urlStr) throws NetException {
        char[] urlBytes = urlStr.trim().toCharArray();
        int extendedSettingsIndex = this.findExtendedSettingPosition(urlBytes);
        if (extendedSettingsIndex == -1) {
            return urlStr;
        }
        this.parseExtendedProperties(urlBytes, extendedSettingsIndex + 1);
        return urlStr.substring(0, extendedSettingsIndex);
    }

    private void parseExtendedProperties(char[] urlChars, int extIndex) throws NetException {
        String key = null;
        String value = null;
        char[] token = new char[urlChars.length];
        int tokenIndx = 0;
        block6: for (int i = extIndex; i < urlChars.length; ++i) {
            if (Character.isWhitespace(urlChars[i])) continue;
            switch (urlChars[i]) {
                case '\\': {
                    if (i + 1 < urlChars.length && this.isValidEscapeChar(urlChars[i + 1])) {
                        token[tokenIndx++] = urlChars[++i];
                        continue block6;
                    }
                    throw new NetException(12261, "Invalid character at " + i + " : " + urlChars[i], false, String.valueOf(urlChars));
                }
                case '\"': {
                    int[] indicies = this.parseQuotedString(i, urlChars, tokenIndx, token);
                    tokenIndx = indicies[1];
                    i = indicies[0];
                    continue block6;
                }
                case '=': {
                    if (key != null) {
                        if (key.equals("wallet_location")) continue block6;
                        String errMsg = "Unable to parse url \"" + new String(token, 0, tokenIndx) + "\"";
                        throw new NetException(12261, errMsg, false, String.valueOf(urlChars));
                    }
                    key = new String(token, 0, tokenIndx).trim();
                    tokenIndx = 0;
                    continue block6;
                }
                case '&': {
                    if (key == null) {
                        String errMsg = "Unable to parse url \"" + new String(token, 0, tokenIndx) + "\"";
                        throw new NetException(12261, errMsg, false, String.valueOf(urlChars));
                    }
                    value = new String(token, 0, tokenIndx).trim();
                    this.addParam(key, value);
                    key = null;
                    value = null;
                    tokenIndx = 0;
                    continue block6;
                }
                default: {
                    token[tokenIndx++] = urlChars[i];
                }
            }
        }
        if (key != null) {
            value = new String(token, 0, tokenIndx).trim();
            this.addParam(key, value);
        }
    }

    private int[] parseQuotedString(int startIndex, char[] urlChars, int tokenIndex, char[] token) throws NetException {
        for (int i = startIndex + 1; i < urlChars.length; ++i) {
            char curChar = urlChars[i];
            if (curChar == '\\') {
                if (i + 1 < urlChars.length && this.isValidEscapeChar(urlChars[i + 1])) {
                    token[tokenIndex++] = urlChars[++i];
                    continue;
                }
                throw new NetException(12261, "Invalid character at " + i + " : " + urlChars[i], false, String.valueOf(urlChars));
            }
            if (curChar == '\"') {
                return new int[]{i, tokenIndex};
            }
            token[tokenIndex++] = curChar;
        }
        throw new NetException(12261, "Quote at " + startIndex + " not closed.", false, String.valueOf(urlChars));
    }

    private boolean isValidEscapeChar(char currentChar) {
        return currentChar == '\\' || currentChar == '\"';
    }

    private void addParam(String key, String value) {
        if (key.equalsIgnoreCase(EXT_TNS_ADMIN_KEYWORD)) {
            this.addTNSAdmin(value);
        } else {
            String aliasKeyName = key.toLowerCase();
            String propertyName = URL_PROPS_ALIAS.get(aliasKeyName);
            if (propertyName != null) {
                this.urlProps.put(propertyName, value);
            } else {
                propertyName = CONNECTION_PROPS_ALIAS.getOrDefault(aliasKeyName, key);
                this.connectionProps.put(propertyName, value);
            }
        }
    }

    private void addTNSAdmin(String tnsAdminValue) {
        if (!new File(tnsAdminValue).exists()) {
            tnsAdminValue = EnvVariableResolver.resolveEnvPlaceHolders(tnsAdminValue, this.connectionProps);
        }
        this.connectionProps.put("oracle.net.tns_admin", tnsAdminValue);
    }

    private int findExtendedSettingPosition(char[] urlBytes) {
        int urlNodeDepth = 0;
        for (int i = 0; i < urlBytes.length; ++i) {
            if (urlBytes[i] == '(') {
                ++urlNodeDepth;
                continue;
            }
            if (urlBytes[i] == ')') {
                --urlNodeDepth;
                continue;
            }
            if (urlBytes[i] != '?' || urlNodeDepth != 0) continue;
            return i;
        }
        return -1;
    }

    private static final Map<String, String> initializeUrlAlias() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("enable", "ENABLE");
        aliasMap.put("failover", "FAILOVER");
        aliasMap.put("load_balance", "LOAD_BALANCE");
        aliasMap.put("recv_buf_size", "RECV_BUF_SIZE");
        aliasMap.put("send_buf_size", "SEND_BUF_SIZE");
        aliasMap.put("sdu", "SDU");
        aliasMap.put("source_route", "SOURCE_ROUTE");
        aliasMap.put("retry_count", "RETRY_COUNT");
        aliasMap.put("retry_delay", "RETRY_DELAY");
        aliasMap.put("https_proxy", "HTTPS_PROXY");
        aliasMap.put("https_proxy_port", "HTTPS_PROXY_PORT");
        aliasMap.put("connect_timeout", "CONNECT_TIMEOUT");
        aliasMap.put("transport_connect_timeout", "TRANSPORT_CONNECT_TIMEOUT");
        aliasMap.put("ssl_server_cert_dn", "SSL_SERVER_CERT_DN");
        aliasMap.put("wallet_location", "MY_WALLET_DIRECTORY");
        aliasMap.put("encryption_client", "ENCRYPTION_CLIENT");
        aliasMap.put("encryption_types_client", "ENCRYPTION_TYPES_CLIENT");
        aliasMap.put("crypto_checksum_client", "CRYPTO_CHECKSUM_CLIENT");
        aliasMap.put("crypto_checksum_types_client", "CRYPTO_CHECKSUM_TYPES_CLIENT");
        aliasMap.put("pool_connection_class", "POOL_CONNECTION_CLASS");
        aliasMap.put("pool_purity", "POOL_PURITY");
        aliasMap.put("service_tag", "SERVICE_TAG");
        aliasMap.put("connection_id_prefix", "CONNECTION_ID_PREFIX");
        return aliasMap;
    }

    public static final Map<String, String> validAliases() {
        return URL_PROPS_ALIAS;
    }

    private static final Map<String, String> initializeConnectionPropertiesAlias() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("keystore_type", "javax.net.ssl.keyStoreType");
        aliasMap.put("keystore_password", "javax.net.ssl.keyStorePassword");
        aliasMap.put("keystore", "javax.net.ssl.keyStore");
        aliasMap.put("truststore_type", "javax.net.ssl.trustStoreType");
        aliasMap.put("truststore_password", "javax.net.ssl.trustStorePassword");
        aliasMap.put("truststore", "javax.net.ssl.trustStore");
        aliasMap.put("ssl_version", "oracle.net.ssl_version");
        aliasMap.put("ssl_ciphers", "oracle.net.ssl_cipher_suites");
        aliasMap.put("ssl_server_dn_match", "oracle.net.ssl_server_dn_match");
        aliasMap.put("allow_weak_crypto", "oracle.net.allow_weak_crypto");
        aliasMap.put("ssl_certificate_alias", "oracle.net.ssl_certificate_alias");
        aliasMap.put("ssl_certificate_thumbprint", "oracle.net.ssl_certificate_thumbprint");
        aliasMap.put("authenticate_bind_method", "oracle.net.ldap.security.authentication");
        aliasMap.put("authenticate_bind", CONNECTION_PROPERTY_THIN_LDAP_AUTH_BIND);
        aliasMap.put("directory_server_type", CONNECTION_PROPERTY_THIN_LDAP_DIRECTORY_SERVER_TYPE);
        aliasMap.put("token_auth", "oracle.jdbc.tokenAuthentication");
        aliasMap.put("token_location", "oracle.jdbc.tokenLocation");
        aliasMap.put("password_auth", "oracle.jdbc.passwordAuthentication");
        aliasMap.put("oci_iam_url", "oracle.jdbc.ociIamUrl");
        aliasMap.put("oci_tenancy", "oracle.jdbc.ociTenancy");
        aliasMap.put("oci_compartment", "oracle.jdbc.ociCompartment");
        aliasMap.put("oci_database", "oracle.jdbc.ociDatabase");
        aliasMap.put("oci_config_file", "oracle.jdbc.ociConfigFile");
        aliasMap.put("oci_profile", "oracle.jdbc.ociProfile");
        aliasMap.put("azure_db_app_id_uri", "oracle.jdbc.azureDatabaseApplicationIdUri");
        aliasMap.put("tenant_id", "oracle.jdbc.tenantId");
        aliasMap.put("client_id", "oracle.jdbc.clientId");
        aliasMap.put("client_certificate", "oracle.jdbc.clientCertificate");
        aliasMap.put("redirect_uri", "oracle.jdbc.redirectUri");
        return aliasMap;
    }
}

