/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.cli.AbstractCommand;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.Option;
import oracle.jdbc.driver.cli.ValuedOption;
import oracle.jdbc.pool.OracleDataSource;

class GetVersionCommand
extends AbstractCommand {
    GetVersionCommand() {
    }

    @Override
    public String getName() {
        return "get-version";
    }

    @Override
    public String getShortUsage() {
        return "Print the database and JDK version";
    }

    @Override
    public String getLongUsage() {
        return "Prints the database and JDK version information.";
    }

    @Override
    public List<Option> getExpectedOptions() {
        ValuedOption url = new ValuedOption("url", "JDBC-url", "JDBC connection url", true, 1, null);
        Option help = new Option("help", "h", "Show help message", false, 1);
        return Arrays.asList(url, help);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.hasOption("help")) {
            this.printCommandHelp(context.getCommandPrefix());
            return;
        }
        try {
            String url = context.getOptionValues("url").get(0);
            String versionInfo = this.getVersionInformation(url);
            if (!versionInfo.isEmpty()) {
                System.out.println(versionInfo);
            }
        }
        catch (Exception e) {
            System.err.println("Error while retrieving version information: " + e.getMessage());
        }
    }

    private String getVersionInformation(String DB_URL) throws Exception {
        String dbVersionInformation = "";
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(DB_URL);
        try (OracleConnection connection = (OracleConnection)ods.getConnection();){
            DatabaseMetaData dbmd = connection.getMetaData();
            dbVersionInformation = "Database Version: " + dbmd.getDatabaseProductVersion();
        }
        catch (SQLException sqlException) {
            throw new Exception("Unable to retrieve database version: " + sqlException.getMessage());
        }
        return dbVersionInformation;
    }
}

