/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.DestinationMap;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.ShardInfoImpl;

public class Chunk {
    private final String name;
    private final AtomicInteger version = new AtomicInteger(0);
    private final boolean isReadOnlyAllowed;
    private final AtomicInteger affinitizedInstId = new AtomicInteger(0);
    private final AtomicInteger id = new AtomicInteger(0);
    private final AtomicInteger uniqueId = new AtomicInteger(0);
    private final Set<ShardInfo> shardInfoSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DestinationMap destinationMap = new DestinationMap();

    Chunk(String name, boolean isReadOnlyAllowed) {
        this.name = name;
        this.isReadOnlyAllowed = isReadOnlyAllowed;
    }

    Chunk(String name, int version, boolean isReadOnlyAllowed) {
        this(name, isReadOnlyAllowed);
        this.version.set(version);
    }

    boolean hasInstance(ServiceMember instance) {
        return this.destinationMap.contains(instance, this.isReadOnlyAllowed);
    }

    int instancePriority(ServiceMember instance) {
        if (instance == null) {
            return Integer.MAX_VALUE;
        }
        return this.destinationMap.getPriority(instance);
    }

    void addInstanceWithPriority(ServiceMember instance, int priority, int state) {
        this.destinationMap.add(instance, priority, state);
    }

    void removeInstance(ServiceMember instance) {
        this.destinationMap.remove(instance);
    }

    void markReadOnly(ServiceMember instance) {
        this.destinationMap.markReadOnly(instance);
    }

    Set<ServiceMember> getReadWritePriorityInstances() {
        return this.destinationMap.getHighestPriorityInstances(false).allInstances();
    }

    Set<ServiceMember> priorityInstances() {
        return this.destinationMap.getHighestPriorityInstances(this.isReadOnlyAllowed).allInstances();
    }

    public Set<ServiceMember> instances() {
        return this.destinationMap.allInstances(this.isReadOnlyAllowed);
    }

    public AtomicInteger affinitizedInstId() {
        return this.affinitizedInstId;
    }

    public void setAffinitizedInstId(int instId) {
        this.affinitizedInstId.set(instId);
    }

    public void setId(int id) {
        this.id.set(id);
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId.set(uniqueId);
    }

    public int getUniqueId() {
        return this.uniqueId.get();
    }

    public void addShardInfo(String name, int priority) {
        this.shardInfoSet.add(new ShardInfoImpl(name, priority));
    }

    public AtomicInteger Id() {
        return this.id;
    }

    String name() {
        return this.name + (String)(this.version() == 0 ? "" : "-" + this.version.get());
    }

    int version() {
        return this.version.get();
    }

    void setVersion(int version) {
        this.version.set(version);
    }

    String absoluteName() {
        if (!this.name.contains("-")) {
            return this.name;
        }
        return this.name.substring(0, this.name.indexOf("-"));
    }

    public Set<ShardInfo> shardInfo() {
        return this.shardInfoSet;
    }

    public String toString() {
        return this.name() + "\t\t " + (String)(this.affinitizedInstId.get() != 0 ? "Affinity Instance Id: " + String.valueOf(this.affinitizedInstId) + ", INSTANCES: " : "") + "[" + this.destinationMap.getHighestPriorityInstances(this.isReadOnlyAllowed).allInstances().stream().filter(k -> k != null).map(sm -> sm.name()).collect(Collectors.joining(", ")) + " ]";
    }

    public boolean hasPriorityInstance(ServiceMember instance) {
        if (instance == null) {
            return false;
        }
        if (this.priorityInstances() == null) {
            return false;
        }
        return this.priorityInstances().contains(instance);
    }

    public static final class Metadata {
        String chunkName;
        InputStream shardKeyLow;
        InputStream shardKeyHigh;
        InputStream superKeyLow;
        InputStream superKeyHigh;
        int priority;
        int state;
        int affinitizedInstId;
        int chunkId;
        int chunkUniqueId;
        String shardName;

        public void setChunkName(String chunkName) {
            this.chunkName = chunkName;
        }

        public void setShardKeyLow(InputStream shardKeyLow) {
            this.shardKeyLow = shardKeyLow;
        }

        public void setShardKeyHigh(InputStream shardKeyHigh) {
            this.shardKeyHigh = shardKeyHigh;
        }

        public void setSuperKeyLow(InputStream superKeyLow) {
            this.superKeyLow = superKeyLow;
        }

        public void setSuperKeyHigh(InputStream superKeyHigh) {
            this.superKeyHigh = superKeyHigh;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setAffinitizedInstId(int affinitizedInstId) {
            this.affinitizedInstId = affinitizedInstId;
        }

        public void setChunkId(int chunkId) {
            this.chunkId = chunkId;
        }

        public void setChunkUniqueId(int chunkUniqueId) {
            this.chunkUniqueId = chunkUniqueId;
        }

        public String toString() {
            return "[chunkName=" + this.chunkName + ", shardKeyLow=" + this.shardKeyLow + ", shardKeyHigh=" + this.shardKeyHigh + ", superKeyLow=" + this.superKeyLow + ", superKeyHigh=" + this.superKeyHigh + ", priority=" + this.priority + ", state=" + this.state + ", affinitizedInstId=" + this.affinitizedInstId + ", chunkId=" + this.chunkId + ", shardName=" + this.shardName + ", chunkUniqueId=" + this.chunkUniqueId + "]";
        }
    }
}

