/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

final class RangeMap<K extends Comparable<? super K>, V> {
    private final NavigableMap<K, Value<K, V>> map = new TreeMap<K, Value<K, V>>();

    RangeMap() {
    }

    private static <K extends Comparable<? super K>, V> K getFloor(Map.Entry<K, Value<K, V>> entry) {
        return (K)((Comparable)Objects.requireNonNull(entry).getKey());
    }

    private static <K extends Comparable<? super K>, V> K getCeiling(Map.Entry<K, Value<K, V>> entry) {
        return Objects.requireNonNull(entry).getValue().keyCeiling;
    }

    private SortedMap<K, Value<K, V>> submap(K fromKey, K toKey) {
        return Objects.nonNull(fromKey) ? (Objects.nonNull(toKey) ? this.map.subMap(fromKey, true, toKey, true) : this.map.tailMap(fromKey, true)) : (Objects.nonNull(toKey) ? this.map.headMap(toKey, true) : Collections.emptySortedMap());
    }

    private static <K extends Comparable<? super K>, V> boolean isOneSameRange(SortedMap<K, Value<K, V>> subMap, K keyFloor, K keyCeiling) {
        if (Objects.requireNonNull(keyFloor).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(subMap);
        return 1 == subMap.size() && subMap.containsKey(keyFloor) && keyCeiling.compareTo(((Value)subMap.get(keyFloor)).keyCeiling) == 0;
    }

    private static <K extends Comparable<? super K>, V> boolean isOneLargerRange(SortedMap<K, Value<K, V>> subMap, K keyFloor, K keyCeiling) {
        if (Objects.requireNonNull(keyFloor).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(subMap);
        if (subMap.size() != 1) {
            return false;
        }
        Map.Entry area = (Map.Entry)subMap.entrySet().stream().findAny().get();
        return keyFloor.compareTo(area.getKey()) > 0 && keyCeiling.compareTo(((Value)area.getValue()).keyCeiling) < 0;
    }

    private static <K extends Comparable<? super K>, V> boolean isOneSmallerRange(SortedMap<K, Value<K, V>> subMap, K keyFloor, K keyCeiling) {
        if (Objects.requireNonNull(keyFloor).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(subMap);
        if (subMap.size() != 1) {
            return false;
        }
        Map.Entry area = (Map.Entry)subMap.entrySet().stream().findAny().get();
        return keyFloor.compareTo(area.getKey()) <= 0 && keyCeiling.compareTo(((Value)area.getValue()).keyCeiling) > 0 || keyFloor.compareTo(area.getKey()) < 0 && keyCeiling.compareTo(((Value)area.getValue()).keyCeiling) >= 0;
    }

    void put(K keyFloor, K keyCeiling, List<V> values) {
        K fromKey;
        if (((Comparable)Objects.requireNonNull(keyFloor)).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(values);
        Map.Entry<K, Value<K, V>> fromEntry = this.map.floorEntry(keyFloor);
        Map.Entry<K, Value<K, V>> toEntry = this.map.floorEntry(keyCeiling);
        K k = Objects.isNull(fromEntry) ? keyFloor : (fromKey = RangeMap.getCeiling(fromEntry).compareTo(keyFloor) > 0 ? RangeMap.getFloor(fromEntry) : keyFloor);
        K toKey = Objects.isNull(toEntry) ? keyCeiling : (RangeMap.getCeiling(toEntry).compareTo(keyCeiling) >= 0 ? RangeMap.getCeiling(toEntry) : keyCeiling);
        SortedMap<K, Value<K, V>> sm = this.submap(fromKey, toKey);
        if (sm.isEmpty()) {
            this.map.put(fromKey, new Value(toKey, new ArrayList(), new ArrayList<V>(values)));
        } else if (RangeMap.isOneSameRange(sm, keyFloor, keyCeiling)) {
            ((Value)sm.get(keyFloor)).values.addAll(values);
        } else if (RangeMap.isOneLargerRange(sm, keyFloor, keyCeiling)) {
            RangeMap<K, List<V>> rm;
            Map.Entry area = (Map.Entry)sm.entrySet().stream().findAny().get();
            if (((Value)area.getValue()).nestedRanges.isEmpty()) {
                rm = new RangeMap<K, V>();
                ((Value)area.getValue()).nestedRanges.add(rm);
            } else {
                rm = ((Value)area.getValue()).nestedRanges.get(0);
            }
            rm.put(keyFloor, keyCeiling, values);
        } else if (RangeMap.isOneSmallerRange(sm, keyFloor, keyCeiling)) {
            RangeMap<K, V> rm = new RangeMap<K, V>();
            rm.map.putAll(sm);
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!sm.containsKey(entry.getKey())) continue;
                it.remove();
            }
            this.map.put(fromKey, new Value<K, V>(toKey, new ArrayList<RangeMap<K, V>>(Collections.singletonList(rm)), new ArrayList<V>(values)));
        } else {
            RangeMap<K, V> rm1 = new RangeMap<K, V>();
            rm1.map.putAll(sm);
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!sm.containsKey(entry.getKey())) continue;
                it.remove();
            }
            RangeMap<K, ArrayList<V>> rm2 = new RangeMap<K, ArrayList<V>>();
            rm2.put(keyFloor, keyCeiling, new ArrayList<V>(values));
            this.map.put(fromKey, new Value(toKey, new ArrayList(Arrays.asList(rm1, rm2)), new ArrayList()));
        }
    }

    void put(K key, V value) {
        this.put(key, key, (V)Collections.singletonList(value));
    }

    void put(K key, List<V> values) {
        this.put(key, key, (V)values);
    }

    void put(K keyFloor, K keyCeiling, V value) {
        this.put(keyFloor, keyCeiling, (V)Collections.singletonList(value));
    }

    List<V> get(K key) {
        Objects.requireNonNull(key);
        Map.Entry<K, Value<K, V>> floorEntry = this.map.floorEntry(key);
        if (Objects.nonNull(floorEntry)) {
            K floorKey = RangeMap.getFloor(floorEntry);
            Value<K, V> value = floorEntry.getValue();
            if (floorKey.equals(value.keyCeiling) && key.equals(floorKey) || key.compareTo(value.keyCeiling) < 0) {
                if (value.nestedRanges.isEmpty()) {
                    return value.values;
                }
                ArrayList values = new ArrayList();
                values.addAll(value.values);
                value.nestedRanges.forEach(p -> {
                    List vals = p.get(key);
                    if (Objects.nonNull(vals)) {
                        values.addAll(vals);
                    }
                });
                return values;
            }
        }
        return Collections.emptyList();
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int[] i = new int[]{1};
        int sz = this.map.size();
        this.map.forEach((k, v) -> {
            if (!v.nestedRanges.isEmpty()) {
                sb.append(v.nestedRanges);
            }
            if (v.values.isEmpty()) {
                i[0] = i[0] + 1;
            } else {
                int n = i[0];
                i[0] = n + 1;
                sb.append('[').append(k).append(",").append(v.keyCeiling).append("]->").append(v.values).append(n < sz ? ", " : "");
            }
        });
        sb.append(']');
        return sb.toString();
    }

    private static class Value<K extends Comparable<? super K>, V> {
        private final K keyCeiling;
        private final List<RangeMap<K, V>> nestedRanges;
        private final List<V> values;

        private Value(K keyCeiling, List<RangeMap<K, V>> nestedRanges, List<V> values) {
            this.keyCeiling = (Comparable)Objects.requireNonNull(keyCeiling);
            this.nestedRanges = Objects.requireNonNull(nestedRanges);
            this.values = Objects.requireNonNull(values);
        }

        public String toString() {
            return "[" + this.keyCeiling + ", " + this.nestedRanges + ", " + this.values + "]";
        }
    }
}

