/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class RefTypeAccessor
extends TypeAccessor {
    static final int MAXLENGTH = -1;

    RefTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.REF_TYPE, stmt, -1, isStoredInBindData);
        this.init(stmt, 111, 111, form, isOutBind);
        this.initForDataAccess(external_type, 0, typeName);
    }

    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName) throws SQLException {
        super(Representation.REF_TYPE, stmt, -1, false);
        this.init(stmt, 111, 111, form, false);
        this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.initForDataAccess(0, max_len, typeName);
    }

    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        super(Representation.REF_TYPE, stmt, -1, false);
        this.init(stmt, 111, 111, form, false);
        this.describeOtype = otype;
        this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.internalOtype = otype;
        this.initForDataAccess(0, max_len, typeName);
    }

    @Override
    final OracleType otypeFromName(String typeName) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(typeName, this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeADT();
    }

    @Override
    final CompletionStage<OracleType> otypeFromNameAsync(String typeName) {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptorAsync(typeName, this.statement.connection).thenApply(TypeDescriptor::getPickler);
        }
        return StructDescriptor.createDescriptorAsync(typeName, this.statement.connection).thenApply(CompletionStageUtil.normalCompletionHandler(StructDescriptor::getOracleTypeADT));
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        super.initForDataAccess(external_type, max_len, typeName);
        this.byteLength = this.statement.connection.refTypeAccessorByteLen;
    }

    @Override
    REF getREF(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] data = this.pickledBytes(currentRow);
        OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
        return new REF(otype.getFullName(), (Connection)this.statement.connection, data);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getObject(currentRow, this.statement.connection.getTypeMap());
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getREF(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        REF ref = this.getREF(currentRow);
        if (ref == null) {
            return null;
        }
        return ref.toJdbc(map);
    }
}

