/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.diagnostics;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.clio.annotations.Sensitive;
import oracle.ucp.diagnostics.Diagnosable;

public class PrintlnDiagnosticsCollector
implements Diagnosable {
    @Override
    public Object secure(@Sensitive Object value) {
        return value;
    }

    @Override
    @Sensitive(value=Sensitive.Dependency.DEPENDENT)
    public Object format(Format.Style f, Object value, long ... args) {
        return value;
    }

    @Override
    public <T extends Throwable> T trace(Level level, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        return this.debugTraceCommon(false, level, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    @Override
    public <T extends Throwable> T debug(Level level, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        return this.debugTraceCommon(true, level, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    private <T extends Throwable> T debugTraceCommon(boolean debug, Level level, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        String msgFormatted = (debug ? "debug:" : "trace:") + String.valueOf(level) + ":" + className + "." + methodName + ":" + MessageFormat.format(publicMessage, args);
        if (Objects.nonNull(thrown)) {
            System.out.println(msgFormatted + " - throwing: " + thrown.getMessage() + " : " + Arrays.toString(thrown.getStackTrace()));
        } else {
            System.out.println(msgFormatted);
        }
        return thrown;
    }

    @Override
    public void suspendLogging() {
    }

    @Override
    public void resumeLogging() {
    }

    @Override
    public void beginCurrentSql(String sql) {
    }

    @Override
    public void endCurrentSql() {
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this;
    }
}

