/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import oracle.net.url.common.MalformedURLException;
import oracle.net.url.common.URLFormat;
import oracle.net.url.parser.ConnectDescriptorParser;
import oracle.net.url.parser.EZConnectParser;
import oracle.net.url.parser.URLParseResult;

public final class URLParser {
    private static final URLParser INSTANCE = new URLParser();
    private boolean strictMode = false;

    private URLParser() {
    }

    public static URLParser instance() {
        return INSTANCE;
    }

    public URLParser strictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    public URLParseResult parse(String url) throws MalformedURLException {
        return this.parse(url, this.resolveType(url));
    }

    public URLParseResult parse(String url, URLFormat format) throws MalformedURLException {
        url = this.removeProviderInfo(url);
        if (format == URLFormat.CONNECT_DESCRIPTOR) {
            ConnectDescriptorParser parser = new ConnectDescriptorParser(this.strictMode);
            return parser.parse(url);
        }
        if (format == URLFormat.EZ_CONNECT) {
            EZConnectParser parser = new EZConnectParser(this.strictMode);
            return parser.parse(url);
        }
        throw new IllegalArgumentException("Parsing not supported for " + format);
    }

    public URLFormat resolveType(String url) {
        String urlLowerCase = this.removeProviderInfo(url.toLowerCase().trim());
        if (urlLowerCase.startsWith("ldap://") || urlLowerCase.startsWith("ldaps://")) {
            return URLFormat.LDAP;
        }
        if (urlLowerCase.startsWith("(")) {
            return URLFormat.CONNECT_DESCRIPTOR;
        }
        return URLFormat.EZ_CONNECT;
    }

    private String removeProviderInfo(String url) {
        if (url.startsWith("jdbc:oracle:")) {
            int providerEndIndex = url.indexOf(64);
            if (providerEndIndex == -1) {
                throw new IllegalArgumentException("Invalid URL");
            }
            return url.substring(providerEndIndex + 1).trim();
        }
        return url;
    }
}

