/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

public abstract class PhasedPublisher<T>
implements Flow.Publisher<T> {
    private static final String CLASS_NAME = PhasedPublisher.class.getName();
    private final Phaser publishingPhaser;
    private final AtomicInteger nextPhaseDeregistrations = new AtomicInteger(0);
    private final TerminalAction terminalAction;
    private final CompletableFuture<Void> terminalFuture = new CompletableFuture();
    private final Executor executor;
    private final CopyOnWriteArraySet<PhasedSubscription> subscriptions = new CopyOnWriteArraySet();
    private final Phaser joinPhaser;
    private final int creationPhase;
    private final AtomicBoolean isSubscribed = new AtomicBoolean(false);

    protected PhasedPublisher(Executor executor, Phaser joinPhaser, TerminalAction terminalAction) {
        this.executor = executor;
        this.terminalAction = terminalAction == null ? () -> {} : terminalAction;
        this.publishingPhaser = new PublishingPhaser();
        this.joinPhaser = joinPhaser;
        this.creationPhase = joinPhaser.register();
    }

    private void deregisterAfterArrivedPhase(int arrivedPhase) {
        int currentPhase = this.publishingPhaser.register();
        if (currentPhase > arrivedPhase) {
            this.publishingPhaser.awaitAdvance(arrivedPhase);
            this.publishingPhaser.arriveAndDeregister();
        } else {
            this.nextPhaseDeregistrations.incrementAndGet();
        }
        this.publishingPhaser.arriveAndDeregister();
    }

    private void executeNextPhaseDeregistrations(int currentPhase) {
        int deregistrations = this.nextPhaseDeregistrations.getAndSet(0);
        if (deregistrations != 0) {
            this.executor.execute(() -> {
                this.publishingPhaser.awaitAdvance(currentPhase);
                for (int i = 0; i < deregistrations; ++i) {
                    this.publishingPhaser.arriveAndDeregister();
                }
            });
        }
    }

    protected void handleOnNext(T nextItem, Consumer<? super T> nextItemConsumer) {
        nextItemConsumer.accept(nextItem);
    }

    protected abstract void requestNext(BiConsumer<T, Throwable> var1);

    private void handlePhaseAdvancement(T nextItem, Throwable error) {
        if (error != null) {
            this.endPublishing(CompletionStageUtil.unwrapCompletionException(error));
        } else if (nextItem != null) {
            for (PhasedSubscription subscription : this.subscriptions) {
                subscription.emitNextItem(nextItem);
            }
        } else {
            this.endPublishing(null);
        }
    }

    private void endPublishing(Throwable error) {
        this.publishingPhaser.forceTermination();
        try {
            this.terminalAction.run();
        }
        catch (Throwable actionFailure) {
            error = CompletionStageUtil.suppress(actionFailure, error);
        }
        if (error == null) {
            this.terminalFuture.complete(null);
        } else {
            this.terminalFuture.completeExceptionally(error);
        }
    }

    @Override
    public final void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        PhasedSubscription newSubscription = new PhasedSubscription(subscriber);
        if (!this.subscriptions.add(newSubscription)) {
            this.subscriptions.stream().filter(newSubscription::equals).findFirst().ifPresent(subscription -> subscription.emitError(new IllegalStateException("Subscriber argument to subscribe(Subscriber) is already subscribed")));
        } else {
            boolean isAfterJoin = !this.isSubscribed.compareAndSet(false, true) && this.creationPhase != this.joinPhaser.register();
            this.publishingPhaser.register();
            try (Monitor.CloseableLock lock = newSubscription.monitor.acquireCloseableLock();){
                subscriber.onSubscribe(newSubscription);
                CompletionStageUtil.callOnComplete(this.terminalFuture, (nil, error) -> {
                    if (isAfterJoin) {
                        newSubscription.emitError(new IllegalStateException("This Publisher is invalid after joinOracle returns"));
                    } else if (error == null) {
                        newSubscription.emitComplete();
                    } else {
                        newSubscription.emitError((Throwable)error);
                    }
                });
            }
            catch (Throwable onSubscribeFailure) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "subscribe", "Subscriber.onSubscribe() threw an exception", null, onSubscribeFailure);
                newSubscription.cancel();
            }
        }
    }

    @FunctionalInterface
    public static interface TerminalAction {
        public void run() throws Exception;
    }

    private class PublishingPhaser
    extends Phaser {
        private PublishingPhaser() {
        }

        @Override
        protected final boolean onAdvance(int phase, int registeredParties) {
            if (registeredParties == 0) {
                PhasedPublisher.this.endPublishing(null);
            } else {
                PhasedPublisher.this.requestNext((value, error) -> PhasedPublisher.this.handlePhaseAdvancement(value, (Throwable)error));
            }
            PhasedPublisher.this.executeNextPhaseDeregistrations(phase);
            return false;
        }
    }

    private class PhasedSubscription
    implements Flow.Subscription {
        private final String CLASS_NAME = PhasedSubscription.class.getName();
        private final Monitor monitor = Monitor.newInstance();
        private final Flow.Subscriber<? super T> subscriber;
        private boolean isCancelled = false;
        private int lastArrivedPhase = -1;
        private long demand = 0L;

        private PhasedSubscription(Flow.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        private void emitNextItem(T item) {
            PhasedPublisher.this.executor.execute(() -> {
                try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                    if (this.isCancelled) {
                        return;
                    }
                    PhasedPublisher.this.handleOnNext(item, handledItem -> {
                        try {
                            this.subscriber.onNext(handledItem);
                        }
                        catch (Throwable onNextFailure) {
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "emitNextItem", "Subscriber.onNext(Object) threw an exception", null, onNextFailure);
                            this.cancel();
                        }
                    });
                    this.decrementDemand();
                    if (this.demand > 0L) {
                        this.arriveForNextPhase();
                    }
                }
            });
        }

        private void emitError(Throwable throwable) {
            PhasedPublisher.this.executor.execute(() -> {
                try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                    if (this.isCancelled) {
                        return;
                    }
                    this.isCancelled = true;
                    try {
                        this.subscriber.onError(throwable);
                        this.terminate();
                    }
                    catch (Throwable onErrorFailure) {
                        try {
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "emitError", "Subscriber.onError(Throwable) threw an exception", null, onErrorFailure);
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            this.terminate();
                        }
                    }
                }
            });
        }

        private void emitComplete() {
            PhasedPublisher.this.executor.execute(() -> {
                try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                    if (this.isCancelled) {
                        return;
                    }
                    this.isCancelled = true;
                    try {
                        this.subscriber.onComplete();
                        this.terminate();
                    }
                    catch (Throwable onCompleteFailure) {
                        try {
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "emitComplete", "Subscriber.onComplete() threw an exception", null, onCompleteFailure);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.terminate();
                        }
                    }
                }
            });
        }

        @Override
        public final void cancel() {
            try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.isCancelled = true;
                this.terminate();
            }
        }

        private void terminate() {
            try {
                this.demand = Long.MIN_VALUE;
                PhasedPublisher.this.subscriptions.remove(this);
                PhasedPublisher.this.deregisterAfterArrivedPhase(this.lastArrivedPhase);
            }
            finally {
                PhasedPublisher.this.joinPhaser.arriveAndDeregister();
            }
        }

        @Override
        public final void request(long n) {
            try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                if (n < 1L) {
                    this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + n));
                    return;
                }
                boolean isIncreasedFromZero = this.demand == 0L;
                this.increaseDemand(n);
                if (isIncreasedFromZero) {
                    this.arriveForNextPhase();
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof PhasedSubscription && ((PhasedSubscription)object).subscriber.equals(this.subscriber);
        }

        public int hashCode() {
            return this.subscriber.hashCode();
        }

        private void increaseDemand(long moreDemand) {
            try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                if (this.demand != Long.MAX_VALUE && this.demand != Long.MIN_VALUE) {
                    long newDemand = this.demand + moreDemand;
                    this.demand = newDemand < 0L ? Long.MAX_VALUE : newDemand;
                }
            }
        }

        private void decrementDemand() {
            try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                if (this.demand != Long.MAX_VALUE && this.demand != Long.MIN_VALUE) {
                    --this.demand;
                }
            }
        }

        private void arriveForNextPhase() {
            try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                PhasedPublisher.this.publishingPhaser.awaitAdvance(this.lastArrivedPhase);
                this.lastArrivedPhase = PhasedPublisher.this.publishingPhaser.arrive();
            }
        }
    }
}

