/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.VectorMetaDataImpl;
import oracle.jdbc.driver.parser.Lexer;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.SqlEarley;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.OracleTypes;

public class OracleParameterMetaDataParser {
    private String sql;
    private List<LexerToken> tokens;
    private ParseNode rootNode;
    private SqlEarley earley = SqlEarley.getInstance();
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    int parameterCount = -1;

    protected OracleParameterMetaDataParser() {
    }

    protected void initialize(String sql, OracleStatement.SqlKind sqlKind, int parameterCount) throws SQLException {
        if (sql == null || sql.length() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104).fillInStackTrace();
        }
        this.sql = sql;
        this.sqlKind = sqlKind;
        this.parameterCount = parameterCount;
    }

    private void parse() throws SQLException {
        this.tokens = Lexer.parse(this.sql);
        this.rootNode = this.earley.parse(this.tokens);
        int[] content = this.rootNode.content();
        if (content.length == 1 && content[0] == -1) {
            if (this.rootNode.topLevel.size() > 1) {
                throw DatabaseError.createSqlException(1736, null);
            }
            this.rootNode = this.rootNode.topLevel.iterator().next();
        }
    }

    private ParameterMetadataSql getParameterMetaDataSql_internal(ParseNode rootNode) {
        if (this.sqlKind != OracleStatement.SqlKind.UNINITIALIZED) {
            if (this.sqlKind.isPlsqlOrCall() || this.parameterCount == 0) {
                return null;
            }
            if (this.sqlKind == OracleStatement.SqlKind.INSERT) {
                return this.getParameterMetaDataSqlForInsert();
            }
        }
        return this.getParameterMetaDataSqlDefault(rootNode);
    }

    private ParameterMetadataSql getParameterMetaDataSqlDefault(ParseNode rootNode) {
        HashSet<String> withClauses = new HashSet<String>();
        ArrayList<BindMetaData> columnNames = new ArrayList<BindMetaData>();
        HashSet<String> tableNames = new HashSet<String>();
        ArrayList<FunctionParameterBindMetaData> functionParameters = new ArrayList<FunctionParameterBindMetaData>();
        int currentBindNumber = 1;
        for (ParseNode currentNode = rootNode; currentNode != null; currentNode = currentNode.next()) {
            boolean isWithClause;
            int[] content = currentNode.content();
            IntStream contentStream = IntStream.of(content);
            boolean containsBindVar = contentStream.anyMatch(x -> x == this.earley.getSymbol("bind_var"));
            if (containsBindVar) {
                this.findBindVarNodeMetaData(currentNode, columnNames, tableNames, functionParameters, currentBindNumber++);
            }
            if (!(isWithClause = IntStream.of(content).anyMatch(x -> x == this.earley.getSymbol("with_clause")))) continue;
            String withClause = this.sql.substring(this.tokens.get((int)currentNode.from).begin, this.tokens.get((int)(currentNode.to - 1)).end);
            withClauses.add(withClause);
        }
        return new ParameterMetadataSql(withClauses, columnNames, tableNames, functionParameters);
    }

    private ParameterMetadataSql[] getParameterMetaDataSqlsBySubQuery() {
        HashSet<Integer> subqueryIndices = new HashSet<Integer>();
        HashSet<String> withClauses = new HashSet<String>();
        HashMap subqueriesColumns = new HashMap();
        HashMap subqueriesTables = new HashMap();
        HashMap subqueriesFunctionParameters = new HashMap();
        int currentBindParameter = 1;
        for (ParseNode currentNode = this.rootNode.next(); currentNode != null; currentNode = currentNode.next()) {
            boolean isWithClause;
            int[] content = currentNode.content();
            IntStream contentStream = IntStream.of(content);
            boolean containsBindVar = contentStream.anyMatch(x -> x == this.earley.getSymbol("bind_var"));
            if (containsBindVar) {
                ParseNode subquery = this.findFirstAncestor(currentNode, new int[]{this.earley.getSymbol("query_block"), this.earley.getSymbol("subquery")});
                if (subqueriesColumns.get(subquery.from) == null) {
                    subqueriesColumns.put(subquery.from, new ArrayList());
                }
                if (subqueriesTables.get(subquery.from) == null) {
                    subqueriesTables.put(subquery.from, new HashSet());
                }
                if (subqueriesFunctionParameters.get(subquery.from) == null) {
                    subqueriesFunctionParameters.put(subquery.from, new ArrayList());
                }
                subqueryIndices.add(subquery.from);
                List columnNames = (List)subqueriesColumns.get(subquery.from);
                Set tableNames = (Set)subqueriesTables.get(subquery.from);
                List functionParameters = (List)subqueriesFunctionParameters.get(subquery.from);
                this.findBindVarNodeMetaData(currentNode, columnNames, tableNames, functionParameters, currentBindParameter++);
            }
            if (!(isWithClause = IntStream.of(content).anyMatch(x -> x == this.earley.getSymbol("with_clause")))) continue;
            String withClause = this.sql.substring(this.tokens.get((int)currentNode.from).begin, this.tokens.get((int)(currentNode.to - 1)).end);
            withClauses.add(withClause);
        }
        ArrayList<ParameterMetadataSql> multiSqls = new ArrayList<ParameterMetadataSql>();
        for (Integer subqueryIndex : subqueryIndices) {
            List columnNames = (List)subqueriesColumns.get(subqueryIndex);
            Set tableNames = (Set)subqueriesTables.get(subqueryIndex);
            List functionParameters = (List)subqueriesFunctionParameters.get(subqueryIndex);
            multiSqls.add(new ParameterMetadataSql(withClauses, columnNames, tableNames, functionParameters));
        }
        ParameterMetadataSql[] result = new ParameterMetadataSql[multiSqls.size()];
        return multiSqls.toArray(result);
    }

    private ParameterMetadataSql getParameterMetaDataSqlForInsert() {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<BindMetaData> columns = new ArrayList<BindMetaData>();
        HashSet<String> tableNames = new HashSet<String>();
        ArrayList<FunctionParameterBindMetaData> functionParameters = new ArrayList<FunctionParameterBindMetaData>();
        ArrayList<NoColumnInsertBindMetaData> noColumnInserts = new ArrayList<NoColumnInsertBindMetaData>();
        boolean valuesClauseFound = false;
        boolean tableInsertFound = false;
        int nbBindVarFound = 0;
        for (ParseNode currentNode = this.rootNode; currentNode != null; currentNode = currentNode.next()) {
            int[] content = currentNode.content();
            tableInsertFound = IntStream.of(content).anyMatch(x -> x == this.earley.getSymbol("insert_into_clause"));
            if (tableInsertFound) {
                for (ParseNode childNode : currentNode.descendants()) {
                    int[] childNodeContent = childNode.content();
                    boolean columnFound = IntStream.of(childNodeContent).anyMatch(x -> x == this.earley.getSymbol("column"));
                    if (columnFound) {
                        StringBuilder columnNameBuilder = new StringBuilder();
                        for (int k = childNode.from; k < childNode.to; ++k) {
                            columnNameBuilder.append(this.tokens.get((int)k).content);
                        }
                        columnNames.add(columnNameBuilder.toString());
                        continue;
                    }
                    boolean tablesFound = IntStream.of(childNodeContent).anyMatch(x -> x == this.earley.getSymbol("dml_table_expression_clause"));
                    if (!tablesFound) continue;
                    StringBuilder tableNameBuilder = new StringBuilder();
                    int last_end = this.tokens.get((int)childNode.from).begin;
                    for (int l = childNode.from; l < childNode.to; ++l) {
                        LexerToken token = this.tokens.get(l);
                        if (last_end < token.begin) {
                            for (int m = 0; m < token.begin - last_end; ++m) {
                                tableNameBuilder.append(" ");
                            }
                        }
                        tableNameBuilder.append(this.tokens.get((int)l).content);
                        last_end = token.end;
                    }
                    tableNames.add(tableNameBuilder.toString());
                }
            } else {
                IntStream contentStream = IntStream.of(content);
                valuesClauseFound = contentStream.anyMatch(x -> x == this.earley.getSymbol("values_clause"));
                if (valuesClauseFound) {
                    boolean isMissingColumns = columnNames.isEmpty();
                    ParseNode valuesClauseNode = currentNode;
                    int bindColumnPosition = 0;
                    int currentColumn = 0;
                    int skipTo = -1;
                    for (ParseNode valueClauseChildNode : valuesClauseNode.descendants()) {
                        if (valueClauseChildNode == valuesClauseNode || skipTo != -1 && valueClauseChildNode.from <= skipTo) continue;
                        skipTo = -1;
                        int[] valueClauseChildNodeContent = valueClauseChildNode.content();
                        contentStream = IntStream.of(valueClauseChildNodeContent);
                        boolean bindVarFound = contentStream.anyMatch(x -> x == this.earley.getSymbol("bind_var"));
                        if (bindVarFound) {
                            ++nbBindVarFound;
                            ++bindColumnPosition;
                            ++currentColumn;
                            if (!isMissingColumns || tableNames.size() != 1) continue;
                            noColumnInserts.add(new NoColumnInsertBindMetaData((String)tableNames.iterator().next(), currentColumn, nbBindVarFound));
                            continue;
                        }
                        contentStream = IntStream.of(valueClauseChildNodeContent);
                        boolean literalFound = contentStream.anyMatch(x -> x == this.earley.getSymbol("string_literal") || x == this.earley.getSymbol("digits") || x == this.earley.getSymbol("'NULL'"));
                        if (literalFound) {
                            contentStream = IntStream.of(valueClauseChildNode.parent.content());
                            boolean isBindVar = contentStream.anyMatch(x -> x == this.earley.getSymbol("bind_var"));
                            if (isBindVar) continue;
                            if (!isMissingColumns) {
                                columnNames.remove(bindColumnPosition);
                                continue;
                            }
                            ++currentColumn;
                            continue;
                        }
                        boolean isUserDefinedFunction = IntStream.of(valueClauseChildNodeContent).anyMatch(x -> x == this.earley.getSymbol("user_defined_function"));
                        if (isUserDefinedFunction) {
                            ParseNode parametersNode;
                            String functionName = null;
                            ParseNode functionNameNode = this.findFirstDescendant(valueClauseChildNode, new int[]{this.earley.getSymbol("user_defined_function___0"), this.earley.getSymbol("user_defined_function___1")});
                            if (functionNameNode != null) {
                                StringBuilder functionNameBuilder = new StringBuilder();
                                for (int i = functionNameNode.from; i < functionNameNode.to; ++i) {
                                    functionNameBuilder.append(this.sql.substring(this.tokens.get((int)i).begin, this.tokens.get((int)i).end));
                                }
                                functionName = functionNameBuilder.toString();
                                if (!functionName.startsWith("\"") && !functionName.startsWith("'") && functionName.indexOf(".") < functionName.length() - 1) {
                                    functionName = functionName.substring(functionName.indexOf(".") + 1);
                                }
                            }
                            if ((parametersNode = this.findFirstDescendant(valueClauseChildNode, new int[]{this.earley.getSymbol("\"(x,y,z)\"")})) != null) {
                                ParseNode parameterList = this.findFirstDescendant(parametersNode, new int[]{this.earley.getSymbol("\"expr_list\"")});
                                if (parameterList != null) {
                                    int currentParameter = 1;
                                    boolean foundBindVar = false;
                                    for (ParseNode node : parameterList.descendants()) {
                                        contentStream = IntStream.of(valueClauseChildNode.parent.content());
                                        boolean isBindVar = contentStream.anyMatch(x -> x == this.earley.getSymbol("bind_var"));
                                        if (isBindVar) {
                                            foundBindVar = true;
                                            if (functionName == null) continue;
                                            functionParameters.add(new FunctionParameterBindMetaData(functionName, currentParameter, bindColumnPosition));
                                            continue;
                                        }
                                        if (node.to - node.from != 1 || !",".equals(this.sql.substring(this.tokens.get((int)node.from).begin, this.tokens.get((int)node.from).end))) continue;
                                        ++currentParameter;
                                    }
                                    if (!foundBindVar && !isMissingColumns) {
                                        columnNames.remove(bindColumnPosition);
                                    }
                                    skipTo = parameterList.to;
                                } else if (!isMissingColumns) {
                                    columnNames.remove(bindColumnPosition);
                                }
                            }
                            if (!isMissingColumns) continue;
                            ++currentColumn;
                            continue;
                        }
                        boolean isColumn = IntStream.of(valueClauseChildNodeContent).anyMatch(x -> x == this.earley.getSymbol("column"));
                        if (!isColumn) continue;
                        if (!isMissingColumns) {
                            columnNames.remove(bindColumnPosition);
                            continue;
                        }
                        ++currentColumn;
                    }
                } else {
                    boolean isSubquery = IntStream.of(content).anyMatch(x -> x == this.earley.getSymbol("query_block"));
                    if (isSubquery) {
                        ParameterMetadataSql subqueryPmtdt = this.getParameterMetaDataSqlDefault(currentNode);
                        if (subqueryPmtdt.columns != null && !subqueryPmtdt.columns.isEmpty()) {
                            columnNames.clear();
                            columns.addAll(subqueryPmtdt.columns);
                            tableNames.addAll(subqueryPmtdt.tables);
                            functionParameters.addAll(subqueryPmtdt.functionParameters);
                        }
                    }
                }
            }
            if (valuesClauseFound && tableInsertFound) break;
        }
        if (!columnNames.isEmpty()) {
            int i = 1;
            for (String columnName : columnNames) {
                columns.add(new BindMetaData(columnName, i));
                ++i;
            }
        }
        if (!noColumnInserts.isEmpty()) {
            return new ParameterMetadataSql(noColumnInserts);
        }
        return new ParameterMetadataSql(new HashSet<String>(), columns, tableNames, functionParameters);
    }

    private ParseNode findFirstAncestor(ParseNode node, int[] symbols) {
        ParseNode parentNode = node.parent;
        while (parentNode != null) {
            int[] parentNodeContent = parentNode.content();
            boolean nodeFound = IntStream.of(parentNodeContent).anyMatch(nodeContent -> OracleParameterMetaDataParser.arrayContains(symbols, nodeContent));
            if (!nodeFound) {
                if (!IntStream.of(parentNodeContent).anyMatch(nodeContent -> OracleParameterMetaDataParser.arrayContains(new int[]{this.earley.getSymbol("cast")}, nodeContent))) {
                    parentNode = parentNode.parent;
                    continue;
                }
                return parentNode;
            }
            return parentNode;
        }
        return null;
    }

    private ParseNode findFirstDescendant(ParseNode node, int[] symbols) {
        if (node == null) {
            return null;
        }
        List<ParseNode> nodeDescendants = node.descendants();
        for (ParseNode nodeDescendant : nodeDescendants) {
            int[] nodeContent;
            boolean nodeFound;
            boolean isParentBindVar = false;
            if (nodeDescendant.parent != null) {
                isParentBindVar = IntStream.of(nodeDescendant.parent.content()).anyMatch(nodeContentElement -> OracleParameterMetaDataParser.arrayContains(new int[]{this.earley.getSymbol("bind_var")}, nodeContentElement));
            }
            if (isParentBindVar || !(nodeFound = IntStream.of(nodeContent = nodeDescendant.content()).anyMatch(nodeContentElement -> OracleParameterMetaDataParser.arrayContains(symbols, nodeContentElement)))) continue;
            return nodeDescendant;
        }
        return null;
    }

    private List<ParseNode> findAllDescendants(ParseNode node, int[] symbols) {
        if (node == null) {
            return null;
        }
        ArrayList<ParseNode> result = new ArrayList<ParseNode>();
        List<ParseNode> nodeDescendants = node.descendants();
        int subquery_begin = 0;
        int subquery_end = 0;
        for (ParseNode nodeDescendant : nodeDescendants) {
            boolean nodeFound;
            if (node == nodeDescendant) continue;
            int[] nodeContent = nodeDescendant.content();
            boolean isSubquery = IntStream.of(nodeContent).anyMatch(nodeContentElement -> nodeContentElement == this.earley.getSymbol("query_block"));
            if (isSubquery && nodeDescendant.from > 0) {
                subquery_begin = nodeDescendant.from;
                subquery_end = nodeDescendant.to;
                continue;
            }
            if (nodeDescendant.from >= subquery_begin && nodeDescendant.to < subquery_end) continue;
            if (nodeDescendant.from > subquery_end) {
                subquery_begin = 0;
                subquery_end = 0;
            }
            if (!(nodeFound = IntStream.of(nodeContent).anyMatch(nodeContentElement -> OracleParameterMetaDataParser.arrayContains(symbols, nodeContentElement))) || nodeDescendant.parent != null && IntStream.of(nodeDescendant.parent.content()).anyMatch(nodeContentElement -> OracleParameterMetaDataParser.arrayContains(symbols, nodeContentElement))) continue;
            result.add(nodeDescendant);
        }
        return result;
    }

    private void findBindVarNodeMetaData(ParseNode bindVarNode, List<BindMetaData> columnNames, Set<String> tableNames, List<FunctionParameterBindMetaData> functionParameters, int currentBindNumber) {
        ParseNode conditionNode = this.findFirstAncestor(bindVarNode, new int[]{this.earley.getSymbol("user_defined_function"), this.earley.getSymbol("extract_datetime"), this.earley.getSymbol("condition"), this.earley.getSymbol("update_set_clause_expr"), this.earley.getSymbol("function"), this.earley.getSymbol("row_limiting_clause")});
        if (conditionNode != null) {
            ParseNode tempNode;
            ParseNode inValuesNode = null;
            if (conditionNode.contains(this.earley.getSymbol("in_condition"))) {
                tempNode = bindVarNode;
                while ((tempNode = tempNode.parent) != null) {
                    if (!tempNode.contains(this.earley.getSymbol("in_condition___2"))) continue;
                    inValuesNode = tempNode;
                    break;
                }
            } else if (conditionNode.contains(this.earley.getSymbol("in_condition___2"))) {
                inValuesNode = conditionNode;
            }
            if (inValuesNode != null) {
                tempNode = inValuesNode;
                int valuePosition = 1;
                int parenthesesTracker = 0;
                while ((tempNode = tempNode.next()) != bindVarNode) {
                    if (tempNode.contains(this.earley.getSymbol("','")) && parenthesesTracker != 0) {
                        ++valuePosition;
                        continue;
                    }
                    if (tempNode.contains(this.earley.getSymbol("'('"))) {
                        ++parenthesesTracker;
                        continue;
                    }
                    if (!tempNode.contains(this.earley.getSymbol("')'")) || --parenthesesTracker != 0) continue;
                    valuePosition = 1;
                    parenthesesTracker = 0;
                }
                tempNode = conditionNode;
                int tempPosition = 1;
                int startPosition = tempNode.next().from;
                while ((tempNode = tempNode.next()) != inValuesNode) {
                    if (tempNode.next().contains(this.earley.getSymbol("','")) || tempNode.next().contains(this.earley.getSymbol("')'"))) {
                        if (tempPosition == valuePosition) {
                            columnNames.add(new BindMetaData(this.sql.substring(this.tokens.get((int)startPosition).begin, this.tokens.get((int)tempNode.to).begin), currentBindNumber));
                            break;
                        }
                        startPosition = tempNode.next().next().from;
                        ++tempPosition;
                        continue;
                    }
                    if (!tempNode.contains(this.earley.getSymbol("'('"))) continue;
                    startPosition = tempNode.next().from;
                }
                this.extractTableNamesFromValueNode(tableNames, conditionNode);
            } else if (conditionNode.contains(this.earley.getSymbol("cast"))) {
                ParseNode datatype = this.findFirstDescendant(conditionNode, new int[]{this.earley.getSymbol("datatype")});
                if (datatype != null) {
                    String datatypeString = this.sql.substring(this.tokens.get((int)datatype.from).begin, this.tokens.get((int)datatype.to).begin);
                    columnNames.add(new BindMetaData("CAST('A' AS " + datatypeString + ")", currentBindNumber));
                }
            } else if (conditionNode.contains(this.earley.getSymbol("extract_datetime"))) {
                columnNames.add(new BindMetaData("CAST('A' AS TIMESTAMP)", currentBindNumber));
            } else if (conditionNode.contains(this.earley.getSymbol("row_limiting_clause"))) {
                columnNames.add(new BindMetaData("1", currentBindNumber));
            } else if (conditionNode.contains(this.earley.getSymbol("user_defined_function")) || conditionNode.contains(this.earley.getSymbol("function"))) {
                ParseNode parameterList;
                ParseNode parametersNode;
                String functionName = null;
                ParseNode functionNameNode = this.findFirstDescendant(conditionNode, new int[]{this.earley.getSymbol("user_defined_function___0"), this.earley.getSymbol("user_defined_function___1"), this.earley.getSymbol("expr")});
                if (functionNameNode != null) {
                    StringBuilder functionNameBuilder = new StringBuilder();
                    for (int i = functionNameNode.from; i < functionNameNode.to; ++i) {
                        functionNameBuilder.append(this.sql.substring(this.tokens.get((int)i).begin, this.tokens.get((int)i).end));
                    }
                    functionName = functionNameBuilder.toString();
                    if (functionName.contains("(")) {
                        functionName = functionName.substring(0, functionName.indexOf("("));
                    }
                    if (!functionName.startsWith("\"") && !functionName.startsWith("'") && functionName.indexOf(".") < functionName.length() - 1) {
                        functionName = functionName.substring(functionName.indexOf(".") + 1);
                    }
                }
                if ((parametersNode = this.findFirstDescendant(conditionNode, new int[]{this.earley.getSymbol("\"(x,y,z)\""), this.earley.getSymbol("expr")})) != null && (parameterList = this.findFirstDescendant(parametersNode, new int[]{this.earley.getSymbol("\"expr_list\""), this.earley.getSymbol("expr#")})) != null) {
                    int currentParameter = 1;
                    for (ParseNode node : parameterList.descendants()) {
                        if (node == bindVarNode) {
                            if (functionName == null) continue;
                            switch (functionName.toUpperCase()) {
                                case "NVL": 
                                case "COALESCE": {
                                    columnNames.add(new BindMetaData(null, currentBindNumber));
                                    break;
                                }
                                default: {
                                    functionParameters.add(new FunctionParameterBindMetaData(functionName, currentParameter, currentBindNumber));
                                    break;
                                }
                            }
                            continue;
                        }
                        if (node.to - node.from != 1 || !",".equals(this.sql.substring(this.tokens.get((int)node.from).begin, this.tokens.get((int)node.from).end))) continue;
                        ++currentParameter;
                    }
                }
            } else {
                ParseNode valueNode = this.findFirstDescendant(conditionNode, new int[]{this.earley.getSymbol("column"), this.earley.getSymbol("string_literal"), this.earley.getSymbol("digits"), this.earley.getSymbol("'ROWID'"), this.earley.getSymbol("user_defined_function"), this.earley.getSymbol("single_row_function"), this.earley.getSymbol("aggregate_function"), this.earley.getSymbol("compound_expression")});
                if (valueNode != null) {
                    ParseNode aggregateFuncNameNode;
                    ParseNode aggregateFuncNode = this.findFirstDescendant(valueNode, new int[]{this.earley.getSymbol("aggregate_function")});
                    if (aggregateFuncNode != null && (aggregateFuncNameNode = this.findFirstDescendant(aggregateFuncNode, new int[]{this.earley.getSymbol("\"aggr_name\"")})) != null) {
                        StringBuilder aggregateFuncNameBuilder = new StringBuilder();
                        int last_end = this.tokens.get((int)aggregateFuncNameNode.from).begin;
                        for (int k = aggregateFuncNameNode.from; k < aggregateFuncNameNode.to; ++k) {
                            Object token = this.tokens.get(k);
                            if (last_end < ((LexerToken)token).begin) {
                                for (int m = 0; m < ((LexerToken)token).begin - last_end; ++m) {
                                    aggregateFuncNameBuilder.append(" ");
                                }
                            }
                            aggregateFuncNameBuilder.append(((LexerToken)token).content);
                            last_end = ((LexerToken)token).end;
                        }
                        String aggregateFuncName = aggregateFuncNameBuilder.toString().toUpperCase();
                        switch (aggregateFuncName) {
                            case "COUNT": {
                                columnNames.add(new BindMetaData("1", currentBindNumber));
                                return;
                            }
                        }
                        valueNode = this.findFirstDescendant(aggregateFuncNode, new int[]{this.earley.getSymbol("column"), this.earley.getSymbol("string_literal"), this.earley.getSymbol("digits"), this.earley.getSymbol("'ROWID'"), this.earley.getSymbol("user_defined_function"), this.earley.getSymbol("compound_expression")});
                    }
                    StringBuilder columnNameBuilder = new StringBuilder();
                    int last_end = this.tokens.get((int)valueNode.from).begin;
                    for (int k = valueNode.from; k < valueNode.to; ++k) {
                        LexerToken token = this.tokens.get(k);
                        if (last_end < token.begin) {
                            for (int m = 0; m < token.begin - last_end; ++m) {
                                columnNameBuilder.append(" ");
                            }
                        }
                        columnNameBuilder.append(token.content);
                        last_end = token.end;
                    }
                    String currentColumnName = columnNameBuilder.toString();
                    if ("LEVEL".equalsIgnoreCase(currentColumnName) && this.findFirstAncestor(conditionNode, new int[]{this.earley.getSymbol("hierarchical_query_clause")}) != null) {
                        columnNames.add(new BindMetaData("1", currentBindNumber));
                    } else {
                        columnNames.add(new BindMetaData(currentColumnName, currentBindNumber));
                        this.extractTableNamesFromValueNode(tableNames, valueNode);
                    }
                } else {
                    ParseNode nullCondition = this.findFirstDescendant(conditionNode, new int[]{this.earley.getSymbol("null_condition")});
                    if (nullCondition != null) {
                        columnNames.add(null);
                    } else {
                        columnNames.add(new BindMetaData(null, currentBindNumber));
                    }
                }
            }
        } else {
            columnNames.add(new BindMetaData(null, currentBindNumber));
        }
    }

    private void extractTableNamesFromValueNode(Set<String> tableNames, ParseNode valueNode) {
        List<ParseNode> tableNodes;
        ParseNode tableBlockNode = this.findFirstAncestor(valueNode, new int[]{this.earley.getSymbol("query_block"), this.earley.getSymbol("subquery"), this.earley.getSymbol("delete"), this.earley.getSymbol("update")});
        if (tableBlockNode != null && (tableNodes = this.findAllDescendants(tableBlockNode, new int[]{this.earley.getSymbol("table_reference"), this.earley.getSymbol("dml_table_expression_clause"), this.earley.getSymbol("aliased_dml_table_expression_clause"), this.earley.getSymbol("external_table")})) != null && !tableNodes.isEmpty()) {
            int last_end = -1;
            for (ParseNode tableNode : tableNodes) {
                ParseNode subquery = this.findFirstAncestor(tableNode, new int[]{this.earley.getSymbol("query_block")});
                if (subquery != null && (valueNode.from < subquery.from || valueNode.to > subquery.to)) continue;
                StringBuilder tableNameBuilder = new StringBuilder();
                if (last_end >= this.tokens.get((int)tableNode.from).begin) continue;
                last_end = this.tokens.get((int)tableNode.from).begin;
                boolean encounteredWhitespaces = false;
                for (int l = tableNode.from; l < tableNode.to; ++l) {
                    LexerToken token = this.tokens.get(l);
                    if (last_end < token.begin) {
                        encounteredWhitespaces = true;
                        for (int m = 0; m < token.begin - last_end; ++m) {
                            tableNameBuilder.append(" ");
                        }
                    }
                    if (this.tokens.get((int)l).content.startsWith("\"") || this.tokens.get((int)l).content.startsWith("'")) {
                        tableNameBuilder.append(this.tokens.get((int)l).content);
                    } else if (!encounteredWhitespaces) {
                        tableNameBuilder.append(this.tokens.get((int)l).content.toUpperCase());
                    } else {
                        tableNameBuilder.append(this.tokens.get((int)l).content);
                    }
                    last_end = token.end;
                }
                tableNames.add(tableNameBuilder.toString());
            }
        }
    }

    public ParameterMetadataSql getParameterMetaDataSql() throws SQLException {
        if (this.sqlKind.isPlsqlOrCall() || this.parameterCount == 0) {
            return null;
        }
        if (this.rootNode == null) {
            this.parse();
        }
        return this.getParameterMetaDataSql_internal(this.rootNode);
    }

    public ParameterMetadataSql[] getParameterMetaDataSqls() throws SQLException {
        if (this.sqlKind.isPlsqlOrCall() || this.parameterCount == 0) {
            return null;
        }
        if (this.rootNode == null) {
            this.parse();
        }
        return this.getParameterMetaDataSqlsBySubQuery();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static boolean arrayContains(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] cases = null;
        if (args.length < 1) {
            System.err.println("ERROR: incorrect usage. OracleParameterMetaDataParser <-test| sql >");
            return;
        }
        cases = "-test".equals(args[0]) ? new String[]{"insert into JAVA_KEYWORDS (\"ABSTRACT\",\"ASSERT\",\"BOOLEAN\",\"BREAK\",\"BYTE\",\"CASE\",\"CATCH\",\"CHAR\",\"CLASS\",\"CONST \",\"CONTINUE\",\"DEFAULT\",\"DO\",\"DOUBLE\",\"ELSE\",\"ENUM \",\"EXTENDS\",\"FINAL\",\"FINALLY\",\"FLOAT\",\"FOR\",\"GOTO \",\"IF\",\"IMPLEMENTS\",\"IMPORT\",\"INSTANCEOF\",\"INT\",\"INTERFACE\",\"LONG\",\"NATIVE\",\"NEW\",\"PACKAGE\",\"PRIVATE\",\"PROTECTED\",\"PUBLIC\",\"RETU RN\",\"SHORT\",\"STATIC\",\"STRICTFP \",\"SUPER\",\"SWITCH\",\"SYNCHRONIZED\",\"THIS\",\"THROW\",\"THROWS\",\"TRANS IENT\",\"TRY\",\"VOID\",\"VOLATILE\",\"WHILE\", \"ID\") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?  ,?,?,?,?,?,?,?,?,?,?,?,?)", "INSERT INTO emp(empno,ename,sal) VALUES(:B1, :b2, :b3)", "INSERT INTO T1 VALUES(:BIND1, :bind2)", "begin INSERT INTO T1 VALUES(:BIND1, :bind2); end;", "UPDATE T1 SET  C1 = :B1 and c2 = :b2 and c3 = 'abc'", "UPDATE T1 SET C1 = :B1 and  c2 = :b2 and c3 = 'abc'", "UPDATE T1 SET    C1 = :B1 and    c2 = :b2 and    c3 = 'abc' and c4 = :b4", "SELECT ename from emp where empno = :a1 and sal = :a2", "DELETE FROM EMP WHERE EMPNO>:x", "DELETE FROM EMP WHERE EMPNO   >   :1", "DELETE FROM EMP WHERE EMPNO   >   :1", "DELETE FROM EMP WHERE EMPNO\n>\n:2", "DELETE FROM EMP WHERE EMPNO\n<>\n:3", "DELETE FROM EMP WHERE EMPNO\n<>\n'abc'", "SELECT ename, d.deptno from emp e, dept d where empno = ?  and sal = ? and e.deptno = d.deptno", "SELECT ename, d.deptno from emp e, dept d where empno = :a1 and sal = :a2 and e.deptno = d.deptno", "SELECT ename, deptno   from    emp   , dept    where    empno =    :a1 and   sal = :a2", "SELECT * FROM TKPJST58_TAB WHERE C1 = :2", "SELECT * FROM TKPJST58_TAB WHERE C1 is null and c2 = :1 and c3 = :4", "SELECT * FROM TKPJST58_TAB WHERE C1 is NULL  AND C2 = :1   AND C3 = :2   AND C4 = :3   AND C5 = :4   AND C6 = :5   AND C7 = :6   AND C8 = :7   AND C9 = :8   AND C10 = :9   AND C11 = :10   AND C12 = :11   AND C13 = :12   AND C14 = :13   AND C15 = :14   AND C16 is not null  AND C17 <> :15", "SELECT * FROM TKPJST58_TAB WHERE C1 = ?  AND C2 = ?  AND C3 = ?  AND C4 = ?  AND C5 = ?  AND C6 = ?  AND C7 = ?  AND C8 = ?  AND C9 = ?  AND C10 = ?  AND C11 = ?  AND C12 = ?  AND C13 = ?  AND C14 = ?  AND C15 = ?  AND C16 = ?  AND C17 = ?", "INSERT INTO TKPJST58_TAB(c1, c2, c3, c4, c5, c9, c14, c10) values (?,?,?,?,?,?,?,?)", "INSERT INTO TKPJST58_TAB values (12,'abc',?,?,?,?,?,?)", "INSERT INTO TKPJST58_TAB values (12,'abc',:1,:2,:3,:4,:5)", "INSERT INTO TKPJST58_TAB(c1,c2,c3,c4,c5,c6,c7) values (12,'abc',:1,:2,:3,:4,:5)", "INSERT INTO TKPJST58_TAB(c1,c2,c3,c4,c5,c6,c7) values (12,'abc',:1,:2,55,:4,:5)", "insert into rawtab values ('010203040506', '0708090a0b0c0d')", "begin insert into asciitab values (200,'21-sep-71',?,?,?); end;", "select col from dummy_tab where rowid=?", "SELECT * FROM test2 WHERE key >= ? ORDER BY key", "SELECT * FROM test2 WHERE key>=? ORDER BY key", "INSERT INTO tkpjb2354325_tab VALUES (111, {ts '1999-12-31 12:59:59'})", "SELECT user FROM dual WHERE  ? < { fn LOCATE('TEST123TEST', 1) }", "INSERT INTO tkpjb2354325_tab VALUES (111, {ts '1999-12-31 12:59:59'}, :3)", "delete from tkpjdg02_view where id >? returning id, name into ?, ?", "SELECT * FROM TABLE( CAST(? AS TYPE_VARCHAR_NT) )", "insert into (select t.col1 as column1, t.col2 as column2 from tkpjsc37 t  where t.col1 in (?,?,?,?)) values ( ?, ?)", "delete from tkpjdg02_view where id >? AND returning_id = ?", "insert into tkpjir93_tab values (?,q'!name LIKE '%DBMS_%%'!')", "insert into tkpjir93_tab values (?,q'{SELECT * FROM employees WHERE last_name = 'Smith';}'", "insert into xml_test values ('adf', '<?xml version=\"1.0\" encoding=\"UTF-8\"?><a></a>')", "SELECT * FROM test2 WHERE key>=? and ORDER_id=?  order BY key", "insert into emp(empno, ename, sal) values (?, N'abc', ?)", "UPDATE tkpjb5752856_tab SET c2=N'????C Mother''s Maiden Name????'", "INSERT INTO TKPJST58_TAB(c1, c2, c3, c4, c5, c9, c14, c10) values (12,'abc',?,?,?,?,?,?)", "UPDATE /*abc*/T1 SET/*xyz*/ C1 = :B1 /*nyl*/and/*bac*/ c2 = :b2 and c3 = 'abc'", "SELECT * FROM TKPJST58_TAB WHERE C1 is/*abc*/ null and c2 = :1 and c3 = :4", "SELECT * FROM TKPJST58_TAB WHERE C1 is/*abc*/not--xyz\n null and c2 = :1 and c3 = :4", "UPDATE TKPJST58_TAB/*comment1*/set/*comment2*/ C1 = ?  WHERE  C4 = /*abc*/? ", "UPDATE TKPJST58_TAB set C1 = ?  and c2 = ? WHERE  C4 = /*abc*/? and c5 = ?"} : args;
        for (String testCase : cases) {
            try {
                OracleSql o = new OracleSql(null);
                o.initialize(testCase);
                String sql = o.getSql(true, true);
                System.out.println("SQL:" + sql);
                System.out.println("  SqlKind:" + String.valueOf((Object)o.sqlKind) + ", Parameter Count=" + o.parameterCount);
                if (!o.sqlKind.isPlsqlOrCall() && o.parameterCount > 0) {
                    OracleParameterMetaDataParser opmdp = new OracleParameterMetaDataParser();
                    opmdp.initialize(sql, o.sqlKind, o.parameterCount);
                    System.out.println("  Parameter SQL: " + opmdp.getParameterMetaDataSql().getMetadataSQL());
                } else {
                    System.out.println("  Cannot get Parameter MetaData");
                }
                System.out.println("\n");
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }

    private static class OracleSqlType {
        private int dataType;
        private String className;

        private OracleSqlType(String OracleSqlType2) {
            switch (OracleSqlType2) {
                case "CHAR": 
                case "CHARACTER": 
                case "LONG": 
                case "STRING": 
                case "VARCHAR": 
                case "VARCHAR2": {
                    this.dataType = 1;
                    this.className = "java.lang.String";
                    break;
                }
                case "NCHAR": 
                case "NVARCHAR2": {
                    this.dataType = -15;
                    this.className = "oracle.sql.NString";
                    break;
                }
                case "NCLOB": {
                    this.dataType = 2011;
                    this.className = "oracle.sql.NCLOB";
                    break;
                }
                case "RAW": 
                case "LONG RAW": {
                    this.dataType = -2;
                    this.className = "oracle.sql.RAW";
                    break;
                }
                case "BINARY_INTEGER": 
                case "NATURAL": 
                case "NATURALN": 
                case "PLS_INTEGER": 
                case "POSITIVE": 
                case "POSITIVEN": 
                case "SIGNTYPE": 
                case "INT": 
                case "INTEGER": {
                    this.dataType = 2;
                    this.className = "java.lang.Integer";
                    break;
                }
                case "DEC": 
                case "DECIMAL": 
                case "NUMBER": 
                case "NUMERIC": {
                    this.dataType = 2;
                    this.className = "java.math.BigDecimal";
                    break;
                }
                case "DOUBLE PRECISION": 
                case "FLOAT": {
                    this.dataType = 8;
                    this.className = "java.lang.Double";
                    break;
                }
                case "SMALLINT": {
                    this.dataType = 2;
                    this.className = "java.lang.Integer";
                    break;
                }
                case "REAL": {
                    this.dataType = 2;
                    this.className = "java.lang.Float";
                    break;
                }
                case "DATE": {
                    this.dataType = 91;
                    this.className = "java.sql.Timestamp";
                    break;
                }
                case "TIMESTAMP WITH TZ": 
                case "TIMESTAMP WITH LOCAL TZ": {
                    this.dataType = 2014;
                    this.className = "java.sql.Timestamp";
                    break;
                }
                case "INTERVAL YEAR TO MONTH": 
                case "INTERVAL DAY TO SECOND": {
                    this.dataType = 12;
                    this.className = "java.lang.String";
                    break;
                }
                case "ROWID": 
                case "UROWID": {
                    this.dataType = -8;
                    this.className = "oracle.sql.ROWID";
                    break;
                }
                case "BOOLEAN": {
                    this.dataType = 16;
                    this.className = "java.lang.Boolean";
                    break;
                }
                case "CLOB": {
                    this.dataType = 2005;
                    this.className = "java.sql.Clob";
                    break;
                }
                case "BLOB": {
                    this.dataType = 2004;
                    this.className = "java.sql.Blob";
                    break;
                }
                case "BFILE": {
                    this.dataType = -2;
                    this.className = "oracle.sql.BFILE";
                    break;
                }
                case "VARRAY": {
                    this.dataType = 2003;
                    this.className = "java.sql.Array";
                    break;
                }
                case "REF CURSOR": {
                    this.dataType = 2012;
                    this.className = "java.sql.Array";
                    break;
                }
                case "VECTOR": {
                    this.dataType = -105;
                    this.className = "java.lang.Object";
                    break;
                }
                default: {
                    this.dataType = 12;
                    this.className = "java.lang.String";
                }
            }
        }

        public int getDataType() {
            return this.dataType;
        }

        public String getClassName() {
            return this.className;
        }
    }

    protected static class ParameterMetadataSql {
        Set<String> withClauses;
        List<BindMetaData> columns;
        Set<String> tables;
        List<FunctionParameterBindMetaData> functionParameters;
        List<NoColumnInsertBindMetaData> noColumnInsertBindMetaDataList;
        int nbBindsRegular = 0;
        int nbBindsAnyData = 0;
        ParameterMetadata[] parametersMetadata;

        public ParameterMetadataSql(Set<String> withClauses, List<BindMetaData> columns, Set<String> tables, List<FunctionParameterBindMetaData> functionParameters) {
            this.withClauses = withClauses;
            this.columns = columns;
            this.tables = tables;
            this.functionParameters = functionParameters;
        }

        public ParameterMetadataSql(List<NoColumnInsertBindMetaData> noColumnInsertBindMetaDataList) {
            this.noColumnInsertBindMetaDataList = noColumnInsertBindMetaDataList;
        }

        public int getNbParameters() {
            return (this.columns != null ? this.columns.size() : 0) + (this.functionParameters != null ? this.functionParameters.size() : 0) + (this.noColumnInsertBindMetaDataList != null ? this.noColumnInsertBindMetaDataList.size() : 0);
        }

        public String getMetadataSQL() {
            Object metadataSQL = null;
            if (this.columns != null && !this.columns.isEmpty()) {
                int i;
                List trimmedColumns = this.columns.stream().filter(column -> column != null && column.getColumnName() != null).collect(Collectors.toList());
                if (trimmedColumns.isEmpty()) {
                    return null;
                }
                this.nbBindsAnyData = this.columns.size() - trimmedColumns.size();
                StringBuilder sb = new StringBuilder(100);
                if (this.withClauses != null && !this.withClauses.isEmpty()) {
                    for (String withClause : this.withClauses) {
                        sb.append(withClause + " ");
                    }
                }
                sb.append("SELECT ");
                for (i = 0; i < trimmedColumns.size(); ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(((BindMetaData)trimmedColumns.get(i)).getColumnName());
                }
                sb.append(" FROM ");
                if (this.tables != null && !this.tables.isEmpty()) {
                    i = 0;
                    for (String table : this.tables) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(table);
                        ++i;
                    }
                } else {
                    sb.append("DUAL");
                }
                metadataSQL = sb.toString();
            } else if (this.noColumnInsertBindMetaDataList != null && !this.noColumnInsertBindMetaDataList.isEmpty()) {
                metadataSQL = "SELECT * FROM " + this.noColumnInsertBindMetaDataList.get(0).getTableName();
            }
            return metadataSQL;
        }

        public void query(Connection connection) throws SQLException {
            this.queryRegularParams(connection);
            this.queryFunctionParameters(connection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queryRegularParams(Connection connection) throws SQLException {
            this.parametersMetadata = null;
            String metadataSQL = this.getMetadataSQL();
            if (metadataSQL != null && !metadataSQL.isEmpty()) {
                OraclePreparedStatement pstmt = null;
                try {
                    int nbFunctionParameters;
                    pstmt = (OraclePreparedStatement)connection.prepareStatement(metadataSQL);
                    ResultSetMetaData rsmd = pstmt.getMetaData();
                    int n = nbFunctionParameters = this.functionParameters != null ? this.functionParameters.size() : 0;
                    if (this.noColumnInsertBindMetaDataList != null && !this.noColumnInsertBindMetaDataList.isEmpty() && rsmd.getColumnCount() != this.noColumnInsertBindMetaDataList.size()) {
                        throw DatabaseError.createSqlException(1734, null);
                    }
                    this.parametersMetadata = new ParameterMetadata[rsmd.getColumnCount() + this.nbBindsAnyData + nbFunctionParameters];
                    int k = 1;
                    for (int j = 0; j < rsmd.getColumnCount() + this.nbBindsAnyData; ++j) {
                        if (this.tables != null) {
                            if (!(this.columns == null || this.columns.isEmpty() || this.columns.get(j) != null && this.columns.get(j).getColumnName() != null)) {
                                this.parametersMetadata[j] = null;
                                continue;
                            }
                            this.parametersMetadata[j] = new ParameterMetadata(this.columns.get(j).getBindNumber(), rsmd.isNullable(k), rsmd.isSigned(k), rsmd.getPrecision(k), rsmd.getScale(k), rsmd.getColumnType(k), rsmd.getColumnTypeName(k), rsmd.getColumnClassName(k), 1, rsmd.unwrap(OracleResultSetMetaData.class).getVectorMetaData(k));
                            ++k;
                            continue;
                        }
                        if (this.noColumnInsertBindMetaDataList == null || this.noColumnInsertBindMetaDataList.isEmpty()) continue;
                        this.parametersMetadata[j] = new ParameterMetadata(this.noColumnInsertBindMetaDataList.get(j).getBindNumber(), rsmd.isNullable(k), rsmd.isSigned(k), rsmd.getPrecision(k), rsmd.getScale(k), rsmd.getColumnType(k), rsmd.getColumnTypeName(k), rsmd.getColumnClassName(k), 1, rsmd.unwrap(OracleResultSetMetaData.class).getVectorMetaData(k));
                        ++k;
                    }
                    this.nbBindsRegular = rsmd.getColumnCount();
                }
                finally {
                    if (pstmt != null) {
                        pstmt.setDisableStmtCaching(true);
                        pstmt.close();
                    }
                }
            } else if (this.columns != null && !this.columns.isEmpty() && (this.tables == null || this.tables.isEmpty())) {
                this.parametersMetadata = new ParameterMetadata[this.columns.size()];
                boolean k = true;
                for (int j = 0; j < this.columns.size(); ++j) {
                    if (this.columns.get(j) != null && this.columns.get(j).getColumnName() != null) {
                        throw DatabaseError.createSqlException(1734, null);
                    }
                    this.parametersMetadata[j] = null;
                }
                this.nbBindsRegular = this.columns.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queryFunctionParameters(Connection connection) throws SQLException {
            if (this.functionParameters != null && !this.functionParameters.isEmpty()) {
                OraclePreparedStatement pstmt = null;
                int processedBinds = 0;
                int matchedParameters = 0;
                try {
                    StringBuilder queryBuilder = new StringBuilder();
                    queryBuilder.append("select  a.object_name, a.position, a.data_type, a.in_out, a.data_length, a.data_precision, a.data_scale, a.radix from ALL_ARGUMENTS a where (");
                    for (int i = 0; i < this.functionParameters.size(); ++i) {
                        FunctionParameterBindMetaData currentParam = this.functionParameters.get(i);
                        if (i != 0) {
                            queryBuilder.append(" OR ");
                        }
                        queryBuilder.append("(UPPER(OBJECT_NAME) = UPPER('" + currentParam.getFunctionName() + "') AND position = " + currentParam.getParameterNumber() + ")");
                    }
                    queryBuilder.append(") ORDER BY CASE WHEN UPPER(a.data_type) = 'CLOB' THEN 0 ELSE 1 END, CASE WHEN UPPER(a.data_type) = 'VARCHAR2' THEN 0 ELSE 1 END, CASE WHEN UPPER(a.data_type) = 'NUMBER' THEN 0 ELSE 1 END, a.data_length DESC, a.data_type ASC");
                    pstmt = (OraclePreparedStatement)connection.prepareStatement(queryBuilder.toString());
                    ResultSet rset = pstmt.executeQuery();
                    HashSet<CallSite> retrievedParameters = new HashSet<CallSite>();
                    while (rset.next()) {
                        int parameterNumber;
                        String functionName = rset.getString(1);
                        if (retrievedParameters.contains(functionName + (parameterNumber = rset.getInt(2)))) continue;
                        retrievedParameters.add((CallSite)((Object)(functionName + parameterNumber)));
                        for (FunctionParameterBindMetaData currentFunctionParam : this.functionParameters) {
                            int parameterMode;
                            if (!currentFunctionParam.getFunctionName().equalsIgnoreCase(functionName) || currentFunctionParam.getParameterNumber() != parameterNumber) continue;
                            ++matchedParameters;
                            if (this.parametersMetadata == null) {
                                this.parametersMetadata = new ParameterMetadata[this.functionParameters.size()];
                            }
                            OracleSqlType sqlType = new OracleSqlType(rset.getString(3));
                            switch (rset.getString(4)) {
                                case "OUT": {
                                    parameterMode = 4;
                                    break;
                                }
                                case "IN/OUT": {
                                    parameterMode = 2;
                                    break;
                                }
                                default: {
                                    parameterMode = 1;
                                }
                            }
                            VectorMetaData vectorMetaData = OracleTypes.isVector(sqlType.getDataType()) ? VectorMetaDataImpl.UNKNOWN : null;
                            this.parametersMetadata[this.nbBindsRegular + this.nbBindsAnyData + processedBinds++] = new ParameterMetadata(currentFunctionParam.getBindNumber(), 1, true, rset.getInt(6), rset.getInt(7), sqlType.getDataType(), rset.getString(3), sqlType.getClassName(), parameterMode, vectorMetaData);
                        }
                    }
                }
                finally {
                    if (pstmt != null) {
                        pstmt.setDisableStmtCaching(true);
                        pstmt.close();
                    }
                }
                if (matchedParameters != this.functionParameters.size()) {
                    throw DatabaseError.createSqlException(1735, null);
                }
            }
        }

        public ParameterMetadata[] getParametersMetadata() {
            return this.parametersMetadata;
        }

        protected class ParameterMetadata {
            protected int bindNumber;
            protected int isNullable;
            protected boolean isSigned;
            protected int precision;
            protected int scale;
            protected int parameterType;
            protected String parameterTypeName;
            protected String parameterClassName;
            protected int parameterMode;
            protected VectorMetaData parameterVectorMetaData;

            ParameterMetadata(int bindNumber, int isNullable, boolean isSigned, int precision, int scale, int parameterType, String parameterTypeName, String parameterClassName, int parameterMode, VectorMetaData parameterVectorMetaData) {
                this.bindNumber = bindNumber;
                this.isNullable = isNullable;
                this.isSigned = isSigned;
                this.precision = precision;
                this.scale = scale;
                this.parameterType = parameterType;
                this.parameterTypeName = parameterTypeName;
                this.parameterClassName = parameterClassName;
                this.parameterMode = parameterMode;
                this.parameterVectorMetaData = parameterVectorMetaData;
            }
        }
    }

    private static class NoColumnInsertBindMetaData {
        private String tableName;
        private int parameterNumber = -1;
        private int bindNumber = -1;

        public NoColumnInsertBindMetaData(String tableName, int parameterNumber, int bindNumber) {
            this.tableName = tableName;
            this.parameterNumber = parameterNumber;
            this.bindNumber = bindNumber;
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getParameterNumber() {
            return this.parameterNumber;
        }

        public int getBindNumber() {
            return this.bindNumber;
        }
    }

    private static class FunctionParameterBindMetaData {
        private String functionName;
        private int parameterNumber = -1;
        private int bindNumber = -1;

        public FunctionParameterBindMetaData(String functionName, int parameterNumber, int bindNumber) {
            this.functionName = functionName;
            this.parameterNumber = parameterNumber;
            this.bindNumber = bindNumber;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public int getParameterNumber() {
            return this.parameterNumber;
        }

        public int getBindNumber() {
            return this.bindNumber;
        }
    }

    private static class BindMetaData {
        private String columnName;
        private int bindNumber;

        public BindMetaData(int bindNumber) {
            this.bindNumber = bindNumber;
        }

        public BindMetaData(String columnName, int bindNumber) {
            this.columnName = columnName;
            this.bindNumber = bindNumber;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public int getBindNumber() {
            return this.bindNumber;
        }
    }
}

